/*****************************************************************************/
/*                                                                           */
/* part_stv6111.h                                                           */
/*                                                                           */
/*****************************************************************************/
#ifndef _PART_STV6111_H
#define _PART_STV6111_H

#include "part_common.h"
#include "part_pe43204.h"

/* STV6111 unique part identifier  */
enum STV6111_PART_ID {
  PTID_STV6111 = FPGA_PTID_STV6111 
};

/* STV6111 Pin control Masks */
enum STV6111_PIN_MASK {
  STV6111_PIN_GPO = 0x00000001   /* GPO control pin */
};

/* STV6111 Register ID's */
enum STV6111_RG_ID {
  STV6111_RG_00 = 0x00,  /* K,R,O values                        */
  STV6111_RG_01 = 0x01,  /* BB,DC,WB,ONOFF                      */
  STV6111_RG_02 = 0x02,  /* GC                                  */
  STV6111_RG_03 = 0x03,  /* LO,GC                               */
  STV6111_RG_04 = 0x04,  /* N                                   */
  STV6111_RG_05 = 0x05,  /* F,N                                 */
  STV6111_RG_06 = 0x06,  /* F                                   */
  STV6111_RG_07 = 0x07,  /* PLL,VCO,F                           */
  STV6111_RG_08 = 0x08,  /* BB,PLL                              */
  STV6111_RG_09 = 0x09,  /* ID,CAL                              */
  STV6111_RG_0A = 0x0A,  /* ID,CAL                              */
  STV6111_RG_0B = 0x0B,  /* Testing                             */
  STV6111_RG_0C = 0x0C,  /* Testing                             */
  STV6111_RG_0D = 0x0D,  /* Testing                             */
  STV6111_RG_0E = 0x0E,  /* Testing                             */
  STV6111_RG_0F = 0x0F   /* Testing                             */
};

/* Create register access structure */
#define STV6111_NUM_RG 16

typedef union {
  /* Register values accessed as raw array of unsigned 8-bit integers */
  uint8_t rg[STV6111_NUM_RG];
  /* Register access by name */
  struct {
    uint8_t ctrl1;
    uint8_t ctrl2;
    uint8_t ctrl3;
    uint8_t ctrl4;
    uint8_t ctrl5;
    uint8_t ctrl6;
    uint8_t ctrl7;
    uint8_t ctrl8;
    uint8_t ctrl9;
    uint8_t ctrl10;
    uint8_t ctrl11;
    uint8_t test1;
    uint8_t test2;
    uint8_t test3;
    uint8_t test4;
    uint8_t test5;
  } nm;
} PT_STV6111_REG; 

static const PT_STV6111_REG stv6111_reg_initializer = {
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}
};

/* STV6111 Register Masks */
enum STV6111_RG_MASK {
  STV6111_RGM_00_K       = 0xF8, /* K divider */          
  STV6111_RGM_00_R       = 0x04, /* R divider */          
  STV6111_RGM_00_O       = 0x03, /* O divider */          
  STV6111_RGM_01_BBWB    = 0x02, /* Wideband mode */
  STV6111_RGM_01_DCLOOP  = 0x08, /* DC loop compensation */
  STV6111_RGM_01_BBMODE  = 0x30, /* BB Mode */
  STV6111_RGM_01_BBMAG   = 0xC0, /* BB Magnitude */
  STV6111_RGM_02_LNASEL  = 0x80, /* STVLNA on / off control */
  STV6111_RGM_02_LNAAGC  = 0x1F, /* STVAGC gain control     */
  STV6111_RGM_03_LO      = 0x80, /* LO divider */
  STV6111_RGM_03_LNAMODE = 0x60, /* LNA mode */    
  STV6111_RGM_03_LNAH    = 0x08, /* LNA max gain */
  STV6111_RGM_04_N70     = 0xFF,
  STV6111_RGM_05_N88     = 0x01,
  STV6111_RGM_05_F60     = 0xFE,
  STV6111_RGM_06_F147    = 0xFF,
  STV6111_RGM_07_ICP     = 0xE0, /* PLL CP current */
  STV6111_RGM_07_VCOAMP  = 0x18, /* VCO amp level */
  STV6111_RGM_07_F1715   = 0x07,
  STV6111_RGM_08_PLLLCK  = 0x01, /* PLL Lock Indicator Bit */
  STV6111_RGM_08_PLLSD   = 0x02, /* SD modulator */
  STV6111_RGM_08_BBFSEL  = 0xFC, /* Baseband filter selection */
  STV6111_RGM_09_BBFCAL  = 0x08, /* VCO loop filter / BB filter calibration */
  STV6111_RGM_09_VCOCAL  = 0x04, /* VCO calibration                         */
  STV6111_RGM_09_TCAL    = 0x03  /* TCAL clock selection                    */
};


/*---------------------------------------------------------------------------*/
/* Public function prototypes from part_stv6111.c */

EXTERN_CDEFINE int32_t pt_stv6111_rgc_default(PT_STV6111_REG *R);
EXTERN_CDEFINE int32_t pt_stv6111_rgc_rffreq(PT_STV6111_REG *R, UDB *B, 
                                              float64_t Fref);
EXTERN_CDEFINE int32_t pt_stv6111_rgc_rfbw(PT_STV6111_REG *S, UDB *bmhz);
EXTERN_CDEFINE int32_t pt_stv6111_rgc_rfgain(PT_STV6111_REG *S, UDB *gdb,
                                               uint32_t *atn);


#endif  /* _PART_STV6111_H */
