/****************************************************************************/
/*                                                                          */
/*  part_si5344.c                                                           */
/*                                                                          */
/****************************************************************************/

#include "part_si5344.h" 

/*                                                           */
/* Sane defaults for SI5344 registers based on Module type   */
/*                                                           */
int32_t pt_si5344_rgc_default(PT_SI5344_REG *R, int32_t modid)
{
  PT_SI5344_REG *rgdflt = (PT_SI5344_REG *)NULL;
  int32_t numreg = 0;
  int32_t i;

  switch (modid) {
    case (FPGA_MODID_D2AWGM3):  
      numreg = sizeof(si5344_d2awgm3_reg_defaults)/sizeof(PT_SI5344_REG);
      rgdflt = (PT_SI5344_REG *) (&si5344_d2awgm3_reg_defaults);
      break;

    default:
      dbgerrormsg("Unknown module type: pt_si5344_rgc_default \n");
      return (-1);
  }

  if (numreg > SI5344_MAX_CFG_RG) {
    printf("ERROR: numreg > SI5344_MAX_CFG_RG !\n");
    return (-1);
  }
  /* First, default all registers to page zero setting */
  for (i=0; i<SI5344_MAX_CFG_RG; i++){
    R[i].rp = 0x00;           
    R[i].ra = 0x00;         
    R[i].rv = 0x00;           
  }
  /* Next, load default register settings */
  if (numreg > SI5344_MAX_CFG_RG) {
    dbgwarnmsg("Si5344 initialization register count too large. Registers ignored!\n");
    numreg = SI5344_MAX_CFG_RG;
  }
  for (i=0; i<numreg; i++){
    R[i].rp = rgdflt[i].rp;
    R[i].ra = rgdflt[i].ra;
    R[i].rv = rgdflt[i].rv;
  }

  return (0);
}

/*
int32_t pt_si5344_rgc_setbits(PT_SI5344_REG *R, uint8_t rgaddr, uint8_t rgmask,
                                uint8_t rgval, uint8_t pgnum)
{
  uint8_t pageref = 0x00;
  int32_t i;
  for (i=0; i<SI5344_MAX_CFG_RG; i++) {
      if (R[i].ra == 255) pageref = (0x01)&(R[i].rv);
      if ((R[i].ra == rgaddr) && (pgnum == pageref)) {
        R[i].rv = u8_setbits(R[i].rv, rgmask, rgval);
      }
  }
  return (0);
}
*/
