#ifndef _PART_SI5326_H
#define _PART_SI5326_H

#include "part_common.h"

/*---------------------------------------------------------------------------*/
/* Si5326 Object */                        
#define SI5326_REGCFG_MAXREGS  128      /* Maximum of 128 reg configs     */
typedef struct
{
  int32_t initmagic;  /* Simple check for valid structure contents          */
  int32_t debuglevel; /* Diagnostic output level                            */
  int32_t mtype;      /* Module type                                        */
  int32_t validflag;  /* -1 = no solution, 0 = solution, 1 = imperfect soln */
  int32_t n1_hs;      /* High-Speed output divider                          */
  int32_t nc1_ls;     /* Low-Speed output divider - Clock 1                 */
  int32_t nc2_ls;     /* Low-Speed output divider - Clock 2                 */
  int32_t n2_hs;      /* High-Speed phase comp divider                      */
  int32_t n2_ls;      /* Low-Speed phase comp divider                       */
  int32_t n31;        /* Input R divider - Clock 1                          */
  int32_t n32;        /* Input R divider - Clock 2                          */
  float64_t fref;      /* Input reference frequency (Hz)                     */
  float64_t f3;        /* PLL comparison frequency (Hz)                      */
  float64_t fvco;      /* VCO center frequency (Hz)                          */
  float64_t dclk1;     /* Desired output Clock-1 frequency                   */
  float64_t fclk1;     /* Actual output Clock-1 frequency                    */
  float64_t dclk2;     /* Desired output Clock-2 frequency                   */
  float64_t fclk2;     /* Actual output Clock-2 frequency                    */
  float64_t dwght1;    /* Weight for Clock-1 VCO error (0.0 to 1.0)          */
  float64_t dwght2;    /* Weight for Clock-2 VCO error (0.0 to 1.0)          */
  int32_t  numreg;    /* Number of valid register configurations            */
  uint32_t regval[SI5326_REGCFG_MAXREGS];  /* SI5326 Register Settings      */

} Si5326_Reg_Obj;


#endif  /* _PART_SI5326_H */
