
#include "part_ptfd.h"

int32_t pt_ptfd_rgc_default(PT_PTFD_REG *R)
{ 
  static const PT_PTFD_REG ptfd_reg_defaults = {
    {0x00000000,0x00000000,0x00000000,0x00000000,
     0x00000000,0x00000000,0x00000000,0x00000000,
     0x00000000,0x00000000,0x00000000,0x00000000,
     0x00000000,0x00000000,0x00000000,0x00000000} };
  
  int32_t i;
  for (i=0; i<PTFD_NUM_RG; i++){
    R->rg[i] = ptfd_reg_defaults.rg[i];
  }
  return (0);
}

int32_t pt_ptfd_tune(PT_PTFD_REG *S, UDB *rate, UDB *freq)
{
  int32_t rtn = 0;
  int32_t i;

  UDB sfreq   = udb_initializer;
  UDB tfreq   = udb_initializer;
  UDB samples = udb_initializer;
  UDB amp     = udb_initializer;
  UDB phase   = udb_initializer;
  UDB afreq   = udb_initializer;
  UDB pinc    = udb_initializer;
  UDB tsin    = udb_initializer;
  UDB tcos    = udb_initializer;
  UDB tcx     = udb_initializer;

  /* sfreq.f64[0] = rate->f64[0] * 1000000.0; */
  sfreq.f64[0] = rate->f64[0];
  tfreq.f64[0] = freq->f64[0];

  samples.i32[0] = 256;
  amp.i32[0] = (1<<15)-1;

  udb_i32wf_to_f64(&samples);
  udb_i32wf_to_f64(&amp);

  pinc.f64[0] = (tfreq.f64[0]/sfreq.f64[0])*samples.f64[0];
  udb_f64_to_i32wf(&pinc);

  if(abs(pinc.i32[1]) > 1073741823) pinc.i32[0] = (pinc.i32[0]<0)? pinc.i32[0]-1 : pinc.i32[0]+1;
  pinc.i32[1] = 0; /* Set fractional part to zero (type cast) */
  udb_i32wf_to_f64(&pinc);

  afreq.f64[0] = sfreq.f64[0]*pinc.f64[0]/samples.f64[0];

  freq->f64[0] = afreq.f64[0];

  if (afreq.f64[0] != tfreq.f64[0]) printf("A2DM1X TUNE - Requested %f, got %f, at sample rate %f\n",tfreq.f64[0],afreq.f64[0],sfreq.f64[0]);

  udb_f64_to_i32wf(&afreq);
  S->nm.tfreqw = afreq.i32[0];
  S->nm.tfreqf = afreq.i32[1];

  for (i=0; i<samples.f64[0]; i++) {
    phase.f64[0] = (i*pinc.f64[0]*6.283185307179586/samples.f64[0]);
    tsin.f64[0] = amp.f64[0]*sin(phase.f64[0]);
    tcos.f64[0] = amp.f64[0]*cos(phase.f64[0]);
    udb_f64_to_i32wf(&tsin);
    udb_f64_to_i32wf(&tcos);
    tcx.i32[0]  = ((tcos.i32[0]<<16)&0xFFFF0000) | (tsin.i32[0]&0xFFFF);
    /* tcx.i32[0]  = ((tsin.i32[0]<<16)&0xFFFF0000) | (tcos.i32[0]&0xFFFF); */
    S->nm.twave[i] = tcx.i32[0];
  }
  return(rtn);
}

