/*****************************************************************************/
/*                                                                           */
/* part_dcs.h                                                                */
/*                                                                           */
/*****************************************************************************/
#ifndef _PART_DCS_H
#define _PART_DCS_H

#include "part_common.h"

/* DCS unique part identifier  */
enum DCS_PART_ID {
  PTID_DCS = FPGA_PTID_DCS 
};

/* DCS Pin control Masks */
enum DCS_PIN_MASK {
  DCS_PIN_NULL   = 0x00000000,  /* Null function place holder */
  DCS_PIN_BYPASS = 0x00000001   /* Enable/Bypass control      */
};

/* DCS Register ID's */
enum DCS_RG_ID {
  DCS_RG_BN = 0x00   /* Bn Term: Beta = (1-1/2^Bn)     */
};


/* DCS Register Keys and Masks */
enum DCS_RG_MASK {
  DCS_RGM_00_DATA = 0x0000000F   /* Bn: 4-Bit Data  */
};


/*---------------------------------------------------------------------------*/
/* Public function prototypes from part_dcs.c */


#endif  /* _PART_DCS_H */
