/*****************************************************************************/
/*                                                                           */
/* part_adf4350.h                                                           */
/*                                                                           */
/*****************************************************************************/
#ifndef _PART_ADF4350_H
#define _PART_ADF4350_H

#include "part_common.h"

/* ADF4350 unique part identifier  */
enum ADF4350_PART_ID {
  PTID_ADF4350 = FPGA_PTID_ADF4350 
};

/* ADF4350 Pin control Masks */
enum ADF4350_PIN_MASK {
  ADF4350_PIN_GPO = 0x00000001   /* GPO control pin */
};

/* ADF4350 Register ID's */
enum ADF4350_RG_ID {
  ADF4350_RG_00 = 0x00,  /* Int,Frac                            */
  ADF4350_RG_01 = 0x01,  /* Prescaler,Phase,Mod                 */
  ADF4350_RG_02 = 0x02,  /* PLL values                          */
  ADF4350_RG_03 = 0x03,  /* CLK Dividers                        */
  ADF4350_RG_04 = 0x04,  /* CLK Dividers,Band select            */
  ADF4350_RG_05 = 0x05   /* LD Pin mode                         */
};

/* Create register access structure */
#define ADF4350_NUM_RG 6

typedef union {
  /* Register values accessed as raw array of unsigned 32-bit integers */
  uint32_t rg[ADF4350_NUM_RG];
  /* Register access by name */
  struct {
    uint32_t reg0;
    uint32_t reg1;
    uint32_t reg2;
    uint32_t reg3;
    uint32_t reg4;
    uint32_t reg5;
  } nm;
} PT_ADF4350_REG; 

static const PT_ADF4350_REG adf4350_reg_initializer = {
    {0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000}
};

/* ADF4350 Register Masks */
enum ADF4350_RG_MASK {
  ADF4350_RGM_00_INT      = 0x7FFF8000, /*  Int                          */
  ADF4350_RGM_00_FRAC     = 0x00007FF8, /*  Frac                         */
  ADF4350_RGM_01_PRESCALE = 0x08000000, /*  Prescaler                    */
  ADF4350_RGM_01_PHASE    = 0x07FF8000, /*  Phase                        */
  ADF4350_RGM_01_MOD      = 0x00007FF8, /*  Mod                          */
  ADF4350_RGM_02_LNLS     = 0x60000000, /*  Low Noise and Low Spur       */
  ADF4350_RGM_02_MUXOUT   = 0x1C000000, /*  Mux output selection         */
  ADF4350_RGM_02_REFDBL   = 0x02000000, /*  Reference Doubler            */
  ADF4350_RGM_02_RDIV2    = 0x01000000, /*  R Divider 2                  */
  ADF4350_RGM_02_RCOUNT   = 0x00FFC000, /*  R Counter                    */
  ADF4350_RGM_02_DBLBUF   = 0x00002000, /*  Double Buff                  */
  ADF4350_RGM_02_CPCS     = 0x00001E00, /*  Charge Pump Current Setting  */
  ADF4350_RGM_02_LDF      = 0x00000100, /*  LDF                          */
  ADF4350_RGM_02_LDP      = 0x00000080, /*  LDP                          */
  ADF4350_RGM_02_PDPOL    = 0x00000040, /*  Power Down Polarity          */
  ADF4350_RGM_02_PD       = 0x00000020, /*  Power Down                   */
  ADF4350_RGM_02_CP3S     = 0x00000010, /*  CP Three State               */
  ADF4350_RGM_02_COUNTRST = 0x00000008, /*  Counter Reset                */
  ADF4350_RGM_03_CSR      = 0x00040000, /*  CSR                          */
  ADF4350_RGM_03_DIVMODE  = 0x00018000, /*  Clock Divider Mode           */
  ADF4350_RGM_03_CLKDIV   = 0x00007FF8, /*  Clock Divider                */
  ADF4350_RGM_04_FDBKSEL  = 0x00800000, /*  Feedback Select              */
  ADF4350_RGM_04_DIVSEL   = 0x00700000, /*  Divider Select               */
  ADF4350_RGM_04_BSCD     = 0x000FF000, /*  Band Select Clock Divider    */
  ADF4350_RGM_04_VCOPD    = 0x00000800, /*  VCO Power Down               */
  ADF4350_RGM_04_MTLD     = 0x00000400, /*  MTLD                         */
  ADF4350_RGM_04_AUXSEL   = 0x00000200, /*  Aux Output Select            */
  ADF4350_RGM_04_AUXEN    = 0x00000100, /*  Aux Output Enable            */
  ADF4350_RGM_04_AUXPOW   = 0x000000C0, /*  Aux Output Power             */
  ADF4350_RGM_04_RFEN     = 0x00000020, /*  RF Enable                    */
  ADF4350_RGM_04_OUTPOW   = 0x00000018, /*  Output Power                 */
  ADF4350_RGM_05_LDMODE   = 0x00C00000  /*  LD Pin Mode                  */
};

/* ADF4350 Parameters */
#define ADF4350_VCO_FMAX 4400000000.0
#define ADF4350_VCO_FMIN 2200000000.0
#define ADF4350_VCO_FSYNTH_MAX 4400000000.0
#define ADF4350_VCO_FSYNTH_MIN  137500000.0

/*---------------------------------------------------------------------------*/
/* Public function prototypes from part_adf4350.c */

EXTERN_CDEFINE int32_t pt_adf4350_rgc_default(PT_ADF4350_REG *R);
EXTERN_CDEFINE int32_t pt_adf4350_setrate(PT_ADF4350_REG *S, UDB *rate, UDB *refclk);

#endif  /* _PART_ADF4350_H */
