#include "part_adclm.h"


/* Convert ADCLM value to crest factor (dBR to full scale sine wave clip) */
/* Assumes that all ADC data is 16-bit (+/- 32768) prescaled              */

float64_t adclm_to_cf_f64(int32_t adcmeas)
{
  float64_t adcf = 0.0;
  const float64_t wdscale = (1.0/32768.0);
  adcf = (float64_t)((ADCLM_RGM_00_DATA)&(adcmeas));
  adcf = (adcf > 0.0) ? (wdscale*adcf) : (wdscale);
  adcf = 20.0*log10(adcf);
  adcf = (adcf > 0.0) ? (0.0) : (adcf);
  return (adcf);
}

int32_t adclm_to_cf_i32(int32_t adcmeas)
{
  int32_t iadcf = 0;
  float64_t adcf;
  adcf = adclm_to_cf_f64(adcmeas);
  adcf = adcf - 0.5;
  adcf = (adcf < 0.0) ? (adcf) : (0.0);
  adcf = (adcf > -2147483648.0) ? (adcf) : (-2147483648.0);
  iadcf = (int32_t) adcf;
  return (iadcf);
}
