/*****************************************************************************/
/*                                                                           */
/* part_adc12d.h                                                           */
/*                                                                           */
/*****************************************************************************/
#ifndef _PART_ADC12D_H
#define _PART_ADC12D_H

#include "part_common.h"

/* ADC12D unique part identifier  */
enum ADC12D_PART_ID {
  PTID_ADC12D = FPGA_PTID_ADC12D 
};

/* ADC12D Pin control Masks */
enum ADC12D_PIN_MASK {
  ADC12D_PIN_GPO = 0x00000001   /* GPO control pin */
};

/* ADC12D Register ID's */
enum ADC12D_RG_ID {
  ADC12D_RG_CONFIG1         = 0x00,  /* Configuration 1 register            */
  ADC12D_RG_RES1            = 0x01,  /* RESERVED                            */
  ADC12D_RG_I_OFF_ADJ       = 0x02,  /* I-channel offset adjust             */
  ADC12D_RG_I_FS_ADJ        = 0x03,  /* I-channel full scale range adjust   */
  ADC12D_RG_CAL_ADJ         = 0x04,  /* Calibration adjust                  */
  ADC12D_RG_CAL_VAL         = 0x05,  /* Calibration values                  */
  ADC12D_RG_RES2            = 0x06,  /* RESERVED                            */
  ADC12D_RG_DES_ADJ         = 0x07,  /* DES timing adjust                   */
  ADC12D_RG_RES3            = 0x08,  /* RESERVED                            */
  ADC12D_RG_RES4            = 0x09,  /* RESERVED                            */
  ADC12D_RG_Q_OFF_ADJ       = 0x0A,  /* Q-channel offset adjust             */
  ADC12D_RG_Q_FS_ADJ        = 0x0B,  /* Q-channel full scale range adjust   */
  ADC12D_RG_APT_DEL_CA      = 0x0C,  /* Aperture delay course adjust        */
  ADC12D_RG_APT_DEL_FA      = 0x0D,  /* Aperture delay fine adjust          */
  ADC12D_RG_AUTOSYNC        = 0x0E,  /* Autosync                            */
  ADC12D_RG_RES5            = 0x0F,  /* RESERVED                            */
  ADC12D_RG_PIN             = 0x10   /* Pin Control                         */
};

/* Create register access structure */
#define ADC12D_NUM_RG 17

typedef union {
  /* Register values accessed as raw array of unsigned 32-bit integers */
  uint16_t rg[ADC12D_NUM_RG];
  /* Register access by name */
  struct {
    uint16_t reg0;
    uint16_t reg1;
    uint16_t reg2;
    uint16_t reg3;
    uint16_t reg4;
    uint16_t reg5;
    uint16_t reg6;
    uint16_t reg7;
    uint16_t reg8;
    uint16_t reg9;
    uint16_t reg10;
    uint16_t reg11;
    uint16_t reg12;
    uint16_t reg13;
    uint16_t reg14;
    uint16_t reg15;
    uint16_t reg16;
  } nm;
} PT_ADC12D_REG; 

static const PT_ADC12D_REG adc12d_reg_initializer = {
    {0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000}
};

/* ADC12D Pin Masks */
enum ADC12D_PN_MASK {
  ADC12D_PNM_NDM              = 0x0001 
};

/* ADC12D Register Masks */
enum ADC12D_RG_MASK {
  ADC12D_RGM_CONFIG1_CAL      = 0x8000, /*  CAL                          */
  ADC12D_RGM_CONFIG1_DPS      = 0x4000, /*  DPS                          */
  ADC12D_RGM_CONFIG1_OVS      = 0x2000, /*  OVS                          */
  ADC12D_RGM_CONFIG1_TPM      = 0x1000, /*  TPM                          */
  ADC12D_RGM_CONFIG1_PDI      = 0x0800, /*  PDI                          */
  ADC12D_RGM_CONFIG1_PDQ      = 0x0400, /*  PDQ                          */
  ADC12D_RGM_CONFIG1_LFS      = 0x0100, /*  LFS                          */
  ADC12D_RGM_CONFIG1_DES      = 0x0080, /*  DES                          */
  ADC12D_RGM_CONFIG1_DEQ      = 0x0040, /*  DEQ                          */
  ADC12D_RGM_CONFIG1_DIQ      = 0x0020, /*  DIQ                          */
  ADC12D_RGM_CONFIG1_2SC      = 0x0010, /*  2SC                          */
  ADC12D_RGM_CONFIG1_TSE      = 0x0008, /*  TSE                          */
  ADC12D_RGM_I_OFF_ADJ_OS     = 0x1000, /*  OS                           */
  ADC12D_RGM_I_OFF_ADJ_OM     = 0x0FFF, /*  OM                           */
  ADC12D_RGM_I_FS_ADJ_FM      = 0x7FFF, /*  FM                           */
  ADC12D_RGM_CAL_ADJ_CSS      = 0x4000, /*  CSS                           */ 
  ADC12D_RGM_CAL_ADJ_SSC      = 0x0080, /*  SSC                           */ 
  ADC12D_RGM_CAL_VAL_SS       = 0xFFFF, /*  SS                           */
  ADC12D_RGM_DES_ADJ_DTA      = 0xFE00, /*  DTA                           */
  ADC12D_RGM_Q_OFF_ADJ_OS     = 0x1000, /*  OS                           */
  ADC12D_RGM_Q_OFF_ADJ_OM     = 0x0FFF, /*  OM                           */
  ADC12D_RGM_Q_FS_ADJ_FM      = 0x7FFF, /*  FM                           */
  ADC12D_RGM_APT_DEL_CA_CAM   = 0xFFF0, /*  CAM                           */
  ADC12D_RGM_APT_DEL_CA_STA   = 0x0008, /*  STA                           */
  ADC12D_RGM_APT_DEL_CA_DCC   = 0x0004, /*  DCC                           */
  ADC12D_RGM_APT_DEL_FA_FAM   = 0xFC00, /*  FAM                           */
  ADC12D_RGM_AUTOSYNC_DRC     = 0xFF80, /*  DRC                           */
  ADC12D_RGM_AUTOSYNC_SP      = 0x0018, /*  SP                           */
  ADC12D_RGM_AUTOSYNC_ES      = 0x0004, /*  ES                           */
  ADC12D_RGM_AUTOSYNC_DOC     = 0x0002, /*  DOC                           */
  ADC12D_RGM_AUTOSYNC_DR      = 0x0001  /*  DR                           */
};

/*---------------------------------------------------------------------------*/
/* Public function prototypes from part_adc12d.c */

EXTERN_CDEFINE int32_t pt_adc12d_rgc_default(PT_ADC12D_REG *R);
EXTERN_CDEFINE int32_t pt_adc12d_cfg(PT_ADC12D_REG *S, UDB *rate);

#endif  /* _PART_ADC12D_H */
