/*
	12/03/2010 sjn moved structure elements to reduce storage, add BW
	11/08/2011 sjn added FEMTO 2.5 constants
	11/09/2011 sjn added function prototypes to remove gcc warnings for incompatible values
*/
#ifndef FEMTO_DATA_H
#define FEMTO_DATA_H

#define FEMTO1 1
#define FEMTO2 2
#define FEMTO25 3


#define MEMSTRUCT 0

#if MEMSTRUCT

typedef struct {
	char LNA;
	char BAND;
	char FREQ;
	char VGA;
	char FIL1;
	char FIL2;
	char FIL3;
	char FIL4;
	char FIL5;
	char CBIAS;
	char GBIAS;
	char WFREQ;
	char BIAS1;
	char BIAS2;
	char BIAS3;
	char BIAS4;
	char BIAS5;
	char BIAS6;
// saved values to be used when switching modes, CDMA, GSM to mid scale, WB to min
	char SCBIAS;
	char SGBIAS;
	char SBIAS1;
	char SBIAS2;
	char SBIAS3;
	char SBIAS4;
	char SBIAS5;
	char SBIAS6;
// Clock settings
	char clkrefsrc;
	char clkfssrc;
	int_4 clkrate;
// frequency setting
	real_8 RFFREQ;
// DAC settings 
	real_4 VCM1;
	real_4 VCM2;
	real_4 VCMWB;
	real_4 REF_TUNE;
	real_4 VREFP;
	real_4 VREFN;
	real_4 LOBIAS;
	real_4 RFBIAS;
// VCO limits
	int_2 VCO1;
	int_2 VCO2;
	int_2 VCO3;
	int_2 spare1;
// gain setting
	int_2 saved_gain;
	int_2 saved_power;
// bandwidth setting
	int_4 saved_bw;
// flags
 	int_4 saved_flags;
// AGC
	char agc_enable;

} LGSSTRUCT;
#else
// The structure has been relabled in terms of offsets for the FPGA RAM based software
// The first version of this code used the compiler directive, offsetof based o nthe structure
// The compiler on the ICE platofrom did not like offsetof so creating discrete offsets
// was the expediant way to fix the problem.
// The macros left an extra variable so all the calls in the code wouldi
// not have to be changed.

	#define LGSSTRUCT 0

	#define LNA 0
	#define BAND 1
	#define FREQ 2
	#define VGA 3 
	#define FIL1 4
	#define FIL2 5 
	#define FIL3 6
	#define FIL4 7
	#define FIL5 8
	#define CBIAS 9
	#define GBIAS 10
	#define WFREQ 11
	#define BIAS1 12 
	#define BIAS2 13
	#define BIAS3 14
	#define BIAS4 15
	#define BIAS5 16
	#define BIAS6 17
// saved values to be used when switching modes, CDMA, GSM to mid scale, WB to min
	#define SCBIAS 18
	#define SGBIAS 19
	#define SBIAS1 20
	#define SBIAS2 21
	#define SBIAS3 22
	#define SBIAS4 23
	#define SBIAS5 24
	#define SBIAS6 25
// clock settings
	#define clkrefsrc 26
	#define clkfssrc 27
	#define clkrate 28
// frequency setting
	#define RFFREQ 32
// DAC settings - not currently used
	#define VCM1 40 
	#define VCM2 44
	#define VCMWB 48
	#define REF_TUNE 52
	#define VREFP 56
	#define VREFN 60
	#define LOBIAS 64
	#define RFBIAS 68
// Calibration settings
	#define VCO1 72
	#define VCO2 74
	#define VCO3 76
	#define SPARE1 78
// gain setting
	#define SAVED_GAIN 80
	#define SAVED_POWER 82
// bandwidth setting
	#define SAVED_BW 84
// flags
	#define SAVED_FLAGS 88
	#define agc_enable 92
#endif


#endif


#ifndef RADIO_H
#define RADIO_H


struct freqlst{
	char mode;		// synthesizer mode
	char mpy;		// multiplier for VCO frequency
	int ll;			// lower limit
	int ul;			// upper limit
};

extern struct freqlst freqtbl[];

#define NUMRFIC_REGS 18

// FPGA RESET register bits
#define FEMTO_FPGA_RESET	1
#define FEMTO_DCM_RESET		2
#define FEMTO_MINMAXRES		4
#define FEMTO_PLL_SYNC		8
#define FEMTO_AGC_RESET 	16
#define FEMTO_START_TIMER	32
#define FEMTO_SPI_CLK_SEL	64
#define FEMTO_CHOP_DCM_RES	128
//  DAC Control bits
#define FEMTO_DC_RST_N		1
#define FEMTO_LDACN		2
#define FEMTO25_BAND		4
#define FEMTO25_RANDOM		8
// Board controls
#define FEMTO_OSCEN		1
#define FEMTO_REF_IN_EXT	2
#define FEMTO_PLL_RSTN		4
#define FEMTO25_RSYN_CE		4
#define FEMTO_RF_CLRN		8
#define FEMTO_TUNE		16
#define FEMTO_LED		32
#define FEMTO_LED_CTRL		64
#define FEMTO_SYN_RST		128
#define FEMTO25_RSYN_PD		128
// Board status
#define FEMTO_PLL_REFMON	1
#define FEMTO_PLL_STATUS	2
#define FEMTO_PLL_LOCK		4
#define FEMTO_SYNNLD		8
#define FEMTO_DCM_LOCK		16
#define FEMTO_TIMER_DONE	128
// lvds SETUP
#if FEMTO1_FIX
#define FEMTO_BYTE_SWAP		4
#else
#define FEMTO_BYTE_SWAP		8
#endif

// spi CONTROL
#define FEMTO_PRG_RF		1
#define FEMTO_PRG_SYN		2
#define FEMTO_PRG_DAC		4
#define FEMTO_PRG_RSSI		8
#define FEMTO_PRG_PLL		16
#define FEMTO25_PRG_ADC		16
#define FEMTO25_PRG_I2C		32
#define FEMTO_SPI_STATUS	128

// registers
#define FEMTO_VERSION		0
#define FEMTO_RESET		1
#define FEMTO_DAC_CTRL		2
#define FEMTO_BOARD_CTRL	3
#define FEMTO_REV		4
#define FEMTO_STATUS		5
#define FEMTO_LVDS		6
#define FEMTO_SPI		7
#define FEMTO_SPI8		8
#define FEMTO_SPI7		9
#define FEMTO_SPI6		0xa
#define FEMTO_SPI5		0xb
#define FEMTO_SPI4		0xc
#define FEMTO_SPI3		0xd
#define FEMTO_SPI2		0xe
#define FEMTO_SPI1		0xf
#define FEMTO_CHOPHI		0x10
#define FEMTO_CHOPLO		0x11
#define FEMTO_PPS		0x12
#define FEMTO_OUT		0x13
#define RSSI_HI			0x14
#define RSSI_LO			0x15
#define OFFSET_I		0x16
#define OFFSET_Q		0x17
#define FEMTO_LED_OUT		0x18
#define FEMTO_IQ_COMP		0x19
#define FEMTO_TIMERHI		0x1A
#define FEMTO_TIMERLO		0x1B
#define FEMTO_OFCOUNT		0x1C
#define SYNTH_SPI_READ		0x1E
#define FEMTO25_I2C_HI		0x1E
#define FEMTO25_I2C_LO		0x1F
#define I_MAXHI			0x20
#define I_MAXLO			0x21
#define I_MINHI			0x22
#define I_MINLO			0x23
#define Q_MAXHI			0x24
#define Q_MAXLO			0x25
#define Q_MINHI			0x26
#define Q_MINLO			0x27
#define FEMTO_ALPHA		0x36
#define FEMTO_BETA		0x37
#define FEMTO_PWRHI		0x38
#define FEMTO_PWRLO		0x39

    	    

int syninit(PICSTRUCT *p, int_4 mport);
int syndump(PICSTRUCT *p, int_4 mport);
int synfr(PICSTRUCT *p, int_4 mport, real_8 * freq);
int synref(PICSTRUCT *p, int_4 mport);
void dac_init(PICSTRUCT *p, int_4 mport);
void clk_init (PICSTRUCT *p, int_4 mport);
int  clk_lock_wait (PICSTRUCT *p, int_4 mport);
int clk_set_rate_params(PICSTRUCT *p, int_4 mport, int r, int b, int a, int n0, int n1, int n2);
void dcm_init (PICSTRUCT *p, int_4 mport);
int  dcm_lock_wait (PICSTRUCT *p, int_4 mport);
void radreset (PICSTRUCT *p, int_4 mport);
int radlna (PICSTRUCT *p, int_4 mport, int lna);
int radlna_noupdate (PICSTRUCT *p, int_4 mport, int lna);
int radgn (PICSTRUCT *p, int_4 mport, int gn);
int clk_ref_src (PICSTRUCT *p, int_4 mport, int intext);
int clk_fs_src (PICSTRUCT *p, int_4 mport, int intext);

int_4 rfxd_get_gain (PICSTRUCT *p, int_4 mport);
int_4 rfxd_set_gain( PICSTRUCT *p, int_4 port, int_4 gain);

int_4 rfxd_get_rfpwr(PICSTRUCT *p, int_4 mport);
int rfxd_agc_reset(PICSTRUCT *p, int_4 mport);
int_4 rfxd_agc_get_pwr(PICSTRUCT *p, int_4 mport);
int_4 rfxd_agc_init(PICSTRUCT *p, int_4 mport, int_4 alpha, int_4 beta);
int_4 rfxd_agc_set(PICSTRUCT *p, int_4 mport,int_4 onoff, int_4 a);
int_4 rfxd_agc_update(PICSTRUCT *p, int_4 mport);

#endif


#ifndef SYNTH_H
#define SYNTH_H

#define LGSSYNTH 1
#define LGSSYNTH2 1

#define KSHIFT	128

#define SYNTH_CS_LOW    (SYN_CS_N = 0)
#define SYNTH_CS_HIGH   (SYN_CS_N = 1)
#define SPI_MOSI_LOW    (SPIMOSI = 0)
#define SPI_MOSI_HIGH   (SPIMOSI = 1)
#define SPI_CLOCK_LOW   (SPICLK = 0)
#define SPI_CLOCK_HIGH  (SPICLK = 1)

#define CPLD_CS_LOW    (PLD_CS1_N = 0)
#define CPLD_CS_HIGH   (PLD_CS1_N = 1)


#ifdef LGSSYNTH
#define SYN_MODREG	0x01
#define SYN_DSMFRI1 0x02
#define SYN_DSMFRI2	0x03
#define SYN_DSMFRF1	0x04
#define SYN_DSMFRF2	0x05
#define SYN_DSMFRF3	0x06
#define SYN_CAPREG	0x07
#define SYN_DACREG	0x08
#define SYN_PFDREG	0x09
#define SYN_DIVREG	0x0a
#define SYN_OUTREG1	0x0b
#define SYN_OUTREG2	0x0c
#define SYN_BIASREG1	0x0d
#define SYN_BIASREG2	0x0e
#define SYN_BIASREG3	0x0f
#define SYN_BIASREG4	0x10
#define SYN_REFREG	0x11
#define SYN_MUXREG	0x14
#define SYN_STATREG	0x20
#define SYN_FLLCAP	0x2e
#define SYN_DEBREG1	0x30
#define SYN_DEBREG2	0x31
#define SYN_RSTVER	0x7f


void synth_reset(PICSTRUCT *p, int_4 port);
void synwr(PICSTRUCT *p, int_4 port, unsigned char address, unsigned char control);
char synrd(PICSTRUCT *p, int_4 port, unsigned char address);
int synth_stat(PICSTRUCT *p, int_4 port);
int synth_ld(PICSTRUCT *p, int_4 port);

int synth_init(PICSTRUCT *p, int_4 port, unsigned char * param_ptr);

int syn_set_freq(PICSTRUCT *p, int_4 port, real_8 * freq);
real_8 syn_get_freq(PICSTRUCT *p, int_4 port);

int synth_cal(PICSTRUCT *p, int_4 port, float freq);

int synth2_limits(PICSTRUCT *p, int_4 port);
int synth_cap(PICSTRUCT *p, int_4 port, unsigned char valuue);
unsigned char synth_index(PICSTRUCT *p, int_4 port, unsigned char index, unsigned char print_flag);
int synth2_cal_sweep(PICSTRUCT *p, int_4 port, unsigned char start, unsigned char stop);
double synth2_test(PICSTRUCT *p, int_4 port, unsigned char vco, unsigned char dac, unsigned char cap);

#ifdef FEMTO25
void clk25_init (PICSTRUCT *p, int_4 mport);
void clk25_fsi (PICSTRUCT *p, int_4 mport, int_4 rate);
void clk25_ref (PICSTRUCT *p, int_4 mport, int_4 refsrc);
int_4 i2c_rd (PICSTRUCT *p, int_4 mport, int_4 slave, int_4 add);
void i2c_wr (PICSTRUCT *p, int_4 mport, int_4 slave, int_4 add, int_4 dat);
void write_si5338 (PICSTRUCT *p, int_4 mport, int_4 a, int_4 d);
int_4 read_si5338 (PICSTRUCT *p, int_4 mport, int_4 a);
void adclvds (PICSTRUCT *p, int_4 mport);
void adccmos (PICSTRUCT *p, int_4 mport);
void adcwr (PICSTRUCT *p, int_4 mport, int_4 addr, int_4 data);
void adcinit (PICSTRUCT *p, int_4 mport);
void syn25wr(PICSTRUCT *p, int_4 mport, int_4 address, int_4 data);
int syn25fr(PICSTRUCT *p, int_4 mport, real_8 * freq);
real_8 syn25calcfr(PICSTRUCT *p, int_4 mport, real_8 freq);
int syn25init(PICSTRUCT *p, int_4 mport);
void syn25mux(PICSTRUCT *p, int_4 mporti, int_4 val);
void syn25csr(PICSTRUCT *p, int_4 mporti, int_4 val);
void syn25lowspur(PICSTRUCT *p, int_4 mporti, int_4 val);
void syn25pwr(PICSTRUCT *p, int_4 mporti, int_4 val);
void syn25phase(PICSTRUCT *p, int_4 mporti, int_4 val);
void syn25cp(PICSTRUCT *p, int_4 mporti, int_4 val);

#endif

#endif

#endif

