/****************************************************************************/
/*                                                                          */
/*   iomlib_lb2dm4.h - LB2DM3 library wrappers for ICEPIC device            */
/*                                                                          */
/****************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <math.h>
#include <fcntl.h>
#include <string.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "icelib.h"

#define LB2DM3_ROOT       0
#define LB2DM3_JVM        1
#define LB2DM3_TMP112     2
#define LB2DM3_SKY13384_0 3
#define LB2DM3_SKY13384_1 4
#define LB2DM3_PE43204    5
#define LB2DM3_LTC2362    6
#define LB2DM3_STV6111    7
#define LB2DM3_LTC2630    8
#define LB2DM3_ADS42B49   9
#define LB2DM3_VMMK2103   10
#define LB2DM3_LTC6957    11
#define LB2DM3_OSC        12
#define LB2DM3_SI5338     13
#define LB2DM3_FXLH42245  14
#define LB2DM3_HBDECFIR_0 15
#define LB2DM3_HBDECFIR_1 16
#define LB2DM3_ADCLM      17
#define LB2DM3_AIS        18
#define LB2DM3_DCS        19
#define LB2DM3_STATIS     20
#define LB2DM3_FIR_0      21
#define LB2DM3_FIR_1      22
#define LB2DM3_FIR_2      23
#define LB2DM3_FIR_3      24
#define LB2DM3_DELAY      25
#define LB2DM3_MTGO       26
#define LB2DM3_MODULE     27 
#define LB2DM3_CMD        28

#define LB2DM3_NUMPARTS   29

/* Define pin controls specific to the state (module) part for the LB2DM3 */
/*   NOTE: These must match the verilog firmware !!!                      */
enum LB2DM3_PIN_MASK {
  LB2DM3_PIN_NULL    =  0x00000000,      /* No PINs active                 */
  LB2DM3_PIN_RSEL    =  (0x00000001<<0), /* Ramp output selection          */
  LB2DM3_PIN_IMP     =  (0x00000001<<1), /* IMP selection                  */
  LB2DM3_PIN_ABSWAP  =  (0x00000001<<2), /* AB Swap selection              */
  LB2DM3_PIN_IMPP    =  (0x00000001<<3), /* Description?                   */
  LB2DM3_PIN_CXRB    =  (0x00000001<<4), /* Description?                   */
  LB2DM3_PIN_HBFBYP  =  (0x00000001<<5), /* Digital halfband filter bypass */
  LB2DM3_PIN_PPSTAG  =  (0x00000001<<6), /* Tag output samples with PPS    */
  LB2DM3_PIN_LSBP    =  (0x00000001<<7), /* Put PPS in LSB of data         */
  LB2DM3_PIN_MTGO    =  (0x00000001<<8)  /* ADC triggered on PPS Port      */
};

/* Define module specific register masks */
enum LB2DM3_RG_MASK {
  LB2DM3_RGM_CLK_EXTREF  = (0x00000001<<0), /* Use external 10MHz ref   */
  LB2DM3_RGM_CLK_MTGO    = (0x00000001<<1)  /* Use triggered go output  */
};

/* Toggle Switches State is stored in LB2DM3_RG_TGLSS */
/*   NOTE: These switches do not control anything directly, they only */
/*         retain the current operating state of the toggle.          */
enum LB2DM3_TGLSS_MASK {
  LB2DM3_TGLSS_NULL    =  0x00000000,      /* Clear control pin              */
  LB2DM3_TGLSS_RSTFPGA = (0x00000001<<0),  /* FPGA reset pin                 */
  LB2DM3_TGLSS_DF      = (0x00000001<<1),  /* Dataflow cntrl (enable/disable) */
  LB2DM3_TGLSS_PPSTAG  = (0x00000001<<5),  /* PPSTAG data (enable/disable)   */
  LB2DM3_TGLSS_HBFBYP  = (0x00000001<<6),  /* HBF control (enable/bypass)    */
  LB2DM3_TGLSS_RAMP    = (0x00000001<<7),  /* Ramp output (enable/bypass)    */
  LB2DM3_TGLSS_SPINV   = (0x00000001<<8),  /* IQ swap     (enable/bypass)    */
  LB2DM3_TGLSS_EXTREF  = (0x00000001<<9),  /* External Ref (enable/disable)  */
  LB2DM3_TGLSS_PRESEL  = (0x00000001<<10), /* RF Preselector (enable/bypass) */
  LB2DM3_TGLSS_AGC     = (0x00000001<<11), /* RF AGC (enable/bypass) */
  LB2DM3_TGLSS_MTGO    = (0x00000001<<12), /* Module trigger Go (ena/dis) */
  LB2DM3_TGLSS_LSBP    = (0x00000001<<13), /* PPS in LSB (ena/dis) */
  LB2DM3_TGLSS_EQ      = (0x00000001<<14), /* Equalizer Control (enable/bypass) */
  LB2DM3_TGLSS_DIO     = (0x00000001<<15), /* DIO output on enable           */
  LB2DM3_TGLSS_LFSR    = (0x00000001<<16)  /* DIO output = LFSR              */
};
