package nxm.ice.lib;

/**
  A class to wrap simulated verilog cores

  @author Jeff Schoen
  @version %I%, %G%

*/
public class VCore extends Object {

  protected static boolean useNative;

  //* default do nothing constructor */
  public VCore() {
    load();
  }

  //* load the native libraries */
  public static boolean load() {
    if (!useNative) try { nxm.sys.lib.Shell.loadLibrary("ice","lib","VCore"); useNative=true; }
    catch (Exception e) { throw new RuntimeException (e); }
    return useNative;
  }

  public native int open();
  public native int syswr (int addr, int value);
  public native int syswrn (int addr, int value, int clocks);
  public native int sysrd (int addr);
  public native int process (byte[] indata, int nin, byte[] outdata, int nout, int nbw);
  public native int close();

}
