package nxm.ice.lib;

import nxm.ice.lib.IceHW;

public class IceJVMFat extends IceJVM {

  // normal static vars
  public static int store0;
  public static int store1;
  public static int store2;
  public static int store3;

  public static void run() {
    int tick;
    for (tick=1;;tick=tick+1) {
      processMessage();
      awMem(HBT,tick);
    }
  }

  public static void processMessage() {
    int opcode,data1,data2,data3;

    maddr = MSG;
    opcode = mdata;
    if (opcode<=0) return;

    data1 = mdata;
    data2 = mdata;

    switch (opcode) {
    case 1: mdata = data1+data2; break;
    case 2: mdata = data1-data2; break;
    case 3: mdata = data1*data2; break;
    case 4: mdata = data1/data2; break;
    case 5: mdata = data1<<data2; break;
    case 6: mdata = data1>>data2; break;
    case 7: mdata = data1&data2; break;
    case 8: mdata = data1|data2; break;
    case 9: mdata = data1^data2; break;
    case 10: 
      for (int i=0; i<data2; i++) data1++;
      mdata = data1;
      break;
    case 11:
      store1 = data1;
      store2 = data2;
      store3 = store1 + store2;
      mdata  = store3;
      break;
    case 12:
      mdata = data1;
      maddr = data2;
      ioadr = 0x4000;
      ioctl = IOCTL_RD|data1;
      break;
    case 13:
      mdata = data1;
      maddr = data2;
      ioadr = 0x4000;
      ioctl = IOCTL_WR|data1;
      break;
    default:
      mdata = 999;
    }
    maddr=MSG;
    mdata=-opcode;
  }
}
