package nxm.ice.lib;

import nxm.sys.lib.Shell;
import nxm.sys.lib.Privileges;

/** A class to interface to Native function libraries.

  @author Jeff Schoen 
  @version $Id: FileIO.java,v 1.41 2014/08/05 20:44:11 ntn Exp $
*/
public class FileIO {

  private static boolean canUse=initUse();

  public static boolean initUse() {
    boolean use;
    use = Shell.getPriv(Privileges.PRIV_NATIVE);
    use = use && Shell.loadLibrary ("ice","lib","FileIO");
    return use;
  }
  
  public static native int fopen (String fname, int dir, int flags);
  public static native int fread (int fd, long lbuf, int boff, int bytes);
  public static native int fwrite (int fd, long lbuf, int boff, int bytes);
  public static native int freadb (int fd, Object buf, int boff, int bytes);
  public static native int fwriteb (int fd, Object buf, int boff, int bytes);
  public static native long fseek (int fd, long offset);
  public static native void fclose (int fd);
  public static native long fid (int fd);

  public static int fopen (String fname, int dir) {
    return fopen(fname,dir,0);
  }

  public native static byte[] allocBufferN (byte[] buf, int bytes);
  public native static int    freeBufferN (byte[] buf);

  // for allocating a page aligned buffer from Java
  public static byte[] allocBuffer (int bytes) {
    byte[] buf = new byte[bytes+64+4096];
    return allocBufferN(buf,bytes);
  }

  // for freeing a page aligned buffer from Java
  public static void freeBuffer (byte[] buf) {
    freeBufferN(buf);
  }

  private native static long malloc_buf (long size);
  private native static int mfree_buf (long addr);

 /** 
    Allocates a block of native memory 
    @param size number of bytes to allocate
    @return pointer to the beginning of the allocated block of memory
   */
  public static long malloc (long size) {
    if (!canUse) return malloc_buf(size);
    System.out.printf("Problem opening native FileIO library!\n");
    return -1;
  }

  /**
   Frees a block of native memory
    @param ptr pointer to the starting address to free
    @return 0 for success
   */
  public static int mfree (long ptr) {
    return mfree_buf(ptr);
  }

}
