/***********************************************************************
  Description:	IOC definitions for ICE cards IOC chip
  Author: 	Jeff Schoen - Innovative Computer Engineering
  Date:		1/97

  0x00010000 is the /CS of the PCI chip
  0x00400000 is off-chip region 0
  0x00500000 is off-chip region 1
  0x00600000 is off-chip region 2
  0x00700000 is off-chip region 3
  0x00800000 is off-chip region U

************************************************************************/

/* Address mappings */
#if _PPC
#define IOC_ADDR	0x00400000
#elif _ICEPIC4|_ICEMBT4
#define IOC_ADDR	0x200
#else
#define IOC_ADDR	0x80000000
#endif

#if _ICEPIC2
#define REG_IOB    EMS_B0
#define REG_AIOCA  REG_AIOC
#define REG_AIOCD  REG_AIOC
#define REG_AIOBA  REG_AIOC
#define REG_AIOBD  REG_AIOC
#elif _ICEMBT2
#define REG_IOB    (EMS_B0|0x8000)
#define REG_AIOCA  (EMS_B0|0xC000)
#define REG_AIOCD  (EMS_B0|0xC001)
#define REG_AIOBA  (EMS_B0|0xC002)
#define REG_AIOBD  (EMS_B0|0xC003)
#elif _ICEPIC3      		/* bit 0x00010000 is /CS */
#define REG_IOB    (EMS_B3|0x10000)
#define REG_AIOCA  (EMS_B0|0x10000)
#define REG_AIOCD  (EMS_B0|0x10001)
#define REG_AIOBA  (EMS_B3|0x10002)
#define REG_AIOBD  (EMS_B3|0x10003)
#elif _ICEMBT3      		/* bit 0x00010000 is /CS */
#define REG_IOB    (EMS_B2|0x10000)
#define REG_AIOCA  (EMS_B0|0x10000)
#define REG_AIOCD  (EMS_B0|0x10001)
#define REG_AIOBA  (EMS_B2|0x10002)
#define REG_AIOBD  (EMS_B2|0x10003)
#elif _ICESLIC3      		/* bit 0x00000020 is /CS */
#define REG_IOB    (EMS_B3|0x10020)
#define REG_AIOCA  (EMS_B2|0x10020)
#define REG_AIOCD  (EMS_B2|0x10021)
#define REG_AIOBA  (EMS_B3|0x10020)
#define REG_AIOBD  (EMS_B3|0x10020)
#elif _ICEPIC4      		/* no /CS */
#define REG_IOB    (EMS_B3|0x00000)
#define REG_AIOCA  (EMS_B0|0x00000)
#define REG_AIOCD  (EMS_B0|0x00001)
#define REG_AIOBA  (EMS_B3|0x00002)
#define REG_AIOBD  (EMS_B3|0x00003)
#elif _ICEMBT4      		/* no /CS */
#define REG_IOB    (EMS_B3|0x00000)
#define REG_AIOCA  (EMS_B0|0x00000)
#define REG_AIOCD  (EMS_B0|0x00001)
#define REG_AIOBA  (EMS_B3|0x00002)
#define REG_AIOBD  (EMS_B3|0x00003)
#else
#define REG_IOB    0x00400000
#define REG_AIOCA  REG_AIOC
#define REG_AIOCD  REG_AIOC
#define REG_AIOBA  REG_AIOC
#define REG_AIOBD  REG_AIOC
#endif

/* IOC registers */
#define IOC_A		0x40	/* modifier for side 1 */
#define IOC_B		0x80	/* modifier for side 2 */
#define IOC_AB		0xC0	/* modifier for side 3 (both) */

/* per side resources */
#define IOC_IOM		0x00	/* module control register (3 bytes) */
#define IOC_STAT	0x00
#define IOC_OVSR	0x03	/* tuner oversampling factor */
#define IOC_FRAME	0x04	/* IOC frame decimation reg (2 bytes deep) */
#define IOC_FRAMEL	0x05	/* IOC frame length (2 bytes deep) */
#define IOC_PROG	0x06	/* IOM programming register (1 byte) */
#define IOC_TCMODE	0x07	/* time code mode */
#define IOC_TCGEN	0x08	/* time code generate sequence */
#define IOC_GAP		0x08	/* readback GAP data */
#define IOC_TCOUNT	0x0C	/* time code count */
#define IOC_UREG	0x10	/* user registers */
#define IOC_FLAGS	0x10	/* PIC5 flags */
#define IOC_DELAY	0x11	/* PIC5 delay */
#define IOC_TAPS	0x12	/* PIC5 taps */
#define IOC_MINC	0x13	/* PIC5 mixclk sample increment */
#define IOC_SEQ		0x14	/* PIC5 sequence */
#define IOC_FLIP	0x15	/* PIC5 spectral flip config */
#define IOC_EMT		0x16	/* EMT config {pow2[3:0],nmax[11:0]} */
#define IOC_RAM		0x20	/* IOC RAM block for TC, etc. */
#define IOC_PKTHDR	0x80	/* IOC RAM block for PKTHDR */

/* global resources */
#define IOC_PGMC	0x00	/* programmable clock registers */
#define IOC_PGMC1	0x01	/* programmable clock registers */
#define IOC_PGMC2	0x02	/* programmable clock registers */
#define IOC_PGMCS	0x04	/* programmable clock reference source */
#define IOC_PGMCB	0x06	/* clock calibration mode */
#define IOC_IRIG	0x08	/* irig-b control register */
#define IOC_TCS		0x10	/* tuner chip select */
#define IOC_DIV		0x20	/* internal clock divider */
#define IOC_TPSEL	0x28	/* test select and port enable */
#define IOC_GMC		0x30	/* global master clock */
#define IOC_GAUX	0x31	/* global auxiliary settings */
#define IOC_CLKDLY	0x38	/* clock delays taps 0,2,4,6 ns */

#define IOC_DT_CDAT	0x01
#define IOC_DT_CCLK	0x02
#define IOC_DT_CSTB	0x04
#define IOC_DT_AHI	0x08

#define IOC_DT_RM	0x01
#define IOC_DT_RMEN	0x02
#define IOC_DT_CE	0x04
#define IOC_DT_CEEN	0x08
#define IOC_DT_CS	0x10
#define IOC_DT_CSEN	0x20
#define IOC_DT_RS	0x40
#define IOC_DT_RSEN	0x80

#define IOC_STAT_ENA	0x01
#define IOC_STAT_ENB	0x02
#define IOC_STAT_ERR	0x04
#define IOC_STAT_SEN	0x08
#define IOC_STAT_TNCLK	0x10
#define IOC_STAT_TDC	0x20
#define IOC_STAT_TCYC	0x40
#define IOC_STAT_TVAL	0x80

#define IOC_TC_BARKER	0x27
#define IOC_TC_TST	0x01
#define IOC_TC_RST	0x02
#define IOC_TC_HIT	0x04
#define IOC_TC_SWAP	0x08
#define IOC_TC_OPPS	0x10
#define IOC_TC_IRIG	0x20
#define IOC_TC_FILL1	0x40
#define IOC_TC_NODC	0x80
#define IOC_TC_SDN	0x100
#define IOC_TC_SDDS	0x200

/* IOC mode bits */
#define IOC_FLG_IN	0x01
#define IOC_FLG_OUT	0x02
#define IOC_FLG_DCM	0x04
#define IOC_FLG_SDDS	0x08
#define IOC_FLG_RAMP	0x10
#define IOC_FLG_WHITE	0x20
#define IOC_FLG_LOOP	0x40
#define IOC_FLG_GOOD	0x80
#define IOC_FLG_ISX	0x100
#define IOC_FLG_RESET	0x200
#define IOC_FLG_IRBF	0x400
#define IOC_FLG_QDRX	0x800	/* Dual Input|Output port mode */
#define IOC_FLG_TOUT	0x1000
#define IOC_FLG_OHOS	0x2000	/* Output Hold Off Select */
#define IOC_FLG_M20F	0x4000	/* M20 fixup */
#define IOC_FLG_UP12	0x8000	/* 12 bit unpack */
#define IOC_FLG_NOFC	0x10000	/* no flow control */
#define IOC_FLG_CBEN	0x20000	/* clock buffer enable */
#define IOC_FLG_MGGO	0x40000	/* no flow control */
#define IOC_FLG_ZFILL	0x80000	/* zero fill between packets */
#define IOC_FLG_SSCLK	0x100000/* spread spectrum clock */
#define IOC_FLG_CSEL	0x200000/* PLL clock select */
#define IOC_FLG_QDRM	0x400000/* QDR match mode */
#define IOC_FLG_SEQF	0x800000/* sequence fill mode */

/* IO Module control word bits */
#define IOM_ENA  0x000001  /* Enable external port transfer */
#define IOM_LEN  0x000002  /* Link Port Enable */
#define IOM_TEN  0x000004  /* Tuner Enable */
#define IOM_SEN  0x000008  /* Sync Enable */

#define IOM_PLY  0x000010  /* Acquire=0 Playback=1 */
#define IOM_COE  0x000020  /* Module Clock Output enable */
#define IOM_MCOE 0x000040  /* External Module Control #1  OE */
#define IOM_MCEN 0x000080  /* External Module Control #2  EN */

#define IOM_16B  0x000000  /* 16-Bit external data */
#define IOM_08B  0x000100  /* 8-Bit external data */
#define IOM_04B  0x000300  /* 1-Bit external data big endian */
#define IOM_01B  0x000200  /* 1-Bit external data */
#define IOM_01BB 0x000300  /* 1-Bit external data big endian */
#define IOM_BITS 0x000300  /* N-Bit field mask */

#define IOM_B15  0x000000  /* Bit 15 input (def) */
#define IOM_B03  0x000000  /* Bit 03 input */
#define IOM_B01  0x000400  /* Bit 01 input */
#define IOM_B04  0x000800  /* Bit 04 input */
#define IOM_B00  0x000C00  /* Bit 00 input */
#define IOM_FX12  0x000400  /* Fix 12b packet */
#define IOM_UP12  0x000800  /* Cvt 12b to 16b */

#define IOM_LSBX 0x001000  /* LSB xsync insertion */
#define IOM_UOPT 0x002000  /* configuration specific option */
#define IOM_CLKI 0x004000  /* Invert input/output clock */
#define IOM_MSBI 0x008000  /* Invert MSB (input only) */

#define IOM_SGO  0x010000  /* Slaved GO (wait for rising edge of slave pin) */
#define IOM_TGO  0x020000  /* Trigger start on slave input */
#define IOM_GGO  0x040000  /* Gated input clock */
#define IOM_XGO  0x080000  /* External triggered go */

#define IOM_DUAL 0x100000  /* Dual link port | clock edge transfer */
#define IOM_MUX  0x200000  /* Dual channel mux */
#define IOM_VHS  0x400000  /* Very High Speed Mode */
#define IOM_VOPT 0x400000  /* Very High Speed Mode */
#define IOM_ALT  0x800000  /* Alternate Input Port */

#define IOM_PORTS    0x07000000  /* Port in use mask */
#define IOM_PORT_L1  0x01000000  /* Link Port 1 in use */
#define IOM_PORT_L2  0x02000000  /* Link Port 2 in use */
#define IOM_PORT_L3  0x04000000  /* Link Port 3 in use */
#define IOM_PORT_S1  0x08000000  /* Serial Port 1 in use */

#define IOM_FLIP     0x04000000  /* PIC5+ Spectral flipping */
#define IOM_CLKM     0x08000000  /* PIC5+ MuxClk=1 */
#define IOM_BMUX     0x80000000  /* PIC5+ Block Mux */

#define IOM_NOSEN    0xFFFFFFF7 /* mcfg1 noSEN mask */
#define IOM_NOSGN    0x7FFFFFFF /* mcfg1 no sign bit */

#define IOP_PGM    0x01  /* Module program mode */
#define IOP_RST    0x02  /* Module program mode */
#define IOP_RD     0x04  /* Module program mode */
#define IOP_CLK    0x08  /* Module program mode */
#define IOP_SBIT0  0x10  /* Module program mode */
#define IOP_CBIT0  0x00  /* Module program mode */

#define IOP_RCLK  0x01	/* LVDS clock reset */
#define IOP_ACLKD 0x02	/* LVDS clock adjust down */
#define IOP_ACLKU 0x06	/* LVDS clock adjust up */

#define DLY_A	   0x10	/* channel A delay */
#define DLY_B	   0x20	/* channel B delay */
#define DLY_M	   0x40	/* channel Mux delay */
#define DLY_TAP0   0x00 /* tap=0 delay=0.6 */
#define DLY_TAP1   0x01 /* tap=0 delay=1.8 */
#define DLY_TAP2   0x03 /* tap=0 delay=3.0 */
#define DLY_TAP3   0x07 /* tap=0 delay=4.8 */
#define DLY_INV    0x08 /* invert signal */

#define IRB_IRIG  0x01 /* enable IRIGB */
#define IRB_OPPS  0x02 /* enable 1PPS */
#define IRB_SWAP  0x04 /* swap IRIG=X/OPPS=0 default bits */

#define GMC_CLKN 0	/* GMCS clock NONE */
#define GMC_CLKI 1	/* GMCS clock Internal/N */
#define GMC_CLKC 2	/* GMCS clock Crystal */
#define GMC_CLKA 3	/* GMCS clock A */
#define GMC_CLKB 4	/* GMCS clock B */
#define GMC_CLKX 5	/* GMCS clock eXternal */
#define GMC_CLKP 6	/* GMCS clock Programmable */
#define GMC_CLKD 7	/* GMCS clock Crystal/N */
#define GMC_CLKQ 8	/* GMCS clock Programmable / 64 */

#define GMC_XSYNCOE  0x10	/* GMCR External sync OE */
#define GMC_XSYNCEN  0x20	/* GMCR External sync comparator/AC EN */
#define GMC_NONCONT  0x40	/* GMCR Non-Continuous Clock */
#define GMC_XSYNCTP  0x40	/* GMCR External on internal test port */
#define GMC_XSYNCTRM 0x80	/* GMCR External 50ohm termination */
#define GMC_DEGLITCH 0x80	/* GMCR Clock DeGlitch Circuit */

#define GMC_PWR5OFF  0x80	/* GMMR 5V power off */


