/***********************************************************************
  Description:	PCI definitions for ICE-PIC cards
  Author: 	Jeff Schoen - Innovative Computer Engineering
  Date:		1/97
************************************************************************/

/* PCI side registers */

#define REG_DVID	0x00		/* Device/Vendor ID */
#define REG_PCSR	0x04		/* Command/Status */
#define REG_CODE	0x08		/* Class Code/Revision ID */
#define REG_PLAT	0x0C		/* Latency Counter */
#define REG_PBAR	0x10		/* Base Address Register #0 */
#define REG_LGIR	0x3C		/* MaxLat, MinGnt, Interrupt */

#define REG_FIFO	0x40		/* Add-on FIFO */
#define REG_MDARH	0x44		/* Master Address (High) */
#define REG_MCSR	0x48		/* Master Control Status */
#define REG_XCMD	0x4C		/* PCI-X Command CID */
#define REG_XSTA	0x50		/* PCI-X Status */
#define REG_IOC		0x54		/* IOC Data */
#define REG_MDAR	0x58		/* Master Address */
#define REG_MDTC	0x5C		/* Master Transfer Count */

#define REG_MWAR	0x58		/* Master Address */
#define REG_MWTC	0x5C		/* Master Transfer Count */
#define REG_MRAR	0x58		/* Master Address */
#define REG_MRTC	0x5C		/* Master Transfer Count */

#define REG_MBX		0x60		/* Offset to Mailboxes */
#define REG_OMBX	0x60		/* Offset to Mailboxes */
#define REG_IMBX	0x70		/* Offset to Mailboxes */

#define REG_OMB1	0x60		/* Output Mailbox #1 */
#define REG_OMB2	0x64		/* Output Mailbox #2 */
#define REG_OMB3	0x68		/* Output Mailbox #3 */
#define REG_OMB4	0x6C		/* Output Mailbox #4 */
#define REG_IMB1	0x70		/* Input Mailbox #1 */
#define REG_IMB2	0x74		/* Input Mailbox #2 */
#define REG_IMB3	0x78		/* Input Mailbox #3 */
#define REG_IMB4	0x7C		/* Input Mailbox #4 */

#define REG_HAR0	0x80		/* Old Host Address Registers or NVME pass-thru command */
#define REG_HAR5	0x94		/* Old Host Address Registers or NVME pass-thru status */
#define REG_HAR6	0x98		/* Old Host Address Registers or NIOP pass-thru status */
#define REG_HAR8	0xA0		/* Old Host Address Registers or NVME pass-thru disk size */

#define REG_HIR8	0xA0		/* Debug register */
#define REG_IOMCRCS	0x1F0		/* IOM State CRC fast access */
#define REG_FIFOT	0x400		/* Add-on FIFO temp registers */

#define MCSR_RPRC	0x00000001	/* Reset PRC */
#define MCSR_RIOC	0x00000002	/* Reset IOC */
#define MCSR_RFIFO	0x00000004	/* Reset FIFO */
#define MCSR_RMBXF	0x00000008	/* Reset PCI */
#define MCSR_MENA	0x00000010	/* Enable PCI master */
#define MCSR_MDIR	0x00000020	/* PCI master direction 1=toHost */
#define MCSR_WIDE	0x00000040	/* Enable 64 bit PCI */
#define MCSR_TEST	0x00000080	/* PCI Self Test */

#define MCSR_BIGE0	0x00000100	/* BigEndianConvert byte swap */
#define MCSR_BIGE1	0x00000200	/* BigEndianConvert short swap */
#define MCSR_BIGE2	0x00000400	/* BigEndianConvert int swap */
#define MCSR_LIOC	0x00000800	/* Load IOC */
#define MCSR_DAC	0x00000800	/* PCIe Dual Address Cycle */
#define MCSR_FLG0	0x00001000	/* Modifier flag bit 0 */
#define MCSR_FLG1	0x00002000	/* Modifier flag bit 1 */
#define MCSR_CLK66	0x00004000	/* 66 MHz PCI Clock  */
#define MCSR_BUS64	0x00008000	/* 64-bit PCI Bus */

#define MCSR_GEN1	0x00001000	/* PCIe Gen1 operation */
#define MCSR_GEN2	0x00002000	/* PCIe Gen2 operation */
#define MCSR_GEN3	0x00003000	/* PCIe Gen3 operation */
#define MCSR_GENX	0x00003000	/* PCIe GenX mask */

#define MCSR_LANE4      0x00004000      /* PIC9 4 Lane PCIe */
#define MCSR_LANE8      0x00008000      /* PIC9 8 Lane PCIe */
#define MCSR_LANE16     0x0000C000      /* PIC9 16 Lane PCIe */
#define MCSR_LANEX      0x0000C000      /* PIC9 X Lane mask */

#define MCSR_OMB1F 	0x00010000	/* Output Mailbox 1 Full */
#define MCSR_OMB2F 	0x00020000	/* Output Mailbox 2 Full */
#define MCSR_OMB3F 	0x00040000	/* Output Mailbox 3 Full */
#define MCSR_OMB4F 	0x00080000	/* Output Mailbox 4 Full */
#define MCSR_IMB1F 	0x00100000	/* Input Mailbox 1 Full */
#define MCSR_IMB2F 	0x00200000	/* Input Mailbox 2 Full */
#define MCSR_IMB3F 	0x00400000	/* Input Mailbox 3 Full */
#define MCSR_IMB4F 	0x00800000	/* Input Mailbox 4 Full */

#define MCSR_OFIFO_FULL 	0x01000000	/* P2C FIFO Full */
#define MCSR_OFIFO_AFULL	0x02000000	/* P2C FIFO Almost Full */
#define MCSR_OFIFO_HALF 	0x04000000	/* P2C FIFO Half Full */
#define MCSR_OFIFO_EMPTY	0x08000000	/* P2C FIFO Empty */
#define MCSR_IFIFO_FULL 	0x10000000	/* C2P FIFO Full */
#define MCSR_IFIFO_AFULL	0x20000000	/* C2P FIFO Almost Full */
#define MCSR_IFIFO_HALF 	0x40000000	/* C2P FIFO Half Full */
#define MCSR_IFIFO_EMPTY	0x80000000	/* C2P FIFO Empty */

#define MCSR_CHANNEL_MASK	0xF0000000	/* current PCI channel */
#define MCSR_SLAVE_SYNC		0x01000000	/* current PCI channel */

#define MCSR_RESET	0x0000000D	/* Almost Full Reset - leave IOC alone */
#define MCSR_ENABLE	0x00000000	/* Enable Standard Mode */
#define MCSR_MASTER_WR	0x00000030	/* Initiate Master Write */
#define MCSR_MASTER_RD	0x00000010	/* Initiate Master Read */
#define MCSR_MASTER_RDM	0x00001010	/* Initiate Master Read Multiple */
#define MCSR_C6TO4	0x10000000	/* CINDEX from 6 to 4 byte addr */
#define MCSR_MASTER_RDMX 0x00003010	/* Initiate Master Read Multiple for Compaq computers */
#define MCSR_MASTER_DAC	0x00000800	/* Initiate Master with DualAddressCycle */

/* CARD side registers */

#define REG_ADVID	(EMS_B1|0x10)		/* Device/Vendor ID */
#define REG_APCSR	(EMS_B1|0x01)		/* Command/Status */
#define REG_ACODE	(EMS_B1|0x02)		/* Class Code/Revision ID */
#define REG_APLAT	(EMS_B1|0x03)		/* Latency Counter */
#define REG_APBAR	(EMS_B1|0x04)		/* Base Address Register #0 */
#define REG_ALGIR	(EMS_B1|0x0F)		/* MaxLat, MinGnt, Interrupt */

#define REG_AFIFO	(EMS_BU|0x00)		/* Add-on FIFO */
#define REG_AMDARH	(EMS_B1|0x11)		/* */
#define REG_AMCSR	(EMS_B1|0x12)		/* Master Control Status */
#define REG_AXCMD	(EMS_B1|0x13)		/* */
#define REG_AXSTA	(EMS_B1|0x14)		/* */
#define REG_AIOC	(EMS_B1|0x15)		/* I/O Controller Chip */
#define REG_AMDAR	(EMS_B1|0x16)		/* Master Address */
#define REG_AMDTC	(EMS_B1|0x17)		/* Master Transfer Count */

#define REG_AMBX	(EMS_B1|0x18)		/* Offset to Mailboxes */
#define REG_AIMB1	(EMS_B1|0x18)		/* Input Mailbox #1 */
#define REG_AIMB2	(EMS_B1|0x19)		/* Input Mailbox #2 */
#define REG_AIMB3	(EMS_B1|0x1A)		/* Input Mailbox #3 */
#define REG_AIMB4	(EMS_B1|0x1B)		/* Input Mailbox #4 */
#define REG_AOMB1	(EMS_B1|0x1C)		/* Output Mailbox #1 */
#define REG_AOMB2	(EMS_B1|0x1D)		/* Output Mailbox #2 */
#define REG_AOMB3	(EMS_B1|0x1E)		/* Output Mailbox #3 */
#define REG_AOMB4	(EMS_B1|0x1F)		/* Output Mailbox #4 */

#define REG_AHIRX	(EMS_B1|0x20)		/* Host Index Register #0 */
#define REG_AHIRY	(0x00800080)		/* Host Index Register #0 */

#define REG_AFIFO_1	(EMS_B1|0x00)		/* Add-on FIFO */
#define REG_AFIFO_2	(EMS_B2|0x00)		/* Add-on FIFO */
#define REG_AFIFO_3	(EMS_B3|0x00)		/* Add-on FIFO */
#define REG_AFIFO_U	(EMS_BU|0x00)		/* Add-on FIFO */

#define REG_SPACE_3	(EMS_B3|0x0E)		/* Add-on FIFO */

#define REG_IOC_DATA	0x00000000
#define REG_IOC_ADDR	0x10000000
#define REG_IOC_AINC	0x30000000

