c************
c   Description : Copy a Midas file/pipe to a PIC RAMDISK file/buffer port 
c
c   Author :    JGS   9/30/98
c
c   $Revision:   1.15  $
c   $Modtime:   01/17/96 10:14:44  $
c   
c************
	program SINKPIC
c
	implicit none
	include 'sinkpic.inc'
	record /HEADER/ HIN,HOUT,HWF
c
	character*8 cnum
	byte      buf(1),out(1)
	pointer   (pbuf,buf),(pout,out)
	logical*4 spinning, wrap, setbreak, donereading, inmem, sss, xts, stats
	integer*4 throttle, mlost, trate, csize, gain
	real*4	  wait, pause, delay, fstat
	real*8    freq, etime(2)
c
	call M$CHECKIN
c
c find the PIC device
	i  = M$HWF_OPEN (hwf) 
	ls = M$HWF_ALIAS (hwf, M$APICK(3), string) 
	i  = M$HWF_CLOSE (hwf) 
c
c open the PIC device
	flags = 0
	if (M$GET_USWITCH('PORT',tmpstr) .gt. 0) then
	  string(ls+1:) = ',PORT='//tmpstr
	  ls = M$LENGTH(string)
	endif
	if (M$GET_USWITCH('FLAGS',tmpstr) .gt. 0) then
	  string = tmpstr(1:M$LENGTH(tmpstr))//','//string
	  ls = M$LENGTH(string)
	endif
	i = M$GET_USWITCH('TC',tcmode)
	if (i.ge.0) then
	  if (i.eq.0) tcmode = 'SDN4'
	  tcoff = M$GET_DSWITCH('TCOFF')
	  if (tcoff.eq.-1) then
	    call M$NOW (time1,time2)
	    i = M$TIMES2TOD (time1,time2,tmpstr)
	    tmpstr(5:) = ':01:01::00:00:00'
	    i = M$TOD2TIMES (tmpstr,tcoff,time2)
	  endif
	  string(ls+1:) = ',TC='//tcmode
	  ls = M$LENGTH(string)
	else
	  tcmode = 'OFF'
	endif
	string(ls+1:ls+2) = ','//CHAR(0)
	if (M$GET_PSWITCH('VERBOSE')) flags = flags.or.FLG_VERBOSE
	status = M$PIC_OPEN (p,string,Mc.break,flags)
	if (status .le. 0) call M$ERROR ('Opening port: '//string)
	status = M$PIC_RESET (p, 0) 
	type  = p.ptype
	port  = p.pindex
c
c open and check input file
	call M$INIT (HIN, M$APICK(1),'1000,2000','SP,SB,SI,SL,CB,CI',0)
	call M$OPEN (HIN, HCBF_INPUT)
	call M$GET_EPOCH (HIN, etime(1),etime(2))
c
c get reduction 
	ired   = M$LPICK(4)	
	if (ired.eq.0) ired = 1
	idelta = iabs(ired)
c
c get freq and gain
	freq = M$DPICK(5)
	gain = M$LPICK(6)
c
c get the transfer length switch
	tl = M$GET_SWITCH('TL')
	throttle = M$GET_SWITCH('THROTTLE')
	setbreak = M$GET_PSWITCH('BREAK')
	wrap = M$GET_PSWITCH('WRAP')
	donereading = .false.
c
c can we allow blocking this file
	noblock = HIN.ape.gt.1 .or. HIN.spa .gt.2
c
c fill out header and open output file
	call M$INIT (HOUT, M$APICK(2),'1000,2000','SP,SB,SI,SL,CB,CI',0)
	call M$OPEN (HOUT, HCBF_INPUT+HCBF_APPEND)
	rate  = 1.d0 / max(1.d-9,HOUT.xdelta)
	ape = HOUT.ape
	spe = HOUT.ape * HOUT.spa
	epb = HOUT.size 
	dbpe = HOUT.dbpe
	L_bbuf = min(L_bbuf, NINT(epb*dbpe/4))
c
c check for consistent file parameters
	if (HIN.format .ne. HOUT.format) then
	  call M$ERROR('In/Out file formats do not match')
	elseif (HIN.ape .ne. HOUT.ape) then
	  call M$ERROR('In/Out file frame lengths do not match')
	endif
c
c get startup modes
	mpp = 0
	msync = 0
	msyncid = M$GET_SWITCH('MASTER')
	if (msyncid.gt.0) msync = 1
	i = M$GET_USWITCH('SLAVE',cnum)
	if (i.ge.0) msync = 2
	sss = (i.eq.2 .and. cnum.eq.'SS') ! same side slave
	xts = (i.eq.2 .and. cnum.eq.'XT') ! external trigger slave
	mgo = -1			! non-piped default
	if (Mc.mode.ne.0) mgo = 2	! piped default
	mgo = M$GET_SWITCH_DEF('REPLAY',mgo)
	if (msync.ge.2) mgo = 0		! slave wait
c
c get sync results label
	if (M$GET_USWITCH ('SYNC', synclab).le.0) synclab = ' '
	if (M$GET_USWITCH ('LOST', lostlab).le.0) lostlab = ' '
	if (M$GET_USWITCH ('PFULL',statlab).le.0) statlab = ' '
c
c start-up wait time 
	wait  = M$GET_DSWITCH('WAIT')
	if (wait.lt.0) wait  = M$GET_DSWITCH('PAUSE')
	pause = M$GET_DSWITCH_DEF('POLL',0.025d0)
	delay = M$GET_DSWITCH_DEF('DELAY',0.2d0)
	stats = M$GET_PSWITCH('STATS')
c
c init the PIC device parameters
	dir   = 1	! Write only primitive
	bps   = HOUT.bps
	spa   = HOUT.spa
	bits  = HOUT.dbpe / HOUT.ape / HOUT.spa * 8
	if (spa .eq. 2) bits = -bits
	bits  = M$GET_SWITCH_DEF ('BITS',bits)
	rate  = M$GET_DSWITCH_DEF ('SRATE',rate)
	trate = M$GET_SWITCH_DEF ('TRATE', max(10000,NINT(rate/8)) )
	dmac  = -1
	delta = HOUT.xdelta
	nblock = max(0,tl) * HOUT.dbpe / HOUT.ape
c
c init the PIC device for IO
	flags = 0
	if (msync.gt.1) flags = FLG_SGO
	if (sss) flags = FLG_RGO
	if (xts) flags = FLG_XTGO
	if (throttle.eq.1 .or. throttle.eq.4) flags = flags .or. FLG_NCCLK
	if (type.eq.IOPT_TUNER) call M$ERROR ('No sink to tuner port')
	dmac = M$PIC_IOPORT (p, type, port, dmac, dir,
     &		bits, NINT(rate), 2*freq/rate, ired, gain, flags)
        if (dmac.le.0) call M$ERROR ('Bad I/O Port parameters')
	fmode = M$GET_SWITCH_DEF('FMODE',1)
	status = M$PIC_MAPFILE (p, map, HOUT, fmode) 
	if (status.le.0) call M$ERROR ('Unacceptable DMA output file')  
	nbytes = map.bytes
	status = M$PIC_DMASETUP (p, dmac, dir, map, nblock, 0)
	if (status.le.0) call M$ERROR ('Unacceptable channel for DMA')  
c
c set up real time controls
	idm = M$MWINIT('Replay Mode',mgo,'REPLAY;Play One,Continuous,'//
     &		'Stop Top,Stop Now,Spin,Reload,ReStart,Abort')
	ids = M$MWINIT('Sync Mode',msync,'Master,Slave Wait,Slave Run')
	idr = M$DWINIT('Sample Rate', rate, 1.d0, 100.d6, 1.d3)
	idd = M$LWINIT('Reduction', ired, -512, 32768, 1)
	idc = M$LWINIT('Curr Cycle', 0, 1, -1, 1)
	idlh = M$LWINIT('Lost HostBuf', 0, 1, -1, 1)
	idlc = M$LWINIT('Lost CardBuf', 0, 1, -1, 1)
c
c report the DMA channel
	if (M$GET_USWITCH('DMAC',tmpstr).gt.0) call M$LRSLT(tmpstr,dmac)
c
c initialize parameters
        nbuf = 0 	! dynamic memory size
	nlost = 0
	mlost = 0
	npass = 0
	ncycle = 1
	lastout = 0
	outoff = 0
	call RAMSYNC (P_SYNCINIT,status)
	if (etime(1).gt.0.0) i = M$PIC_SETKEY (p, dmac, KEY_TCOFF, etime, 16)
	i = M$PIC_GETKEY (p, dmac, KEY_CBUFSZ, csize, 4)
c
c is data already in memory
	inmem = HOUT.file_name .eq. HIN.file_name
	if (inmem .and. HOUT.mode .ne. 1) then
	  pout = map.vaddr 
	  call M$GRAB(HIN,out,1.d0,NINT(HIN.size),-1)
	endif
c
c signal start of processing block
	call M$SYNC()
c
c initial slave sync up
	if (msyncid.gt.0) call M$MWPUT(msyncid-1,mgo)	
	if (wait.gt.0) call M$PAUSE(wait)
c
c top of throttle loop
  1	do while (mgo.eq.0 .or. mgo.eq.3 .or. mgo.eq.4 .or. mgo.eq.7)
	  call UPDATE(status,0)
	  isok = M$MWGET(idm,mgo)
	  if (mgo.eq.7) then ! restart ?
	    mgo = 2 ! already stopped - just start
	    call M$MWPUT(idm,mgo)
	  elseif (mgo.eq.3 .or. mgo.eq.4) then
	    mgo = 0
	    call M$MWPUT(idm,mgo)
	  endif
	  if (msyncid.gt.0) call M$MWPUT(msyncid-1,mgo)	
	  if (Mc.break .or. mgo.eq.8) goto 999
	  call M$PAUSE(pause)
        enddo
	dstart = min( 0.5*HOUT.size, delay*rate )
	dstart = min( HOUT.size, max(dstart, 2.0*csize/HOUT.dbpe) )
	if (throttle.eq.1) dstart = HOUT.size+1
	if (throttle.eq.2) dstart = HOUT.size
	if (throttle.eq.4) dstart = 0
	if (HIN.pipe.eq.0 .and. .not.wrap) dstart = min(dstart,HIN.size)
	spinning = mgo.eq.5
c
c make sure the slaved PIC device is running
	if (msyncid.gt.0) then	
	  isok = M$MWGET (msyncid,ssync)
	  do while (ssync.eq.2 .and. .not.Mc.break)	! wait for slave
	    call M$PAUSE (pause)
	    isok = M$MWGET (msyncid,ssync)
	  enddo
	endif
c
c update the pass through RAM buffer count
  2	npass = npass + 1
	call M$LWPUT (idc,npass)
c
c get stride
	! reduction widget was polled in UPDATE
	if (ired.eq.0) ired = 1
 	if (ired.lt.-1 .and. noblock) then
	  call M$WARNING('Cannot perform blocking on input data type')
	  ired = 1
	endif
	idelta = iabs(ired)
c
c calculate copy and stride lengths in bytes
	iskip = 1
	icopy = max( 1.d0, HIN.dbpe)
	mdbpe = max( HIN.dbpe, HOUT.dbpe )
	if (icopy*(ired-1).lt.512) then	! small stride
	  iper = tl
	  if (iper.le.0) iper = max(1, NINT(L_bbuf/mdbpe))
	else					! large stride
	  iper = 1 
	  iskip = idelta
	endif
	ibuf = iper*mdbpe
	if (ibuf.gt.nbuf) then
	  call M$MFREE (nbuf,pbuf)
	  nbuf = ibuf
	  call M$MALLOC (nbuf,pbuf)
	endif
c
c set xfer parameters
  3	dnext = 0
	ntogo = HOUT.size
c
c debug statistics output
        if (stats .or. statlab.ne.' ') then
	  status = M$PIC_DMAFUNCX (p,dmac,DMA_STATUS)
	  fstat = FLOAT(status)*100/nbytes
	  if (stats) print *,'Sinkpic top ',npass,ncycle,iper*iskip*HIN.ape,fstat
	  if (statlab.ne.' ') call M$FRSLT (statlab,fstat)
        endif
c
c warn if we are falling way behind
	if (mpp.eq.0) then
	  npass = 1
	else if (throttle.eq.1) then

	elseif (ncycle.gt.npass+nlost) then
!	  print *,'ncyc,pass,lost ',ncycle,npass,nlost
	  if (donereading) then
	    mgo = 8
	    call M$MWPUT(idm,mgo)
	  else
	    status = M$L2A (ncycle-(npass+nlost),cnum)
            if (.not. inmem) then
	      call M$WARNING ('Fell behind '//cnum//' RAM buffers')
            endif
	    nlost = (ncycle-npass)
	    call M$LRSLT (lostlab,nlost)
	  endif
	else
	  ! wait for current data pointer
	  do while (npass+nlost.gt.ncycle+1 .and. .not.Mc.break)
            call RAMSYNC (P_SYNCSTAT,status)
	    call M$PAUSE (pause)
	  enddo
	endif
c
c loop through buffers of data  (data buffer loop)
c
	do while (ntogo.gt.0 .and. .not.Mc.break)
	  nget = min(iper/idelta,ntogo)
          call RAMSYNC (P_SYNCSTAT,status)
c
c get new real time controls
	  call UPDATE(status,1)
c
c dont test pointer if pre-filling the buffer
	  if (mpp.eq.0) then
c
c check for falling behind
	  elseif (npass+nlost.le.ncycle .and. throttle.ne.1) then
	    status = M$PIC_DMAFUNCX (p,dmac,DMA_STATUS)
	    nnext = dnext*HOUT.dbpe
	    if (status .gt. nnext) then
	      if (donereading) then
		mgo = 8
		call M$MWPUT(idm,mgo)
	      else
            if (.not. inmem) then
	        call M$WARNING ('Falling behind one RAM buffer')
            endif
	        nlost = nlost + 1
	        call M$LRSLT (lostlab,nlost)
	      endif
	    endif
c
c wait until space is available
	  elseif (npass+nlost.ge.ncycle+1) then
	    nnext = (dnext+nget)*HOUT.dbpe
	    status = M$PIC_DMAFUNCX (p,dmac,DMA_STATUS)
	    do while ( status .lt. nnext
     &		.and. npass+nlost.ge.ncycle+1 .and. .not.Mc.break)
	      call UPDATE(status,1)
	      call M$PAUSE(pause)
              call RAMSYNC (P_SYNCSTAT,status)
	      if (throttle.eq.1 .and. status.eq.0) status = HOUT.size*HOUT.dbpe
	      if (throttle.eq.3) then
		i = M$PIC_SETKEY (p, dmac, KEY_RATE, NINT(rate), 4)
		throttle = 2
	      endif
	    enddo
	  endif
c
c check for end of file handling
	  if (HIN.pipe .eq. 0) then
	    if (HIN.offset .ge. HIN.size) then
	      if (wrap) then
		HIN.offset = 0
	      else
		donereading = .true.
		nget = 0
	      endif
	    endif
	    if (HIN.offset+nget .gt. HIN.size) nget = HIN.size-HIN.offset
	  endif
	  if (donereading .and. throttle.eq.3) then
	    i = M$PIC_SETKEY (p, dmac, KEY_RATE, NINT(rate), 4)
	    throttle = 2
	  endif
	  if (throttle.eq.4 .and. nget.gt.0) then
	    call M$HCBFUNC(HIN,HCBF_AVAIL,i)
	    if (i.lt.nget) nget = i
	  endif
c
c set the RAM buffer pointer
	  pout = map.vaddr + dnext*HOUT.dbpe 
	  ngot = nget*idelta
	  ntogo = ntogo - nget
	  dnext = dnext + nget
c
c not ready yet
	  if (nget .eq. 0) then
	    call M$PAUSE(pause)
c
c spin mode
	  elseif (spinning .or. inmem) then
	    npot = (ngot+idelta-1)/idelta
c
c large or no skip
	  elseif (iper.eq.1 .or. idelta.eq.1) then	
	    HIN.xfer_len = nget
	    npot = ngot
	    if (HIN.format .eq. HOUT.format) then
              call M$GRABX (HIN,out,ngot)
	    else
              call M$GRABX (HIN,buf,ngot)
	      call M$REFORMAT (buf,HIN.format,out,HOUT.buf_type,ngot)
	    endif
c
c regular thinning/blocking operation
	  else				
	    HIN.xfer_len = ngot
            call M$GRABX (HIN,buf,ngot)
	    call M$REFORMAT (buf,HIN.format,buf,HOUT.buf_type, ngot)
	    npot = (ngot+idelta-1)/idelta
	    if (ired.ge.0) then				! thinning
	      call M$VMOVN (buf,idelta,out,1,npot,icopy)
	    else					! blocking
	      HOUT.buf_type = HOUT.format(2:2)
	      call M$VTYPE (HOUT.buf_type)
	      if (spa .eq. 2) then
		call M$CVBLK (buf,out,idelta,ngot)
	      else
		call M$VBLK (buf,out,idelta,ngot)
	      endif
	    endif
	  endif
!	print *, 'got = ',npass,dnext,ncycle,status,throttle
	  if (throttle.eq.4 .and. nget.gt.0)
     &      i = M$PIC_SETKEY (p,dmac,KEY_INBYTE,NINT(dnext*HOUT.dbpe),4)
c
c make sure the PIC device is running (except in throttle)
	  if (mgo.ne.6 .and. mpp.ne.1 .and. dnext.ge.dstart) then
	    mpp = 1
	    if (mgo.lt.0) then
	      status = M$PIC_DMAFUNC (p,dmac,-mgo)
	    elseif (throttle .eq. 4) then
	      status = M$PIC_DMAFUNC (p,dmac,DMA_ONDEMAND)
	    elseif (mgo.eq.2 .or. mgo.eq.5) then
	      status = M$PIC_DMAFUNC (p,dmac,DMA_CIRCULAR)
	    else
	      status = M$PIC_DMAFUNC (p,dmac,DMA_ONESHOT)
	    endif
	    call RAMSYNC (P_SYNCSET,status)
	    if (msync.gt.1) call M$MWPUT (ids,3)	! report slave running
	  endif 
c
c check throttle control widget
	  isok = M$MWGET(idm,mgo)
	  if (isok.gt.0 .and. msyncid.gt.0) then
	    isok = M$MWGET (msyncid+3,i)
	    do while (i.lt.npass .and. .not.Mc.break)
	      call M$PAUSE(pause)
	      isok = M$MWGET (msyncid+3,i)
	    enddo
	    call M$MWPUT(msyncid-1,mgo)	
	  endif
	  if (mgo.eq.4 .or. mgo.eq.8) ntogo = 0
	  if (throttle.eq.2 .and. mgo.eq.2 .and. .not.donereading) then
	    status = M$PIC_DMAFUNCX (p,dmac,DMA_STATUS)
	    ! at 80% into buffer, check to see if we are keeping up
	    if (status .gt. nbytes*.8 .and. 
     &		(status-dnext*HIN.dbpe).gt. nbytes*.1) then
	      ! fell back by > 10%, temporarily slow the clock
              i = M$PIC_SETKEY (p, dmac, KEY_RATE, trate, 4)
	      throttle = 3
	    endif
	  endif

	enddo
c
c handle throttle modes
	if (throttle.eq.1 .and. mgo.eq.2) then
	  if (mpp.gt.0) then	! restart transfer
	    status = M$PIC_DMAFUNC (p,dmac,DMA_WAIT)
	    status = M$PIC_DMAFUNC (p,dmac,DMA_RESHOT)
	  else			! start transfer
	    status = M$PIC_DMAFUNC (p,dmac,DMA_ONESHOT)
	  endif
	  call RAMSYNC (P_SYNCSET,status)
	  if (msync.gt.1) call M$MWPUT (ids,3)	! report slave running
	  mpp = 1
	endif
c
c update the status widgets
  99    call M$LWPUT(idlh,nlost)
        i = M$PIC_DMAFUNC(p,dmac,DMA_LOST)
	call M$LWPUT(idlc,i)
	if (i.gt.mlost) call M$WARNING ('Lost one or more CardBuffers')
	mlost = i
c
c stop PIC if necessary
	if ((mgo.eq.1 .or. (mgo.ge.3 .and. mgo.ne.5)) .and. mpp.eq.1) then
	  if (msyncid.gt.0) then
	    isok = M$MWGET (msyncid+3,i)
	    isok = M$MWGET (msyncid,ssync)
	    do while (ssync.eq.3 .and. .not.Mc.break)	! wait for stop
	      call M$PAUSE (pause)
	      isok = M$MWGET (msyncid,ssync)
	    enddo
	    isok = M$MWGET (msyncid+3,i)
	  endif
	  do while (ncycle .le. npass+nlost .and. mgo .le. 1)
	    call M$PAUSE(Mc.pause)
            call RAMSYNC (P_SYNCSTAT,status)
	  enddo
	  mpp = 0
	  ! use delay on donereading abort to output extra samples 
	  if (mgo.eq.8 .and. donereading) call M$PAUSE(delay)
	  if (mgo.eq.1) status = M$PIC_DMAFUNC (p,dmac,DMA_WAIT)
	  status = M$PIC_DMAFUNC (p,dmac,DMA_STOP)
	  status = M$PIC_DMAFUNC (p,dmac,DMA_RESET)
	  npass = 0
	  nlost = 0
	  mlost = 0
	  ncycle = 1
	  outoff = lastout
	  if (msync.gt.1) then
	    if (mgo.eq.7) then
	      mgo = 0 ! slave reports stopped
	      call M$MWPUT(idm,mgo)
	    endif
	    call M$MWPUT (ids,2)	! report slave wait
	  endif
	endif
c
c finish RELOAD pass
	if (mgo.eq.6) then
	  npass = 0
	  nlost = 0
	  mlost = 0
	  ncycle = 1
	  mgo = 4
	endif
c
c go back for replay
	if (mgo.ge.0) then
	  if (mgo.eq.1 .or. mgo.eq.3 .or. mgo.eq.4) then
	    mgo = 0
	    call M$MWPUT(idm,mgo)
	  endif
	  if (mgo.eq.2 .and. .not.Mc.break) goto 2
	  if (mgo.eq.5 .and. .not.Mc.break) goto 2
	  if (mgo.ne.8 .and. .not.Mc.break) goto 1
	else
	  mgo = mgo + 1 ! replicate mode
	  call M$MWPUT(idm,mgo)
	  if (mgo.lt.0 .and. .not.Mc.break) goto 1
  	  status = M$PIC_DMAFUNC (p,dmac,DMA_WAIT)
	endif
c
c close PIC DEVICE
  999	status = M$PIC_DMAFUNC (p,dmac,DMA_CANCEL)
	status = M$PIC_MAPFILE  (p, map, HOUT, -fmode) 
	status = M$PIC_CLOSE (p)
c
c close input/output files
	call M$CLOSE(HIN)
	call M$CLOSE(HOUT)
c
	if (setbreak) Mc.break = .true.
	call M$RETURN
	end


	subroutine RAMSYNC (mode,status)
	implicit none
	include 'sinkpic.inc'
	integer*4 mode
	real*4 time

	if (mode.eq.P_SYNCINIT) then		! to initialize
	  statuslast = 0
	  return
	endif
	status = M$PIC_DMAFUNCX (p,dmac,DMA_STATUS)
	if (status.eq.-1) call M$ERROR ('ICE-PIC is down')
	status = max(0,min(nbytes,status))
	if (status.lt.statuslast .or. mode.eq.P_SYNCSET) then 	! next buffer
	  time = SECNDS(0.0)
	  time = time - status/(rate*dbpe/ape)
	  call M$FRSLT (synclab, time)
	  if (mode.eq.P_SYNCSET) return
  	  ncycle = M$PIC_DMAFUNC (p,dmac,DMA_CYCLE) + 1	! 0->1 based
	endif
	statuslast = status
	return
	end


	subroutine UPDATE (status,mode)
	implicit none
	include 'sinkpic.inc'
	include 'qmessages.inc'
	real*8	time, trigger, soy, fsoy, sample
	integer*4 mode, ratex, iredx, iredorig, lostoff

	iredorig = ired
	! look for messages
	if (Mu.id .le. 0) goto 100
	if (M$GET_MSG(mqh,mqd,L_mqd,0.0,0).le.0) goto 100
	if (mqh.name .eq. 'MGO') then
	  if (mqh.ndata.gt.0 .and. mqd.dbuf(1).gt.0) then
	    trigger = mqd.dbuf(1)
	  else
	    trigger = 0
	  endif
 1	  call M$NOW (time1,time2)
	  time = time1 + time2
	  if (trigger.eq.0) then
	  elseif (trigger-time.le.0) then
	    ! take it now
	  elseif (trigger-time.gt.600.d0) then
	    call M$WARNING ('Huge trigger offset in message')
	  else
	    call M$PAUSE (Mc.pause)
	    goto 1
	  endif
	  call M$SEND_MSGL ('=MGO',0,mqh.sender,mqh.info,0,1,'D',time,0)
	  call M$MWPUT (idm, mqh.info)
	elseif (mqh.name .eq. 'RATE') then
	  call M$DWPUT (idr, mqd.dbuf(1) )
	elseif (mqh.name .eq. 'DEC') then
	  call M$LWPUT (idd, NINT(mqd.dbuf(1)) )
	elseif (mqh.name .eq. 'TC') then
	  trigger = mqd.dbuf(1)
	  if (trigger.eq.-1) trigger = lastout
	  lostoff = nlost * epb
	  sample = (trigger-outoff+lostoff) * ape
	  if (ired.gt.1 .and. type.ne.IOPT_TUNER)
     &          sample = sample * ired
          status = M$PIC_TC (p, dmac, sample, delta,
     &                          soy, fsoy, FLG_TCINTERP)
	  mqd.dbuf(1) = trigger
	  mqd.dbuf(2) = tcoff + soy
	  mqd.dbuf(3) = fsoy 
	  if (status.lt.0) mqd.dbuf(2) = 0
	  call M$SEND_MSGL ('=TC',0,mqh.sender,status,0,3,'D',mqd,0)
	elseif (mqh.name .eq. 'RFFREQ') then
          i = M$PIC_SETKEY (p, dmac, KEY_RFFREQ, mqd.dbuf(1), 8)
	elseif (mqh.name .eq. 'RFGAIN') then
          i = M$PIC_SETKEY (p, dmac, KEY_RFGAIN, mqd.ibuf(1), 4)
	elseif (mqh.name .eq. 'REPLAY') then
          mgo = mqh.info
	elseif (mqh.name .eq. 'EXIT') then
	  call M$MWPUT (idm,8)
	else
	  call M$WARNING ('Unexpected message: '//mqh.name)
	endif

 100	continue	! look for widgets
	ratex = M$DWGET(idr,rate)
	iredx = M$LWGET(idd,ired)
	if (ratex.gt.0 .or. iredx.gt.0) then
          i = M$PIC_SETKEY (p, dmac, KEY_RATE, NINT(rate), 4)
	  delta = (ired/rate)
	endif

	return
	end

