c************
c  Description:	Driver functions for the ICE-PIC DSP card
c
c  Author:	Jeff Schoen	9/96	
c
c  $Revision:	$
c  $Modtime:	$
c
c************
	program picdriver
c
	implicit none
	include 'primitive.inc'
	include 'hwlib.inc'
	include 'icelib.inc'
	record /HEADER/ hwf, hcb
	integer*4 i, j, n, status, status_, offset, value, ls, timeout
	integer*4 buf(*), zbuf(*)
	character verb*8, name*16, string*512, label*40, tmpstr*256, cnum*4
	character fn_in*80, statlab*40, tcmode*8, label2*40, trigger*40
	integer*4 nstart, nbytes, errors, value2
	integer*4 port, bits, dec, dmac, dir, flags, dmamode, fmode, dmao
	integer*4 mask, tl, nget, ngot, idb, replay, gain, kick
	integer*4 ndata, block, maxsjump, maxbjump, ntotal
	integer*4 dmap, tcbp, channel, index, values(16)
	integer*4 nchan, xfer, pktlen
	logical*4 all, tuner
	character type
	integer*4 TESTIT,test
	real*4 time, rates(2), wait, arate
	real*8 rate, tune, tcoff, time1, time2, dummy, dfreq
	real*8 etime(2), delta
	pointer (pbuf,buf),(pzbuf,zbuf)
	record /PICSTRUCT/ p
	record /DMAMAP/ map

	call M$CHECKIN

! get the action
	verb = M$UPICK(1)
	if (verb.eq.'DETECT') then
	  status = M$PIC_DETECT(0)
	  goto 999
	endif

! form device alias
	i  = M$HWF_OPEN (hwf)
	ls = M$HWF_ALIAS (hwf, M$APICK(2), string)
	i  = M$HWF_CLOSE (hwf)

	if (M$GET_USWITCH('PORT',label) .gt. 0) then
	  string(ls+1:) = ',PORT='//label
	  ls = M$LENGTH(string)
	endif
	if (M$GET_USWITCH('FLAGS',tmpstr) .gt. 0) then
	  string = tmpstr(1:M$LENGTH(tmpstr))//','//string
	  ls = M$LENGTH(string)
	endif
	i = M$GET_USWITCH('TC',tcmode)
	if (i.ge.0) then
	  if (i.eq.0) tcmode = 'SDN4'
	  tcoff = M$GET_DSWITCH('TCOFF')
	  if (tcoff.eq.-1) then
	    call M$NOW (time1,time2)
	    i = M$TIMES2TOD (time1,time2,label)
	    label(5:) = ':01:01::00:00:00'
	    i = M$TOD2TIMES (label,tcoff,time2)
	    if (tcmode(1:3).eq.'CPU') tcoff = 0
	  endif
	  string(ls+1:) = ',TC='//tcmode
	  ls = M$LENGTH(string)
	else
	  tcmode = 'OFF'
	endif

	flags = 0
        i = M$GET_USWITCH('VERBOSE',cnum)
        if (i.ge.0) then
          if (i.eq.0) string = 'VERBOSE,'//string(1:ls)
          if (i.ne.0) string = 'VERBOSE='//cnum(1:i)//','//string(1:ls)
          ls = M$LENGTH(string)
        endif
	string(ls+1:ls+2) = ','//CHAR(0)

	if (M$GET_USWITCH('STAT',statlab) .lt. 0) statlab = ' '
	all = M$GET_SSWITCH ('ALL')

! open device
	status = M$PIC_OPEN (p,string,Mc.break,flags)
	if (status .le. 0) call M$ERROR ('Opening port: '//string)

! show status
	if (verb.eq.'SNIFF') then
	  flags = 0
	  if (all) flags = -1
	  status = M$PIC_SNIFF (p,flags)

! reset device
	elseif (verb.eq.'HALT') then
	  status = M$PIC_RESET (p,FLG_DISABLE)

! reset device
	elseif (verb.eq.'RESET' .or. verb.eq.'REBOOT') then
	  status = M$PIC_RESET (p,0)
	  if (status.lt.0) then
	    call M$WARNING ('Problem resetting card')
	  elseif (M$PPICK(3)) then
	    label = M$APICK(3)
	    status = M$PIC_LOADFILE (p, '*_'//label, FLG_IOC)
	  endif

! write register
	elseif (verb.eq.'WRITE') then
	  name = M$UPICK(3)
	  offset = M$PIC_NAME2OFFSET(p,name,0)
	  value = M$LPICK(4)
	  if (M$GET_PSWITCH('ADDR')) value = JIBSET(value,31)
	  mask = M$GET_SWITCH ('MASK')
	  if (mask.eq.-1) then
	    status = M$PIC_WRITE (p, offset, value)
	  else
	    status = M$PIC_WRITEM (p, offset, value, mask)
	  endif
	  if (Mu.verbose) write(*,101) value,offset,status
 101	  format(1x,6hWrote ,z8.8,4h at ,z8.8,3h = ,z8.8) 

! read register
	elseif (verb.eq.'READ') then
	  name = M$UPICK(3)
	  offset = M$PIC_NAME2OFFSET(p,name,0)
	  label = M$UPICK(4)
	  status = M$PIC_READ (p, offset, value)
	  if (Mu.verbose .and. label .eq. ' ') then
	    write(*,'(1x,6hRead  ,z8.8,4h at ,z8.8)') value,offset
	  else
	    call M$LRSLT(label,value)
	  endif

! perform tests
	elseif (verb.eq.'TEST') then
	  value = M$LPICK(3)
	  label = M$UPICK(4)
	  if (label.eq.' ') then
	    status = M$PIC_TEST (p,value,1)
	  else
	    status = M$PIC_TEST (p,value,0)
	    call M$LRSLT(label,status)
	  endif

! load SHARC code
	elseif (verb.eq.'LOAD' .or. verb.eq.'LOADSHARC') then
	  label = M$APICK(3)
	  status = M$PIC_LOADFILE (p, label, FLG_SHARC)

! load IOC program
	elseif (verb.eq.'LOADIOC') then
 	  label = M$APICK(3)
	  status = M$PIC_LOADFILE (p, '*_'//label, FLG_IOC)

! load MOD program
	elseif (verb.eq.'LOADMOD') then
 	  label = M$APICK(3)
	  status = M$PIC_LOADFILE (p, label, FLG_MOD+1)

! load PM program
	elseif (verb.eq.'LOADPM') then
 	  label = M$APICK(3)
	  status = M$PIC_LOADFILE (p, label, FLG_PM)

! load FLASH program
	elseif (verb.eq.'LOADFLAS') then
	  print *,'No longer supported from PICDRIVER in X-Midas. Use $ICEROOT/test/flashpic.'

! check FLASH program
	elseif (verb.eq.'CHECKFLA') then
 	  label = M$APICK(3)
	  status = M$PIC_RESET (p,FLG_BOOT) 
	  status = M$PIC_SETKEY (p,0,KEY_VERBOSE,1,4) 
	  status = M$PIC_GETKEY (p,0,KEY_FLASH,value,4) 
	  if (label .eq. ' ') then
	    write(*,'(1x,12hFlash CRC=0x,z8.8)') value
	  else
	    call M$LRSLT(label,value)
	  endif

! get closest available tuner decimation ratio 
	elseif (verb.eq.'TDEC') then
	  port = M$LPICK(5)
	  dec = M$LPICK(6)
	  status = M$PIC_TUNER_DEC (p, dec, port, 0)
	  call M$LRSLT (M$UPICK(4),status)

! get closest available tuner frequency 
	elseif (verb.eq.'TFREQ') then
	  port = M$LPICK(5)
	  tune = M$DPICK(7)
	  tune = M$PIC_TUNER_FREQ (p, tune, 0)
	  call M$DRSLT (M$UPICK(4),tune)

! set tuner oversampling ratio 
	elseif (verb.eq.'OVSR') then
	  value = M$LPICK(4)
	  port = M$LPICK(5)
	  status = M$PIC_TUNER_OVSR (p, value, port, 0)
	  if (status.lt.0) call M$ERROR ('Bad Tuner OVSR parameters')

! load tuner coefficients
	elseif (verb.eq.'LOADFC') then
 	  fn_in = M$APICK(3)
	  port = M$LPICK(5)
	  call M$INIT (hcb, fn_in, '1000','SI',0)
	  call M$OPEN (hcb, HCBF_INPUT)
	  nget = hcb.size
	  call M$MALLOC (nget*hcb.bpe, pbuf)
	  call M$GRAB (hcb, buf, 1.d0, nget, -1)
	  call M$CLOSE (hcb)
	  flags= 0
	  if (M$GET_PSWITCH('NCFIR')) flags = flags .or. FLG_NCFIR
	  status = M$PIC_LOADFC (p, port, buf, nget, flags)
	  call M$FREE (pbuf)

! set timer
	elseif (verb.eq.'TIMER') then
	  status = M$PIC_TIMER (p, M$LPICK(5), M$LPICK(3) )

! acquire/playback data file
	elseif (verb.eq.'ACQUIRE' .or. verb.eq.'PLAY') then

	  test = M$GET_USWITCH ('GOLDTEST',fn_in)
	  dmac  = M$GET_SWITCH_DEF ('DMAC',-1)
	  call M$VFILL(hcb,0,L_header_size/4) ! DR in M$INITIALIZE
	  call M$INIT (hcb, M$APICK(3), '1000',
     &				'SP,SB,SI,SL,SF,CB,CI,CF',0)
	  if (verb.eq.'ACQUIRE') then
	    call M$OPEN (hcb, HCBF_APPEND)
	    dir  = -1
	  else
	    call M$OPEN (hcb, HCBF_INPUT)
	    dir  = 1
	  endif
	  tuner = (p.ptype.eq.IOPT_TUNER) .or. (p.ptype.eq.IOPT_TBANK) 
	  bits = hcb.bps*8
	  if (hcb.bps.le.0) bits = -hcb.bps
	  bits  = M$GET_SWITCH_DEF ('BITS', bits)
	  if (hcb.spa .eq. 2) bits = -bits
	  dec   = M$LPICK(6)
	  if (.not. tuner) dec = 1
	  rate  = dec / max(1.d-9,hcb.xdelta)
	  if (tuner) rate = rate*hcb.spa
	  rate  = M$GET_DSWITCH_DEF ('SRATE',rate)
	  tune  = M$DPICK(7)
	  if (tune.eq.-1) tune = rate*0.25d0
	  gain  = M$LPICK(8)
	  replay = M$GET_SWITCH ('REPLAY')
	  wait = M$GET_DSWITCH ('WAIT')
	  if (wait.lt.0) wait = M$GET_DSWITCH ('PAUSE')
	  tl = M$GET_SWITCH ('TL')
	  block = max(0,tl) * hcb.dbpe
	  kick = M$GET_SWITCH ('KICK')
	  if (M$GET_USWITCH ('TRIGGER',trigger).le.0) trigger = ' '
	  if (M$GET_USWITCH ('ARATE',label).le.0) label = ' '

	  if (replay.eq.2) then
	    dmamode = DMA_CIRCULAR
	  elseif (replay.eq.1) then
	    dmamode = DMA_ONESHOT
	  elseif (replay.eq.5 .and. dir.lt.0) then
	    dmamode = DMA_SPIN
	  elseif (replay.eq.4 .or. replay.eq.5) then
	    dmamode = DMA_LOAD
	  elseif (replay.le.0) then
	    dmamode = -replay
	  else
	    call M$ERROR ('Illegal replay mode')
	  endif

	  ! reset the device
	  status = M$PIC_RESET (p,0)
	  if (status .le. 0) call M$ERROR ('Resetting port: '//string)

	  if (p.ptype .eq. IOPT_TBANK) then
	    status = M$PIC_GETKEY (p,-1,KEY_CHNS,nchan,4) 
	    status = M$PIC_GETKEY (p,-1,KEY_PINDEX,i,4) 
	    if (i.ne.3) nchan = nchan/2
	    nchan = M$GET_SWITCH_DEF('NCHN',nchan)
	    status = M$PIC_SETKEY (p,-1,KEY_CHNS,nchan,4) 
	    xfer = M$GET_SWITCH_DEF('TL',4096)
	    pktlen = M$GET_SWITCH_DEF('PKTLEN',xfer*hcb.bpa)
	    status = M$PIC_SETKEY (p,-1,KEY_PKTLEN,pktlen,4) 
	    dfreq = M$GET_DSWITCH_DEF('DFREQ',(0.5/hcb.xdelta))
	    status = M$PIC_SETKEY (p,-1,KEY_DFREQ,2*dfreq/rate,8) 
	  endif

	  ! set up data port
	  dmac = M$PIC_IOPORT (p, -1,-1, dmac, dir, 
     &		bits, NINT(rate), 2*tune/rate, dec, gain, flags)
	  if (dmac.le.0) call M$ERROR ('Bad I/O Port parameters')

	  ! process the file for DMA access parameters
	  fmode = M$GET_SWITCH_DEF('FMODE',1)
	  status = M$PIC_MAPFILE (p, map, hcb, fmode)
	  if (status.le.0) call M$ERROR ('Unacceptable input file')

	  ! set up host DMA channel
	  status = M$PIC_DMASETUP (p, dmac, dir, map, block, flags)
	  if (status.le.0) call M$ERROR ('Bad DMA channel parameters')

	  call M$SYNC

	  do while (trigger.ne.' ')
	    call M$PAUSE(Mc.pause)
	    if (M$RFIND(trigger,tmpstr,dummy).le.'A') call M$ERROR
     &		('Trigger result not found or must be numeric')
	    if (dummy.gt.0.0) trigger = ' '
	  enddo

	  if (wait.gt.0) call M$PAUSE(wait)

	  pbuf = map.vaddr
	  nbytes = map.bytes
	  if (hcb.mode.ge.2 .and. dir.gt.0) 
     &		call M$FREAD (hcb,buf,hcb.first_byte,nbytes,nget)

	  status = M$PIC_DMAFUNC (p, dmac, dmamode)	! start
	  if (kick.gt.0) status = M$PIC_DMAFUNC (p, kick, DMA_SPIN)
	  time = SECNDS(0.0)

	  if (tcmode.ne.'OFF' .and. dir.le.0) then
	    status = M$PIC_GETKEY (p,dmac,KEY_TIMEOUT,timeout,4) 
  71	    continue
  	    status_ = M$PIC_TC (p, dmac, 0.d0, hcb.xdelta, 
     &					etime(1), etime(2), FLG_TCINTERP)
	    if (status_.ge.0) then
	      call M$PUT_EPOCH (hcb, tcoff+etime(1), etime(2), .false.)
	      call M$UPDATE_HEADER (hcb)
	    else if (M$PIC_DMASTAT(p, dmac, i, j) .eq. 1) then
	      if (status_.ne.-1 .and. status_.ne.-3) 
     &		print *, 'Bad TC status = ',status_
	      call M$PAUSE (Mc.pause)
	      if (timeout.lt.0 .or. SECNDS(time).lt.timeout) goto 71	! still running, try again
	      status = M$PIC_SETKEY (p,dmac,KEY_TIMEOUT,0,4)  ! run out the timer
	    else
	      print *, 'Bad TC status = ',status_
	    endif
	  endif

	  status = M$PIC_DMAFUNC (p, dmac, DMA_WAIT)	! wait
	  time = SECNDS(time)

	  if (test.gt.0 .and. status.ge.0) then
	    status = TESTIT (hcb,buf,fn_in)
	    if (status.eq.1) dir = 0	! its OK, bypass file write
	  endif

	  if (hcb.mode.ge.2 .and. dir.lt.0) 
     &	    call M$FWRITE (hcb,buf,hcb.first_byte,nbytes,nget)

	  if (dmamode.gt.0) then
	    arate = 1.e-6*nbytes*dmamode/max(.001,time)
	    if (Mu.verbose) print *, 'stat = ',status,
     &		' took = ',time,' sec = ', arate, 'Mby/sec'
	    arate = hcb.size*hcb.ape*dmamode/max(.001,time)
	    call M$FRSLT (label, arate)	! samples/second
	  endif
 	  if (replay.eq.5) then
	    status_ = M$PIC_DMAFUNC (p, dmac, DMA_SPIN)		! spin
	  elseif (replay.ne.4) then
	    status_ =  M$PIC_DMAFUNC (p, dmac, DMA_LOST)
	    if (status_.gt.0) print *, 'missed ',status,' blocks'
	    status_ = M$PIC_DMAFUNC (p, dmac, DMA_STOP)		! stop
	    status_ = M$PIC_DMAFUNC (p, dmac, DMA_CANCEL)	! release
	  endif
	  status_ = M$PIC_MAPFILE (p, map, hcb, -fmode)
	  if (replay.eq.4 .and. status.ge.0) status = dmac
	  call M$CLOSE (hcb)
	  goto 99	! skip M$SYNC

! start a spin transfer
	elseif (verb.eq.'START') then
	  dir  = M$GET_SWITCH_DEF('DIR', 0)
	  dmac = M$PIC_IOPORT (p, -1,-1, -1, dir, 
     &		16, 0, 0.d0, 64, 0, FLG_DISABLE)
	  status = M$PIC_DMAFUNC (p, dmac, DMA_SPIN)	! spin

! stop a spin transfer
	elseif (verb.eq.'STOP') then
	  dir  = M$GET_SWITCH_DEF('DIR', 0)
	  dmac = M$PIC_IOPORT (p, -1,-1, -1, dir, 
     &		16, 0, 0.d0, 64, 0, FLG_DISABLE)
	  status = M$PIC_DMAFUNC (p, dmac, DMA_STOP)	! stop
	  status = M$PIC_DMAFUNC (p, dmac, DMA_CANCEL)	! release

! loop active alternate input to named output port 
	elseif (verb.eq.'LOOP') then
	  bits  = M$GET_SWITCH_DEF('BITS', 16)
	  rate = M$GET_DSWITCH_DEF('RATE',10.0d6)
	  dmac = M$PIC_IOPORT (p, -1,-1, 0, 1, 
     &		bits, NINT(rate), 0.d0, 64, 0, 0)

! loop input module-1 to output module-2 port 
	elseif (verb.eq.'LOOPIO') then
	  bits  = M$GET_SWITCH_DEF('BITS', 16)
	  rate = M$GET_DSWITCH_DEF('RATE',10.0d6)
	  dmac = M$PIC_IOPORT (p, IOPT_MODULE,1, -1, -1, 
     &		bits, NINT(rate), 0.d0, 1, 0, 0, 0)
	  dmao = M$PIC_IOPORT (p, IOPT_MODULE,2,  0, 1, 
     &		bits, NINT(rate), 0.d0, 1, 0, FLG_LOOP) ! start output
	  status = M$PIC_DMAFUNC (p, dmac, DMA_LOOP)	! start input
	  wait = M$GET_DSWITCH ('POLL')
	  delta = 1.d0 / rate
	  if (tcmode.ne.'OFF') then
	    call M$SYNC
  11	    call M$PAUSE(0.1)
	    status_ = M$PIC_TC (p,dmac,0.d0,delta,
     &			etime(1),etime(2),FLG_TCINTERP)
	    if (status_ .lt. 0 .and. .not.Mc.break) goto 11
      	    status_ = M$PIC_SETKEY (p,dmao,KEY_TCOFF,etime,16) 
	    if (wait .gt. 0.0 .and. .not.Mc.break) then
	      call M$PAUSE(wait)
	      goto 11
	    endif
	    goto 99	! skip M$SYNC
	  endif

! get a keyed value
	elseif (verb(1:3).eq.'GET' .or. verb.eq.'QUERY') then
	  name = M$UPICK(3)
	  label = M$UPICK(4)
	  index = M$PIC_NAME2KEY (p,name)
	  dmac = M$GET_SWITCH_DEF('DMAC',0)
          n    = M$PIC_GETKEYSIZE(p,index)
          type = CHAR(M$PIC_GETKEYTYPE(p,index))
	  ls = n*4
	  if (type.eq.'D') ls = n*8
	  ls = M$GET_SWITCH_DEF('LEN',ls)
	  if (index.eq.KEY_NDEC) values(1) = M$LPICK(4)
	  if (index.eq.KEY_NFREQ .or. index.eq.KEY_NRATIO) then
	    dummy = M$DPICK(4)
	    call M$MOVE(dummy,values,8)
	  endif
	  status = M$PIC_GETKEY (p,dmac,index,values,ls) 
	  if (status.lt.0) then
	    call M$WARNING('Unrecognized key name: '//name)
	  else if (label.ne.' ') then
	    if (M$GET_PSWITCH('ASCII')) then
	      call M$MOVE (values,%ref(cnum),4)
	      call M$ARSLT(label,cnum)
	    else 
	      i = M$PUT_RESULT(label,values,ls,0,type,0)
	    endif
	  else if (M$GET_PSWITCH('HEX')) then
	    write(*,'(1x,4hKey ,a,3h = ,z8.8)') name,values(1)
	  else if (type .eq. 'D') then
	    call M$MOVE(values,dummy,8)
	    write(*,'(1x,4hKey ,a,3h = ,g12.6)') name,dummy
	  else
	    write(*,'(1x,4hKey ,a,3h = ,i10)') name,values(1)
	  endif

! get a keyed value
	elseif (verb(1:3).eq.'SET') then
	  name = M$UPICK(3)
	  dmac = M$GET_SWITCH_DEF('DMAC',0)
	  ls = M$GET_SWITCH_DEF('LEN',-1)
	  index = M$PIC_NAME2KEY (p,name)
          type = CHAR(M$PIC_GETKEYTYPE(p,index))
	  if (type.eq.'D') then
	    dummy = M$DPICK(4)
	    status = M$PIC_SETKEY (p,dmac,index,dummy,8) 
	  else
	    value = M$LPICK(4)
	    status = M$PIC_SETKEY (p,dmac,index,value,ls) 
	  endif

! join a multicast group
	elseif (verb.eq.'JOIN') then
	  name = M$UPICK(3)
	  value = M$PIC_STR2IP (p,name)
	  status = M$PIC_SETKEY (p,0,KEY_IPCONN,value,4) 

! leave a multicast group
	elseif (verb.eq.'LEAVE') then
	  name = M$UPICK(3)
	  value = M$PIC_STR2IP (p,name)
	  status = M$PIC_SETKEY (p,0,KEY_IPDISC,value,4) 

! test PCI bus speed
	elseif (verb.eq.'SPEC') then
	  status = M$PIC_TEST (p,7,1)

! test PCI bus speed
	elseif (verb.eq.'SPECS') then
	  status = M$PIC_RESET (p,0)
	  call M$INIT (hcb, M$APICK(3), '3000','SF',0)
	  call M$ADDSREC (hcb, 'SRAT', 'SF')
	  call M$ADDSREC (hcb, 'BRAT', 'SF')
	  call M$OPEN (hcb, HCBF_OUTPUT)
	  block = M$GET_SWITCH_DEF ('BLOCK',16384)
	  idb = M$LWINIT ('BlockSize',block,1,512*1024,1)
	  ndata = M$GET_SWITCH_DEF ('SIZE',1024*1024)
	  nbytes = ndata*4
	  if (M$PIC_MAP(p,pbuf,nstart,nbytes,1).le.0)
     &	    call M$ERROR ('Mapping DMA buffer')
	  call M$SYNC
	  call M$PAUSE (0.1)
  90	  continue
	  status = M$PIC_SPEC (p, buf, nstart, ndata, block, ntotal,
     &		rates(1), maxsjump, rates(2), maxbjump, 0)
	  status = M$LWGET(idb,block)
	  call M$FILAD (hcb, rates, 1)
	  if (Mc.mode .gt. 0 .and. .not. Mc.break) goto 90
	  if (M$PIC_MAP(p,pbuf,nstart,nbytes,-1).le.0) continue
	  call M$CLOSE (hcb)
	  goto 99	! skip M$SYNC

! SHARC memory dump
	elseif (verb.eq.'DUMP') then
	  call M$INIT (hcb, M$APICK(3), '1000','SL',0)
          i = '28000'X
	  hcb.xstart = M$GET_SWITCH_DEF ('START',i)
          i = '08000'X
	  hcb.size   = M$GET_SWITCH_DEF ('SIZE' ,i)
	  call M$OPEN (hcb, HCBF_OUTPUT)
	  call M$MALLOC (NINT(hcb.size)*4, pbuf)
	  do i = 1, NINT(hcb.size)
	    offset = '20000000'X
	    offset = offset + NINT(hcb.xstart+i-1)
	    status = M$PIC_READ (p, offset, buf(i))
	  enddo
	  call M$FILAD (hcb, buf, NINT(hcb.size) )
	  call M$FREE  (pbuf)
	  call M$CLOSE (hcb)

! display SHARC DMA parameters 
	elseif (verb.eq.'DMAC') then
	  dmac = M$LPICK(3)
	  call M$PIC_DMADUMP (p,dmac,0)

! test buffer mapping
	elseif (verb.eq.'MAP') then
	  nbytes = M$LPICK(4)
	  print *,'Mapping ',nbytes
	  if (M$PIC_MAP(p,pbuf,nstart,nbytes,1).le.0)
     &	      call M$ERROR ('Mapping DMA buffer')
	  print *,'Mapped ',nbytes,pbuf,nstart
	  call M$MALLOC(nbytes,pzbuf)
	  n = max(1,256*1024*1024/nbytes)
	  time = SECNDS(0.0)
	  do i = 1,n
	    call M$MOVE(buf,zbuf(nbytes/8+1),nbytes/2)
	    call M$MOVE(zbuf(nbytes/8+1),buf,nbytes/2)
	    ! call M$MOVE(buf,zbuf,nbytes)
	  enddo
	  time = SECNDS(time)
	  print *,'Mapped Transfer rate (Mby) ',n*nbytes/time*1e-6
	  time = SECNDS(0.0)
	  do i = 1,n
	    call M$MOVE(zbuf,zbuf(nbytes/8+1),nbytes/2)
	    call M$MOVE(zbuf(nbytes/8+1),zbuf,nbytes/2)
	  enddo
	  time = SECNDS(time)
	  print *,'Unmapped Transfer rate (Mby) ',n*nbytes/time*1e-6
	  print *,'Unmapping ',nbytes,pbuf,nstart	
	  if (M$PIC_MAP(p,pbuf,nstart,nbytes,-1).le.0)
     &	      call M$ERROR ('UnMapping DMA buffer')
	  print *,'UnMapped ',nbytes,pbuf,nstart

! convert NVRAM file to binary
	elseif (verb(1:3).eq.'NVC') then
	  fn_in = M$APICK(3)
	  call M$LOWERCASE (fn_in)
	  call M$PIC_NVRAM (p,fn_in,0)

! write NVRAM 
	elseif (verb(1:3).eq.'NVW') then
	  fn_in = M$APICK(3)
	  call M$LOWERCASE (fn_in)
	  call M$PIC_NVRAM (p,fn_in,0)
	  call M$PIC_NVRAM (p,fn_in,1)

! read NVRAM 
	elseif (verb(1:3).eq.'NVR') then
	  call M$PIC_NVRAM (p,fn_in,-1)

	else
	  call M$ERROR ('Unsupported verb: '//verb)

	endif

! finish up
	call M$SYNC
 99	call M$LRSLT (statlab,status)
 	status = M$PIC_CLOSE (p)
 999	call M$RETURN

	end



	integer*4 function TESTIT (hcb,buf,testfile)
	implicit none
	include 'types.inc'
	include 'headers.inc'
	record /HEADER/ hcb,ht
	integer*4 buf(*),buft(*),ngot,npass,iper,i,j,k,n,skip,mask,md,mt,tmp
	character*80 testfile
	pointer (pbuft,buft)

	testit = -3

	call M$INIT (ht,testfile,'1000','SL,SI,SB,SP,CI,CB',0)
	call M$OPEN (ht,HCBF_INPUT)
	if (M$GET_KEYDATA(ht,'SKIP',skip,4,0,'L') .ne. 4) skip = 0 
	if (M$GET_KEYDATA(ht,'MASK',mask,4,0,'L') .ne. 4) mask = 0 
	iper = ht.size * ht.dbpe / 4
	npass = hcb.size * hcb.dbpe / 4 / iper
	skip = skip * hcb.dbpe / 4
	call M$MALLOC (iper*4,pbuft)
	call M$GRAB (ht,buft,1.0d0,NINT(hcb.size),ngot)
	call M$CLOSE (ht)
	
	k = 0
	mask = .not. mask
	do n = 0,npass-1
	  j = n*iper+skip
	  do i = 1+skip,iper
	    j = j+1
	    mt = (buft(i).and.mask)
	    md = (buf(j).and.mask)
	    if (mt .ne. md) then
		k = k+1
		if (k.gt.16) return
		tmp = buft(i).xor.buf(j)
		write(*,1) j,buft(i),buf(j),tmp
 1		format(1x,'I=',i8.8,' T=',z8.8,' D=',z8.8,'  xor=',z8.8)
	    endif
	  enddo
	enddo
	if (k.le.1) testit = 1
	return
	end
