startmacro/quiet s:device[PIC1] &
  s:clksrc[D] l:nfft[1k] l:ndec[256] l:ntun[-1] l:samplerate[10e6] d:freq[620e3]

res flags "MUXCLK=^clksrc|^/aflags"
picd/flags=^flags reset ^device 
if ntun lt 0 picd/flags=^flags get ^device "CHNS" ntun

calc psdr 10
calc buflen 0.5
calc l:ntun ntun 8 min
calc nyquist samplerate/2
calc osamplerate samplerate/ndec/2
calc pdec samplerate nfft*psdr / round 1 max
calc qdec osamplerate nfft*psdr / round 1 max

res plotmin -50
res plotmax  50

! create test output files
calc fsize buflen*samplerate nfft*2 max 64k max round
pic create testoutA SB fsize samplerate
pic create testoutB SB fsize samplerate
calc fsize buflen*osamplerate nfft*2 max 64k max round
do nn 1 ntun
  pic create testout^nn CI fsize osamplerate
enddo

pipe/panel/controls=gc on 

  sourcepic/id=SPA/port=Module1/flags=^flags/skip=pdec/tl=1/host=y &
		testoutA{fs=nfft} _cbA ^device 1 freq
  fft/id=FFA/mag/log _cbA{fs=0} _cbfA nfft HANN 0
  plot/id=PPA/msgid=main/wname="Module-A" _cbfA type=line 

if /nob isfalse
  sourcepic/id=SPB/port=Module2/flags=^flags/skip=pdec/tl=1/host=y &
		testoutB{fs=nfft} _cbB ^device 1 freq
  fft/id=FFA/mag/log _cbB{fs=0} _cbfB nfft HANN 0
  plot/id=PPB/msgid=main/wname="Module-B" _cbfB type=line 
endif

 do nn 1 ntun
  sourcepic/id=SP^nn/port=tuner^nn/flags=^flags/skip=qdec/tl=1 &
		testout^nn{fs=nfft} _cb^nn ^device ndec freq
  fft/id=FF^nn/mag/log _cb^nn{fs=0} _cbf^nn nfft HANN 0
  plot/id=PP^nn/msgid=main/wname="Tuner-^nn" _cbf^nn type=line 
 enddo

pipe run

gcontrol label  "MACRO" "Macro" 
gcontrol button "MAIN"  ,, "Run,Stop,Exit" 
gcontrol choice "PLOT"  "Plot #" "A,B,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32" 1
gcontrol label  "PORT"  "ICE Port" 
gcontrol dvalue "FREQ"  "TFreq " 0 0 nyquist nyquist*1e-5
gcontrol lvalue "GAIN"  "TGain " 0 -100 100 1 
gcontrol lvalue "DEC"   "TDec  " 0 1 8192 2 
gcontrol button "MODE"  ,, "Cont,One,StopN" 
gcontrol menu   "TEST"  ,"Tests", "StartWB,StopWB,StartNB,StopNB,OneDec,NewDec,OldDec,MultiDec,ReConnect,Restart" /nc=2
gcontrol tval   "TIME"   "TC"     0 1 -1 1  /edit=f

call setupSP


set this.timers 2
set this.timer(0) 1
pipe wait
pipe off

picd reset ^device 

! remove test output files
erase testoutA testoutB
do nn 1 ntun
  erase testout^nn 
enddo

endmacro


procedure processMessage 
if msg.name eqs "TIMER" then
  set gc.TIME.v reg.spa.time.sec
elseif msg.name eqs "MARK" then
  sedit msg.fid nn trim "PP"
  set gc.PLOT.value nn
  call setupSP
elseif msg.name eqs "PLOT" then
  call setupSP
elseif msg.name eqs "FREQ" then
  set SP.freq msg.data
elseif msg.name eqs "DEC" then
  set SP.dec msg.data
elseif msg.name eqs "GAIN" then
  set SP.gain msg.data
elseif msg.name eqs "MODE" then
  set SP.replay msg.data
elseif msg.name eqs "MAIN" then
  if msg.data eqs "EXIT" then
    stop
  elseif msg.data eqs "RUN" then
  elseif msg.data eqs "STOP" then
  endif
elseif msg.name eqs "TEST" then
  if msg.data eqs "STARTWB"
    if reg.spA rexists set reg.spA.replay cont
    if reg.spB rexists set reg.spB.replay cont
  elseif msg.data eqs "STOPWB"
    if reg.spA rexists set reg.spA.replay stop
    if reg.spB rexists set reg.spB.replay stop
  elseif msg.data eqs "STARTNB"
    do nn 1 ntun
      set reg.sp^{nn}.replay cont
    enddo
  elseif msg.data eqs "STOPNB"
    do nn 1 ntun
      set reg.sp^{nn}.replay stop
    enddo
  elseif msg.data eqs "ONEDEC"
    do nn 1 ntun
      set reg.sp^{nn}.dec ndec
    enddo
  elseif msg.data eqs "NEWDEC"
    do nn 1 ntun
      set reg.sp^{nn}.dec 320
    enddo
  elseif msg.data eqs "OLDDEC"
    do nn 1 ntun
      set reg.sp^{nn}.dec 256
    enddo
  elseif msg.data eqs "MULTIDEC"
    do nn 1 ntun
      set reg.sp^{nn}.dec nn*20+ndec
      pause 0.1
    enddo
  elseif msg.data eqs "RECONNECT"
    set sp.replay "STOPNOW"
    set sp.replay "RECONNECT"
    set sp.replay "CONT"
  elseif msg.data eqs "RESTART"
    do nn 1 ntun
      set reg.sp^{nn}.replay "STOPNOW"
      set reg.sp^{nn}.replay "RECONNECT"
      pause .2
    enddo
    do nn ntun 1 -1
      set reg.sp^{nn}.replay "RESTART"
    enddo
  endif
  pause 0.25
  call setupSP
endif
return

procedure setupSP
set nn gc.PLOT.value
set sp reg.sp^nn
set gc.FREQ.value sp.freq
set gc.DEC.value  sp.dec
set gc.GAIN.value sp.gain
set gc.MODE.value sp.replay
return
