startmacro/ps=4m u:device[picj] s:mode[def]

set nfft 2k
if mode eqs "DEF" then
 set rate 100e6
 set dec  100
 set nchn 16
 set freq 10.7e6
 set flg "MUXCLK=P,FTTM=0,INP=2"
 set psz  2k*nchn*4
else
 error "Unsupported flow=^mode"
endif

set crate rate/dec/2
set orate rate/dec
set frep  freq+0.1e6
set skp   256
set cskp  32

picd get ^device type ctype

pic/round=nfft create wbfile si 1M rate

pic/round=psz create nafile ci nchn*crate crate
pic/round=psz create nbfile ci nchn*crate crate
pic/round=psz create ncfile ci nchn*crate crate
pic/round=psz create ndfile ci nchn*crate crate
pic/round=psz create nefile ci nchn*crate crate
pic/round=psz create cafile ci nchn*crate crate
pic/round=psz create cbfile ci nchn*crate crate
pic/round=psz create ctfile ci nchn*crate crate 

picd reset ^device /flags=flg

pipe/panel on

  ! wideband data source
  sourcepic/id=swb/port=module2 wbfile{fs=nfft} _wb ^device skp /flags=flg /host=n /master=sna

  fft/log _wb _wbf nfft=nfft 
  plot/id=wbp _wbf

if mode eqs "DEF" then

 if /tuner then
  sourcepic/id=sna/port=tuner1 nafile{fs=nfft} _na ^device dec freq /flags=(^flg|XOPORT=NONE) /replay=0 /master=snb /skip=cskp
  sourcepic/id=snb/port=tuner2 nbfile{fs=nfft} _nb ^device dec frep /flags=(^flg|XOPORT=NONE) /slave    /master=snc /skip=cskp
  sourcepic/id=snc/port=tuner5 ncfile{fs=nfft} _nc ^device dec frep /flags=(^flg|XOPORT=NONE) /slave=ss /master=snd /skip=cskp
  sourcepic/id=snd/port=tuner6 ndfile{fs=nfft} _nd ^device dec frep /flags=(^flg|XOPORT=NONE) /slave=ss /master=sca /skip=cskp

  fft/log _na _naf nfft=nfft 
  plot/id=nap _naf type=line cm=re y1=-50 y2=90
  fft/log _nb _nbf nfft=nfft 
  plot/id=nbp _nbf type=line cm=re y1=-50 y2=90
 endif

 if /core then
  sourcepic/id=sca/port=core11 cafile{fs=nfft} _ca ^device dec /flags=(^flg|XIPORT=NONE) /slave=ss /master=scb /skip=cskp
  sourcepic/id=scb/port=core12 cbfile{fs=nfft} _cb ^device dec /flags=(^flg|XIPORT=NONE) /slave /skip=cskp

  fft/log _ca _caf nfft=nfft 
  plot/id=cap _caf type=line cm=re y1=-50 y2=90
  fft/log _cb _cbf nfft=nfft 
  plot/id=cbp _cbf type=line cm=re y1=-50 y2=90
 endif

endif

  gcontrol prompt "MODE" "Mode" mode
  gcontrol menu "ACTION" "Do" "Cont,OneShot,Stop,StopWB,Test,DMAC,SYSREG,FTT,Exit" /nc=2 /tleft
  gcontrol pipemon 

pipe off

if /dump then
  icediff testca testcb
endif

erase wbfile nafile nbfile ncfile ndfile nefile cafile cbfile ctfile

endmacro

procedure processMessage msg

if msg.name eqs "ACTION" then
  if msg.data eqs "CONT" or msg.data eqs "ONESHOT" or msg.data eqs "STOP" then
    set reg.sna.replay msg.data
    if reg.sct rexists then set reg.sct.replay msg.data
!    pause 0.5
!    set reg.swb.replay msg.data
  elseif msg.data eqs "RUNM" then
    set reg.sna.replay "CONT"
  elseif msg.data eqs "RUNS" then
    set reg.scb.replay "CONT"
  elseif msg.data eqs "DMAC" then
    pic dmacx device
  elseif msg.data eqs "SYSREG" then
    picd/hex get device "CORE" /port=core11
    picd/hex get device "CORE" /port=core12
  elseif msg.data eqs "FTT" then
    icetest PPC/FTT device
  elseif msg.data eqs "STOPWB" then
    set reg.swb.replay "STOP"
  elseif msg.data eqs "TEST" then
    if mode eqs "DLT" then
      picd/port=tuner1 set ^device DELAY 30e6
      icetest ppc/peek ^device 0xfd000600 4
    endif
  elseif msg.data eqs "EXIT" then
    pipe stop
  endif
endif
return

