!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!  Production Test macro for ICE cards
!
!  Switches:	/NOTUN - no tuner test
!		/NOINT - no internal transfer tests
!		/NOEXT - no external transfer tests
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
startmacro u:device[pic] l:npass[3] u:deviceo[]

global/readall

if /fab gt 0
ask answer "Make sure extender slot power is OFF [Y]/N :"
if answer neqss "Y" goto abort
ask answer "Insert card to be tested into extender slot [Y]/N :"
if answer neqss "Y" goto abort
ask answer "Switch extender slot power to ON [Y]/N :"
if answer neqss "Y" goto abort
picd/flags=test test ^device 91
endif

sedit "^{device}_testin" testin "LOCASE"
sedit "^{device}_testout" testout "LOCASE"

! default to single card test
if deviceo eqs "" res deviceo device

picd get ^device active pstat
if pstat gt 0 then
say "Halting card ..."
picd/stat=pstat halt ^device 
endif

timer set

if /nosig le 0
say "Looking for card signature ..."
picd/stat=pstat sniff ^device 
if pstat lt 0 goto problem_cardsig

say "Testing PCI slave interface ..."
picd/stat=pstat test ^device 2
if pstat gt 0 goto problem_pci

say "Testing PCI master interface ..."
picd/stat=pstat test ^device 7
if pstat gt 0 goto problem_pci

say "Testing PRC reset ..."
picd/stat=pstat test ^device 1
if pstat gt 0 goto problem_pci

say "Testing PRC interface ..."
picd/stat=pstat test ^device 3
if pstat gt 0 goto problem_prc
picd/stat=pstat test ^device 4
if pstat gt 0 goto problem_prc
picd/stat=pstat test ^device 6
if pstat gt 0 goto problem_prc

say "Testing IOC interface ..."
picd/stat=pstat test ^device 5
if pstat gt 0 goto problem_ioc

endif

picd get ^device "TYPE" ctype
picd get ^device "PCIREV" crev
picd get ^device "MTYPE1" mtype1
picd get ^device "MTYPE2" mtype2
picd get ^device "PMTYPE1" pmtype1
picd get ^device "PMTYPE2" pmtype2
picd get ^device "CHNS" tuners
picd get ^device "GCHIP" gchip

if ctype ge 5 and ctype lt 10
say "Testing MainBoard RAM ..."
picd/stat=pstat test ^device 99 
if pstat gt 0 goto problem_dram
endif

if mtype1 eq -100
picd/stat=pstat/flags=iom=test|vhs=1|verbose=2 reset ^device 
endif

if pmtype1 gt 0 and pmtype1 lt 9
say "Testing Processor Module #1 RAM ..."
picd/stat=pstat test ^device 99 /flags=tp=11
if pstat gt 0 goto problem_dram
endif

if pmtype2 gt 0 and pmtype2 lt 9
say "Testing Processor Module #2 RAM ..."
picd/stat=pstat test ^device 99 /flags=tp=12
if pstat gt 0 goto problem_dram
endif

if /speed gt 0
  res rate /speed
else
  res rate 10e6
endif

say "Erasing old test files ..."
erase/warn=n testin testout

say "Creating test files ..."
pic create testin si 64k rate white
pic create testout si 1m rate 

if /b then
  header testin f=sb
  header testout f=sb
endif

if /noint le 0 

say "Testing 1->2 internal transfer T2 ..."
picd reset ^device t2
call testxfer module1 module2 testin testout testin npass
if pstat lt 0 goto problem_xferi

say "Testing 2->1 internal transfer T1 ..."
picd reset ^device t1
call testxfer module2 module1 testin testout testin npass
if pstat lt 0 goto problem_xferi

endif
if /noext le 0

say "Testing 1->2 external transfer OI ..."
picd reset ^device oi
call testxfer module1 module2 testin testout testin npass
if pstat lt 0 goto problem_xferx

say "Testing 2->1 external transfer IO ..."
picd reset ^device io
call testxfer module2 module1 testin testout testin npass
if pstat lt 0 goto problem_xferx

!say "Testing 2->1 external transfer IOX ..."
!picd reset ^device iox
!call testxferx module2 module1 testin testout testin npass
!if pstat lt 0 goto problem_xferx

endif


res tdec 44
if /withovsr then
 res rate 10e6
 res tflags "MUXCLK=I"
elseif /hs ne 0 then
 picd get ^device "CCLK" rate
 res tflags "MUXCLK=C"
else
 res rate 40e6
 res tflags "MUXCLK=I"
endif

picd reset ^device iir

if /notbank le 0 then

 calc tbs 0
 if pmtype1 eq -100 then set tbs 1
 do pm 1 2 
   if pmtype^pm le 0 continue
   if pmtype^pm ge 6 then
     fname tbgold dat gtbank4_32 prm ice
   elseif pmtype^pm le 2 then
     if ctype eq 10 then
       fname tbgold dat gtbank1_32 prm ice
     else
       fname tbgold dat gtbank2_32 prm ice
     endif
   else
     continue
   endif
   calc tbs tbs+1
   pic create testout ci 16k*32/2 rate/(tdec*2)
   do nn 1 3 
     if gchip lt 4 and nn eq 3 continue
     say "Testing tuner bank ^{pm}^{nn} transfer ..."
     call testtbank tbank^{pm}^{nn} testout tbgold npass nn
     if /gtun then stop
     if pstat lt 0 goto problem_xfert
   enddo
 enddo
 if tbs gt 0 then ! now address the main board tuners
   res tflags "^tflags|PMI=0"
   picd/flags=^tflags get ^device "CHNS" tuners
   picd/flags=^tflags get ^device "GCHIP" gchip
   if tuners gt 2 then set l:tuners 2
 endif

endif

picd get ^device "FPGASIG" sig /str

if /notun le 0 and tuners gt 0

 if sig ends "MT" or sig ends "TD" then
  fname tgold dat gtun2x prm ice
  res tflags "^tflags|MBITS=-16"
  set l:tuners 0
 elseif gchip eq 4 then
  fname tgold dat gtun5 prm ice
 elseif gchip eq 2 and ctype neq 4 and ctype neq 10
  fname tgold dat gtun11 prm ice
 else
  fname tgold dat gtun^ctype prm ice
 endif

 pic create testout ci 16k rate/(tdec*2)

 do nn 1 tuners 
  say "Testing tuner ^nn transfer ..."
  call testtuner tuner^nn testout tgold npass nn
  if /gtun then stop
  if pstat lt 0 goto problem_xfert
 enddo

endif

if ctype eq 8 and crev eq 1
  icetest QSFP ^device
endif

timer elapse
erase/warn=n testin testout

say "********************************"
say "* All tests completed normally *"
say "********************************"
if /fab then
picd halt ^device 
!ask answer "Switch extender slot power to OFF [Y]/N :"
!if answer neqss "Y" goto abort
say "It is now safe to remove the card ..."
else 
picd reset ^device
pic status ^device
endif

stop

label abort
say "Test aborted ..."
stop

label problem_cardsig
say "Problem getting the card signature."
say "Try  > Cycle power on card extender."
say "     > Power OFF card extender and reseat card in extender slot."
say "     > Check that EPROM E1 is seated correctly."
say "     > Check connections on E1/U1."
stop

label problem_pci
say "Problem with PCI interface U1."
say "     > Power OFF card extender and reseat card in extender slot."
say "     > Check connections on U1."
stop

label problem_pci64
say "Problem with PCI interface U1."
say "     > Power OFF card extender and reseat card in extender slot."
say "     > Check connections on right side of U1."
stop

label problem_prc_reset
say "Problem with PRC reset U2 <-> U1."
picd/verbose reset ^device
say "     > If error after Loading /boot/ without the O.K. - bad sharc chip
say "     > Check connections on U1/U2 or 40MHz crystal X1."
stop

label problem_prc
say "Problem with PRC interface U2 <-> U1."
say "     > Check connections on U1/U2."
stop

label problem_ioc
say "Problem with IOC interface U3 <-> U1."
say "     > Check connections on LS of U3."
stop

label problem_xferi
say "Problem with IOC internal transfer U3 <-> U2."
say "     > Check connections between U2/U3."
stop

label problem_xferx
say "Problem with IOC external transfer U3 <-> U2."
say "     > Check ribbon cable connection/polarity from H7 to H8."
say "     > Check connections between U3 and H7/H8."
stop

label problem_dram
say "Problem with DRAM interface on processor module."
say "     > Check connections between U1 and M1/M2."
stop

label problem_xfert
say "Problem with tuner chip transfer."
if ctype eq 2 and nn eq 1
 say "     > Check connections between U3 and U4."
elseif ctype eq 2 and nn eq 2
 say "     > Check connections between U3 and U5."
elseif ctype eq 3 
 say "     > Check connections between U3 and T^nn."
elseif ctype eq 4 
 res l:nn2cc (4,5,4,5,4,5,4,5)
 say "     > Check connections between U3 and U^nn2cc(nn-)."
 say "     > Check connections between BR of U3 and RT of U2."
elseif ctype eq 5 or ctype eq 6 or ctype eq 7
 say "     > Its all internal to U1. No joints to check."
elseif ctype eq 8 or ctype eq 9 
 res l:nn2cc (1,2,1,2,1,2,1,2,3,4,3,4,3,4,3,4,5,6,5,6,5,6,5,6)
 res l:chip nn2cc(nn-)
 say "     > Check connections between U3 and G^chip."
 say "     > Check connections between BR of U3 and RT of U2."
 say "     > Check connections on tuner chips in same row as G^chip."
elseif ctype eq 10 or ctype eq 11 
 res l:nn2cc (1,2,1,2,1,2,1,2,5,6,5,6,5,6,5,6,3,4,3,4,3,4,3,4,7,8,7,8,7,8,7,8)
 res l:chip nn2cc(nn-)
 say "     > Check connections on X1 or between U1 and G^chip on DTDM."
 say "     > Check connections on X1 or tuner chips in same row as G^chip."
endif
if "|^nn|" nsubs "|1|2|9|10|17|18|25|26"
  say "     > Looks as though other channels on this chip were OK !
  say "     > Probably a bad tuner chip but - check first."
endif
stop

endmacro


procedure testxfer s:porto s:porti fn:filei fn:fileo fn:fileg l:count

res pstat 0
if /noa and porti eqs "MODULE1" return
if /nob and porti eqs "MODULE2" return

res flags "TO=2|IOM=TEST"
if ctype eq 3 or ctype eq 4 set flags "^flags|DUAL" 
if ctype eq 2 or ctype eq 8 set flags "^flags|XGO" 

do pass 1 count 
say " -> running transfer pass ^pass"

  picd/replay=4/stat=chan/port=^porto/flags=muxclk=i|^flags/quiet &
	play ^deviceo filei
  picd/replay=-3/stat=pstat/kick=chan/port=^porti/flags=^flags/quiet/goldtest=^fileg &
	acquire ^device fileo
  picd/port=^porto/dir=1 stop ^deviceo 

if /goon then res pstat 0
if pstat lt 0 return
enddo

return


procedure testxferx s:porto s:porti fn:filei fn:fileo fn:fileg l:count

res pstat 0
if /noa and porti eqs "MODULE1" return
if /nob and porti eqs "MODULE2" return

res flags "TO=2|IOM=TEST"
if ctype eq 3 or ctype eq 4 set flags "^flags|DUAL" 
if ctype eq 2 or ctype eq 8 set flags "^flags|XGO" 

do pass 1 count 
say " -> running transfer pass ^pass"

picd/replay=4/stat=chan/port=^porto/flags=muxclk=i|^flags/quiet &
	play ^deviceo filei
picd/replay=-3/stat=pstat/kick=chan/port=^porti/flags=muxclk=i|sgo|^flags/quiet/goldtest=^fileg &
	acquire ^device fileo
picd/port=^porto/dir=1 stop ^deviceo 

if /goon then res pstat 0
if pstat lt 0 return
enddo

return



procedure testtuner s:porti fn:fileo fn:fileg l:count l:index

res pstat 0
calc ii index 2 mod
if /noa and ii eq 1 return
if /nob and ii eq 0 return

do pass 1 count 

say " -> running transfer pass ^pass"

picd/replay=1/stat=pstat/port=^porti/flags=^tflags|ioc=iir|to=2/quiet/goldtest="^fileg" &
	acquire ^device fileo ,,, tdec rate*.015

if /goon then res pstat 0
if pstat lt 0 return

enddo

return



procedure testtbank s:porti fn:fileo fn:fileg l:count l:index

res pstat 0
calc ii index 2 mod
if /noa and ii eq 1 return
if /nob and ii eq 0 return

do pass 1 count 

say " -> running transfer pass ^pass"

picd/replay=1/stat=pstat/port=^porti/flags=^tflags|to=2|pmi=^pm|ioc=iir/quiet/goldtest="^fileg" &
	acquire ^device fileo ,,, tdec rate*.015
!picd/port=^porti/flags=^tflags|to=2|pmi=^pm reboot ^device iir

if /goon then res pstat 0
if pstat lt 0 return

enddo

return

