startmacro t:tbl f:cl
  set flags "^tbl.flags|^tbl.aflags|rfgain=^tbl.gain|rffreq=^tbl.cardfreq|rfbw=^tbl.cardbw"
  set wstr "aux=^tbl.aux"
  calc rate ^tbl.rate 1e6 *
  set failure 0

  pic/batch clean
  call cleanFiles
  picd/flags=force|^flags reset ^tbl.card

  ! create the output file
  pic create fileo ^tbl.format ^tbl.fsize rate

  ! acquire
  picd/replay=^tbl.replay/port=^tbl.port/flags=^flags acquire ^tbl.card fileo
  ! get the rf power
  picd/flags=^flags/port=^tbl.port get ^tbl.card rfpwr rxpow
  fft/mag fileo ftmp{^wstr} ^tbl.nfft navg=^tbl.aves win=bh92
  calc fbw ^tbl.cardbw 1e6 * rate /
  calc freq ^tbl.sigfreq ^tbl.cardfreq - 1e6 *
  if ^tbl.format eqs SI then
    ! headermod scalar
    calc delt rate tbl.nfft /
    calc rate rate 2 /
    calc fbeg -rate 2 /
    headermod ftmp xd=^delt xs=^fbeg
  endif
  icemeas char flist{^wstr} ftmp rate fbw ^tbl.threshdb freq
  call procResults flist ^tbl.snr ^tbl.sfdr ^tbl.thresh

  if /plotson or ( failure eq 1 ) then 
    fcalc fplot{^wstr} ftmp log 10 *
    pipe on
      panel/setup
      plot/id=plot1 fplot
      plot/id=plot2 fplot type=line
      list/id=plot3 flist
    pipe off
  endif
  call cleanFiles
endmacro

procedure cleanFiles
  erase/warn=n ftmp flist fplot fileo
return

procedure procResults hi f:vsnr f:vsfdr f:vthresh
 status hi size=sze
  file open/d tag hi
  calc/nform=".00" snr tag.getDataTable(0).snr
  calc/nform=".00" sfdr tag.getDataTable(0).sfdr
  calc/nform=".00" thresh tag.getDataTable(0).thresh

  do ind 1 sze-1 1
    res tmp tag.getDataTable(ind)
    if snr gt tmp.snr
      calc/nform=".00" snr tmp.snr
    endif
    if sfdr gt tmp.sfdr
      calc/nform=".00" sfdr tmp.sfdr
    endif
    if thresh lt tmp.thresh
      calc/nform=".00" thresh tmp.thresh
    endif
  enddo

  file close tag
  ! test thresholds here
  assert/text="Signal-to-Noise (Meas: ^snr, Thresh: ^vsnr)" ^snr gt vsnr
  assert/text="Spur Free Dynamic Range (Meas: ^sfdr, Thresh: ^vsfdr)" ^sfdr gt vsfdr
  assert/text="Median Noise (Meas: ^thresh, Thresh: ^vthresh)" ^thresh lt vthresh
  if ( snr le vsnr ) or ( sfdr le vsfdr ) or ( thresh ge vthresh ) then 
    set failure 1
  endif
return 
