startmacro t:tbl
  set flags "^tbl.flags|^tbl.aflags|rfgain=^tbl.gain|rfbw=^tbl.cardbw"
  set wstr "aux=^tbl.aux"
  calc rate ^tbl.rate 1e6 *

  ! clean out playground
  pic/batch clean
  call cleanFiles

  ! create a file to track peak
  file open/d/n tag2 temp{sr=(FREQ/SD,PEAK/SD)}

  ! for gain linearity
  set minpeak 99999
  set maxpeak -99999
  ! reset the card
  picd/flags=force|^flags reset ^tbl.card
  pic create fileo ^tbl.format ^tbl.fsize rate
  calc freq 1e6 ^tbl.freqoff *
  calc fbw ^tbl.cardbw 1e6 * rate /

  ! loop through the frequencies
  do cardfreq ^tbl.fbeg ^tbl.fend ^tbl.fstep
    set failure 0
    calc sigfreq cardfreq ^tbl.freqoff + 
    ! set the signal generator frequency
    call sourceOn ^tbl.gen ^sigfreq ^tbl.amp 

    ! acquire
    picd/replay=^tbl.replay/port=^tbl.port/flags=^flags|rffreq=^cardfreq acquire ^tbl.card fileo
    ! process
    fft/mag fileo ftmp{^wstr} ^tbl.nfft navg=^tbl.aves win=bh92
    icemeasure char flist{^wstr} ftmp rate fbw ^tbl.threshdb ^freq
  
    call procResults flist ^sigfreq peak ^tbl.snr ^tbl.sfdr ^tbl.thresh
    res mtab {FREQ=^sigfreq,PEAK=^peak}
    ! insert 
    invoke ,, tag2.insertData(-1,mtab)
    if peak lt minpeak then
      set minpeak peak
    endif
    if peak gt maxpeak then
      set maxpeak peak
    endif

    if /plotson or ( failure eq 1 ) then
      fcalc fplot{^wstr} ftmp log 10 *
      pipe on
        panel/setup
        plot/id=plot1 fplot
        plot/id=plot2 fplot type=line
        list/id=plot3 flist
      pipe off
    endif
  enddo
  call sourceOff ^tbl.gen

  ! close the file
  invoke ,, tag2.flush()
  file close tag2

  calc/nform=".00" fdelt maxpeak minpeak - 
  assert/text="Gain Linearity (Meas: ^fdelt, Thresh: ^tbl.fthresh)" ^fdelt le ^tbl.fthresh
  if /plotson or ( fdelt gt ^tbl.fthresh ) then 
    list temp
  endif

endmacro

procedure cleanFiles
  erase/warn=n temp filei fileo ftmp flist fmax fplot fplot2
return

procedure sourceOn s:siggen f:sigfreq f:sigamp
  hw set ^siggen ^{tbl.genfreq}=^sigfreq
  hw set ^siggen ^{tbl.genamp}=^sigamp
  hw set ^siggen ^{tbl.genon}=1
return

procedure sourceOff s:siggen
  hw set ^siggen ^{tbl.genoff}=1
return

procedure procResults hi f:frin peak f:vsnr f:vsfdr f:vthresh
 status hi size=sze
  file open/d tag hi
  calc/nform=".00" snr tag.getDataTable(0).snr
  calc/nform=".00" sfdr tag.getDataTable(0).sfdr
  calc/nform=".00" thresh tag.getDataTable(0).thresh
  calc/nform=".00" peak tag.getDataTable(0).sig

  do ind 1 sze-1 1
    res tmp tag.getDataTable(ind)
    if snr gt tmp.snr
      calc/nform=".00" snr tmp.snr
    endif
    if sfdr gt tmp.sfdr
      calc/nform=".00" sfdr tmp.sfdr
    endif
    if thresh lt tmp.thresh
      calc/nform=".00" thresh tmp.thresh
    endif
    if peak lt tmp.sig
      calc/nform=".00" peak tmp.sig
    endif
  enddo

  file close tag
  ! test thresholds here
  assert/text="Signal-to-Noise, Freq=^frin (Meas: ^snr, Thresh: ^vsnr)" ^snr gt vsnr
  assert/text="Spur Free Dynamic Range, Freq=^frin (Meas: ^sfdr, Thresh: ^vsfdr)" ^sfdr gt vsfdr
  assert/text="Median Noise, Freq=^frin (Meas: ^thresh, Thresh: ^vthresh)" ^thresh lt vthresh
  if ( snr le vsnr ) or ( sfdr le vsfdr ) or ( thresh ge vthresh ) then 
    set failure 1
  endif
return


