startmacro t:tbl
  set flags "^tbl.flags|^tbl.aflags"
  set wstr "aux=^tbl.aux"
  calc rate ^tbl.rate 1e6 *
  set failure 0

  pic/batch clean
  call cleanFiles
  picd/flags=force|^flags reset ^tbl.card

  ! create the output file
  pic create fileo ^tbl.format ^tbl.fsize rate

  picd/flags=^flags/port=^tbl.port set ^tbl.card rffreq ^tbl.cardfreq
  picd/flags=^flags/port=^tbl.port set ^tbl.card rfbw ^tbl.cardbw
  picd/flags=^flags/port=^tbl.port set ^tbl.card rfgain ^tbl.gain

  ! acquire
  picd/replay=^tbl.replay/port=^tbl.port/flags=^flags acquire ^tbl.card fileo

  icemeas/tl=^{tbl.tl} hist flist{^wstr} fileo ^tbl.nbits ^tbl.bitsoff
  call procResults flist ^tbl.thresh

  if /plotson or ( failure eq 1 ) then 
    pipe on
      panel/setup
      plot/id=plot1 fileo
      list/id=plot2 flist
    pipe off
  endif
  call cleanFiles
endmacro

procedure cleanFiles
  erase/warn=n flist fileo 
return

procedure procResults hi f:vthresh
  status hi size=sze
  file open/d tag hi

  table tag.getDataTable(0) getsize nents
  table tag.getDataTable(0) getkeys keys

  do ind 0 sze-1 1
    res tmp tag.getDataTable(ind)
    do n 0 nents-1 1
      set cur ^tmp.^{keys.^n}
      if cur le vthresh then
        file close tag
        assert/text="Bit Wiring (^{keys.^n}: ^cur, Thresh: ^vthresh)" 1 lt 0
        set failure 1
        return
      endif
    enddo
  enddo

  file close tag
  assert/text="Bit Wiring" 1 gt 0

return

