startmacro s:ho l:amp[10k] l:nels[4k] l:rate[1] f:w1[.5] f:w2[.3] f:gap[.05] l:ntaps[128] s:wstr[""]

  calc pad 1 w1 w2 gap + + - 2 /
  if pad lt 0 then 
    say "Error, bandwidth greater than 100%! Please use b.w. percentages for w1, w2 and gap!"
    stop
  endif

  set form si
  ! calc CF's
  calc cf1 w1 2 / pad +
  calc cf2 w2 2 / pad w1 gap + + + 
  ! alter for complex
  if /cmplx istrue then 
    set form ci
    calc w1 w1 2 *
    calc w2 w2 2 *
    calc cf1 cf1 .5 - 2 *
    calc cf2 cf2 .5 - 2 *
  endif

  call cleanFiles
  ! pad length
  calc pels nels ntaps +
  ! generate white noise
  wave tmpwave{^wstr} form=^form shape=white amp=^amp elem=^pels

  ! generate the two pass band filters
  firkais tmpfir1{^wstr} band cf1 w1 ntap=^ntaps
  firkais tmpfir2{^wstr} band cf2 w2 ntap=^ntaps
  ! combine the two filters
  fcalc firf tmpfir1 tmpfir2 + 
  ! apply filter
  fdfilter tmpwave firf tmpo{^wstr}

  reformat tmpo ^ho{^wstr} form

  ! thin off the pad
  thin ^ho ^ho ,, nels
  ! now headermod to the correct frequency/start time
  calc xdel 1 rate /
  headermod ^ho xd=xdel xs=0

  call cleanFiles 

endmacro

procedure cleanFiles
  erase/warn=n tmpwave tmpfir1 tmpfir2 firf tmpo
return
