startmacro t:tbl_rx t:tbl_tx
  set fa "^tbl_rx.flags|^tbl_rx.aflags"
  set fd "^tbl_tx.flags|^tbl_tx.aflags"
  set wstr "aux=^tbl_rx.aux"
  calc rate_tx ^tbl_tx.rate 1e6 *
  calc rate_rx ^tbl_rx.rate 1e6 *

  ! reset card and clean out playground
  picd/flags=force|^fa reset ^tbl_rx.card
  picd/flags=force|^fd reset ^tbl_tx.card
  pic/batch clean
  call cleanFiles
  ! create the file
  file open/d/n tag2 temp{sr=(ATTEN/SD,PEAK/SD,SNR/SD,SFDR/SD,THRESH/SD)}

  ! create a wrapping phase continous tone
  pic create filei si 1m 64 sin 16k 1
  ! calculate signal properties
  calc xdel 1 rate_tx /
  calc freq 1 64 / rate_tx *
  calc rfreq freq 1e6 /
  headermod filei xd=xdel
 
  ! create the output file
  pic create fileo ^tbl_rx.format ^tbl_rx.fsize rate_rx
  set minlevel 99999
  set maxlevel -99999

  ! launch play
  picd/port=^tbl_tx.port/flags=^fd/replay=2/bg play ^tbl_tx.card filei

  ! loop
  do attn ^tbl_tx.abeg ^tbl_tx.aend ^tbl_tx.astep
    set failure 0
    ! set the attenuation
    picd/port=^tbl_tx.port/flags=^fd set ^tbl_tx.card rfattn attn
    ! a2d
    picd/replay=^tbl.replay/port=^tbl_rx.port/flags=^fa acquire ^tbl_rx.card fileo gain=^tbl_rx.gain
    fft/mag fileo ftmp{^wstr} ^tbl_rx.nfft navg=^tbl_rx.aves win=bh92
    icemeasure char flist{^wstr} ftmp rate_rx ^tbl_rx.fbw ^tbl_rx.threshdb freq

    call procResults flist mtab attn aattn ^tbl_rx.snr ^tbl_rx.sfdr ^tbl_rx.thresh
    ! two seperate conditionals in case the max or min is 1st
    if ^aattn lt minlevel
      set minlevel ^aattn
    endif
    if ^aattn gt maxlevel
      set maxlevel ^aattn
    endif
    invoke ,, tag2.insertData(-1,mtab)
    if /plotson or ( failure eq 1 )  then 
      fcalc fplot{^wstr} ftmp log 10 *
      pipe on
        panel/setup
        plot/id=plot1 fileo
        plot/id=plot2 fplot
        plot/id=plot3 fplot type=line
      pipe off
    endif

  enddo

  ! close the file
  invoke ,, tag2.flush() 
  file close tag2
  ! make sure the level was acceptable
  calc/nform=".00" adelta maxlevel minlevel 2 ^tbl_tx.athresh * + - 
  assert/text="Testing Attenuation Ramp (Meas: ^adelta, Thresh: 0)" adelta le 0
  if /plotson or ( adelta gt 0 ) then 
    list temp
  endif
  call cleanFiles
endmacro

procedure cleanFiles
  erase/warn=n temp fileo ftmp flist fmax fplot fplot2
return

procedure procResults hi tab f:attn aattn f:vsnr f:vsfdr f:vthresh
  status hi size=sze
  file open/d tag hi
  calc/nform=".00" snr tag.getDataTable(0).snr
  calc/nform=".00" sfdr tag.getDataTable(0).sfdr
  calc/nform=".00" thresh tag.getDataTable(0).thresh
  calc/nform=".00" accum 10 tag.getDataTable(0).sig 20 / ** sze /

  do ind 1 sze-1 1
    res tmp tag.getDataTable(ind)
    if snr gt tmp.snr
      calc/nform=".00" snr tmp.snr
    endif
    if sfdr gt tmp.sfdr
      calc/nform=".00" sfdr tmp.sfdr
    endif
    if thresh lt tmp.thresh
      calc/nform=".00" thresh tmp.thresh
    endif
    calc/nform=".00" accum 10 tag.getDataTable(0).sig 20 / ** sze / accum +
  enddo

  calc peak accum log 20 *
  file close tag
  ! build table
  res ^tab {ATTEN=^attn,PEAK=^peak,SNR=^snr,SFDR=^sfdr,THRESH=^thresh}
  calc/nform=".00" aattn peak attn +
  ! test thresholds here
  assert/text="Signal/Noise Att=^attn dB (Meas: ^snr, Thresh: ^vsnr)" snr gt vsnr
  assert/text="Spur Free Dynamic Range Att=^attn dB (Meas: ^sfdr, Thresh: ^vsfdr)" sfdr gt vsfdr
  assert/text="Median Noise Threshold Att=^attn dB (Meas: ^thresh, Thresh: ^vthresh)" thresh lt vthresh
  if ( snr le vsnr ) or ( sfdr le vsfdr ) or ( thresh ge vthresh ) then 
    set failure 1
  endif
return

