/*
 *
 * Header file for the ICEPIC PCI device driver.
 *
 * Author: Tom Potthast, tom@espycorp.com
 * Module: picdrv.h
 * Creation Date: 2/10/2000
 *
 * $RCSfile:$
 * $Revision: $
 * $Author: $
 * $Date: $
 */

#define VENDOR_ID 0x1172
#define DEVICE_ID 0x7777
#define PREFIX_STRING "icepic_"
#define WHOAMI PREFIX_STRING
#include "../../inc/icedefs.h"
#include "../../inc/iceioctl.h"
#include "../../inc/iceflex.h"

#define MAXPIC 8
#define MAXIOBUF 100
#define MAXBCNT (1024*1024*1024)
#define NO_ERROR 0

typedef struct {
  pid_t pid;
  pciio_dmamap_t dma_map;
  uvaddr_t usradr;
  alenlist_t Ualen;
  opaque_t cookie;
  size_t bytes;
  int dir;
  int primed;
  unsigned int pciadr;
} DMACHANNEL;

typedef struct {
  pciio_piomap_t addrMap;
  int		attached;
  int		opened;
  caddr_t	membase;
  DMACHANNEL 	dma[MAXIOBUF];
  struct controller *ctlr;
} UCB;


struct DEVICE_INFO_STRUCT {
  UCB ucb;
  device_desc_t dev_desc;
  pciio_intr_t intr_hdl;
  u_char InterruptLine;    /* interrupt line from pci config space */
  u_char InterruptPin;     /* interrupt pin from pci config space */
  short vendor;
  short device_id;
  
  mutex_t        mutex;
  sema_t         eventSema;
  int    abiType;
  __userabi_t   userAbi;
  
  uint32_t driverState;
  
  volatile int boardPresent;
  volatile int boardOpen;
  volatile int refCount;
  
  int numRingBuffers;
  int maxBufferSize;
  
  int debugLevel;
  pciio_slot_t slot;
  vertex_hdl_t   parentVertex;
  vertex_hdl_t   vertex;
  int unit;
};

typedef struct DEVICE_INFO_STRUCT *DEVICE_INFO_PTR;
#define IO_SPACE_SIZE 65535

#define SetInfo(v,i)    device_info_set((v),(i))
#define GetInfo(v)      (DEVICE_INFO_PTR )device_info_get((v))
#define NEW(ptr)    (ptr=kmem_zalloc(sizeof(*(ptr)),KM_SLEEP))
#define DELETE(ptr)      (kmem_free(ptr, sizeof(*(ptr))))
