/**
  Do NOT edit.
  This file is generated by ICEJVCC.
  See UDUC.jv for documentation.
*/
#include "Modefs.c"
#include "Modems.c"
#include "UDAT.c"
#include "DUC.c"

/** Define Signatures */
#define CORE_NAME UDUC
#define CORE_AREA nxm_ice_core
#define CORE_FLOW 3
#include "cores/CoreDefs.h"
#define NP 1
#define AW 16
#define BW 32
#define CW 6

enum { UDUC_SSZ = 2048 };


/** Define CORE Plan Handles */
typedef struct {
  HALO halo;
  UDAT* udp;
  DUC* duc;
  Stream* sa;
  int_1 isAsync;
} UDUC;

#include "cores/CoreProtos.h"

/** CORE Code */

void* UDUC_alloc (char *config) {
  UDUC* plan = UDUC_plan();
  if (plan==NULL) return NULL;
  HW_alloc(plan,config);
  return (void*)plan;
}


int_4 UDUC_upload (UDUC* plan) {
  void *planp=(void*)plan;
  if (HW_isLocal(planp)) return 0;
  HW_push (planp,HW_PREP);
  HW_loadHdr (planp,4);
  HW_loadSub  (planp,0xA3000001);
  HW_loadSub  (planp,0xA3000002);
  HW_loadInt  (planp,0);
  HW_loadInt  (planp,plan->isAsync);
  HW_push (planp,HW_OPEN);
  return 4;
}

int_4 UDUC_init (UDUC* plan) {
  plan->udp = UDAT_subCore (&plan->halo,1);
  plan->duc = DUC_subCore (&plan->halo,2);
  return 0;
}

int_4 UDUC_set (UDUC* plan, String* key, Value* value) {
  if (UDAT_set (plan->udp, key, value) == 0);
  else if (DUC_set (plan->duc, key, value) == 0);
  else return Core_set (plan, key, value);
  return 0;
}

int_4 UDUC_get (UDUC* plan, String* key, Value* value) {
  if (UDAT_get (plan->udp, key, value) == 0);
  else if (DUC_get (plan->duc, key, value) == 0);
  else return Core_get (plan, key, value);
  return 0;
}

int_4 UDUC_open (UDUC* plan) {
  UDAT_open (plan->udp);
  DUC_setRateIn (plan->duc, UDAT_getRate (plan->udp));
  DUC_setCTXF (plan->duc, UDAT_getCTXF (plan->udp));
  DUC_open (plan->duc);
  plan->sa = Stream_new (UDUC_SSZ, BW, BW);
  plan->isAsync = UDAT_isAsync (plan->udp);
  UDUC_upload (plan);
  return 0;
}

int_4 UDUC_process (UDUC* plan, Buffer* bi, Stream* so) {
  while ((plan->isAsync || bi->rok) && so->wok) {
    UDAT_process (plan->udp, bi, plan->sa);
    DUC_process (plan->duc, plan->sa, so);
  }
  return 0;
}

int_4 UDUC_poll (UDUC* plan) {
  DUC_poll (plan->duc);
  return UDAT_poll (plan->udp);
}

int_4 UDUC_close (UDUC* plan) {
  UDAT_close (plan->udp);
  DUC_close (plan->duc);
  HW_push(plan,HW_CLOSE);
  return 0;
}

int_4 UDUC_free (UDUC* plan) {
  HW_free(plan);
  free(plan);
}

#include "cores/CoreHandles.h"

#undef CORE_NAME
#undef CORE_AREA
#undef CORE_FLOW
#undef AW
#undef BW
#undef CW
#undef NP
