/**
  Do NOT edit.
  This file is generated by ICEJVCC.
  See UDAT.jv for documentation.
*/

import CORE_types::*;
package UDAT_types;
import CORE_types::*;
endpackage
import UDAT_types::*;

module UDAT_core #(PORT=1, IBW=64,OBW=IBW, IFLG=0,OFLG=0, IOCLKS=1, IKR=16,OKR=4, PBW=32,PKR=1) (
  input[2:0] s_clks, input s_rst, input s_cs, input[31:0] s_addr,
                     input s_wr, input[31:0] s_wrbus, input s_rd, output[31:0] s_rdbus, output s_ack,
  input[3:0] io_clk, output[1:0] i_rdy, input i_ena, input[7:0] i_sel, input[IBW-1:0] i_bus,
                     output[1:0] o_rdy, input o_ena, output[7:0] o_sel, output[OBW-1:0] o_bus,
  output [7:0] s_test);
  wire T=1,F=0; wire[7:0] T8=~0,F8=0;
  localparam SBW=32, ARRAY=0, STREAM=1, BUFFER=2, BUFSTR=3, PACKET=4;
  localparam BCIO=0, BCI=1, BCO=2, BCIIO=3, BCIOO=4, BCIIIOO=5;
  localparam FRAW=0, FCXI=1, FBIT=2, FAXI=3, FALL=4, FSWP=5;
  localparam TIGHT=8, BPAR=1024, BDMA=2048, BENA=16384, DBLBUF=32768, NEMPTY=131072, RAHEAD=262144;
  localparam FLOW=BUFSTR, BUFCFG=BCIO, SELFPACE=1, PIPE=-1, MC=0, CW=6, AW=16, MBW=256, NP=1, BW=32, SIBW=BW, SOBW=BW, BIBW=BW, BOBW=BW, PIBW=PBW, POBW=PBW, IFMT=FRAW, OFMT=FSWP, DBGBW=32, DBGBD=10, P2=FLOW, P3=NP, P4=BW, P5=0, P6=0, P7=0;
  localparam XIBW=BIBW, XOBW=SOBW;
  localparam BWP=BW/8, IBWP=IBW/8, OBWP=OBW/8, XIBWP=XIBW/8, XOBWP=XOBW/8;
  localparam XIBWO=(XIBW>64)? 4 : (XIBW>32)? 3 : (XIBW>16)? 2 : (XIBW>8)? 1 : 0;
  localparam XOBWO=(XOBW>64)? 4 : (XOBW>32)? 3 : (XOBW>16)? 2 : (XOBW>8)? 1 : 0;
  localparam SUB=(PORT>10)? PORT-10:0;

  wire s_clk=s_clks[0],clk=s_clks[0],clk2=s_clks[1]; wire[1:0] clks=s_clks;
  logic rst,s_wrsys,s_wrscid; logic[31:0] s_sys; logic s_csm,s_csd,s_ena; logic[3:0] s_scid; 
  logic c_rd,c_wr,c_wok; logic[15:0] c_adr; logic[31:0] c_wbus,c_rbus; wire c_ok;
  always @(posedge s_clk) begin
    s_csd <= s_cs && s_addr[11:0]==12'hFFC;
    s_csm <= s_cs && !s_csd;
    s_wrsys <= s_cs && s_wr && s_addr[11:0]==0;
    if (s_rst) s_sys <= 0; else if (s_wrsys) s_sys <= s_wrbus;
    rst <= s_rst || s_sys[23];
    if (s_rst) c_wok <= 1; else if (!c_wr) c_wok <= !s_sys[22];
    s_ena <= (SUB==0)? s_sys[0] : s_clks[2];
  end
  wire frst=!s_ena; wire s_opt=s_sys[4]; wire[3:0] s_ifmt=s_sys[11:8], s_ofmt=s_sys[15:12]; wire [1:0] s_vbpr=s_sys[21:20];
  wire i_frst = frst; wire o_frst = frst; wire p_frst = frst;

  wire [31:0] s_sub, s_rdbusm, s_rdbust; wire [63:0] s_val; wire [15:0] s_ind; wire[25:0] s_set;
  wire s_csr=s_csm && !s_sub[24] && !s_addr[0];
  setter #(26,1) s_bank (clk,rst,s_csm&s_wr,s_addr,s_wrbus,s_sub,s_ind,s_set,s_val);
  portstatusblk #(PORT,"UDAT",P2,P3,P4,P5,P6,P7) s_sblk (s_clk,s_csr,s_addr,s_wr,s_wrbus,s_rd,s_rdbusm, clk,1'b1,c_adr,c_wok&c_wr,c_wbus,c_rd,c_rbus);
  assign s_rdbus = s_rdbusm;

  wire i_clk=io_clk[0], o_clk=(IOCLKS>1)?io_clk[1]:io_clk[0];
  logic bi_rd,so_wen,bi_nxt,bi_rok,so_wok; logic[7:0] so_swaps;
  logic[AW-1:0] bi_adr,bi_len; logic[31:0] bi_dma;
  logic[XIBW-1:0] bi_bus; logic[XIBWP-1:0] bi_sel; logic[XOBW-1:0] so_wbus; logic[XOBWP-1:0] so_wsel;
  logic[XIBWO-1:0] bi_adrb;  always @(posedge s_clk) bi_adrb <= bi_adr;
  logic[7:0] bi_busb; assign bi_busb = bi_bus >> {bi_adrb,3'h0};
  logic i_val; always @(posedge i_clk) i_val <= i_ena;
  wire c_rdy = (SELFPACE!=0) || (bi_rok && so_wok);

  fiaoNxM #(IBW+IBWP,XIBW+XIBWP,IKR,5,IFLG^BPAR,BPAR|BDMA|BENA) f_i (i_clk,i_frst, i_rdy,i_val,{i_sel,i_bus}, s_clk,i_frst, bi_rok,bi_rd,bi_dma,bi_nxt,bi_adr,bi_len,{bi_sel,bi_bus});
  logic so_wen_; logic[XOBWP-1:0] so_wsel_; logic[XOBW-1:0] so_wbus_;   convertEndian f_oswp (s_clk,o_frst,so_swaps, so_wen,so_wsel,so_wbus, so_wen_,so_wsel_,so_wbus_);
  generate if (SUB&2) begin
    assign o_bus=so_wbus_, o_sel=so_wsel_, o_rdy=so_wen_, so_wok=o_ena;
  end else begin
    fifoNxM #(XOBW+XOBWP,OBW+OBWP,OKR,5,BPAR,OFLG^BPAR) f_o (s_clk,o_frst, so_wok,so_wen_,{so_wsel_,so_wbus_}, o_clk,o_frst, o_rdy,o_ena,{o_sel,o_bus});
    if (SUB==2) assign s_ack = bi_rok;
  end endgenerate

  logic c_start,c_done,c_active; logic[15:0] c_cnt,c_stat;
  always @(posedge clk) begin
    if (frst) c_start <= 0; else c_start <= s_ena && c_rdy && !c_start && !c_active;
    if (frst) c_active <= 0; else c_active <= c_start || (c_active && !c_done);
    if (c_start) c_cnt <= 0; else c_cnt <= c_cnt+1;
  end
  flowcontrol f_c (clk, frst, s_opt, c_cnt, c_ok);

  import CORE_funcs::*;

  localparam NL=249, PT_AUTO=-1, PT_NONE=0, PT_NOOP=1, PT_ICE=2, PT_SDDS=3, PT_VRT=4, PT_VRTL=5, PT_VRTW=6, PT_VRTX=7,
     PT_VRTD=8, PF_FILL=0, PF_TIME=1, PF_OUID=2, PF_SOS=3, PF_FB3=4, PF_ANYSID=5, PF_BYPASS=6, PF_CTXF=7, PF_XSR=8,
     PF_XIF=9, PF_XRF=10, PF_XGAIN=11, XFER=256, OUID=1068407, DIFI=6971934;
  localparam CV_halo_sys=0, CV_halo_flag=28, CV_halo_func=64, CV_halo_fmts=68, CV_halo_flow=72, CV_halo_impl=76;
  localparam CV_pkty=256,CV_flags=260,CV_osel=264,CV_sid=268,CV_pinc=272,CV_cwsec=276,CV_nwsec=280,CV_cpsec=284,
    CV_npsec=292,CV_mpsec=300,CV_counts=308,CV_nseq=312,CV_swaps=316,CV_length=320,CV_ifix=324,CV_mfix=328,CV_nfix=332,CV_pad=336,
    CV_pstate=340,CV_npinc=344,CV_ouid=348,CV_pass=352,CV_vctx=356;

  int8 pkty;
  uint12 flags;
  uint8 osel;
  uint16 sid;
  uint20 pinc;
  uint32 cwsec;
  uint32 nwsec;
  uint40 cpsec;
  uint40 npsec;
  uint40 mpsec;
  uint32 counts;
  uint8 nseq;
  int8 swaps;
  uint12 length;
  uint4 ifix;
  uint4 mfix;
  uint4 nfix;
  uint32 pad;
  uint4 pstate;
  uint20 npinc;
  int24 ouid;
  uint4 pass;
  uint28 vctx;

  /* verilator lint_off UNOPTFLAT */
  Line c_ln[249];  wire c_en[249];  wire c_xn[249];
  /* verilator lint_on UNOPTFLAT */

  setLine #(1,0,0) f_1 (c_ln[1],"startMethod",c_start,F);    // public int process ( BufferI bi , StreamO so ) {
  uint14 ulen;                                               // uint14 ulen ;
  uint12 xfer, bfer, i;                                      // uint12 xfer , bfer , i ;
  uint8 ioff, seq;                                           // uint8 ioff , seq ;
  uint4 ooff, bpa, j, k;                                     // uint4 ooff , bpa , j , k ;
  uint6 bps, coff;                                           // uint6 bps , coff ;
  uint32 bx, by, bz;                                         // uint32 bx , by , bz ;
  uint40 lpsec;                                              // uint40 lpsec ;
  int32 difws;                                               // int32 difws ;
  int44 difps;                                               // int44 difps ;
  uint16 id;                                                 // uint16 id ;
  uint2 ifb;                                                 // uint2 ifb ;
  uint10 pfix;                                               // uint10 pfix ;
  int28 dpsec, fpsec;                                        // int28 dpsec , fpsec ;
  int20 phinc;                                               // int20 phinc ;
  int32 bc;                                                  // int32 bc ;
  boolean isNone, isNoop, isICE, isSDDS, isVRT, isVRTi, isVRTj, isVRTd, isVRTc, isVCTX, isSID, isBE, isNB, isOK; // boolean isNone , isNoop , isICE , isSDDS , isVRT , isVRTi , isVRTj , isVRTd , isVRTc , isVCTX , isSID , isBE , isNB , isOK ;
  boolean anyID, hasOUID, hasSID, usePad, useTC, useOUID, anyOUID, fb3, ctxf, xSR, xIF, xRF, xGain, byp; // boolean anyID , hasOUID , hasSID , usePad , useTC , useOUID , anyOUID , fb3 , ctxf , xSR , xIF , xRF , xGain , byp ;
  boolean okICE, okSDDS, okVRT, okIn, okLen, oknSec, doFill, doWrap, doStop, doClip, doTrim; // boolean okICE , okSDDS , okVRT , okIn , okLen , oknSec , doFill , doWrap , doStop , doClip , doTrim ;
  boolean cweqnw, cwgtnw, cwltnw, cpeqnp, cpgtnp, cpltnp, ceqn, cgtn, cltn, lpgtnp, needPad, needFill, needDrop; // boolean cweqnw , cwgtnw , cwltnw , cpeqnp , cpgtnp , cpltnp , ceqn , cgtn , cltn , lpgtnp , needPad , needFill , needDrop ;
  setLine #(1,0,1) f_21 (c_ln[21],"setVar",T,F);             // usePad = flags [ PF_FILL ] ;
  setLine #(1,0,1) f_22 (c_ln[22],"setVar",T,F);             // useTC = flags [ PF_TIME ] ;
  setLine #(1,0,1) f_23 (c_ln[23],"setVar",T,F);             // anyID = flags [ PF_ANYSID ] ;
  setLine #(1,0,1) f_24 (c_ln[24],"setVar",T,F);             // fb3 = flags [ PF_FB3 ] ;
  setLine #(1,0,1) f_25 (c_ln[25],"setVar",T,F);             // ctxf = flags [ PF_CTXF ] ;
  setLine #(1,0,1) f_26 (c_ln[26],"setVar",T,F);             // byp = flags [ PF_BYPASS ] ;
  setLine #(1,0,1) f_27 (c_ln[27],"setVar",T,F);             // useOUID = flags [ PF_OUID ] ;
  setLine #(1,0,1) f_28 (c_ln[28],"setVar",T,F);             // xSR = flags [ PF_XSR ] ;
  setLine #(1,0,1) f_29 (c_ln[29],"setVar",T,F);             // xIF = flags [ PF_XIF ] ;
  setLine #(1,0,1) f_30 (c_ln[30],"setVar",T,F);             // xRF = flags [ PF_XRF ] ;
  setLine #(1,0,1) f_31 (c_ln[31],"setVar",T,F);             // xGain = flags [ PF_XGAIN ] ;
  setLine #(1,0,1) f_32 (c_ln[32],"setVar",T,F);             // isNone = ( pkty == PT_NONE ) ;
  setLine #(1,0,1) f_33 (c_ln[33],"setVar",T,F);             // isNoop = ( pkty == PT_NOOP ) ;
  setLine #(1,0,1) f_34 (c_ln[34],"setVar",T,F);             // okICE = ( pkty == PT_AUTO ) || ( pkty == PT_ICE ) ;
  setLine #(1,0,1) f_35 (c_ln[35],"setVar",T,F);             // okSDDS = ( pkty == PT_SDDS ) ;
  setLine #(1,0,1) f_36 (c_ln[36],"setVar",T,F);             // okVRT = ( pkty == PT_AUTO ) || ( pkty >= PT_VRT ) ;
  setLine #(1,0,1) f_37 (c_ln[37],"setVar",T,F);             // okIn = bi.rok ;
  setLine #(1,0,1) f_38 (c_ln[38],"setVar",T,F);             // phinc = pinc ;
  setLine #(1,0,1) f_39 (c_ln[39],"setVar",T,F);             // okLen = ( length > 0 ) ;
  setLine #(1,0,1) f_40 (c_ln[40],"setVar",T,F);             // doTrim = length < XFER ;
  setLine #(1,1,1) f_41 (c_ln[41],"setVar",T,F);             // xfer = ! okIn ? 0 : doTrim ? length : XFER ;
  setLine #(1,0,1) f_42 (c_ln[42],"setVar",T,F);             // oknSec = ( nwsec > 0 ) ;
  setLine #(1,0,1) f_43 (c_ln[43],"setVar",T,F);             // difws = cwsec - nwsec ;
  setLine #(1,0,1) f_44 (c_ln[44],"setVar",T,F);             // difps = cpsec - npsec ;
  setLine #(1,1,1) f_45 (c_ln[45],"setVar",T,F);             // cwgtnw = ( difws > 0 ) ;
  setLine #(1,1,1) f_46 (c_ln[46],"setVar",T,F);             // cwltnw = ( difws < 0 ) ;
  setLine #(1,2,0) f_47 (c_ln[47],"setVar",T,F);             // cweqnw = ! cwgtnw && ! cwltnw ;
  setLine #(1,1,1) f_48 (c_ln[48],"setVar",T,F);             // cpgtnp = ( difps > ( phinc << 2 ) ) ;
  setLine #(1,1,1) f_49 (c_ln[49],"setVar",T,F);             // cpltnp = ( difps < - phinc ) ;
  setLine #(1,2,0) f_50 (c_ln[50],"setVar",T,F);             // cpeqnp = ! cpgtnp && ! cpltnp ;
  setLine #(1,2,0) f_51 (c_ln[51],"setVar",T,F);             // ceqn = cweqnw && cpeqnp ;
  setLine #(1,2,0) f_52 (c_ln[52],"setVar",T,F);             // cgtn = cwgtnw || ( cweqnw && cpgtnp ) ;
  setLine #(1,2,0) f_53 (c_ln[53],"setVar",T,F);             // cltn = cwltnw || ( cweqnw && cpltnp ) ;
  setLine #(1,1,1) f_54 (c_ln[54],"setVar",T,F);             // needPad = ( usePad && ! okIn ) ;
  setLine #(1,2,1) f_55 (c_ln[55],"setVar",T,F);             // needFill = ( useTC && oknSec && cltn ) ;
  setLine #(1,2,1) f_56 (c_ln[56],"setVar",T,F);             // needDrop = ( pstate == 4 ) && useTC && cgtn ;
  setLine #(1,0,1) f_57 (c_ln[57],"setVar",T,F);             // lpsec = cpsec + ( pinc << 8 ) ;
  setLine #(1,1,1) f_58 (c_ln[58],"setVar",T,F);             // lpgtnp = ( lpsec > npsec ) ;
  setLine #(1,1,1) f_59 (c_ln[59],"setVar",T,F);             // doClip = ( lpsec > mpsec ) ;
  setLine #(1,3,1) f_60 (c_ln[60],"setVar",T,F);             // doFill = ( needPad || needFill || needDrop ) && ! isNoop && ! isNone ;
  setLine #(1,2,1) f_61 (c_ln[61],"setVar",T,F);             // doStop = oknSec && cweqnw && lpgtnp && ! needPad ;
  setLine #(1,3,1) f_62 (c_ln[62],"setVar",T,F);             // fpsec = doClip ? l2i ( mpsec - cpsec ) : doStop ? l2i ( npsec - cpsec ) : ( pinc << 8 ) ;
  setLine #(1,0,1) f_63 (c_ln[63],"setVar",T,F);             // sid = 0 ;
  setLine #(1,0,1) f_64 (c_ln[64],"setVar",T,F);             // ooff = 0 ;
  setLine #(1,0,1) f_65 (c_ln[65],"setVar",T,F);             // seq = 0 ;
  setLine #(1,0,1) f_66 (c_ln[66],"setVar",T,F);             // ifb = 0 ;
  setLine #(1,0,1) f_67 (c_ln[67],"setVar",T,F);             // pfix = 0 ;
  setLine #(1,3,0) f_68 (c_ln[68],"print",s_vbpr[1],F);      // dprint ( "Top  Cur w=%08x p=%012lx  Nxt w=%08x p=%012lx  Counts=%x Pad=%x Fill=%x Drop=%x rOk=%x wOk=%x cnt=%d\n" , cwsec , cpsec , nwsec , npsec , counts , needPad ? 1 : 0 , needFill ? 1 : 0 , needDrop ? 1 : 0 , bi.rok ? 1 : 0 , so.wok ? 1 : 0 , c_cnt ) ;
  setLine #(1,4,0) f_69 (c_ln[69],"If",doFill,F);            // if ( doFill ) {
  setLine #(69,0,1) f_70 (c_ln[70],"setVar",T,F);            // pstate = 1 ;
  setLine #(69,0,1) f_71 (c_ln[71],"setVar",T,F);            // dpsec = fpsec ;
  setLine #(69,0,1) f_72 (c_ln[72],"setVar",T,F);            // bz = pad ;
  setLine #(69,1,0) f_73 (c_ln[73],"While",(so_wok && dpsec > 0) || (ifb != 0),c_xn[82]); // while ( ( so.wok && dpsec > 0 ) || ( ifb != 0 ) ) {
  setLine #(73,0,1) f_74 (c_ln[74],"setVar",T,F);            // cpsec = cpsec + pinc ;
  setLine #(73,0,1) f_75 (c_ln[75],"setVar",T,F);            // ifb = ! fb3 ? 0 : ( ifb == 2 ) ? 0 : ifb + 1 ;
  setLine #(73,0,0) f_76 (c_ln[76],"If",ifix == mfix,F);     // if ( ifix == mfix ) {
  setLine #(76,0,1) f_77 (c_ln[77],"setVar",T,F);            // pfix = pfix + nfix ;
  setLine #(76,0,0) f_78 (c_ln[78],"endIf",c_xn[76],F);      // }
  setLine #(73,0,1) f_79 (c_ln[79],"setVar",T,F);            // ifix = ( ifix == mfix ) ? 0 : ifix + 1 ;
  setLine #(73,0,1) f_80 (c_ln[80],"StreamO_wrLS",T,F);      // so.wrLS ( bz , swaps ) ;
  setLine #(73,0,1) f_81 (c_ln[81],"setVar",T,F);            // dpsec -= pinc ;
  setLine #(73,1,0) f_82 (c_ln[82],"endWhile",c_xn[73],F);   // }
  setLine #(82,0,1) f_83 (c_ln[83],"setVar",T,F);            // counts [ 15 : 12 ] = counts [ 15 : 12 ] + 1 ;
  setLine #(82,0,1) f_84 (c_ln[84],"setVar",T,F);            // bz = 0 ;
  setLine #(82,1,0) f_85 (c_ln[85],"endIfE",c_xn[69],F);     // }
  setLine #(85,4,0) f_86 (c_ln[86],"ElseIf",okLen,c_xn[69]); // else if ( okLen ) {
  setLine #(86,0,1) f_87 (c_ln[87],"setVar",T,F);            // pstate = 2 ;
  setLine #(86,0,1) f_88 (c_ln[88],"setVar",T,F);            // i = 0 ;
  setLine #(86,1,0) f_89 (c_ln[89],"While",so_wok && i < xfer,c_xn[99]); // while ( so.wok && i < xfer ) {
  setLine #(89,0,1) f_90 (c_ln[90],"setVar",T,F);            // cpsec = cpsec + pinc ;
  setLine #(89,0,0) f_91 (c_ln[91],"If",ifix == mfix,F);     // if ( ifix == mfix ) {
  setLine #(91,0,1) f_92 (c_ln[92],"setVar",T,F);            // pfix = pfix + nfix ;
  setLine #(91,0,0) f_93 (c_ln[93],"endIf",c_xn[91],F);      // }
  setLine #(89,0,1) f_94 (c_ln[94],"setVar",T,F);            // ifix = ( ifix == mfix ) ? 0 : ifix + 1 ;
  setLine #(89,0,3) f_95 (c_ln[95],"BufferI_getL",T,F);      // bz = bi.getL ( i << 2 ) ;
  setLine #(89,3,1) f_96 (c_ln[96],"StreamO_wrLS",T,F);      // so.wrLS ( bz , swaps ) ;
  setLine #(89,0,1) f_97 (c_ln[97],"setVar",T,F);            // i ++ ;
  setLine #(89,0,1) f_98 (c_ln[98],"setVar",T,F);            // length -- ;
  setLine #(89,4,0) f_99 (c_ln[99],"endWhile",c_xn[89],F);   // }
  setLine #(99,0,0) f_100 (c_ln[100],"BufferI_rnxt",T,F);    // bi.rnxt ( i << 2 ) ;
  setLine #(99,0,0) f_101 (c_ln[101],"endIfE",c_xn[86],F);   // }
  setLine #(101,4,0) f_102 (c_ln[102],"ElseIf",okIn && isNoop,c_xn[86]); // else if ( okIn && isNoop ) {
  setLine #(102,0,1) f_103 (c_ln[103],"setVar",T,F);         // pstate = 3 ;
  setLine #(102,0,1) f_104 (c_ln[104],"setVar",T,F);         // length = XFER ;
  setLine #(102,1,0) f_105 (c_ln[105],"endIfE",c_xn[102],F); // }
  setLine #(105,4,0) f_106 (c_ln[106],"ElseIf",okIn && ! isNone,c_xn[102]); // else if ( okIn && ! isNone ) {
  setLine #(106,0,1) f_107 (c_ln[107],"setVar",T,F);         // pstate = 4 ;
  setLine #(106,0,1) f_108 (c_ln[108],"setVar",T,F);         // ulen = 0 ;
  setLine #(106,0,3) f_109 (c_ln[109],"BufferI_getL",T,F);   // bx = bi.getL ( 0 ) ;
  setLine #(106,1,3) f_110 (c_ln[110],"BufferI_getL",T,F);   // by = bi.getL ( 4 ) ;
  setLine #(106,2,3) f_111 (c_ln[111],"BufferI_getL",T,F);   // bz = bi.getL ( 8 ) ;
  setLine #(106,3,1) f_112 (c_ln[112],"setVar",T,F);         // anyOUID = ! useOUID || ! bx [ 3 ] ;
  setLine #(106,3,1) f_113 (c_ln[113],"setVar",T,F);         // hasOUID = bx [ 3 ] ;
  setLine #(106,3,1) f_114 (c_ln[114],"setVar",T,F);         // hasSID = ( bx [ 6 : 5 ] > 1 ) ? T : bx [ 4 ] ;
  setLine #(106,5,1) f_115 (c_ln[115],"setVar",T,F);         // isSID = bswap2 ( hasSID ? by [ 31 : 16 ] : bz [ 15 : 0 ] ) == sid ;
  setLine #(106,5,1) f_116 (c_ln[116],"setVar",T,F);         // isVRTi = ( bx [ 7 : 0 ] == 0x1C ) && ( ( bswap4 ( bz ) == ouid ) || anyOUID ) ;
  setLine #(106,4,1) f_117 (c_ln[117],"setVar",T,F);         // isVRTj = ( bx [ 7 : 0 ] == 0x08 ) && ( ( bswap4 ( by ) == ouid ) || anyOUID ) ;
  setLine #(106,5,1) f_118 (c_ln[118],"setVar",T,F);         // isVRTd = ( bx [ 7 : 0 ] == 0x18 ) && ( ( bswap4 ( bz ) == DIFI ) || anyOUID ) ;
  setLine #(106,5,1) f_119 (c_ln[119],"setVar",T,F);         // isVRTc = ( bx [ 7 : 0 ] == 0x49 ) && ( ( bswap4 ( bz ) == ouid ) || anyOUID ) ;
  setLine #(106,3,1) f_120 (c_ln[120],"setVar",T,F);         // isICE = okICE && ( bx == 0x00676665 ) ;
  setLine #(106,6,1) f_121 (c_ln[121],"setVar",T,F);         // isVRT = okVRT && ( isVRTi || isVRTj || isVRTd ) && ( isSID || anyID ) ;
  setLine #(106,6,1) f_122 (c_ln[122],"setVar",T,F);         // isVCTX = okVRT && isVRTc && ( isSID || anyID ) ;
  setLine #(106,7,0) f_123 (c_ln[123],"If",isICE,F);         // if ( isICE ) {
  setLine #(123,0,1) f_124 (c_ln[124],"setVar",T,F);         // ioff = 64 ;
  setLine #(123,0,1) f_125 (c_ln[125],"setVar",T,F);         // seq = by [ 7 : 0 ] ;
  setLine #(123,0,1) f_126 (c_ln[126],"setVar",T,F);         // bfer = bz [ 13 : 0 ] ;
  setLine #(123,0,1) f_127 (c_ln[127],"setVar",T,F);         // ulen = bz [ 13 : 0 ] ;
  setLine #(123,0,3) f_128 (c_ln[128],"BufferI_getL",T,F);   // bx = bi.getL ( 12 ) ;
  setLine #(123,3,1) f_129 (c_ln[129],"setVar",T,F);         // sid = bx [ 31 : 16 ] ;
  setLine #(123,1,3) f_130 (c_ln[130],"BufferI_getL",T,F);   // bx = bi.getL ( 16 ) ;
  setLine #(123,4,1) f_131 (c_ln[131],"setVar",T,F);         // bpa = bx [ 27 : 24 ] ;
  setLine #(123,5,0) f_132 (c_ln[132],"For",j+1 < bpa,F);    // for ( j = 1 ; j < bpa ; j ++ ) {
  setLine #(132,0,1) f_133 (c_ln[133],"setVar",T,F);         // ulen = ulen + bfer ;
  setLine #(132,0,0) f_134 (c_ln[134],"endFor",c_xn[132],F); // }
  setLine #(134,0,0) f_135 (c_ln[135],"endIfE",c_xn[123],F); // }
  setLine #(135,7,0) f_136 (c_ln[136],"ElseIf",isVRT,c_xn[123]); // else if ( isVRT ) {
  setLine #(136,0,1) f_137 (c_ln[137],"setVar",T,F);         // ooff = ( bx [ 2 ] ) ? 4 : 0 ;
  setLine #(136,0,1) f_138 (c_ln[138],"setVar",T,F);         // ioff = ! hasOUID ? 20 : ! hasSID ? 24 : 28 ;
  setLine #(136,0,1) f_139 (c_ln[139],"setVar",T,F);         // seq = bx [ 11 : 8 ] ;
  setLine #(136,0,1) f_140 (c_ln[140],"setVar",T,F);         // nseq = nseq & 0xF ;
  setLine #(136,1,1) f_141 (c_ln[141],"setVar",T,F);         // ulen = ( bswap2 ( bx [ 31 : 16 ] ) << 2 ) - ioff - ooff ;
  setLine #(136,0,3) f_142 (c_ln[142],"BufferI_getL",T,F);   // bx = bi.getL ( 12 ) ;
  setLine #(136,3,1) f_143 (c_ln[143],"setVar",T,F);         // isBE = isVRTi ? bx [ 22 ] : isVRTj ? bz [ 22 ] : T ;
  setLine #(136,3,1) f_144 (c_ln[144],"setVar",T,F);         // bps = isVRTi ? bx [ 27 : 24 ] : isVRTj ? bz [ 27 : 24 ] : 15 ;
  setLine #(136,4,0) f_145 (c_ln[145],"If",useTC,F);         // if ( useTC ) {
  setLine #(145,0,3) f_146 (c_ln[146],"BufferI_getL",T,F);   // by = bi.getL ( ioff - 12 ) ;
  setLine #(145,3,1) f_147 (c_ln[147],"setVar",T,F);         // nwsec = bswap4 ( by ) ;
  setLine #(145,1,3) f_148 (c_ln[148],"BufferI_getL",T,F);   // by = bi.getL ( ioff - 8 ) ;
  setLine #(145,4,1) f_149 (c_ln[149],"setVar",T,F);         // npsec [ 39 : 32 ] = bswap4 ( by ) ;
  setLine #(145,2,3) f_150 (c_ln[150],"BufferI_getL",T,F);   // by = bi.getL ( ioff - 4 ) ;
  setLine #(145,5,1) f_151 (c_ln[151],"setVar",T,F);         // npsec [ 31 : 0 ] = bswap4 ( by ) ;
  setLine #(145,6,0) f_152 (c_ln[152],"endIf",c_xn[145],F);  // }
  setLine #(152,0,1) f_153 (c_ln[153],"setVar",T,F);         // swaps [ 0 ] = ( bps == 15 ) && isBE ;
  setLine #(152,0,1) f_154 (c_ln[154],"setVar",T,F);         // swaps [ 1 ] = ( bps > 15 ) && isBE ;
  setLine #(152,0,1) f_155 (c_ln[155],"setVar",T,F);         // swaps [ 2 ] = ( bps == 11 ) && isBE ;
  setLine #(152,0,0) f_156 (c_ln[156],"print",s_vbpr[1],F);  // dprint ( "New Cur w=%08x p=%012lx  Nxt w=%08x p=%012lx\n" , cwsec , cpsec , nwsec , npsec ) ;
  setLine #(152,1,0) f_157 (c_ln[157],"endIfE",c_xn[136],F); // }
  setLine #(157,7,0) f_158 (c_ln[158],"ElseIf",isVCTX,c_xn[136]); // else if ( isVCTX ) {
  setLine #(158,0,1) f_159 (c_ln[159],"setVar",T,F);         // pstate = 5 ;
  setLine #(158,0,1) f_160 (c_ln[160],"setVar",T,F);         // ioff = bx [ 31 : 24 ] << 2 ;
  setLine #(158,0,1) f_161 (c_ln[161],"setVar",T,F);         // coff = hasOUID ? 28 : 20 ;
  setLine #(158,1,0) f_162 (c_ln[162],"If",ctxf,F);          // if ( ctxf ) {
  setLine #(162,0,3) f_163 (c_ln[163],"BufferI_getL",T,F);   // bx = bi.getL ( coff ) ;
  setLine #(162,3,1) f_164 (c_ln[164],"setVar",T,F);         // bx = brev4 ( bswap4 ( bx ) ) ;
  setLine #(162,4,0) f_165 (c_ln[165],"print",s_vbpr[0],F);  // vprint ( "UDAT Ctx bx=%08x coff=%d len=%d\n" , bx , coff , ioff ) ;
  setLine #(162,4,0) f_166 (c_ln[166],"For",k+1 < 8,F);      // for ( k = 0 ; k < 8 ; k ++ ) {
  setLine #(166,0,1) f_167 (c_ln[167],"StreamO_wrLC",T,F);   // so.wrLC ( 0 , 1 ) ;
  setLine #(166,0,0) f_168 (c_ln[168],"endFor",c_xn[166],F); // }
  setLine #(168,0,1) f_169 (c_ln[169],"StreamO_wrLC",T,F);   // so.wrLC ( bx , 2 ) ;
  setLine #(168,0,1) f_170 (c_ln[170],"setVar",T,F);         // coff += 4 + ( ( bx [ 2 : 2 ] ) << 3 ) + ( ( bx [ 1 : 1 ] ) << 2 ) ;
  setLine #(168,1,0) f_171 (c_ln[171],"If",bx[3] && xIF,F);  // if ( bx [ 3 ] && xIF ) {
  setLine #(171,0,3) f_172 (c_ln[172],"BufferI_getL",T,F);   // by = bi.getL ( coff ) ;
  setLine #(171,1,3) f_173 (c_ln[173],"BufferI_getL",T,F);   // bz = bi.getL ( coff + 4 ) ;
  setLine #(171,4,1) f_174 (c_ln[174],"setVar",T,F);         // bc = l2i ( ii2l ( bswap4 ( by ) , bswap4 ( bz ) ) >> 20 ) ;
  setLine #(171,5,0) f_175 (c_ln[175],"print",s_vbpr[0],F);  // vprint ( "UDAT Ctx IF bc=%d\n" , bc ) ;
  setLine #(171,5,1) f_176 (c_ln[176],"StreamO_wrLC",T,F);   // so.wrLC ( bc , 4 ) ;
  setLine #(171,6,0) f_177 (c_ln[177],"endIf",c_xn[171],F);  // }
  setLine #(177,0,1) f_178 (c_ln[178],"setVar",T,F);         // coff += ( ( bx [ 3 : 3 ] ) << 3 ) ;
  setLine #(177,1,0) f_179 (c_ln[179],"If",bx[4] && xRF,F);  // if ( bx [ 4 ] && xRF ) {
  setLine #(179,0,3) f_180 (c_ln[180],"BufferI_getL",T,F);   // by = bi.getL ( coff ) ;
  setLine #(179,1,3) f_181 (c_ln[181],"BufferI_getL",T,F);   // bz = bi.getL ( coff + 4 ) ;
  setLine #(179,4,1) f_182 (c_ln[182],"setVar",T,F);         // bc = l2i ( ii2l ( bswap4 ( by ) , bswap4 ( bz ) ) >> 20 ) ;
  setLine #(179,5,0) f_183 (c_ln[183],"print",s_vbpr[0],F);  // vprint ( "UDAT Ctx RF bc=%d\n" , bc ) ;
  setLine #(179,5,1) f_184 (c_ln[184],"StreamO_wrLC",T,F);   // so.wrLC ( bc , 4 ) ;
  setLine #(179,6,0) f_185 (c_ln[185],"endIf",c_xn[179],F);  // }
  setLine #(185,0,1) f_186 (c_ln[186],"setVar",T,F);         // coff += ( ( bx [ 4 : 4 ] + bx [ 5 : 5 ] + bx [ 6 : 6 ] ) << 3 ) + ( ( bx [ 7 : 7 ] ) << 2 ) ;
  setLine #(185,1,0) f_187 (c_ln[187],"If",bx[8] && xGain,F); // if ( bx [ 8 ] && xGain ) {
  setLine #(187,0,3) f_188 (c_ln[188],"BufferI_getL",T,F);   // by = bi.getL ( coff ) ;
  setLine #(187,3,1) f_189 (c_ln[189],"setVar",T,F);         // bc = bswap4 ( by ) >> 7 ;
  setLine #(187,4,0) f_190 (c_ln[190],"print",s_vbpr[0],F);  // vprint ( "UDAT Ctx GAIN bc=%d\n" , bc ) ;
  setLine #(187,4,1) f_191 (c_ln[191],"StreamO_wrLC",T,F);   // so.wrLC ( bc , 8 ) ;
  setLine #(187,5,0) f_192 (c_ln[192],"endIf",c_xn[187],F);  // }
  setLine #(192,0,1) f_193 (c_ln[193],"setVar",T,F);         // coff += ( ( bx [ 8 : 8 ] + bx [ 9 : 9 ] ) << 2 ) ;
  setLine #(192,1,0) f_194 (c_ln[194],"If",bx[10] && xSR,F); // if ( bx [ 10 ] && xSR ) {
  setLine #(194,0,3) f_195 (c_ln[195],"BufferI_getL",T,F);   // by = bi.getL ( coff ) ;
  setLine #(194,1,3) f_196 (c_ln[196],"BufferI_getL",T,F);   // bz = bi.getL ( coff + 4 ) ;
  setLine #(194,4,1) f_197 (c_ln[197],"setVar",T,F);         // bc = l2i ( ii2l ( bswap4 ( by ) , bswap4 ( bz ) ) >> 20 ) ;
  setLine #(194,5,0) f_198 (c_ln[198],"print",s_vbpr[0],F);  // vprint ( "UDAT Ctx SR bc=%d\n" , bc ) ;
  setLine #(194,5,1) f_199 (c_ln[199],"StreamO_wrLC",T,F);   // so.wrLC ( bc , 10 ) ;
  setLine #(194,6,0) f_200 (c_ln[200],"endIf",c_xn[194],F);  // }
  setLine #(200,0,1) f_201 (c_ln[201],"StreamO_wrLC",T,F);   // so.wrLC ( bx , 2 ) ;
  setLine #(200,1,1) f_202 (c_ln[202],"StreamO_setC",T,F);   // so.setC ( 0 ) ;
  setLine #(200,2,0) f_203 (c_ln[203],"endIf",c_xn[162],F);  // }
  setLine #(203,0,1) f_204 (c_ln[204],"setVar",T,F);         // counts [ 23 : 20 ] = counts [ 23 : 20 ] + 1 ;
  setLine #(203,1,0) f_205 (c_ln[205],"endIfE",c_xn[158],F); // }
  setLine #(205,7,0) f_206 (c_ln[206],"ElseIf",T,c_xn[158]); // else {
  setLine #(206,0,1) f_207 (c_ln[207],"setVar",T,F);         // ioff = 4 ;
  setLine #(206,0,1) f_208 (c_ln[208],"setVar",T,F);         // counts [ 30 : 24 ] = counts [ 30 : 24 ] + 1 ;
  setLine #(206,1,0) f_209 (c_ln[209],"endIf",c_xn[206],F|c_en[205]|c_en[157]|c_en[135]); // }
  setLine #(209,0,0) f_210 (c_ln[210],"BufferI_rnxt",T,F);   // bi.rnxt ( ioff ) ;
  setLine #(209,0,0) f_211 (c_ln[211],"If",ulen > 0,F);      // if ( ulen > 0 ) {
  setLine #(211,0,1) f_212 (c_ln[212],"setVar",T,F);         // length = ulen >> 2 ;
  setLine #(211,0,1) f_213 (c_ln[213],"StreamO_setC",T,F);   // so.setC ( osel ) ;
  setLine #(211,0,1) f_214 (c_ln[214],"setVar",T,F);         // counts [ 3 : 0 ] = counts [ 3 : 0 ] + 1 ;
  setLine #(211,1,0) f_215 (c_ln[215],"If",seq != nseq,F);   // if ( seq != nseq ) {
  setLine #(215,0,1) f_216 (c_ln[216],"setVar",T,F);         // counts [ 7 : 4 ] = counts [ 7 : 4 ] + 1 ;
  setLine #(215,1,0) f_217 (c_ln[217],"endIf",c_xn[215],F);  // }
  setLine #(217,0,1) f_218 (c_ln[218],"setVar",T,F);         // nseq = seq + 1 ;
  setLine #(217,1,0) f_219 (c_ln[219],"endIf",c_xn[211],F);  // }
  setLine #(219,0,0) f_220 (c_ln[220],"endIf",c_xn[106],F|c_en[105]|c_en[101]|c_en[85]); // }
  setLine #(220,0,0) f_221 (c_ln[221],"If",needDrop,F);      // if ( needDrop ) {
  setLine #(221,0,1) f_222 (c_ln[222],"setVar",T,F);         // counts [ 11 : 8 ] = counts [ 11 : 8 ] + 1 ;
  setLine #(221,0,0) f_223 (c_ln[223],"BufferI_rnxt",T,F);   // bi.rnxt ( xfer << 2 ) ;
  setLine #(221,0,1) f_224 (c_ln[224],"setVar",T,F);         // length = length - xfer ;
  setLine #(221,1,0) f_225 (c_ln[225],"If",length > 0,F);    // if ( length > 0 ) {
  setLine #(225,0,1) f_226 (c_ln[226],"setVar",T,F);         // pstate = 4 ;
  setLine #(225,1,0) f_227 (c_ln[227],"endIf",c_xn[225],F);  // }
  setLine #(227,0,0) f_228 (c_ln[228],"endIf",c_xn[221],F);  // }
  setLine #(228,0,1) f_229 (c_ln[229],"setVar",T,F);         // counts [ 19 : 16 ] = ( length > 15 ) ? 15 : length [ 3 : 0 ] ;
  setLine #(228,1,1) f_230 (c_ln[230],"setVar",T,F);         // counts [ 31 ] = okIn ;
  setLine #(228,0,1) f_231 (c_ln[231],"setVar",T,F);         // cpsec = cpsec + pfix ;
  setLine #(228,1,1) f_232 (c_ln[232],"setVar",T,F);         // doWrap = ( cpsec >= mpsec ) ;
  setLine #(228,2,0) f_233 (c_ln[233],"If",doWrap,F);        // if ( doWrap ) {
  setLine #(233,0,1) f_234 (c_ln[234],"setVar",T,F);         // cpsec = cpsec - mpsec ;
  setLine #(233,0,1) f_235 (c_ln[235],"setVar",T,F);         // cwsec = cwsec + 1 ;
  setLine #(233,1,0) f_236 (c_ln[236],"endIf",c_xn[233],F);  // }
  setLine #(236,0,0) f_237 (c_ln[237],"If",pass == 0,F);     // if ( pass == 0 ) {
  setLine #(237,0,0) f_238 (c_ln[238],"Ram_wr",CV_counts,F); // this.counts = counts ;
  setLine #(237,1,0) f_239 (c_ln[239],"Ram_wr",CV_cwsec,F);  // this.cwsec = cwsec ;
  setLine #(237,2,2) f_240 (c_ln[240],"Ram_wrx",CV_cpsec,F); // this.cpsec = cpsec ;
  setLine #(237,4,0) f_241 (c_ln[241],"Ram_wr",CV_nwsec,F);  // this.nwsec = nwsec ;
  setLine #(237,5,2) f_242 (c_ln[242],"Ram_wrx",CV_npsec,F); // this.npsec = npsec ;
  setLine #(237,8,0) f_243 (c_ln[243],"endIf",c_xn[237],F);  // }
  setLine #(243,0,1) f_244 (c_ln[244],"setVar",T,F);         // pass = ( pass >= 14 ) ? 0 : pass + 1 ;
  setLine #(243,1,0) f_245 (c_ln[245],"print",s_vbpr[1],F);  // dprint ( "Bot  Cur w=%08x p=%012lx  Nxt w=%08x p=%012lx  Counts=%x pstate=%d cnt=%d pass=%d\n" , cwsec , cpsec , nwsec , npsec , counts , pstate , c_cnt , pass ) ;
  setLine #(243,0,0) f_246 (c_ln[246],"BufferI_rokLen",T,F); // bi.rokLen ( XFER << 2 ) ;
  setLine #(243,0,0) f_247 (c_ln[247],"return",c_stat,F);    // return 0 ;
  setLine #(247,0,0) f_248 (c_ln[248],"endMethod",T,F);      // }

  assign cweqnw = ! cwgtnw && ! cwltnw;
  assign cpeqnp = ! cpgtnp && ! cpltnp;
  assign ceqn = cweqnw && cpeqnp;
  assign cgtn = cwgtnw || (cweqnw && cpgtnp);
  assign cltn = cwltnw || (cweqnw && cpltnp);
  always @(posedge clk) begin
    c_wr <= F; c_rd <= F; c_done <= F;
    bi_rd <= F; bi_nxt <= F;
    so_wen <= F; 
    if (s_set[0]) pkty <= s_val;
    if (s_set[1]) flags <= s_val;
    if (s_set[2]) osel <= s_val;
    if (s_set[3]) sid <= s_val;
    if (s_set[4]) pinc <= s_val;
    if (s_set[5]) cwsec <= s_val;
    if (s_set[6]) nwsec <= s_val;
    if (s_set[8]) cpsec <= lswap(s_val);
    if (s_set[10]) npsec <= lswap(s_val);
    if (s_set[12]) mpsec <= lswap(s_val);
    if (s_set[13]) counts <= s_val;
    if (s_set[14]) nseq <= s_val;
    if (s_set[15]) swaps <= s_val;
    if (s_set[16]) length <= s_val;
    if (s_set[17]) ifix <= s_val;
    if (s_set[18]) mfix <= s_val;
    if (s_set[19]) nfix <= s_val;
    if (s_set[20]) pad <= s_val;
    if (s_set[21]) pstate <= s_val;
    if (s_set[22]) npinc <= s_val;
    if (s_set[23]) ouid <= s_val;
    if (s_set[24]) pass <= s_val;
    if (s_set[25]) vctx <= s_val;
    if (c_xn[21]) begin usePad <= flags[PF_FILL]; end
    if (c_xn[22]) begin useTC <= flags[PF_TIME]; end
    if (c_xn[23]) begin anyID <= flags[PF_ANYSID]; end
    if (c_xn[24]) begin fb3 <= flags[PF_FB3]; end
    if (c_xn[25]) begin ctxf <= flags[PF_CTXF]; end
    if (c_xn[26]) begin byp <= flags[PF_BYPASS]; end
    if (c_xn[27]) begin useOUID <= flags[PF_OUID]; end
    if (c_xn[28]) begin xSR <= flags[PF_XSR]; end
    if (c_xn[29]) begin xIF <= flags[PF_XIF]; end
    if (c_xn[30]) begin xRF <= flags[PF_XRF]; end
    if (c_xn[31]) begin xGain <= flags[PF_XGAIN]; end
    if (c_xn[32]) begin isNone <= (pkty == PT_NONE); end
    if (c_xn[33]) begin isNoop <= (pkty == PT_NOOP); end
    if (c_xn[34]) begin okICE <= (pkty == PT_AUTO) || (pkty == PT_ICE); end
    if (c_xn[35]) begin okSDDS <= (pkty == PT_SDDS); end
    if (c_xn[36]) begin okVRT <= (pkty == PT_AUTO) || (pkty >= PT_VRT); end
    if (c_xn[37]) begin okIn <= bi_rok; end
    if (c_xn[38]) begin phinc <= pinc; end
    if (c_xn[39]) begin okLen <= (length > 0); end
    if (c_xn[40]) begin doTrim <= length < XFER; end
    if (c_xn[41]) begin xfer <= ! okIn ? 0 : doTrim ? length : XFER; end
    if (c_xn[42]) begin oknSec <= (nwsec > 0); end
    if (c_xn[43]) begin difws <= cwsec - nwsec; end
    if (c_xn[44]) begin difps <= cpsec - npsec; end
    if (c_xn[45]) begin cwgtnw <= (difws > 0); end
    if (c_xn[46]) begin cwltnw <= (difws < 0); end
    if (c_xn[48]) begin cpgtnp <= (difps > (phinc << 2)); end
    if (c_xn[49]) begin cpltnp <= (difps < - phinc); end
    if (c_xn[54]) begin needPad <= (usePad && ! okIn); end
    if (c_xn[55]) begin needFill <= (useTC && oknSec && cltn); end
    if (c_xn[56]) begin needDrop <= (pstate == 4) && useTC && cgtn; end
    if (c_xn[57]) begin lpsec <= cpsec + (pinc << 8); end
    if (c_xn[58]) begin lpgtnp <= (lpsec > npsec); end
    if (c_xn[59]) begin doClip <= (lpsec > mpsec); end
    if (c_xn[60]) begin doFill <= (needPad || needFill || needDrop) && ! isNoop && ! isNone; end
    if (c_xn[61]) begin doStop <= oknSec && cweqnw && lpgtnp && ! needPad; end
    if (c_xn[62]) begin fpsec <= doClip ? l2i (mpsec - cpsec) : doStop ? l2i (npsec - cpsec) : (pinc << 8); end
    if (c_xn[63]) begin sid <= 0; end
    if (c_xn[64]) begin ooff <= 0; end
    if (c_xn[65]) begin seq <= 0; end
    if (c_xn[66]) begin ifb <= 0; end
    if (c_xn[67]) begin pfix <= 0; end
    if (c_xn[68]) begin $write ("Top  Cur w=%08x p=%012x  Nxt w=%08x p=%012x  Counts=%x Pad=%x Fill=%x Drop=%x rOk=%x wOk=%x cnt=%d\n", cwsec, cpsec, nwsec, npsec, counts, needPad ? 1 : 0, needFill ? 1 : 0, needDrop ? 1 : 0, bi_rok ? 1 : 0, so_wok ? 1 : 0, c_cnt); end
    if (c_xn[70]) begin pstate <= 1; end
    if (c_xn[71]) begin dpsec <= fpsec; end
    if (c_xn[72]) begin bz <= pad; end
    if (c_xn[74]) begin cpsec <= cpsec + pinc; end
    if (c_xn[75]) begin ifb <= ! fb3 ? 0 : (ifb == 2) ? 0 : ifb + 1; end
    if (c_xn[77]) begin pfix <= pfix + nfix; end
    if (c_xn[79]) begin ifix <= (ifix == mfix) ? 0 : ifix + 1; end
    if (c_xn[80]) begin so_wen <= T; so_wbus <= bz; so_swaps <= swaps; end
    if (c_xn[81]) begin dpsec <= dpsec - pinc; end
    if (c_xn[83]) begin counts[15:12] <= counts[15:12] + 1; end
    if (c_xn[84]) begin bz <= 0; end
    if (c_xn[87]) begin pstate <= 2; end
    if (c_xn[88]) begin i <= 0; end
    if (c_xn[90]) begin cpsec <= cpsec + pinc; end
    if (c_xn[92]) begin pfix <= pfix + nfix; end
    if (c_xn[94]) begin ifix <= (ifix == mfix) ? 0 : ifix + 1; end
    if (c_en[95]) begin bi_rd <= T; bi_adr <= i << 2; end 
    if (c_xn[95]) begin bz <= bi_bus; end
    if (c_xn[96]) begin so_wen <= T; so_wbus <= bz; so_swaps <= swaps; end
    if (c_xn[97]) begin i <= i + 1; end
    if (c_xn[98]) begin length <= length - 1; end
    if (c_en[100]) begin bi_nxt <= T; bi_adr <= i << 2; end
    if (c_xn[103]) begin pstate <= 3; end
    if (c_xn[104]) begin length <= XFER; end
    if (c_xn[107]) begin pstate <= 4; end
    if (c_xn[108]) begin ulen <= 0; end
    if (c_en[109]) begin bi_rd <= T; bi_adr <= 0; end 
    if (c_xn[109]) begin bx <= bi_bus; end
    if (c_en[110]) begin bi_rd <= T; bi_adr <= 4; end 
    if (c_xn[110]) begin by <= bi_bus; end
    if (c_en[111]) begin bi_rd <= T; bi_adr <= 8; end 
    if (c_xn[111]) begin bz <= bi_bus; end
    if (c_xn[112]) begin anyOUID <= ! useOUID || ! bx[3]; end
    if (c_xn[113]) begin hasOUID <= bx[3]; end
    if (c_xn[114]) begin hasSID <= (bx[6:5] > 1) ? T : bx[4]; end
    if (c_xn[115]) begin isSID <= bswap2 (hasSID ? by[31:16] : bz[15:0]) == sid; end
    if (c_xn[116]) begin isVRTi <= (bx[7:0] == 8'h1C) && ((bswap4 (bz) == ouid) || anyOUID); end
    if (c_xn[117]) begin isVRTj <= (bx[7:0] == 8'h08) && ((bswap4 (by) == ouid) || anyOUID); end
    if (c_xn[118]) begin isVRTd <= (bx[7:0] == 8'h18) && ((bswap4 (bz) == DIFI) || anyOUID); end
    if (c_xn[119]) begin isVRTc <= (bx[7:0] == 8'h49) && ((bswap4 (bz) == ouid) || anyOUID); end
    if (c_xn[120]) begin isICE <= okICE && (bx == 32'h00676665); end
    if (c_xn[121]) begin isVRT <= okVRT && (isVRTi || isVRTj || isVRTd) && (isSID || anyID); end
    if (c_xn[122]) begin isVCTX <= okVRT && isVRTc && (isSID || anyID); end
    if (c_xn[124]) begin ioff <= 64; end
    if (c_xn[125]) begin seq <= by[7:0]; end
    if (c_xn[126]) begin bfer <= bz[13:0]; end
    if (c_xn[127]) begin ulen <= bz[13:0]; end
    if (c_en[128]) begin bi_rd <= T; bi_adr <= 12; end 
    if (c_xn[128]) begin bx <= bi_bus; end
    if (c_xn[129]) begin sid <= bx[31:16]; end
    if (c_en[130]) begin bi_rd <= T; bi_adr <= 16; end 
    if (c_xn[130]) begin bx <= bi_bus; end
    if (c_xn[131]) begin bpa <= bx[27:24]; end
    if (c_xn[132] || rst) begin j <= 1; end else if (c_en[132]) begin j <= j + 1; end
    if (c_xn[133]) begin ulen <= ulen + bfer; end
    if (c_xn[137]) begin ooff <= (bx[2]) ? 4 : 0; end
    if (c_xn[138]) begin ioff <= ! hasOUID ? 20 : ! hasSID ? 24 : 28; end
    if (c_xn[139]) begin seq <= bx[11:8]; end
    if (c_xn[140]) begin nseq <= nseq & 4'hF; end
    if (c_xn[141]) begin ulen <= (bswap2 (bx[31:16]) << 2) - ioff - ooff; end
    if (c_en[142]) begin bi_rd <= T; bi_adr <= 12; end 
    if (c_xn[142]) begin bx <= bi_bus; end
    if (c_xn[143]) begin isBE <= isVRTi ? bx[22] : isVRTj ? bz[22] : T; end
    if (c_xn[144]) begin bps <= isVRTi ? bx[27:24] : isVRTj ? bz[27:24] : 15; end
    if (c_en[146]) begin bi_rd <= T; bi_adr <= ioff - 12; end 
    if (c_xn[146]) begin by <= bi_bus; end
    if (c_xn[147]) begin nwsec <= bswap4 (by); end
    if (c_en[148]) begin bi_rd <= T; bi_adr <= ioff - 8; end 
    if (c_xn[148]) begin by <= bi_bus; end
    if (c_xn[149]) begin npsec[39:32] <= bswap4 (by); end
    if (c_en[150]) begin bi_rd <= T; bi_adr <= ioff - 4; end 
    if (c_xn[150]) begin by <= bi_bus; end
    if (c_xn[151]) begin npsec[31:0] <= bswap4 (by); end
    if (c_xn[153]) begin swaps[0] <= (bps == 15) && isBE; end
    if (c_xn[154]) begin swaps[1] <= (bps > 15) && isBE; end
    if (c_xn[155]) begin swaps[2] <= (bps == 11) && isBE; end
    if (c_xn[156]) begin $write ("New Cur w=%08x p=%012x  Nxt w=%08x p=%012x\n", cwsec, cpsec, nwsec, npsec); end
    if (c_xn[159]) begin pstate <= 5; end
    if (c_xn[160]) begin ioff <= bx[31:24] << 2; end
    if (c_xn[161]) begin coff <= hasOUID ? 28 : 20; end
    if (c_en[163]) begin bi_rd <= T; bi_adr <= coff; end 
    if (c_xn[163]) begin bx <= bi_bus; end
    if (c_xn[164]) begin bx <= brev4 (bswap4 (bx)); end
    if (c_xn[165]) begin $write ("UDAT Ctx bx=%08x coff=%d len=%d\n", bx, coff, ioff); end
    if (c_xn[166] || rst) begin k <= 0; end else if (c_en[166]) begin k <= k + 1; end
    if (c_xn[167]) begin so_wen <= T; so_wbus <= 0; so_wsel <= 1; so_swaps <= 0; end
    if (c_xn[169]) begin so_wen <= T; so_wbus <= bx; so_wsel <= 2; so_swaps <= 0; end
    if (c_xn[170]) begin coff <= coff + 4 + ((bx[2:2]) << 3) + ((bx[1:1]) << 2); end
    if (c_en[172]) begin bi_rd <= T; bi_adr <= coff; end 
    if (c_xn[172]) begin by <= bi_bus; end
    if (c_en[173]) begin bi_rd <= T; bi_adr <= coff + 4; end 
    if (c_xn[173]) begin bz <= bi_bus; end
    if (c_xn[174]) begin bc <= l2i (ii2l (bswap4 (by), bswap4 (bz)) >>> 20); end
    if (c_xn[175]) begin $write ("UDAT Ctx IF bc=%d\n", bc); end
    if (c_xn[176]) begin so_wen <= T; so_wbus <= bc; so_wsel <= 4; so_swaps <= 0; end
    if (c_xn[178]) begin coff <= coff + ((bx[3:3]) << 3); end
    if (c_en[180]) begin bi_rd <= T; bi_adr <= coff; end 
    if (c_xn[180]) begin by <= bi_bus; end
    if (c_en[181]) begin bi_rd <= T; bi_adr <= coff + 4; end 
    if (c_xn[181]) begin bz <= bi_bus; end
    if (c_xn[182]) begin bc <= l2i (ii2l (bswap4 (by), bswap4 (bz)) >>> 20); end
    if (c_xn[183]) begin $write ("UDAT Ctx RF bc=%d\n", bc); end
    if (c_xn[184]) begin so_wen <= T; so_wbus <= bc; so_wsel <= 4; so_swaps <= 0; end
    if (c_xn[186]) begin coff <= coff + ((bx[4:4] + bx[5:5] + bx[6:6]) << 3) + ((bx[7:7]) << 2); end
    if (c_en[188]) begin bi_rd <= T; bi_adr <= coff; end 
    if (c_xn[188]) begin by <= bi_bus; end
    if (c_xn[189]) begin bc <= bswap4 (by) >>> 7; end
    if (c_xn[190]) begin $write ("UDAT Ctx GAIN bc=%d\n", bc); end
    if (c_xn[191]) begin so_wen <= T; so_wbus <= bc; so_wsel <= 8; so_swaps <= 0; end
    if (c_xn[193]) begin coff <= coff + ((bx[8:8] + bx[9:9]) << 2); end
    if (c_en[195]) begin bi_rd <= T; bi_adr <= coff; end 
    if (c_xn[195]) begin by <= bi_bus; end
    if (c_en[196]) begin bi_rd <= T; bi_adr <= coff + 4; end 
    if (c_xn[196]) begin bz <= bi_bus; end
    if (c_xn[197]) begin bc <= l2i (ii2l (bswap4 (by), bswap4 (bz)) >>> 20); end
    if (c_xn[198]) begin $write ("UDAT Ctx SR bc=%d\n", bc); end
    if (c_xn[199]) begin so_wen <= T; so_wbus <= bc; so_wsel <= 10; so_swaps <= 0; end
    if (c_xn[201]) begin so_wen <= T; so_wbus <= bx; so_wsel <= 2; so_swaps <= 0; end
    if (c_xn[202]) begin so_wsel <= 0; end
    if (c_xn[204]) begin counts[23:20] <= counts[23:20] + 1; end
    if (c_xn[207]) begin ioff <= 4; end
    if (c_xn[208]) begin counts[30:24] <= counts[30:24] + 1; end
    if (c_en[210]) begin bi_nxt <= T; bi_adr <= ioff; end
    if (c_xn[212]) begin length <= ulen >>> 2; end
    if (c_xn[213]) begin so_wsel <= osel; end
    if (c_xn[214]) begin counts[3:0] <= counts[3:0] + 1; end
    if (c_xn[216]) begin counts[7:4] <= counts[7:4] + 1; end
    if (c_xn[218]) begin nseq <= seq + 1; end
    if (c_xn[222]) begin counts[11:8] <= counts[11:8] + 1; end
    if (c_en[223]) begin bi_nxt <= T; bi_adr <= xfer << 2; end
    if (c_xn[224]) begin length <= length - xfer; end
    if (c_xn[226]) begin pstate <= 4; end
    if (c_xn[229]) begin counts[19:16] <= (length > 15) ? 15 : length[3:0]; end
    if (c_xn[230]) begin counts[31] <= okIn; end
    if (c_xn[231]) begin cpsec <= cpsec + pfix; end
    if (c_xn[232]) begin doWrap <= (cpsec >= mpsec); end
    if (c_xn[234]) begin cpsec <= cpsec - mpsec; end
    if (c_xn[235]) begin cwsec <= cwsec + 1; end
    if (c_xn[238]) begin c_wr <= T; c_adr <= CV_counts; c_wbus <= counts; end
    if (c_xn[239]) begin c_wr <= T; c_adr <= CV_cwsec; c_wbus <= cwsec; end
    if (c_en[240]) begin c_wr <= T; c_adr <= CV_cpsec; c_wbus <= cpsec; end 
    if (c_xn[240]) begin c_wr <= T; c_adr <= CV_cpsec + 4; c_wbus <= (cpsec) >> 32; end
    if (c_xn[241]) begin c_wr <= T; c_adr <= CV_nwsec; c_wbus <= nwsec; end
    if (c_en[242]) begin c_wr <= T; c_adr <= CV_npsec; c_wbus <= npsec; end 
    if (c_xn[242]) begin c_wr <= T; c_adr <= CV_npsec + 4; c_wbus <= (npsec) >> 32; end
    if (c_xn[244]) begin pass <= (pass >= 14) ? 0 : pass + 1; end
    if (c_xn[245]) begin $write ("Bot  Cur w=%08x p=%012x  Nxt w=%08x p=%012x  Counts=%x pstate=%d cnt=%d pass=%d\n", cwsec, cpsec, nwsec, npsec, counts, pstate, c_cnt, pass); end
    if (c_en[246]) begin bi_len <= XFER << 2; end
    if (c_xn[247]) begin c_stat <= 0; c_done <= T; end
  end

  /* verilator lint_off WIDTHCONCAT */
  localparam int SEQ_PARAMS[249*4] = '{ 0,0,0,0, 11,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0, 21,1,0,0, 21,1,0,0, 21,1,0,0, 21,1,0,0, 21,1,0,0, 21,1,0,0, 21,1,0,0, 21,1,0,0, 21,1,0,0, 21,1,0,0, 21,1,0,0, 21,1,0,0, 21,1,0,0, 21,1,0,0, 21,1,0,0, 21,1,0,0, 21,1,0,0, 21,1,0,0, 21,1,0,0, 21,1,0,0, 21,1,1,0, 21,1,0,0, 21,1,0,0, 21,1,0,0, 21,1,1,0, 21,1,1,0, 21,1,2,0, 21,1,1,0, 21,1,1,0, 21,1,2,0, 21,1,2,0, 21,1,2,0, 21,1,2,0, 21,1,1,0, 21,1,2,0, 21,1,2,0, 21,1,0,0, 21,1,1,0, 21,1,1,0, 21,1,3,0, 21,1,2,0, 21,1,3,0, 21,1,0,0, 21,1,0,0, 21,1,0,0, 21,1,0,0, 21,1,0,0, 24,1,3,0, 33,1,4,0, 21,69,0,0, 21,69,0,0, 21,69,0,0, 41,69,1,1, 21,73,0,0, 21,73,0,0, 31,73,0,0, 21,76,0,0, 32,76,0,0, 21,73,0,0, 10,73,0,0, 21,73,0,0, 42,73,1,0, 21,82,0,0, 21,82,0,0, 35,82,1,0, 34,85,4,0, 21,86,0,0, 21,86,0,0, 41,86,1,1, 21,89,0,0, 31,89,0,0, 21,91,0,0, 32,91,0,0, 21,89,0,0, 10,89,0,2, 10,89,3,0, 21,89,0,0, 21,89,0,0, 42,89,4,0, 10,99,0,0, 35,99,0,0, 34,101,4,0, 21,102,0,0, 21,102,0,0, 35,102,1,0, 34,105,4,0, 21,106,0,0, 21,106,0,0, 10,106,0,2, 10,106,1,2, 10,106,2,2, 21,106,3,0, 21,106,3,0, 21,106,3,0, 21,106,5,0, 21,106,5,0, 21,106,4,0, 21,106,5,0, 21,106,5,0, 21,106,3,0, 21,106,6,0, 21,106,6,0, 33,106,7,0, 21,123,0,0, 21,123,0,0, 21,123,0,0, 21,123,0,0, 10,123,0,2, 21,123,3,0, 10,123,1,2, 21,123,4,0, 45,123,5,0, 21,132,0,0, 46,132,0,0, 35,134,0,0, 34,135,7,0, 21,136,0,0, 21,136,0,0, 21,136,0,0, 21,136,0,0, 21,136,1,0, 10,136,0,2, 21,136,3,0, 21,136,3,0, 31,136,4,0, 10,145,0,2, 21,145,3,0, 10,145,1,2, 21,145,4,0, 10,145,2,2, 21,145,5,0, 32,145,6,0, 21,152,0,0, 21,152,0,0, 21,152,0,0, 24,152,0,0, 35,152,1,0, 34,157,7,0, 21,158,0,0, 21,158,0,0, 21,158,0,0, 31,158,1,0, 10,162,0,2, 21,162,3,0, 24,162,4,0, 45,162,4,0, 10,166,0,0, 46,166,0,0, 10,168,0,0, 21,168,0,0, 31,168,1,0, 10,171,0,2, 10,171,1,2, 21,171,4,0, 24,171,5,0, 10,171,5,0, 32,171,6,0, 21,177,0,0, 31,177,1,0, 10,179,0,2, 10,179,1,2, 21,179,4,0, 24,179,5,0, 10,179,5,0, 32,179,6,0, 21,185,0,0, 31,185,1,0, 10,187,0,2, 21,187,3,0, 24,187,4,0, 10,187,4,0, 32,187,5,0, 21,192,0,0, 31,192,1,0, 10,194,0,2, 10,194,1,2, 21,194,4,0, 24,194,5,0, 10,194,5,0, 32,194,6,0, 10,200,0,0, 10,200,1,0, 32,200,2,0, 21,203,0,0, 35,203,1,0, 34,205,7,0, 21,206,0,0, 21,206,0,0, 32,206,1,0, 10,209,0,0, 31,209,0,0, 21,211,0,0, 10,211,0,0, 21,211,0,0, 31,211,1,0, 21,215,0,0, 32,215,1,0, 21,217,0,0, 32,217,1,0, 32,219,0,0, 31,220,0,0, 21,221,0,0, 10,221,0,0, 21,221,0,0, 31,221,1,0, 21,225,0,0, 32,225,1,0, 32,227,0,0, 21,228,0,0, 21,228,1,0, 21,228,0,0, 21,228,1,0, 31,228,2,0, 21,233,0,0, 21,233,0,0, 32,233,1,0, 31,236,0,0, 10,237,0,0, 10,237,1,0, 10,237,2,1, 10,237,4,0, 10,237,5,1, 32,237,8,0, 21,243,0,0, 24,243,1,0, 10,243,0,0, 14,243,0,0, 15,247,0,0};
  sequencer #(249,SEQ_PARAMS) c_seq (clks,rst, c_ln, c_en,c_xn);
  /* verilator lint_on WIDTHCONCAT */
  assign s_test = {c_cnt[0],c_done,c_active,c_start,o_ena,i_ena,o_frst,i_frst};
endmodule

