/**
  Do NOT edit.
  This file is generated by ICEJVCC.
  See UDAT.jv for documentation.
*/

/** Define Signatures */
#define CORE_NAME UDAT
#define CORE_AREA nxm_ice_core
#define CORE_FLOW 3
#include "cores/CoreDefs.h"
#define NP 1
#define AW 16
#define BW 32
#define CW 6

static char* UDAT_pktList = "Auto,None,Noop,ICE,SDDS,VRT,VRTL,VRTW,VRTX,VRTD";
enum { UDAT_PT_AUTO = -1 };
enum { UDAT_PT_NONE = 0 };
enum { UDAT_PT_NOOP = 1 };
enum { UDAT_PT_ICE = 2 };
enum { UDAT_PT_SDDS = 3 };
enum { UDAT_PT_VRT = 4 };
enum { UDAT_PT_VRTL = 5 };
enum { UDAT_PT_VRTW = 6 };
enum { UDAT_PT_VRTX = 7 };
enum { UDAT_PT_VRTD = 8 };
static char* UDAT_flgList = "Fill,Time,OUID,SOS,FB3,AnySID,Bypass,CTXF,xSR,xIF,xRF,xGAIN";
enum { UDAT_PF_FILL = 0 };
enum { UDAT_PF_TIME = 1 };
enum { UDAT_PF_OUID = 2 };
enum { UDAT_PF_SOS = 3 };
enum { UDAT_PF_FB3 = 4 };
enum { UDAT_PF_ANYSID = 5 };
enum { UDAT_PF_BYPASS = 6 };
enum { UDAT_PF_CTXF = 7 };
enum { UDAT_PF_XSR = 8 };
enum { UDAT_PF_XIF = 9 };
enum { UDAT_PF_XRF = 10 };
enum { UDAT_PF_XGAIN = 11 };
enum { UDAT_XFER = 256 };
enum { UDAT_OUID = 0x104D77 };
enum { UDAT_DIFI = 0x6A621E };


/** Define CORE Plan Handles */
typedef struct {
  HALO halo;
  real_8 ctime;
  real_8 srate;
  int_4 bits;
  int_4 ptype;
  int_4 bpa;
  int_1 pkty;
  int_u2 flags;
  int_u1 osel;
  int_u2 sid;
  int_u4 pinc;
  int_u4 cwsec;
  int_u4 nwsec;
  int_u8 cpsec;
  int_u8 npsec;
  int_u8 mpsec;
  int_u4 counts;
  int_u1 nseq;
  int_1 swaps;
  int_u2 length;
  int_u1 ifix;
  int_u1 mfix;
  int_u1 nfix;
  int_u4 pad;
  int_u1 pstate;
  int_u4 npinc;
  int_4 ouid;
  int_u1 pass;
  int_u4 vctx;
} UDAT;

#include "cores/CoreProtos.h"

/** CORE Code */

void* UDAT_alloc (char *config) {
  UDAT* plan = UDAT_plan();
  if (plan==NULL) return NULL;
  HW_alloc(plan,config);
  return (void*)plan;
}


int_4 UDAT_upload (UDAT* plan) {
  void *planp=(void*)plan;
  if (HW_isLocal(planp)) return 0;
  HW_push (planp,HW_PREP);
  HW_loadHdr (planp,26);
  HW_loadInt  (planp,plan->pkty);
  HW_loadInt  (planp,plan->flags);
  HW_loadInt  (planp,plan->osel);
  HW_loadInt  (planp,plan->sid);
  HW_loadInt  (planp,plan->pinc);
  HW_loadInt  (planp,plan->cwsec);
  HW_loadInt  (planp,plan->nwsec);
  HW_loadInt8 (planp,plan->cpsec);
  HW_loadInt8 (planp,plan->npsec);
  HW_loadInt8 (planp,plan->mpsec);
  HW_loadInt  (planp,plan->counts);
  HW_loadInt  (planp,plan->nseq);
  HW_loadInt  (planp,plan->swaps);
  HW_loadInt  (planp,plan->length);
  HW_loadInt  (planp,plan->ifix);
  HW_loadInt  (planp,plan->mfix);
  HW_loadInt  (planp,plan->nfix);
  HW_loadInt  (planp,plan->pad);
  HW_loadInt  (planp,plan->pstate);
  HW_loadInt  (planp,plan->npinc);
  HW_loadInt  (planp,plan->ouid);
  HW_loadInt  (planp,plan->pass);
  HW_loadInt  (planp,plan->vctx);
  HW_push (planp,HW_OPEN);
  return 26;
}

void UDAT_setTime (UDAT* plan, real_8 time) {
  if (plan->ctime > 60.0) time = plan->ctime;
  else time += plan->ctime;
  plan->cwsec = d2i (floor (time));
  plan->cpsec = d2l (frac (time) * 1.0e12);
  plan->nwsec = 0;
  plan->npsec = 0;
  if (HW_needsPut(plan)) { HW_push(plan,HW_PREP);  HW_loadAddr(plan,5);HW_loadInt4(plan,plan->cwsec); HW_loadAddr(plan,7);HW_loadInt8(plan,plan->cpsec); HW_loadAddr(plan,6);HW_loadInt4(plan,plan->nwsec); HW_loadAddr(plan,9);HW_loadInt8(plan,plan->npsec);  HW_push(plan,HW_UPD); }
}

void UDAT_startup (UDAT* plan, real_8 time) {
  UDAT_setTime (plan, time);
  UDAT_poll (plan);
  plan->pkty = plan->ptype;
  if (HW_needsPut(plan)) { HW_push(plan,HW_PREP);  HW_loadAddr(plan,0);HW_loadInt1(plan,plan->pkty);  HW_push(plan,HW_UPD); }
}

void UDAT_setPhaseInc (UDAT* plan, real_8 rate) {
  plan->npinc = d2i (round (1.0e12 / rate / plan->bpa * 4));
}

int_1 UDAT_isAsync (UDAT* plan) {
  return (plan->ptype != UDAT_PT_NOOP) && getBit(plan->flags, UDAT_PF_TIME);
}

real_8 UDAT_getRate (UDAT* plan) {
  return plan->srate;
}

int_1 UDAT_getCTXF (UDAT* plan) {
  return getBit(plan->flags, UDAT_PF_CTXF);
}

int_4 UDAT_init (UDAT* plan) {
  plan->pkty = UDAT_PT_NONE;
  plan->ptype = UDAT_PT_NOOP;
  plan->flags = 0;
  plan->sid = -1;
  plan->ctime = 0;
  plan->srate = 10e6;
  plan->bits = -16;
  plan->pad = 0;
  plan->ouid = 0;
  return 0;
}

int_4 UDAT_set (UDAT* plan, String* key, Value* value) {
  if (isMatch (key, "S:PT")) plan->ptype = Value_toItem (value, UDAT_pktList);
  else if (isMatch (key, "L:PKTY")) plan->ptype = Value_toL (value);
  else if (isMatch (key, "L:SID")) plan->sid = Value_toL (value);
  else if (isMatch (key, "L:OSEL")) plan->osel = Value_toL (value);
  else if (isMatch (key, "L:OUID")) plan->ouid = Value_toL (value);
  else if (isMatch (key, "L:BITS")) plan->bits = Value_toL (value);
  else if (isMatch (key, "L:PAD")) plan->pad = Value_toL (value);
  else if (isMatch (key, "D:CTIME")) plan->ctime = Value_toD (value);
  else if (isMatch (key, "D:SRATE")) plan->srate = Value_toD (value);
  else if (isMatch (key, "L:VCTX")) plan->vctx = Value_toL (value);
  else if (isMatch (key, "L:FLAGS")) plan->flags = Value_toL (value);
  else if (isMatch (key, "S:FLAGS")) plan->flags = Value_toMask (value, UDAT_flgList);
  else if (isMatch (key, "D:NEXTSRATE")) {
    UDAT_setPhaseInc (plan, Value_toD (value));
  if (HW_needsPut(plan)) { HW_push(plan,HW_PREP);  HW_loadAddr(plan,22);HW_loadInt4(plan,plan->npinc);  HW_push(plan,HW_UPD); }
  }
  else if (isMatch (key, "D:STARTUP")) UDAT_startup (plan, Value_toD (value));
  else return Core_set (plan, key, value);
  return 0;
}

int_4 UDAT_get (UDAT* plan, String* key, Value* value) {
  if (isMatch (key, "L:PKTY")) Value_fromL (value, plan->ptype);
  else if (isMatch (key, "L:SID")) Value_fromL (value, plan->sid);
  else if (isMatch (key, "L:FLAGS")) Value_fromL (value, plan->flags);
  else if (isMatch (key, "D:STARTUP")) Value_fromD (value, plan->ctime);
  else return Core_get (plan, key, value);
  return 0;
}

int_4 UDAT_open (UDAT* plan) {
  plan->sid &= 0xFFFF;
  plan->bpa = (plan->bits < 0) ? - plan->bits * 2 / 8 : plan->bits / 8;
  plan->nseq = 0;
  plan->counts = 0;
  plan->length = 0;
  plan->swaps = 0;
  plan->nwsec = 0;
  plan->npsec = 0;
  plan->mpsec = d2l (1.0e12);
  plan->pstate = 0;
  if (plan->ptype == UDAT_PT_NOOP) {
    plan->bpa = 4;
    plan->pkty = plan->ptype;
  }
  if (plan->ptype == UDAT_PT_VRTD) plan->ouid = UDAT_DIFI;
  UDAT_setTime (plan, cpuTime ());
  if (plan->srate < 1e6) printf ("Sample Rate=%f too low for UDAT counters\n", plan->srate);
  UDAT_setPhaseInc (plan, plan->srate);
  plan->pinc = plan->npinc;
  if (plan->srate == 300e6 && plan->bpa == 3) {
    plan->mfix = 8;
    plan->nfix = 4;
  }
  if (plan->nfix != 0) printf ("Fixup for UDAT fractional pinc=%d nfix=%d mfix=%d\n", plan->pinc, plan->nfix, plan->mfix);
  plan->flags=setBit(plan->flags, UDAT_PF_FB3, (plan->bpa == 3));
  plan->flags=setBit(plan->flags, UDAT_PF_ANYSID, (plan->sid == 0xFFFF));
  plan->flags=setBit(plan->flags, UDAT_PF_XSR, getBit(plan->flags, UDAT_PF_XSR) || getBit(plan->vctx, 24));
  plan->flags=setBit(plan->flags, UDAT_PF_XIF, getBit(plan->flags, UDAT_PF_XIF) || getBit(plan->vctx, 25));
  plan->flags=setBit(plan->flags, UDAT_PF_XRF, getBit(plan->flags, UDAT_PF_XRF) || getBit(plan->vctx, 26));
  plan->flags=setBit(plan->flags, UDAT_PF_XGAIN, getBit(plan->flags, UDAT_PF_XGAIN) || getBit(plan->vctx, 27));
  plan->flags=setBit(plan->flags, UDAT_PF_CTXF, getBit(plan->flags, UDAT_PF_CTXF) || (getBit(plan->flags, UDAT_PF_XSR) || getBit(plan->flags, UDAT_PF_XIF) || getBit(plan->flags, UDAT_PF_XRF) || getBit(plan->flags, UDAT_PF_XGAIN)));
  plan->flags=setBit(plan->flags, UDAT_PF_OUID, getBit(plan->flags, UDAT_PF_OUID) && (plan->ouid >= 0));
  if (plan->ouid <= 0) plan->ouid = UDAT_OUID;
  if(plan->halo.vbpr&1)printf ("UDAT pkty=%d:%d srate=%f bits=%d flags=%04x\n", plan->ptype, plan->pkty, plan->srate, plan->bits, plan->flags);
  UDAT_upload (plan);
  return 0;
}

int_4 UDAT_process (UDAT* plan, Buffer* bi, Stream* so) {
  int_u2 ulen;
  int_u2 xfer, bfer, i;
  int_u1 ioff, seq;
  int_u1 ooff, bpa, j, k;
  int_u1 bps, coff;
  int_u4 bx, by, bz;
  int_u8 lpsec;
  int_4 difws;
  int_8 difps;
  int_u2 id;
  int_u1 ifb;
  int_u2 pfix;
  int_4 dpsec, fpsec;
  int_4 phinc;
  int_4 bc;
  int_1 isNone, isNoop, isICE, isSDDS, isVRT, isVRTi, isVRTj, isVRTd, isVRTc, isVCTX, isSID, isBE, isNB, isOK;
  int_1 anyID, hasOUID, hasSID, usePad, useTC, useOUID, anyOUID, fb3, ctxf, xSR, xIF, xRF, xGain, byp;
  int_1 okICE, okSDDS, okVRT, okIn, okLen, oknSec, doFill, doWrap, doStop, doClip, doTrim;
  int_1 cweqnw, cwgtnw, cwltnw, cpeqnp, cpgtnp, cpltnp, ceqn, cgtn, cltn, lpgtnp, needPad, needFill, needDrop;
  usePad = getBit(plan->flags, UDAT_PF_FILL);
  useTC = getBit(plan->flags, UDAT_PF_TIME);
  anyID = getBit(plan->flags, UDAT_PF_ANYSID);
  fb3 = getBit(plan->flags, UDAT_PF_FB3);
  ctxf = getBit(plan->flags, UDAT_PF_CTXF);
  byp = getBit(plan->flags, UDAT_PF_BYPASS);
  useOUID = getBit(plan->flags, UDAT_PF_OUID);
  xSR = getBit(plan->flags, UDAT_PF_XSR);
  xIF = getBit(plan->flags, UDAT_PF_XIF);
  xRF = getBit(plan->flags, UDAT_PF_XRF);
  xGain = getBit(plan->flags, UDAT_PF_XGAIN);
  isNone = (plan->pkty == UDAT_PT_NONE);
  isNoop = (plan->pkty == UDAT_PT_NOOP);
  okICE = (plan->pkty == UDAT_PT_AUTO) || (plan->pkty == UDAT_PT_ICE);
  okSDDS = (plan->pkty == UDAT_PT_SDDS);
  okVRT = (plan->pkty == UDAT_PT_AUTO) || (plan->pkty >= UDAT_PT_VRT);
  okIn = bi->rok;
  phinc = plan->pinc;
  okLen = (plan->length > 0);
  doTrim = plan->length < UDAT_XFER;
  xfer = ! okIn ? 0 : doTrim ? plan->length : UDAT_XFER;
  oknSec = (plan->nwsec > 0);
  difws = plan->cwsec - plan->nwsec;
  difps = plan->cpsec - plan->npsec;
  cwgtnw = (difws > 0);
  cwltnw = (difws < 0);
  cweqnw = ! cwgtnw && ! cwltnw;
  cpgtnp = (difps > (phinc << 2));
  cpltnp = (difps < - phinc);
  cpeqnp = ! cpgtnp && ! cpltnp;
  ceqn = cweqnw && cpeqnp;
  cgtn = cwgtnw || (cweqnw && cpgtnp);
  cltn = cwltnw || (cweqnw && cpltnp);
  needPad = (usePad && ! okIn);
  needFill = (useTC && oknSec && cltn);
  needDrop = (plan->pstate == 4) && useTC && cgtn;
  lpsec = plan->cpsec + (plan->pinc << 8);
  lpgtnp = (lpsec > plan->npsec);
  doClip = (lpsec > plan->mpsec);
  doFill = (needPad || needFill || needDrop) && ! isNoop && ! isNone;
  doStop = oknSec && cweqnw && lpgtnp && ! needPad;
  fpsec = doClip ? l2i (plan->mpsec - plan->cpsec) : doStop ? l2i (plan->npsec - plan->cpsec) : (plan->pinc << 8);
  plan->sid = 0;
  ooff = 0;
  seq = 0;
  ifb = 0;
  pfix = 0;
  if(plan->halo.vbpr&2)printf ("Top  Cur w=%08x p=%012lx  Nxt w=%08x p=%012lx  Counts=%x Pad=%x Fill=%x Drop=%x rOk=%x wOk=%x cnt=%d\n", plan->cwsec, plan->cpsec, plan->nwsec, plan->npsec, plan->counts, needPad ? 1 : 0, needFill ? 1 : 0, needDrop ? 1 : 0, bi->rok ? 1 : 0, so->wok ? 1 : 0, 0);
  if (doFill) {
    plan->pstate = 1;
    dpsec = fpsec;
    bz = plan->pad;
    while ((so->wok && dpsec > 0) || (ifb != 0)) {
      plan->cpsec = plan->cpsec + plan->pinc;
      ifb = ! fb3 ? 0 : (ifb == 2) ? 0 : ifb + 1;
      if (plan->ifix == plan->mfix) {
        pfix = pfix + plan->nfix;
      }
      plan->ifix = (plan->ifix == plan->mfix) ? 0 : plan->ifix + 1;
      Stream_wrLS (so, bz, plan->swaps);
      dpsec -= plan->pinc;
    }
    plan->counts=setBits(plan->counts, 15, 12, getBits(plan->counts, 15, 12) + 1);
    bz = 0;
  }
  else if (okLen) {
    plan->pstate = 2;
    i = 0;
    while (so->wok && i < xfer) {
      plan->cpsec = plan->cpsec + plan->pinc;
      if (plan->ifix == plan->mfix) {
        pfix = pfix + plan->nfix;
      }
      plan->ifix = (plan->ifix == plan->mfix) ? 0 : plan->ifix + 1;
      bz = Buffer_getL (bi, i << 2);
      Stream_wrLS (so, bz, plan->swaps);
      i ++;
      plan->length --;
    }
    Buffer_rnxt (bi, i << 2);
  }
  else if (okIn && isNoop) {
    plan->pstate = 3;
    plan->length = UDAT_XFER;
  }
  else if (okIn && ! isNone) {
    plan->pstate = 4;
    ulen = 0;
    bx = Buffer_getL (bi, 0);
    by = Buffer_getL (bi, 4);
    bz = Buffer_getL (bi, 8);
    anyOUID = ! useOUID || ! getBit(bx, 3);
    hasOUID = getBit(bx, 3);
    hasSID = (getBits(bx, 6, 5) > 1) ? 1 : getBit(bx, 4);
    isSID = bswap2 (hasSID ? getBits(by, 31, 16) : getBits(bz, 15, 0)) == plan->sid;
    isVRTi = (getBits(bx, 7, 0) == 0x1C) && ((bswap4 (bz) == plan->ouid) || anyOUID);
    isVRTj = (getBits(bx, 7, 0) == 0x08) && ((bswap4 (by) == plan->ouid) || anyOUID);
    isVRTd = (getBits(bx, 7, 0) == 0x18) && ((bswap4 (bz) == UDAT_DIFI) || anyOUID);
    isVRTc = (getBits(bx, 7, 0) == 0x49) && ((bswap4 (bz) == plan->ouid) || anyOUID);
    isICE = okICE && (bx == 0x00676665);
    isVRT = okVRT && (isVRTi || isVRTj || isVRTd) && (isSID || anyID);
    isVCTX = okVRT && isVRTc && (isSID || anyID);
    if (isICE) {
      ioff = 64;
      seq = getBits(by, 7, 0);
      bfer = getBits(bz, 13, 0);
      ulen = getBits(bz, 13, 0);
      bx = Buffer_getL (bi, 12);
      plan->sid = getBits(bx, 31, 16);
      bx = Buffer_getL (bi, 16);
      bpa = getBits(bx, 27, 24);
      for (j = 1; j < bpa; j ++) {
        ulen = ulen + bfer;
      }
    }
    else if (isVRT) {
      ooff = (getBit(bx, 2)) ? 4 : 0;
      ioff = ! hasOUID ? 20 : ! hasSID ? 24 : 28;
      seq = getBits(bx, 11, 8);
      plan->nseq = plan->nseq & 0xF;
      ulen = (bswap2 (getBits(bx, 31, 16)) << 2) - ioff - ooff;
      bx = Buffer_getL (bi, 12);
      isBE = isVRTi ? getBit(bx, 22) : isVRTj ? getBit(bz, 22) : 1;
      bps = isVRTi ? getBits(bx, 27, 24) : isVRTj ? getBits(bz, 27, 24) : 15;
      if (useTC) {
        by = Buffer_getL (bi, ioff - 12);
        plan->nwsec = bswap4 (by);
        by = Buffer_getL (bi, ioff - 8);
        plan->npsec=setBits(plan->npsec, 39, 32, bswap4 (by));
        by = Buffer_getL (bi, ioff - 4);
        plan->npsec=setBits(plan->npsec, 31, 0, bswap4 (by));
      }
      plan->swaps=setBit(plan->swaps, 0, (bps == 15) && isBE);
      plan->swaps=setBit(plan->swaps, 1, (bps > 15) && isBE);
      plan->swaps=setBit(plan->swaps, 2, (bps == 11) && isBE);
      if(plan->halo.vbpr&2)printf ("New Cur w=%08x p=%012lx  Nxt w=%08x p=%012lx\n", plan->cwsec, plan->cpsec, plan->nwsec, plan->npsec);
    }
    else if (isVCTX) {
      plan->pstate = 5;
      ioff = getBits(bx, 31, 24) << 2;
      coff = hasOUID ? 28 : 20;
      if (ctxf) {
        bx = Buffer_getL (bi, coff);
        bx = brev4 (bswap4 (bx));
        if(plan->halo.vbpr&1)printf ("UDAT Ctx bx=%08x coff=%d len=%d\n", bx, coff, ioff);
        for (k = 0; k < 8; k ++) {
          Stream_wrLC (so, 0, 1);
        }
        Stream_wrLC (so, bx, 2);
        coff += 4 + ((getBits(bx, 2, 2)) << 3) + ((getBits(bx, 1, 1)) << 2);
        if (getBit(bx, 3) && xIF) {
          by = Buffer_getL (bi, coff);
          bz = Buffer_getL (bi, coff + 4);
          bc = l2i (ii2l (bswap4 (by), bswap4 (bz)) >> 20);
          if(plan->halo.vbpr&1)printf ("UDAT Ctx IF bc=%d\n", bc);
          Stream_wrLC (so, bc, 4);
        }
        coff += ((getBits(bx, 3, 3)) << 3);
        if (getBit(bx, 4) && xRF) {
          by = Buffer_getL (bi, coff);
          bz = Buffer_getL (bi, coff + 4);
          bc = l2i (ii2l (bswap4 (by), bswap4 (bz)) >> 20);
          if(plan->halo.vbpr&1)printf ("UDAT Ctx RF bc=%d\n", bc);
          Stream_wrLC (so, bc, 4);
        }
        coff += ((getBits(bx, 4, 4) + getBits(bx, 5, 5) + getBits(bx, 6, 6)) << 3) + ((getBits(bx, 7, 7)) << 2);
        if (getBit(bx, 8) && xGain) {
          by = Buffer_getL (bi, coff);
          bc = bswap4 (by) >> 7;
          if(plan->halo.vbpr&1)printf ("UDAT Ctx GAIN bc=%d\n", bc);
          Stream_wrLC (so, bc, 8);
        }
        coff += ((getBits(bx, 8, 8) + getBits(bx, 9, 9)) << 2);
        if (getBit(bx, 10) && xSR) {
          by = Buffer_getL (bi, coff);
          bz = Buffer_getL (bi, coff + 4);
          bc = l2i (ii2l (bswap4 (by), bswap4 (bz)) >> 20);
          if(plan->halo.vbpr&1)printf ("UDAT Ctx SR bc=%d\n", bc);
          Stream_wrLC (so, bc, 10);
        }
        Stream_wrLC (so, bx, 2);
        Stream_setC (so, 0);
      }
      plan->counts=setBits(plan->counts, 23, 20, getBits(plan->counts, 23, 20) + 1);
    }
    else {
      ioff = 4;
      plan->counts=setBits(plan->counts, 30, 24, getBits(plan->counts, 30, 24) + 1);
    }
    Buffer_rnxt (bi, ioff);
    if (ulen > 0) {
      plan->length = ulen >> 2;
      Stream_setC (so, plan->osel);
      plan->counts=setBits(plan->counts, 3, 0, getBits(plan->counts, 3, 0) + 1);
      if (seq != plan->nseq) {
        plan->counts=setBits(plan->counts, 7, 4, getBits(plan->counts, 7, 4) + 1);
      }
      plan->nseq = seq + 1;
    }
  }
  if (needDrop) {
    plan->counts=setBits(plan->counts, 11, 8, getBits(plan->counts, 11, 8) + 1);
    Buffer_rnxt (bi, xfer << 2);
    plan->length = plan->length - xfer;
    if (plan->length > 0) {
      plan->pstate = 4;
    }
  }
  plan->counts=setBits(plan->counts, 19, 16, (plan->length > 15) ? 15 : getBits(plan->length, 3, 0));
  plan->counts=setBit(plan->counts, 31, okIn);
  plan->cpsec = plan->cpsec + pfix;
  doWrap = (plan->cpsec >= plan->mpsec);
  if (doWrap) {
    plan->cpsec = plan->cpsec - plan->mpsec;
    plan->cwsec = plan->cwsec + 1;
  }
  if (plan->pass == 0) {
    plan->counts = plan->counts;
    plan->cwsec = plan->cwsec;
    plan->cpsec = plan->cpsec;
    plan->nwsec = plan->nwsec;
    plan->npsec = plan->npsec;
  }
  plan->pass = (plan->pass >= 14) ? 0 : plan->pass + 1;
  if(plan->halo.vbpr&2)printf ("Bot  Cur w=%08x p=%012lx  Nxt w=%08x p=%012lx  Counts=%x pstate=%d cnt=%d pass=%d\n", plan->cwsec, plan->cpsec, plan->nwsec, plan->npsec, plan->counts, plan->pstate, 0, plan->pass);
  Buffer_rokLen (bi, UDAT_XFER << 2);
  return 0;
}

int_4 UDAT_close (UDAT* plan) {
  HW_push(plan,HW_CLOSE);
  return 0;
}

int_4 UDAT_poll (UDAT* plan) {
  real_8 time = cpuTime ();
  int_4 twsec = d2i (floor (time));
  int_8 tpsec = d2l (frac (time) * 1.0e12);
  if (plan->ptype <= UDAT_PT_NOOP) return 0;
  if (HW_needsPut(plan)) { HW_push(plan,HW_PREP);  HW_unloadInt4(plan,5,&plan->cwsec); HW_unloadInt8(plan,7,&plan->cpsec); HW_unloadInt4(plan,6,&plan->nwsec); HW_unloadInt8(plan,9,&plan->npsec); HW_unloadInt4(plan,13,&plan->counts);  HW_push(plan,HW_UPD); }
  printf ("Poll EECLFDSU=%08x  Cpu=%08x:%012lx  Nxt=%08x:%012lx  Cur=%08x:%012lx\n", plan->counts, twsec, tpsec, plan->nwsec, plan->npsec, plan->cwsec, plan->cpsec);
  return 5;
}

int_4 UDAT_free (UDAT* plan) {
  HW_free(plan);
  free(plan);
}

#include "cores/CoreHandles.h"

UDAT* UDAT_subCore (HALO* halo, int_4 scid) {
  UDAT* plan = UDAT_plan();
  if (plan==NULL) return NULL;
  Core_copyHaloToSub(halo,&plan->halo,scid);
  UDAT_init(plan);
  return plan;
}
#undef CORE_NAME
#undef CORE_AREA
#undef CORE_FLOW
#undef AW
#undef BW
#undef CW
#undef NP
