/**
  Do NOT edit.
  This file is generated by ICEJVCC.
  See TFDD.jv for documentation.
*/

/** Define Signatures */
#define CORE_NAME TFDD
#define CORE_AREA nxm_ice_core
#define CORE_FLOW 1
#include "cores/CoreDefs.h"
#define NP 1
#define AW 16
#define BW NP*32
#define CW 6

enum { TFDD_OCIC = 5 };
enum { TFDD_ODEC = 10 };
enum { TFDD_OTAP = 8 };
enum { TFDD_RTAP = 256 };
enum { TFDD_PTAP = 8 };
enum { TFDD_OAGC = 12 };
enum { TFDD_FPS = ( TFDD_RTAP / 8 ) - 1 };
enum { TFDD_MAXCR = 300000000 };


/** Define CORE Plan Handles */
typedef struct {
  HALO halo;
  int_4 irate;
  int_4 orate;
  real_8 fcny;
  real_8 ratio;
  int_4 dec;
  int_4 gain;
  int_4 flags;
} TFDD;

#include "cores/CoreProtos.h"

/** CORE Code */

void* TFDD_alloc (char *config) {
  TFDD* plan = TFDD_plan();
  if (plan==NULL) return NULL;
  HW_alloc(plan,config);
  return (void*)plan;
}


int_4 TFDD_upload (TFDD* plan) {
  void *planp=(void*)plan;
  if (HW_isLocal(planp)) return 0;
  HW_push (planp,HW_PREP);
  HW_loadHdr (planp,0);
  HW_push (planp,HW_OPEN);
  return 0;
}

int_4 TFDD_init (TFDD* plan) {
  plan->irate = 1000000;
  plan->orate = -1;
  plan->fcny = 0.0;
  plan->gain = 0;
  plan->dec = 1;
  plan->ratio = 1.0;
  return 0;
}

int_4 TFDD_set (TFDD* plan, String* key, Value* value) {
  if (isMatch (key, "L:RATE")) plan->irate = Value_toL (value);
  else if (isMatch (key, "L:ORATE")) plan->orate = Value_toL (value);
  else if (isMatch (key, "D:FREQ")) plan->fcny = Value_toD (value) * 2 / plan->irate;
  else if (isMatch (key, "D:FCNY")) plan->fcny = Value_toD (value);
  else if (isMatch (key, "L:DEC")) plan->dec = Value_toL (value);
  else if (isMatch (key, "D:RATIO")) plan->ratio = Value_toD (value);
  else if (isMatch (key, "L:GAIN")) plan->gain = Value_toL (value);
  else if (isMatch (key, "L:FLAGS")) plan->flags = Value_toL (value);
  else return Core_set (plan, key, value);
  return 0;
}

int_4 TFDD_get (TFDD* plan, String* key, Value* value) {
  if (isMatch (key, "L:RATE")) Value_fromL (value, plan->irate);
  else if (isMatch (key, "D:FREQ")) Value_fromD (value, plan->fcny);
  else if (isMatch (key, "D:RATIO")) Value_fromD (value, plan->ratio);
  else if (isMatch (key, "D:XDIO")) Value_fromD (value, plan->dec * 2 / plan->ratio);
  else if (isMatch (key, "L:GAIN")) Value_fromL (value, plan->gain);
  else return Core_get (plan, key, value);
  return 0;
}

int_4 TFDD_open (TFDD* plan) {
  if (plan->orate < 0) plan->orate = plan->irate / plan->dec / 2;
  setupTunerChip (plan->halo.ph, -1, -16, plan->irate, plan->fcny, plan->dec, plan->gain, plan->flags, plan->ratio);
  printf ("TFDD Fs=%d Fc=%f Fo=%d dec=%d gain=%d ratio=%f\n", plan->irate, plan->fcny, plan->orate, plan->dec, plan->gain, plan->ratio);
  return 0;
}

int_4 TFDD_process (TFDD* plan, Stream* si, Stream* so) {
  return 0;
}

int_4 TFDD_close (TFDD* plan) {
  HW_push(plan,HW_CLOSE);
  return 0;
}

int_4 TFDD_poll (TFDD* plan) { return 0; }

int_4 TFDD_free (TFDD* plan) {
  HW_free(plan);
  free(plan);
}

#include "cores/CoreHandles.h"

TFDD* TFDD_subCore (HALO* halo, int_4 scid) {
  TFDD* plan = TFDD_plan();
  if (plan==NULL) return NULL;
  Core_copyHaloToSub(halo,&plan->halo,scid);
  TFDD_init(plan);
  return plan;
}
#undef CORE_NAME
#undef CORE_AREA
#undef CORE_FLOW
#undef AW
#undef BW
#undef CW
#undef NP
