/**
  Do NOT edit.
  This file is generated by ICEJVCC.
  See RFP.jv for documentation.
*/
package nxm.ice.core;
import nxm.ice.core.Modefs;
import nxm.ice.core.Modems;
import nxm.ice.lib.*;
public class RFP extends CoreFactory {

public static class JVM extends CORE       {                             public JVM() { setFlow(STREAM); } }
public static class CPU extends CoreNative { public native long alloc(); public CPU() { setFlow(STREAM); } }
public static class ICE extends CoreNative { public native long alloc(); public ICE() { setFlow(STREAM); } }

public final static int FLOW = STREAM, OFMT = FBIT, SELFPACE = 1, BW = 32, MO = 9, OLUT = 12, NLUT = 1 << OLUT;
public final static int COMMA = 0x1CE1CEBB;
public final static int LRSPB = 0x0400081;
public final static int LRSPM = 0x2000023;
public final static int MSEQ = 0xFFFFFF;
public final static int MTU = 1536;
public static class CORE extends Core implements Modefs {
  public int rfp;
  public int fec;
  public int scr;
  public int bpw;
  public int upp;
  public int lrsl;
  int shft, mask;
  int punc, ipunc, mpunc;
  int iseq, mseq;
  int errs;
  int[] elut;
  int ilen;
  int olen;
  int flgs;
  int scrc;
  int scrv;
  int gmask;
  int lrsi, lrsc, lrsp;
  int uv;
  int bi;
  public void optimize () {
    if (getBit(flgs, 0)) elut = new int[8];
  }
  public int init () {
    rfp = RFP_NONE;
    fec = FEC_NONE;
    scr = -1;
    bpw = -1;
    return 0;
  }
  public boolean isGen () {
    return (bpw == 0);
  }
  public int set (String key, Value value) {
    if (isMatch (key, "S:RFP")) rfp = value.toItem (rfpList);
    else if (isMatch (key, "S:FEC")) fec = value.toItem (fecList);
    else if (isMatch (key, "S:SCR")) scr = value.toItem (scrList);
    else if (isMatch (key, "L:BPW")) bpw = value.toL ();
    else if (isMatch (key, "L:LRSP")) lrsp = value.toL ();
    else if (isMatch (key, "L:LRSI")) lrsi = value.toL ();
    else if (isMatch (key, "L:LRSL")) lrsl = value.toL ();
    else if (isMatch (key, "L:VFLG"));
    else if (isMatch (key, "L:ERRS")) errs = value.toL ();
    else if (isMatch (key, "L:UPP")) upp = value.toL ();
    else return super.set (key, value);
    return 0;
  }
  public int get (String key, Value value) {
    if (isMatch (key, "L:RFP")) value.fromL (rfp);
    else if (isMatch (key, "L:FEC")) value.fromL (fec);
    else if (isMatch (key, "L:SCR")) value.fromL (scr);
    else if (isMatch (key, "L:ERRS")) value.fromL (errs);
    else return super.get (key, value);
    return 0;
  }
  public int open () {
    int iom;
    elut = new int[NLUT];
    iom = Modems.getFECLUT (fec, upp, elut, null);
    ilen = (iom >> 0) & 0xFF;
    olen = (iom >> 8) & 0xFF;
    mask = (iom >> 16) & 0xFFF;
    mpunc = (iom >> 28) & 0xF;
    gmask = (1 << ilen) - 1;
    shft = 0;
    ipunc = mpunc;
    scrv = 0;
    lrsc = lrsi;
    if (lrsp == 0 || lrsp == - 1) lrsp = LRSPM;
    if (lrsl >= (1 << 24)) System.out.printf ("Err: LSR repeat length=%d too long max=%d\n", lrsl, (1 << 24));
    flgs = 0;
    if (scr < 0) scr = (fec == FEC_NONE) ? SCR_LRS : SCR_NONE;
    if (scr > SCR_LRS) {
      flgs |= 0x4;
      if (fec == FEC_NONE) ilen = olen = 1;
    }
    if (fec == FEC_NONE && scr <= SCR_LRS && bpw != 0) flgs |= 0x1;
    if (bpw == 0) flgs |= 0x8;
    if (fec >= FEC_TCM) flgs |= 0x10;
    if (getBit(flgs, 0)) ilen = olen = 32;
    if (this.halo.impl == CORE_TYPE_ICE) flgs |= 0x2;
    iseq = 0;
    mseq = (lrsl > 0) ? lrsl - ilen : getBit(flgs, 3) ? MSEQ : MTU * 8 - ilen;
    optimize ();
    if((this.halo.vbpr&1)!=0)System.out.printf ("RFP rfp=%d fec=%d scr=%x ilen=%d olen=%d flgs=%x punc=%d\n", rfp, fec, scr, ilen, olen, flgs, mpunc + 1);
    this.halo.state=1;
    return 0;
  }
  public int process (Stream si, Stream so) {
    int olut;
    int ilut;
    int bix;
    int otcm3;
    int biy, otcm2;
    int qtcm, scrv0;
    boolean bypass, scramb, gen, tcm, rt;
    bypass = getBit(flgs, 0);
    rt = getBit(flgs, 1);
    scramb = getBit(flgs, 2);
    gen = getBit(flgs, 3);
    tcm = getBit(flgs, 4);
    while (so.wok && (gen || si.rok || rt)) {
      if (gen) {
        lrsc = (iseq == 0) ? lrsi : iLRSP (lrsc, lrsp);
        bi = lrsc;
      }
      else if ((iseq & 0x1F) != 0) {
        bi = bi >> ilen;
      }
      else if (iseq == 0 || ! si.rok) {
        bi = COMMA;
      }
      else {
        bi = si.rdL ();
      }
      iseq = (iseq >= mseq) ? 0 : iseq + ilen;
      if (bypass) {
        so.wrBits (32, bi);
      }
      else {
        scrv0 = getBits(bi, 0, 0) ^ (getBits(scrv, 3, 3) ^ getBits(scrv, 20, 20) ^ ((scrc == 31) ? 1 : 0));
        scrc = (getBit(scrv, 1) != getBit(scrv, 9)) ? 0 : scrc + 1;
        scrv = (scrv0 << 1) | (scrv << 1);
        bix = tcm ? getBits(bi, 1, 1) : scramb ? scrv0 : (bi & gmask);
        biy = getBits(bi, 0, 0);
        shft = ((shft << 1) & mask) | bix;
        ilut = (ipunc << MO) | shft;
        ipunc = (ipunc >= mpunc) ? 0 : ipunc + 1;
        olut = elut[ilut];
        if (tcm) {
          uv = uv ^ (biy << getBits(olut, 1, 1));
          otcm2 = getBits(olut, 1, 0);
          qtcm = getBits(olut, 1, 1);
          otcm3 = otcm2 | (getBit(uv, qtcm) ? 4 : 0);
          so.wrBits (3, otcm3);
        }
        else {
          so.wrBits (olen - getBits(olut, 8, 8), getBits(olut, 7, 0));
        }
      }
    }
    return 0;
  }
  public int close () {
    this.halo.state=0;
    return 0;
  }
}
}
