/**
  Do NOT edit.
  This file is generated by ICEJVCC.
  See PKT2DAT.jv for documentation.
*/

import CORE_types::*;
package PKT2DAT_types;
import CORE_types::*;
endpackage
import PKT2DAT_types::*;

module PKT2DAT_core #(PORT=1, IBW=64,OBW=IBW, IFLG=0,OFLG=0, IOCLKS=1, IKR=4,OKR=IKR, PBW=32,PKR=1) (
  input[2:0] s_clks, input s_rst, input s_cs, input[31:0] s_addr,
                     input s_wr, input[31:0] s_wrbus, input s_rd, output[31:0] s_rdbus, output s_ack,
  input[3:0] io_clk, output[1:0] i_rdy, input i_ena, input[7:0] i_sel, input[IBW-1:0] i_bus,
                     output[1:0] o_rdy, input o_ena, output[7:0] o_sel, output[OBW-1:0] o_bus,
                     output pi_rdy, input pi_ena, input[PBW-1:0] pi_bus,
                     output po_rdy, input po_ena, output[PBW-1:0] po_bus,
  output [7:0] s_test);
  wire T=1,F=0; wire[7:0] T8=~0,F8=0;
  localparam SBW=32, ARRAY=0, STREAM=1, BUFFER=2, BUFSTR=3, PACKET=4;
  localparam BCIO=0, BCI=1, BCO=2, BCIIO=3, BCIOO=4, BCIIIOO=5;
  localparam FRAW=0, FCXI=1, FBIT=2, FAXI=3, FALL=4, FSWP=5;
  localparam TIGHT=8, BPAR=1024, BDMA=2048, BENA=16384, DBLBUF=32768, NEMPTY=131072, RAHEAD=262144;
  localparam FLOW=PACKET, BUFCFG=BCIO, SELFPACE=1, PIPE=0, MC=0, CW=2, AW=16, MBW=256, NP=1, BW=32, SIBW=BW, SOBW=BW, BIBW=BW, BOBW=BW, PIBW=32, POBW=32, IFMT=FRAW, OFMT=FRAW, DBGBW=32, DBGBD=10, P2=FLOW, P3=NP, P4=BW, P5=0, P6=0, P7=0;
  localparam XIBW=BIBW, XOBW=BOBW;
  localparam BWP=BW/8, IBWP=IBW/8, OBWP=OBW/8, XIBWP=XIBW/8, XOBWP=XOBW/8;
  localparam XIBWO=(XIBW>64)? 4 : (XIBW>32)? 3 : (XIBW>16)? 2 : (XIBW>8)? 1 : 0;
  localparam XOBWO=(XOBW>64)? 4 : (XOBW>32)? 3 : (XOBW>16)? 2 : (XOBW>8)? 1 : 0;
  localparam SUB=(PORT>10)? PORT-10:0;

  wire s_clk=s_clks[0],clk=s_clks[0],clk2=s_clks[1]; wire[1:0] clks=s_clks;
  logic rst,s_wrsys,s_wrscid; logic[31:0] s_sys; logic s_csm,s_csd,s_ena; logic[3:0] s_scid; 
  logic c_rd,c_wr,c_wok; logic[15:0] c_adr; logic[31:0] c_wbus,c_rbus; wire c_ok;
  always @(posedge s_clk) begin
    s_csd <= s_cs && s_addr[11:0]==12'hFFC;
    s_csm <= s_cs && !s_csd;
    s_wrsys <= s_cs && s_wr && s_addr[11:0]==0;
    if (s_rst) s_sys <= 0; else if (s_wrsys) s_sys <= s_wrbus;
    rst <= s_rst || s_sys[23];
    if (s_rst) c_wok <= 1; else if (!c_wr) c_wok <= !s_sys[22];
    s_ena <= (SUB==0)? s_sys[0] : s_clks[2];
  end
  wire frst=!s_ena; wire s_opt=s_sys[4]; wire[3:0] s_ifmt=s_sys[11:8], s_ofmt=s_sys[15:12]; wire [1:0] s_vbpr=s_sys[21:20];
  wire i_frst,o_frst,p_frst; 

  wire [31:0] s_sub, s_rdbusm, s_rdbust; wire [63:0] s_val; wire [15:0] s_ind; wire[17:0] s_set;
  wire s_csr=s_csm && !s_sub[24] && !s_addr[0];
  setter #(18,1) s_bank (clk,rst,s_csm&s_wr,s_addr,s_wrbus,s_sub,s_ind,s_set,s_val);
  portstatusblk #(PORT,"PKT2",P2,P3,P4,P5,P6,P7) s_sblk (s_clk,s_csr,s_addr,s_wr,s_wrbus,s_rd,s_rdbusm, clk,1'b1,c_adr,c_wok&c_wr,c_wbus,c_rd,c_rbus);
  assign s_rdbus = s_rdbusm;

  wire i_clk=io_clk[0], o_clk=(IOCLKS>1)?io_clk[1]:io_clk[0];
  logic sip_ren,sop_wen,sip_rok,sop_wok,bi_rd,so_wen,bi_nxt,bi_rok,so_wok;
  logic[AW-1:0] bi_adr,bi_len; logic[31:0] bi_dma;
  logic[XIBW-1:0] bi_bus; logic[XIBWP-1:0] bi_sel; logic[XOBW-1:0] so_wbus; logic[XOBWP-1:0] so_wsel; logic[POBW-1:0] sop_wbus; logic[PIBW-1:0] sip_rbus;
  logic[XIBWO-1:0] bi_adrb;  always @(posedge s_clk) bi_adrb <= bi_adr;
  logic[7:0] bi_busb; assign bi_busb = bi_bus >> {bi_adrb,3'h0};
  logic i_val; always @(posedge i_clk) i_val <= i_ena;
  logic pi_val; always @(posedge i_clk) pi_val <= pi_ena;
  wire c_rdy = (SELFPACE!=0) || (sip_rok && bi_rok && so_wok && sop_wok);

  fiaoNxM #(IBW+IBWP,XIBW+XIBWP,IKR,5,IFLG^BPAR,BPAR|BDMA|BENA) f_i (i_clk,i_frst, i_rdy,i_val,{i_sel,i_bus}, s_clk,i_frst, bi_rok,bi_rd,bi_dma,bi_nxt,bi_adr,bi_len,{bi_sel,bi_bus});
  fifoNxM #(XOBW+XOBWP,OBW+OBWP,OKR,5,BPAR,OFLG^BPAR) f_o (s_clk,o_frst, so_wok,so_wen,{so_wsel,so_wbus}, o_clk,o_frst, o_rdy,o_ena,{o_sel,o_bus});
  fifoNxM #(PBW,PIBW,PKR/2,2,0,NEMPTY) p_i (i_clk,p_frst, pi_rdy,pi_val,pi_bus, s_clk,p_frst, sip_rok,sip_ren,sip_rbus);
  fifoNxM #(POBW,PBW,PKR/2,2,0,NEMPTY) p_o (s_clk,p_frst, sop_wok,sop_wen,sop_wbus, o_clk,p_frst, po_rdy,po_ena,po_bus);

  logic c_start,c_done,c_active; logic[15:0] c_cnt,c_stat;
  always @(posedge clk) begin
    if (frst) c_start <= 0; else c_start <= s_ena && c_rdy && !c_start && !c_active;
    if (frst) c_active <= 0; else c_active <= c_start || (c_active && !c_done);
    if (c_start) c_cnt <= 0; else c_cnt <= c_cnt+1;
  end
  flowcontrol f_c (clk, frst, s_opt, c_cnt, c_ok);

  import CORE_funcs::*;

  localparam NL=195, PT_AUTO=-1, PT_NONE=0, PT_ETH=1, PT_UDP=2, PT_ICE=3, PT_SDDS=4, PT_VRT=5, PT_VRTL=6, PT_VRTW=7,
     PT_VRTX=8, PT_VRTD=9, RW=15, NC=4, IP=8, ARP=1544, ICMP=1, IGMP=2, TCP=6, UDP=17, SOP=1431655765, OUID=1068407,
     DIFI=6971934, IGMP_BA=-536870911, RES_IPKT=1, RES_OPKT=2, RES_ARP=3, RES_ICMP=4, RES_IGMP=5, RES_OTHER=6;
  localparam CV_halo_sys=0, CV_halo_flag=28, CV_halo_func=64, CV_halo_fmts=68, CV_halo_flow=72, CV_halo_impl=76;
  localparam CV_pkty=256,CV_myip=260,CV_mcip=264,CV_mcid=268,CV_flags=272,CV_osel=276,CV_ipkt=280,CV_opkt=284,CV_ic=288,
    CV_nc=292,CV_mcips=296,CV_mcids=300,CV_osels=304,CV_counts=308,CV_nseq=312,CV_ouid=316,CV_debug=320,CV_dma=324;

  int8 pkty;
  uint32 myip;
  uint32 mcip;
  uint16 mcid;
  uint16 flags;
  uint8 osel;
  uint12 ipkt;
  uint32 opkt;
  uint4 ic;
  uint4 nc;
  uint32 counts;
  uint8 nseq;
  int24 ouid;
  int32 debug;
  logic dma_start; logic[RW-1:0] dma_cnt; logic[8-1:0] dma_flags; logic dma_shrd; logic dma_busy; 
  logic dma_rok; logic[RW-1:0] dma_radr; logic[BW-1:0] dma_rbus; logic[32-1:0] dma_rdma; 
  logic dma_wok; logic[RW-1:0] dma_wadr; logic[BW-1:0] dma_wbus; logic[32-1:0] dma_wdma; 
  Dma #( RW , BW ) dma (clks,rst,dma_start,dma_cnt,dma_flags,dma_shrd,dma_busy,dma_rok,dma_radr,dma_rbus,dma_rdma,dma_wok,dma_wadr,dma_wbus,dma_wdma);
  uint32 mcips[NC];
  uint16 mcids[NC];
  uint8 osels[NC];

  /* verilator lint_off UNOPTFLAT */
  Line c_ln[195];  wire c_en[195];  wire c_xn[195];
  /* verilator lint_on UNOPTFLAT */

  setLine #(1,0,0) f_1 (c_ln[1],"startMethod",c_start,F);    // public int process ( BufferI bi , StreamI sip , StreamO so , StreamO sop ) {
  uint14 length, reslen, pktlen, udplen, ulen, dlen;         // uint14 length , reslen , pktlen , udplen , ulen , dlen ;
  uint32 src, dest, bx, by, bz, bq, bs;                      // uint32 src , dest , bx , by , bz , bq , bs ;
  uint8 ihdr, ioff, seq, dmaflg;                             // uint8 ihdr , ioff , seq , dmaflg ;
  uint4 restyp, ooff, bps, tlen;                             // uint4 restyp , ooff , bps , tlen ;
  uint16 sid;                                                // uint16 sid ;
  boolean asis, doclip, anyMC, anySID, anyOUID, anyIP, othpkt, pack, isMe, isMC, isBA, isSID, isOUID, hasOUID, hasSID; // boolean asis , doclip , anyMC , anySID , anyOUID , anyIP , othpkt , pack , isMe , isMC , isBA , isSID , isOUID , hasOUID , hasSID ;
  boolean isARP, isIP, isICMP, isIGMP, isUDP, isICE, isSDDS, isVRT, isVRTi, isVRTj, isVRTx, isVRTd, isVRTc, isVCTX, isKeep, isBE, isNB; // boolean isARP , isIP , isICMP , isIGMP , isUDP , isICE , isSDDS , isVRT , isVRTi , isVRTj , isVRTx , isVRTd , isVRTc , isVCTX , isKeep , isBE , isNB ;
  boolean alludp, alleth, okICE, okSDDS, okVRT, noOut, tena, xrst; // boolean alludp , alleth , okICE , okSDDS , okVRT , noOut , tena , xrst ;
  setLine #(1,0,1) f_10 (c_ln[10],"setVar",T,F);             // asis = flags [ 0 ] ;
  setLine #(1,0,1) f_11 (c_ln[11],"setVar",T,F);             // doclip = flags [ 2 ] ;
  setLine #(1,0,1) f_12 (c_ln[12],"setVar",T,F);             // anyMC = flags [ 4 ] ;
  setLine #(1,0,1) f_13 (c_ln[13],"setVar",T,F);             // anySID = flags [ 5 ] ;
  setLine #(1,0,1) f_14 (c_ln[14],"setVar",T,F);             // anyIP = flags [ 6 ] ;
  setLine #(1,0,1) f_15 (c_ln[15],"setVar",T,F);             // othpkt = flags [ 7 ] ;
  setLine #(1,0,1) f_16 (c_ln[16],"setVar",T,F);             // pack = flags [ 8 ] ;
  setLine #(1,0,1) f_17 (c_ln[17],"setVar",T,F);             // tena = flags [ 9 ] ;
  setLine #(1,0,1) f_18 (c_ln[18],"setVar",T,F);             // tlen = flags [ 15 : 12 ] ;
  setLine #(1,0,1) f_19 (c_ln[19],"setVar",T,F);             // xrst = F ;
  setLine #(1,0,1) f_20 (c_ln[20],"setVar",T,F);             // noOut = ( pkty == PT_NONE ) ;
  setLine #(1,0,1) f_21 (c_ln[21],"setVar",T,F);             // alleth = ( pkty == PT_ETH ) ;
  setLine #(1,0,1) f_22 (c_ln[22],"setVar",T,F);             // alludp = ( pkty == PT_UDP ) ;
  setLine #(1,0,1) f_23 (c_ln[23],"setVar",T,F);             // okICE = ( pkty == PT_AUTO ) || ( pkty == PT_ICE ) ;
  setLine #(1,0,1) f_24 (c_ln[24],"setVar",T,F);             // okSDDS = ( pkty == PT_AUTO ) || ( pkty == PT_SDDS ) ;
  setLine #(1,0,1) f_25 (c_ln[25],"setVar",T,F);             // okVRT = ( pkty == PT_AUTO ) || ( pkty >= PT_VRT ) ;
  setLine #(1,1,0) f_26 (c_ln[26],"While",sip_rok,c_xn[189]); // while ( sip.rok ) {
  setLine #(26,0,1) f_27 (c_ln[27],"setVar",T,F);            // dmaflg = 0 ;
  setLine #(26,0,1) f_28 (c_ln[28],"setVar",T,F);            // pktlen = 0 ;
  setLine #(26,0,1) f_29 (c_ln[29],"setVar",T,F);            // reslen = 0 ;
  setLine #(26,0,1) f_30 (c_ln[30],"setVar",T,F);            // restyp = 0 ;
  setLine #(26,0,1) f_31 (c_ln[31],"setVar",T,F);            // ihdr = 0 ;
  setLine #(26,0,1) f_32 (c_ln[32],"setVar",T,F);            // ioff = 0 ;
  setLine #(26,0,1) f_33 (c_ln[33],"setVar",T,F);            // length = 0 ;
  setLine #(26,0,1) f_34 (c_ln[34],"setVar",T,F);            // seq = nseq ;
  setLine #(26,0,1) f_35 (c_ln[35],"setVar",T,F);            // ipkt ++ ;
  setLine #(26,1,1) f_36 (c_ln[36],"setVar",T,F);            // counts [ 11 : 0 ] = ipkt ;
  setLine #(26,0,3) f_37 (c_ln[37],"StreamI_rdL",T,F);       // bs = sip.rdL ( ) ;
  setLine #(26,0,3) f_38 (c_ln[38],"BufferI_getL",T,F);      // by = bi.getL ( 0 ) ;
  setLine #(26,1,3) f_39 (c_ln[39],"BufferI_getL",T,F);      // bx = bi.getL ( 16 ) ;
  setLine #(26,4,1) f_40 (c_ln[40],"setVar",T,F);            // isARP = ( bx [ 31 : 16 ] == ARP ) ;
  setLine #(26,4,1) f_41 (c_ln[41],"setVar",T,F);            // isIP = ( bx [ 31 : 16 ] == IP ) ;
  setLine #(26,2,3) f_42 (c_ln[42],"BufferI_getL",T,F);      // bx = bi.getL ( 28 ) ;
  setLine #(26,5,1) f_43 (c_ln[43],"setVar",T,F);            // isUDP = isIP && ( bx [ 15 : 8 ] == UDP ) ;
  setLine #(26,5,1) f_44 (c_ln[44],"setVar",T,F);            // isICMP = isIP && ( bx [ 15 : 8 ] == ICMP ) ;
  setLine #(26,5,1) f_45 (c_ln[45],"setVar",T,F);            // isIGMP = isIP && ( bx [ 15 : 8 ] == IGMP ) ;
  setLine #(26,0,1) f_46 (c_ln[46],"setVar",T,F);            // isVCTX = F ;
  setLine #(26,3,3) f_47 (c_ln[47],"BufferI_getL",T,F);      // bx = bi.getL ( 36 ) ;
  setLine #(26,6,1) f_48 (c_ln[48],"setVar",T,F);            // dest = bswap4 ( bx ) ;
  setLine #(26,7,1) f_49 (c_ln[49],"setVar",T,F);            // isMe = ( dest == myip ) ;
  setLine #(26,7,1) f_50 (c_ln[50],"setVar",T,F);            // isMC = ( dest == mcip ) ;
  setLine #(26,7,1) f_51 (c_ln[51],"setVar",T,F);            // isBA = ( dest == IGMP_BA ) ;
  setLine #(26,8,0) f_52 (c_ln[52],"If",bs[17:16] != 4'h1 || by != SOP,F); // if ( bs [ 17 : 16 ] != 0x1 || by != SOP ) {
  setLine #(52,0,1) f_53 (c_ln[53],"setVar",T,F);            // xrst = T ;
  setLine #(52,0,1) f_54 (c_ln[54],"setVar",T,F);            // counts [ 31 ] = T ;
  setLine #(52,1,1) f_55 (c_ln[55],"setVar",T,F);            // counts [ 30 : 28 ] = counts [ 30 : 28 ] + 1 ;
  setLine #(52,0,0) f_56 (c_ln[56],"return",c_stat,F);       // return 1 ;
  setLine #(56,0,0) f_57 (c_ln[57],"endIf",c_xn[52],F);      // }
  setLine #(57,0,0) f_58 (c_ln[58],"If",alleth,F);           // if ( alleth ) {
  setLine #(58,0,0) f_59 (c_ln[59],"endIfE",c_xn[58],F);     // }
  setLine #(59,0,0) f_60 (c_ln[60],"ElseIf",isUDP && (anyMC || isMC),c_xn[58]); // else if ( isUDP && ( anyMC || isMC ) ) {
  setLine #(60,0,3) f_61 (c_ln[61],"BufferI_getL",T,F);      // bx = bi.getL ( 44 ) ;
  setLine #(60,3,1) f_62 (c_ln[62],"setVar",T,F);            // udplen = bswap2 ( bx [ 15 : 0 ] ) ;
  setLine #(60,0,1) f_63 (c_ln[63],"setVar",T,F);            // ooff = 8 ;
  setLine #(60,0,1) f_64 (c_ln[64],"setVar",T,F);            // ihdr = 48 ;
  setLine #(60,0,1) f_65 (c_ln[65],"setVar",T,F);            // isKeep = T ;
  setLine #(60,1,3) f_66 (c_ln[66],"BufferI_getL",T,F);      // bx = bi.getL ( ihdr ) ;
  setLine #(60,2,3) f_67 (c_ln[67],"BufferI_getL",T,F);      // by = bi.getL ( ihdr + 4 ) ;
  setLine #(60,3,3) f_68 (c_ln[68],"BufferI_getL",T,F);      // bz = bi.getL ( ihdr + 8 ) ;
  setLine #(60,4,3) f_69 (c_ln[69],"BufferI_getL",T,F);      // bq = bi.getL ( ihdr + 12 ) ;
  setLine #(60,4,1) f_70 (c_ln[70],"setVar",T,F);            // anyOUID = flags [ 10 ] || ! bx [ 3 ] ;
  setLine #(60,4,1) f_71 (c_ln[71],"setVar",T,F);            // hasOUID = bx [ 3 ] ;
  setLine #(60,4,1) f_72 (c_ln[72],"setVar",T,F);            // hasSID = ( bx [ 6 : 5 ] > 1 ) ? T : bx [ 4 ] ;
  setLine #(60,6,1) f_73 (c_ln[73],"setVar",T,F);            // sid = bswap2 ( hasSID ? by [ 31 : 16 ] : bz [ 15 : 0 ] ) ;
  setLine #(60,7,1) f_74 (c_ln[74],"setVar",T,F);            // isSID = ( sid == mcid ) ;
  setLine #(60,6,1) f_75 (c_ln[75],"setVar",T,F);            // isOUID = ( ouid == bswap4 ( hasSID ? bz : by ) ) ;
  setLine #(60,4,1) f_76 (c_ln[76],"setVar",T,F);            // isVRTi = ( bx [ 7 : 0 ] == 0x1C ) ;
  setLine #(60,4,1) f_77 (c_ln[77],"setVar",T,F);            // isVRTj = ( bx [ 7 : 0 ] == 0x08 ) ;
  setLine #(60,4,1) f_78 (c_ln[78],"setVar",T,F);            // isVRTx = ( bx [ 7 : 0 ] == 0x14 ) && ( pkty == PT_VRTX ) ;
  setLine #(60,4,1) f_79 (c_ln[79],"setVar",T,F);            // isVRTd = ( bx [ 7 : 0 ] == 0x18 ) ;
  setLine #(60,4,1) f_80 (c_ln[80],"setVar",T,F);            // isVRTc = ( bx [ 7 : 0 ] == 0x49 ) || ( bx [ 7 : 0 ] == 0x41 ) ;
  setLine #(60,4,1) f_81 (c_ln[81],"setVar",T,F);            // isICE = okICE && ( bx == 0x00676665 ) ;
  setLine #(60,4,1) f_82 (c_ln[82],"setVar",T,F);            // isSDDS = okSDDS && ( udplen == 1088 ) ;
  setLine #(60,8,1) f_83 (c_ln[83],"setVar",T,F);            // isVRT = okVRT && ( isVRTi || isVRTj || isVRTx || isVRTd ) && ( isSID || anySID ) && ( isOUID || anyOUID ) ;
  setLine #(60,8,1) f_84 (c_ln[84],"setVar",T,F);            // isVCTX = okVRT && isVRTc && ( isSID || anySID ) && ( isOUID || anyOUID ) ;
  setLine #(60,9,0) f_85 (c_ln[85],"If",alludp,F);           // if ( alludp ) {
  setLine #(85,0,1) f_86 (c_ln[86],"setVar",T,F);            // ioff = 0 ;
  setLine #(85,1,0) f_87 (c_ln[87],"endIfE",c_xn[85],F);     // }
  setLine #(87,9,0) f_88 (c_ln[88],"ElseIf",isICE,c_xn[85]); // else if ( isICE ) {
  setLine #(88,0,1) f_89 (c_ln[89],"setVar",T,F);            // ioff = 64 ;
  setLine #(88,0,1) f_90 (c_ln[90],"setVar",T,F);            // seq = by [ 7 : 0 ] ;
  setLine #(88,0,1) f_91 (c_ln[91],"setVar",T,F);            // sid = bq [ 31 : 16 ] ;
  setLine #(88,1,0) f_92 (c_ln[92],"endIfE",c_xn[88],F);     // }
  setLine #(92,9,0) f_93 (c_ln[93],"ElseIf",isSDDS,c_xn[88]); // else if ( isSDDS ) {
  setLine #(93,0,1) f_94 (c_ln[94],"setVar",T,F);            // ioff = 56 ;
  setLine #(93,0,1) f_95 (c_ln[95],"setVar",T,F);            // seq = bx [ 31 : 24 ] ;
  setLine #(93,0,1) f_96 (c_ln[96],"setVar",T,F);            // isNB = bx [ 13 : 8 ] > 8 ;
  setLine #(93,0,3) f_97 (c_ln[97],"BufferI_getL",T,F);      // bq = bi.getL ( ihdr + 52 ) ;
  setLine #(93,3,1) f_98 (c_ln[98],"setVar",T,F);            // sid = bq [ 31 : 16 ] ;
  setLine #(93,1,1) f_99 (c_ln[99],"setVar",T,F);            // dmaflg [ 0 ] = isNB ;
  setLine #(93,4,0) f_100 (c_ln[100],"endIfE",c_xn[93],F);   // }
  setLine #(100,9,0) f_101 (c_ln[101],"ElseIf",isVRT,c_xn[93]); // else if ( isVRT ) {
  setLine #(101,0,0) f_102 (c_ln[102],"If",(bx[2]) && ! asis,F); // if ( ( bx [ 2 ] ) && ! asis ) {
  setLine #(102,0,1) f_103 (c_ln[103],"setVar",T,F);         // ooff = 12 ;
  setLine #(102,1,0) f_104 (c_ln[104],"endIf",c_xn[102],F);  // }
  setLine #(104,0,1) f_105 (c_ln[105],"setVar",T,F);         // seq = bx [ 11 : 8 ] ;
  setLine #(104,0,1) f_106 (c_ln[106],"setVar",T,F);         // nseq = nseq & 0xF ;
  setLine #(104,0,1) f_107 (c_ln[107],"setVar",T,F);         // ioff = ! hasOUID ? 20 : ! hasSID ? 24 : 28 ;
  setLine #(104,0,1) f_108 (c_ln[108],"setVar",T,F);         // isBE = isVRTi ? bq [ 22 ] : isVRTj ? bz [ 22 ] : T ;
  setLine #(104,0,1) f_109 (c_ln[109],"setVar",T,F);         // bps = isVRTi ? bq [ 27 : 24 ] : isVRTj ? bz [ 27 : 24 ] : 15 ;
  setLine #(104,1,1) f_110 (c_ln[110],"setVar",T,F);         // dmaflg [ 0 ] = ( bps == 15 ) && isBE ;
  setLine #(104,1,1) f_111 (c_ln[111],"setVar",T,F);         // dmaflg [ 1 ] = ( bps > 7 ) && isBE ;
  setLine #(104,1,1) f_112 (c_ln[112],"setVar",T,F);         // dmaflg [ 2 ] = ( bps == 11 ) && isBE ;
  setLine #(104,2,0) f_113 (c_ln[113],"If",tena,F);          // if ( tena ) {
  setLine #(113,0,3) f_114 (c_ln[114],"BufferI_getL",T,F);   // bx = bi.getL ( ihdr + 16 ) ;
  setLine #(113,3,1) f_115 (c_ln[115],"setVar",T,F);         // isKeep = ( bx [ 31 : 28 ] < tlen ) ;
  setLine #(113,4,0) f_116 (c_ln[116],"endIf",c_xn[113],F);  // }
  setLine #(116,0,0) f_117 (c_ln[117],"endIfE",c_xn[101],F); // }
  setLine #(117,9,0) f_118 (c_ln[118],"ElseIf",T,c_xn[101]); // else {
  setLine #(118,0,1) f_119 (c_ln[119],"setVar",T,F);         // isKeep = isVCTX ? asis : F ;
  setLine #(118,1,0) f_120 (c_ln[120],"endIf",c_xn[118],F|c_en[117]|c_en[100]|c_en[92]|c_en[87]); // }
  setLine #(120,0,0) f_121 (c_ln[121],"If",asis,F);          // if ( asis ) {
  setLine #(121,0,1) f_122 (c_ln[122],"setVar",T,F);         // ioff = 0 ;
  setLine #(121,0,1) f_123 (c_ln[123],"setVar",T,F);         // dmaflg = 0 ;
  setLine #(121,1,0) f_124 (c_ln[124],"endIf",c_xn[121],F);  // }
  setLine #(124,0,1) f_125 (c_ln[125],"setVar",T,F);         // ulen = udplen - ioff - ooff ;
  setLine #(124,0,1) f_126 (c_ln[126],"setVar",T,F);         // isSID = ( sid == mcid ) ;
  setLine #(124,1,0) f_127 (c_ln[127],"If",isKeep && (isSID || anySID),F); // if ( isKeep && ( isSID || anySID ) ) {
  setLine #(127,0,1) f_128 (c_ln[128],"setVar",T,F);         // length = ulen ;
  setLine #(127,1,0) f_129 (c_ln[129],"endIf",c_xn[127],F);  // }
  setLine #(129,0,0) f_130 (c_ln[130],"endIfE",c_xn[60],F);  // }
  setLine #(130,0,0) f_131 (c_ln[131],"ElseIf",isICMP && (isMe | anyIP),c_xn[60]); // else if ( isICMP && ( isMe | anyIP ) ) {
  setLine #(131,0,1) f_132 (c_ln[132],"setVar",T,F);         // restyp = RES_ICMP ;
  setLine #(131,0,1) f_133 (c_ln[133],"setVar",T,F);         // counts [ 19 : 16 ] = counts [ 19 : 16 ] + 1 ;
  setLine #(131,1,0) f_134 (c_ln[134],"endIfE",c_xn[131],F); // }
  setLine #(134,0,0) f_135 (c_ln[135],"ElseIf",isIGMP && (isMe | anyIP | isMC | isBA),c_xn[131]); // else if ( isIGMP && ( isMe | anyIP | isMC | isBA ) ) {
  setLine #(135,0,1) f_136 (c_ln[136],"setVar",T,F);         // restyp = RES_IGMP ;
  setLine #(135,0,1) f_137 (c_ln[137],"setVar",T,F);         // counts [ 23 : 20 ] = counts [ 23 : 20 ] + 1 ;
  setLine #(135,1,0) f_138 (c_ln[138],"endIfE",c_xn[135],F); // }
  setLine #(138,0,0) f_139 (c_ln[139],"ElseIf",isARP,c_xn[135]); // else if ( isARP ) {
  setLine #(139,0,1) f_140 (c_ln[140],"setVar",T,F);         // restyp = RES_ARP ;
  setLine #(139,0,1) f_141 (c_ln[141],"setVar",T,F);         // counts [ 27 : 24 ] = counts [ 27 : 24 ] + 1 ;
  setLine #(139,1,0) f_142 (c_ln[142],"endIfE",c_xn[139],F); // }
  setLine #(142,0,0) f_143 (c_ln[143],"ElseIf",othpkt && ! isUDP,c_xn[139]); // else if ( othpkt && ! isUDP ) {
  setLine #(143,0,1) f_144 (c_ln[144],"setVar",T,F);         // restyp = RES_OTHER ;
  setLine #(143,0,1) f_145 (c_ln[145],"setVar",T,F);         // counts [ 30 : 28 ] = counts [ 30 : 28 ] + 1 ;
  setLine #(143,1,0) f_146 (c_ln[146],"endIf",c_xn[143],F|c_en[142]|c_en[138]|c_en[134]|c_en[130]|c_en[59]); // }
  setLine #(146,0,0) f_147 (c_ln[147],"If",alleth,F);        // if ( alleth ) {
  setLine #(147,0,0) f_148 (c_ln[148],"While",! sip_rok,c_xn[149]); // while ( ! sip.rok ) {
  setLine #(148,0,0) f_149 (c_ln[149],"endWhile",c_xn[148],F); // }
  setLine #(149,0,3) f_150 (c_ln[150],"StreamI_rdL",T,F);    // pktlen = sip.rdL ( ) ;
  setLine #(149,0,1) f_151 (c_ln[151],"setVar",T,F);         // dlen = 0x0040 << flags [ 10 : 8 ] ;
  setLine #(149,3,1) f_152 (c_ln[152],"setVar",T,F);         // length = doclip ? dlen : pktlen ;
  setLine #(149,4,0) f_153 (c_ln[153],"endIf",c_xn[147],F);  // }
  setLine #(153,0,0) f_154 (c_ln[154],"If",length > 0 && ! noOut,F); // if ( length > 0 && ! noOut ) {
  setLine #(154,0,0) f_155 (c_ln[155],"If",nc > 0,F);        // if ( nc > 0 ) {
  setLine #(155,0,1) f_156 (c_ln[156],"setVar",T,F);         // osel = osels [ ic ] ;
  setLine #(155,1,0) f_157 (c_ln[157],"endIf",c_xn[155],F);  // }
  setLine #(157,0,1) f_158 (c_ln[158],"StreamO_setC",T,F);   // so.setC ( osel ) ;
  setLine #(157,0,0) f_159 (c_ln[159],"Dma_setFlags",T,F);   // dma.setFlags ( dmaflg ) ;
  setLine #(157,1,1) f_160 (c_ln[160],"Dma_b2s",dma_busy,F); // dma.b2s ( bi , ihdr + ioff , so , 0 , length ) ;
  setLine #(157,0,1) f_161 (c_ln[161],"setVar",T,F);         // opkt ++ ;
  setLine #(157,2,0) f_162 (c_ln[162],"If",isUDP && ! isVCTX,F); // if ( isUDP && ! isVCTX ) {
  setLine #(162,0,0) f_163 (c_ln[163],"If",seq != nseq,F);   // if ( seq != nseq ) {
  setLine #(163,0,1) f_164 (c_ln[164],"setVar",T,F);         // counts [ 15 : 12 ] = counts [ 15 : 12 ] + 1 ;
  setLine #(163,1,0) f_165 (c_ln[165],"endIf",c_xn[163],F);  // }
  setLine #(165,0,1) f_166 (c_ln[166],"setVar",T,F);         // nseq = seq + 1 ;
  setLine #(165,1,0) f_167 (c_ln[167],"endIf",c_xn[162],F);  // }
  setLine #(167,0,0) f_168 (c_ln[168],"Dma_sync",dma_busy,F); // dma.sync ( ) ;
  setLine #(168,0,0) f_169 (c_ln[169],"endIf",c_xn[154],F);  // }
  setLine #(169,0,0) f_170 (c_ln[170],"If",! alleth,F);      // if ( ! alleth ) {
  setLine #(170,0,0) f_171 (c_ln[171],"While",! sip_rok,c_xn[172]); // while ( ! sip.rok ) {
  setLine #(171,0,0) f_172 (c_ln[172],"endWhile",c_xn[171],F); // }
  setLine #(172,0,3) f_173 (c_ln[173],"StreamI_rdL",T,F);    // pktlen = sip.rdL ( ) ;
  setLine #(172,3,0) f_174 (c_ln[174],"endIf",c_xn[170],F);  // }
  setLine #(174,0,0) f_175 (c_ln[175],"If",restyp > 0 && sop_wok,F); // if ( restyp > 0 && sop.wok ) {
  setLine #(175,0,0) f_176 (c_ln[176],"Dma_setFlags",T,F);   // dma.setFlags ( 0 ) ;
  setLine #(175,0,1) f_177 (c_ln[177],"setVar",T,F);         // reslen = pktlen ;
  setLine #(175,0,1) f_178 (c_ln[178],"setVar",T,F);         // bs [ 31 : 20 ] = 0x1CE ;
  setLine #(175,1,1) f_179 (c_ln[179],"setVar",T,F);         // bs [ 19 : 16 ] = restyp ;
  setLine #(175,2,1) f_180 (c_ln[180],"setVar",T,F);         // bs [ 15 : 0 ] = reslen ;
  setLine #(175,3,1) f_181 (c_ln[181],"StreamO_wrL",T,F);    // sop.wrL ( bs ) ;
  setLine #(175,3,1) f_182 (c_ln[182],"setVar",T,F);         // bs = bswap4 ( myip ) ;
  setLine #(175,4,1) f_183 (c_ln[183],"StreamO_wrL",T,F);    // sop.wrL ( bs ) ;
  setLine #(175,5,1) f_184 (c_ln[184],"Dma_b2s",dma_busy,F); // dma.b2s ( bi , 0 , sop , 0 , reslen ) ;
  setLine #(175,1,0) f_185 (c_ln[185],"print",T,F);          // print ( "Got restyp=%d reslen=%d\n" , restyp , reslen ) ;
  setLine #(175,6,0) f_186 (c_ln[186],"Dma_sync",dma_busy,F); // dma.sync ( ) ;
  setLine #(186,0,0) f_187 (c_ln[187],"endIf",c_xn[175],F);  // }
  setLine #(187,0,0) f_188 (c_ln[188],"BufferI_rnxt",T,F);   // bi.rnxt ( pktlen ) ;
  setLine #(187,0,0) f_189 (c_ln[189],"endWhile",c_xn[26],F); // }
  setLine #(189,0,0) f_190 (c_ln[190],"Ram_wr",CV_opkt,F);   // this.opkt = opkt ;
  setLine #(189,1,0) f_191 (c_ln[191],"Ram_wr",CV_counts,F); // this.counts = counts ;
  setLine #(189,2,0) f_192 (c_ln[192],"Ram_wr",CV_debug,F);  // this.debug = pack ( isARP , isIP , isUDP , isICMP , isIGMP , isMe , isMC , isBA , isICE , isSDDS , isVRT , isVCTX , seq [ 3 : 0 ] , bs [ 17 : 16 ] , pktlen ) ;
  setLine #(189,0,0) f_193 (c_ln[193],"return",c_stat,F);    // return 0 ;
  setLine #(193,0,0) f_194 (c_ln[194],"endMethod",T,F);      // }

  assign bi_dma = dma_rdma;
  always @(posedge clk) begin
    c_wr <= F; c_rd <= F; c_done <= F;
    bi_rd <= F; bi_nxt <= F; sip_ren <= F;
    so_wen <= F; sop_wen <= F;
    dma_start <= F; if (rst) dma_cnt <= 0; if (rst) dma_flags <= F; dma_rok <= F; if (rst) dma_radr <= 0; if (rst) dma_rbus <= 0; dma_wok <= F; if (rst) dma_wadr <= 0; 
    if (s_set[0]) pkty <= s_val;
    if (s_set[1]) myip <= s_val;
    if (s_set[2]) mcip <= s_val;
    if (s_set[3]) mcid <= s_val;
    if (s_set[4]) flags <= s_val;
    if (s_set[5]) osel <= s_val;
    if (s_set[6]) ipkt <= s_val;
    if (s_set[7]) opkt <= s_val;
    if (s_set[8]) ic <= s_val;
    if (s_set[9]) nc <= s_val;
    if (s_set[10]) mcips[s_ind] <= s_val;
    if (s_set[11]) mcids[s_ind] <= s_val;
    if (s_set[12]) osels[s_ind] <= s_val;
    if (s_set[13]) counts <= s_val;
    if (s_set[14]) nseq <= s_val;
    if (s_set[15]) ouid <= s_val;
    if (s_set[16]) debug <= s_val;
    if (c_xn[10]) begin asis <= flags[0]; end
    if (c_xn[11]) begin doclip <= flags[2]; end
    if (c_xn[12]) begin anyMC <= flags[4]; end
    if (c_xn[13]) begin anySID <= flags[5]; end
    if (c_xn[14]) begin anyIP <= flags[6]; end
    if (c_xn[15]) begin othpkt <= flags[7]; end
    if (c_xn[16]) begin pack <= flags[8]; end
    if (c_xn[17]) begin tena <= flags[9]; end
    if (c_xn[18]) begin tlen <= flags[15:12]; end
    if (c_xn[19]) begin xrst <= F; end
    if (c_xn[20]) begin noOut <= (pkty == PT_NONE); end
    if (c_xn[21]) begin alleth <= (pkty == PT_ETH); end
    if (c_xn[22]) begin alludp <= (pkty == PT_UDP); end
    if (c_xn[23]) begin okICE <= (pkty == PT_AUTO) || (pkty == PT_ICE); end
    if (c_xn[24]) begin okSDDS <= (pkty == PT_AUTO) || (pkty == PT_SDDS); end
    if (c_xn[25]) begin okVRT <= (pkty == PT_AUTO) || (pkty >= PT_VRT); end
    if (c_xn[27]) begin dmaflg <= 0; end
    if (c_xn[28]) begin pktlen <= 0; end
    if (c_xn[29]) begin reslen <= 0; end
    if (c_xn[30]) begin restyp <= 0; end
    if (c_xn[31]) begin ihdr <= 0; end
    if (c_xn[32]) begin ioff <= 0; end
    if (c_xn[33]) begin length <= 0; end
    if (c_xn[34]) begin seq <= nseq; end
    if (c_xn[35]) begin ipkt <= ipkt + 1; end
    if (c_xn[36]) begin counts[11:0] <= ipkt; end
    if (c_en[37]) begin sip_ren <= T; end 
    if (c_xn[37]) begin bs <= sip_rbus; end
    if (c_en[38]) begin bi_rd <= T; bi_adr <= 0; end 
    if (c_xn[38]) begin by <= bi_bus; end
    if (c_en[39]) begin bi_rd <= T; bi_adr <= 16; end 
    if (c_xn[39]) begin bx <= bi_bus; end
    if (c_xn[40]) begin isARP <= (bx[31:16] == ARP); end
    if (c_xn[41]) begin isIP <= (bx[31:16] == IP); end
    if (c_en[42]) begin bi_rd <= T; bi_adr <= 28; end 
    if (c_xn[42]) begin bx <= bi_bus; end
    if (c_xn[43]) begin isUDP <= isIP && (bx[15:8] == UDP); end
    if (c_xn[44]) begin isICMP <= isIP && (bx[15:8] == ICMP); end
    if (c_xn[45]) begin isIGMP <= isIP && (bx[15:8] == IGMP); end
    if (c_xn[46]) begin isVCTX <= F; end
    if (c_en[47]) begin bi_rd <= T; bi_adr <= 36; end 
    if (c_xn[47]) begin bx <= bi_bus; end
    if (c_xn[48]) begin dest <= bswap4 (bx); end
    if (c_xn[49]) begin isMe <= (dest == myip); end
    if (c_xn[50]) begin isMC <= (dest == mcip); end
    if (c_xn[51]) begin isBA <= (dest == IGMP_BA); end
    if (c_xn[53]) begin xrst <= T; end
    if (c_xn[54]) begin counts[31] <= T; end
    if (c_xn[55]) begin counts[30:28] <= counts[30:28] + 1; end
    if (c_xn[56]) begin c_stat <= 1; c_done <= T; end
    if (c_en[61]) begin bi_rd <= T; bi_adr <= 44; end 
    if (c_xn[61]) begin bx <= bi_bus; end
    if (c_xn[62]) begin udplen <= bswap2 (bx[15:0]); end
    if (c_xn[63]) begin ooff <= 8; end
    if (c_xn[64]) begin ihdr <= 48; end
    if (c_xn[65]) begin isKeep <= T; end
    if (c_en[66]) begin bi_rd <= T; bi_adr <= ihdr; end 
    if (c_xn[66]) begin bx <= bi_bus; end
    if (c_en[67]) begin bi_rd <= T; bi_adr <= ihdr + 4; end 
    if (c_xn[67]) begin by <= bi_bus; end
    if (c_en[68]) begin bi_rd <= T; bi_adr <= ihdr + 8; end 
    if (c_xn[68]) begin bz <= bi_bus; end
    if (c_en[69]) begin bi_rd <= T; bi_adr <= ihdr + 12; end 
    if (c_xn[69]) begin bq <= bi_bus; end
    if (c_xn[70]) begin anyOUID <= flags[10] || ! bx[3]; end
    if (c_xn[71]) begin hasOUID <= bx[3]; end
    if (c_xn[72]) begin hasSID <= (bx[6:5] > 1) ? T : bx[4]; end
    if (c_xn[73]) begin sid <= bswap2 (hasSID ? by[31:16] : bz[15:0]); end
    if (c_xn[74]) begin isSID <= (sid == mcid); end
    if (c_xn[75]) begin isOUID <= (ouid == bswap4 (hasSID ? bz : by)); end
    if (c_xn[76]) begin isVRTi <= (bx[7:0] == 8'h1C); end
    if (c_xn[77]) begin isVRTj <= (bx[7:0] == 8'h08); end
    if (c_xn[78]) begin isVRTx <= (bx[7:0] == 8'h14) && (pkty == PT_VRTX); end
    if (c_xn[79]) begin isVRTd <= (bx[7:0] == 8'h18); end
    if (c_xn[80]) begin isVRTc <= (bx[7:0] == 8'h49) || (bx[7:0] == 8'h41); end
    if (c_xn[81]) begin isICE <= okICE && (bx == 32'h00676665); end
    if (c_xn[82]) begin isSDDS <= okSDDS && (udplen == 1088); end
    if (c_xn[83]) begin isVRT <= okVRT && (isVRTi || isVRTj || isVRTx || isVRTd) && (isSID || anySID) && (isOUID || anyOUID); end
    if (c_xn[84]) begin isVCTX <= okVRT && isVRTc && (isSID || anySID) && (isOUID || anyOUID); end
    if (c_xn[86]) begin ioff <= 0; end
    if (c_xn[89]) begin ioff <= 64; end
    if (c_xn[90]) begin seq <= by[7:0]; end
    if (c_xn[91]) begin sid <= bq[31:16]; end
    if (c_xn[94]) begin ioff <= 56; end
    if (c_xn[95]) begin seq <= bx[31:24]; end
    if (c_xn[96]) begin isNB <= bx[13:8] > 8; end
    if (c_en[97]) begin bi_rd <= T; bi_adr <= ihdr + 52; end 
    if (c_xn[97]) begin bq <= bi_bus; end
    if (c_xn[98]) begin sid <= bq[31:16]; end
    if (c_xn[99]) begin dmaflg[0] <= isNB; end
    if (c_xn[103]) begin ooff <= 12; end
    if (c_xn[105]) begin seq <= bx[11:8]; end
    if (c_xn[106]) begin nseq <= nseq & 4'hF; end
    if (c_xn[107]) begin ioff <= ! hasOUID ? 20 : ! hasSID ? 24 : 28; end
    if (c_xn[108]) begin isBE <= isVRTi ? bq[22] : isVRTj ? bz[22] : T; end
    if (c_xn[109]) begin bps <= isVRTi ? bq[27:24] : isVRTj ? bz[27:24] : 15; end
    if (c_xn[110]) begin dmaflg[0] <= (bps == 15) && isBE; end
    if (c_xn[111]) begin dmaflg[1] <= (bps > 7) && isBE; end
    if (c_xn[112]) begin dmaflg[2] <= (bps == 11) && isBE; end
    if (c_en[114]) begin bi_rd <= T; bi_adr <= ihdr + 16; end 
    if (c_xn[114]) begin bx <= bi_bus; end
    if (c_xn[115]) begin isKeep <= (bx[31:28] < tlen); end
    if (c_xn[119]) begin isKeep <= isVCTX ? asis : F; end
    if (c_xn[122]) begin ioff <= 0; end
    if (c_xn[123]) begin dmaflg <= 0; end
    if (c_xn[125]) begin ulen <= udplen - ioff - ooff; end
    if (c_xn[126]) begin isSID <= (sid == mcid); end
    if (c_xn[128]) begin length <= ulen; end
    if (c_xn[132]) begin restyp <= RES_ICMP; end
    if (c_xn[133]) begin counts[19:16] <= counts[19:16] + 1; end
    if (c_xn[136]) begin restyp <= RES_IGMP; end
    if (c_xn[137]) begin counts[23:20] <= counts[23:20] + 1; end
    if (c_xn[140]) begin restyp <= RES_ARP; end
    if (c_xn[141]) begin counts[27:24] <= counts[27:24] + 1; end
    if (c_xn[144]) begin restyp <= RES_OTHER; end
    if (c_xn[145]) begin counts[30:28] <= counts[30:28] + 1; end
    if (c_en[150]) begin sip_ren <= T; end 
    if (c_xn[150]) begin pktlen <= sip_rbus; end
    if (c_xn[151]) begin dlen <= 16'h0040 << flags[10:8]; end
    if (c_xn[152]) begin length <= doclip ? dlen : pktlen; end
    if (c_xn[156]) begin osel <= osels[ic]; end
    if (c_xn[158]) begin so_wsel <= osel; end
    if (c_en[159]) begin dma_flags <= dmaflg; end
    if (c_en[160]) begin dma_start <= T; dma_radr <= ihdr + ioff; dma_wadr <= 0; dma_cnt <= length; end 
    if (c_xn[160]) begin dma_rok <= bi_rok; dma_rbus <= bi_bus; dma_wok <= so_wok; so_wen <= dma_wdma[31]; so_wbus <= dma_wbus; end
    if (c_xn[161]) begin opkt <= opkt + 1; end
    if (c_xn[164]) begin counts[15:12] <= counts[15:12] + 1; end
    if (c_xn[166]) begin nseq <= seq + 1; end
    if (c_en[173]) begin sip_ren <= T; end 
    if (c_xn[173]) begin pktlen <= sip_rbus; end
    if (c_en[176]) begin dma_flags <= 0; end
    if (c_xn[177]) begin reslen <= pktlen; end
    if (c_xn[178]) begin bs[31:20] <= 12'h1CE; end
    if (c_xn[179]) begin bs[19:16] <= restyp; end
    if (c_xn[180]) begin bs[15:0] <= reslen; end
    if (c_xn[181]) begin sop_wen <= T; sop_wbus <= bs; end
    if (c_xn[182]) begin bs <= bswap4 (myip); end
    if (c_xn[183]) begin sop_wen <= T; sop_wbus <= bs; end
    if (c_en[184]) begin dma_start <= T; dma_radr <= 0; dma_wadr <= 0; dma_cnt <= reslen; end 
    if (c_xn[184]) begin dma_rok <= bi_rok; dma_rbus <= bi_bus; dma_wok <= sop_wok; sop_wen <= dma_wdma[31]; sop_wbus <= dma_wbus; end
    if (c_xn[185]) begin $write ("Got restyp=%d reslen=%d\n", restyp, reslen); end
    if (c_en[188]) begin bi_nxt <= T; bi_adr <= pktlen; end
    if (c_xn[190]) begin c_wr <= T; c_adr <= CV_opkt; c_wbus <= opkt; end
    if (c_xn[191]) begin c_wr <= T; c_adr <= CV_counts; c_wbus <= counts; end
    if (c_xn[192]) begin c_wr <= T; c_adr <= CV_debug; c_wbus <= {isARP , isIP , isUDP , isICMP , isIGMP , isMe , isMC , isBA , isICE , isSDDS , isVRT , isVCTX , seq [ 3 : 0 ] , bs [ 17 : 16 ] , pktlen}; end
    if (c_xn[193]) begin c_stat <= 0; c_done <= T; end
  end

  assign  i_frst=frst|xrst, o_frst=noOut, p_frst=frst|xrst ;
  /* verilator lint_off WIDTHCONCAT */
  localparam int SEQ_PARAMS[195*4] = '{ 0,0,0,0, 11,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0, 21,1,0,0, 21,1,0,0, 21,1,0,0, 21,1,0,0, 21,1,0,0, 21,1,0,0, 21,1,0,0, 21,1,0,0, 21,1,0,0, 21,1,0,0, 21,1,0,0, 21,1,0,0, 21,1,0,0, 21,1,0,0, 21,1,0,0, 21,1,0,0, 41,1,1,0, 21,26,0,0, 21,26,0,0, 21,26,0,0, 21,26,0,0, 21,26,0,0, 21,26,0,0, 21,26,0,0, 21,26,0,0, 21,26,0,0, 21,26,1,0, 10,26,0,2, 10,26,0,2, 10,26,1,2, 21,26,4,0, 21,26,4,0, 10,26,2,2, 21,26,5,0, 21,26,5,0, 21,26,5,0, 21,26,0,0, 10,26,3,2, 21,26,6,0, 21,26,7,0, 21,26,7,0, 21,26,7,0, 31,26,8,0, 21,52,0,0, 21,52,0,0, 21,52,1,0, 14,52,0,0, 32,56,0,0, 33,57,0,0, 35,58,0,0, 34,59,0,0, 10,60,0,2, 21,60,3,0, 21,60,0,0, 21,60,0,0, 21,60,0,0, 10,60,1,2, 10,60,2,2, 10,60,3,2, 10,60,4,2, 21,60,4,0, 21,60,4,0, 21,60,4,0, 21,60,6,0, 21,60,7,0, 21,60,6,0, 21,60,4,0, 21,60,4,0, 21,60,4,0, 21,60,4,0, 21,60,4,0, 21,60,4,0, 21,60,4,0, 21,60,8,0, 21,60,8,0, 33,60,9,0, 21,85,0,0, 35,85,1,0, 34,87,9,0, 21,88,0,0, 21,88,0,0, 21,88,0,0, 35,88,1,0, 34,92,9,0, 21,93,0,0, 21,93,0,0, 21,93,0,0, 10,93,0,2, 21,93,3,0, 21,93,1,0, 35,93,4,0, 34,100,9,0, 31,101,0,0, 21,102,0,0, 32,102,1,0, 21,104,0,0, 21,104,0,0, 21,104,0,0, 21,104,0,0, 21,104,0,0, 21,104,1,0, 21,104,1,0, 21,104,1,0, 31,104,2,0, 10,113,0,2, 21,113,3,0, 32,113,4,0, 35,116,0,0, 34,117,9,0, 21,118,0,0, 32,118,1,0, 31,120,0,0, 21,121,0,0, 21,121,0,0, 32,121,1,0, 21,124,0,0, 21,124,0,0, 31,124,1,0, 21,127,0,0, 32,127,1,0, 35,129,0,0, 34,130,0,0, 21,131,0,0, 21,131,0,0, 35,131,1,0, 34,134,0,0, 21,135,0,0, 21,135,0,0, 35,135,1,0, 34,138,0,0, 21,139,0,0, 21,139,0,0, 35,139,1,0, 34,142,0,0, 21,143,0,0, 21,143,0,0, 32,143,1,0, 31,146,0,0, 41,147,0,0, 42,148,0,0, 10,149,0,2, 21,149,0,0, 21,149,3,0, 32,149,4,0, 31,153,0,0, 31,154,0,0, 21,155,0,0, 32,155,1,0, 10,157,0,0, 10,157,0,0, 56,157,1,0, 21,157,0,0, 31,157,2,0, 31,162,0,0, 21,163,0,0, 32,163,1,0, 21,165,0,0, 32,165,1,0, 55,167,0,0, 32,168,0,0, 31,169,0,0, 41,170,0,0, 42,171,0,0, 10,172,0,2, 32,172,3,0, 31,174,0,0, 10,175,0,0, 21,175,0,0, 21,175,0,0, 21,175,1,0, 21,175,2,0, 10,175,3,0, 21,175,3,0, 10,175,4,0, 56,175,5,0, 24,175,1,0, 55,175,6,0, 32,186,0,0, 10,187,0,0, 42,187,0,0, 10,189,0,0, 10,189,1,0, 10,189,2,0, 14,189,0,0, 15,193,0,0};
  sequencer #(195,SEQ_PARAMS) c_seq (clks,rst, c_ln, c_en,c_xn);
  /* verilator lint_on WIDTHCONCAT */
  assign s_test = {c_cnt[0],c_done,c_active,c_start,o_ena,i_ena,o_frst,i_frst};
endmodule

