/**********************************************
 ICE Proprietary Software - do NOT disseminate
 **********************************************/
/*
  Nop Core 

  Jeff Schoen
  Innovative Computer Engineering, Inc.
  1/15/2003

  defaultKeys = {L:DEC=1,L:RATE=10e6,L:FLAG=0,L:USER0=0x123,L:USER1=0x456}

*/
module Nop_engine (sclk,srst, scs,saddr, swr,swrbus, srd,srdbus, sack,
		   ioclk, istat,iena,isel,ibus, ostat,oena,osel,obus, test);

  parameter PORT=1;	// engine index
  parameter IBW=64;	// I/O input bus width
  parameter OBW=IBW;	// I/O output bus width

  localparam SBW=32;	// System bus width - always 32
  localparam DBW=32;	// Data bus width (internal core use)
  localparam NR=2;	// Number of 16kby RAMS in fifos

  input sclk;		// system clock
  input srst;		// system reset
  input scs;		// system select (qualifies swr and srd for this core)
  input swr;		// register write
  input srd;		// register read
  input [31:0] saddr;	// register address
  input [31:0] swrbus;	// register data
  output [31:0] srdbus;	// register data
  output sack;          // acknowledge

  input ioclk;          // I/O data bus clock
  output istat;         // istat - ready to accept 64 by burst
  input iena;           // input enable (one cycle early) (continuous 64 byte burst)
  input [7:0] isel;     // input channel selection
  input [IBW-1:0] ibus; // input data bus
  output ostat;         // ostat - ready to provide 64 byte burst
  input oena;           // output enable (one cycle early) (continuous 64 byte burst)
  output [7:0] osel;    // output channel selection
  output [OBW-1:0] obus;// output data bus

  output [7:0] test;	// 8 test signals for scope probes
  
  wire L=0, H=1;
  assign sack=H;
  assign osel=0;	// single channel core

  // system status ram with parameterized ID 
  swrstat #("NOP",32'h1CE) ss (sclk,scs,swr, saddr, swrbus,srdbus);

  // system register address resolution - with pipeline
  wire [15:0] sb; swrbank #(0,16) swb (sclk,scs,swr,saddr,sb);
  wire swrsys  = sb[0]; // system register (required)
  wire swrdec  = sb[1]; // decimation register (optional)
  wire swrgain = sb[2]; // gain register (optional)
  wire swrrate = sb[3]; // rate register (optional
  wire swrfram = sb[5]; // frame register (optional
  wire swrflag = sb[7]; // flag register (optional)
  wire swu0    = sb[8]; // flag register (optional)
  wire swu1    = sb[9]; // flag register (optional)

  // system registers - written to by pic_cport() host control software
  reg [31:0] system,dec,rate,frame,flag,u0,u1;	
  always @(posedge sclk) begin
    if (srst) system <= 0; else if (swrsys) system <= swrbus;
    if (srst) dec    <= 0; else if (swrdec) dec    <= swrbus;
    if (srst) rate   <= 0; else if (swrrate) rate  <= swrbus;
    if (srst) frame  <= 0; else if (swrfram) frame <= swrbus;
    if (srst) flag   <= 0; else if (swrflag) flag  <= swrbus;
    if (srst) u0     <= 0; else if (swu0  ) u0    <= swrbus;
    if (srst) u1     <= 0; else if (swu1  ) u1    <= swrbus;
    if (swu0) $write("Swu0 %x\n",swrbus);
    if (swu1) $write("Swu1 %x\n",swrbus);
  end
  wire enable     = system[0];		// core enable
  wire dir        = system[1];		// direction ? output:input
  wire reduce     = system[2];		// reduction ? enable:disable
  wire [3:0] ifmt = system[11:8];	// input format  bit[2:0]? 0=16b 1=8b 2=4b 3=1b 4=32b  bit[3]?complex:real
  wire [3:0] ofmt = system[15:12];	// output format bit[2:0]? 0=16b 1=8b 2=4b 3=1b 4=32b  bit[3]?complex:real
  wire throttle   = flag[0];
  wire swap       = flag[1];

  wire reset = !enable;		// core reset (at boot or disabled)
  wire vena,wena,vstat,wstat;
  wire [DBW-1:0] vbus,wbus;

  reg ival; always @(posedge ioclk) ival <= iena; // handle iena early

  // this reformats any input type to output format 4'h8 = complex 16b
//  fifoNxMfmt #(IBW,DBW,NR) fi (ioclk,reset, ifmt,istat,ival,ibus, sclk,reset, 4'h8, vstat,vena,vbus);
  fifoNxM #(IBW,DBW,NR,3,0,`RAHEAD) fi (ioclk,reset, istat,ival,ibus, sclk,reset, vstat,vena,vbus);

  // example function - replace with call to user verilog or vhdl here
  nop #(DBW) inst (sclk,reset, reduce,dec,frame,throttle,rate,swap, vstat,vena,vbus, wstat,wena,wbus);

  // this reformats the 4'h8 = complex 16b to any output type 
  fifoNxMfmti #(OBW,DBW,NR) fo (ioclk,reset, ofmt,ostat,oena,obus, sclk,reset, 4'h8, wstat,wena,wbus);

  assign test = {oena,ostat,iena,istat,wena,vena,throttle,dir};	// example test probe

endmodule

// this function uses internal fifo book-keeping
module nop (clk,reset, reduce,dec,frame,throttle,rate,swap,  vstat,vena,vbus, wstat,wena,wbus);
  parameter BW=32;
  localparam HBW=BW/2;
  localparam FCLK=`SYS_CLKF*1000000;
  input clk,reset,reduce,throttle,swap;
  input [31:0] dec,rate,frame;
  input vstat,wstat;
  output vena,wena;
  input [BW-1:0] vbus;
  output [BW-1:0] wbus;

  // example noop with dec = decimation-1
  // note vbus is valid with vena due to RAHEAD
  reg [15:0] fcnt;	// frame count
  reg [15:0] dcnt;	// decimation count
  reg [7:0] rcnt;	// rate count
  wire [31:0] fclkb = FCLK;
  reg vena,hold;
  wire vval = vena;
  wire fzero = (fcnt==0);
  wire fload = (vena && fzero);
  wire dzero = (dcnt==0);
  wire dload = (vena && dzero && fzero);
  wire rstr = (rcnt==fclkb[27:20]);
  always @(posedge clk) begin
    // frame circuit
    if (reset|fload) fcnt <= frame; else if (vena) fcnt <= fcnt-1;
    // decimation circuit
    if (reset) dcnt <= 0; else if (dload) dcnt <= dec; else if (fload) dcnt <= dcnt-1;
    vena <= vstat && wstat && !reset && !hold;
    // throttle circuit
    if (!throttle) hold <= 0; else hold <= (rcnt>rate[27:20]);
    if (rstr) rcnt <= 1; else rcnt <= rcnt+1;
  end
  assign wena = vval && (dzero || !reduce);
  assign wbus = swap? {vbus[HBW-1:0],vbus[BW-1:HBW]} : vbus;

endmodule
