/**
  Do NOT edit.
  This file is generated by ICEJVCC.
  See Modems.jv for documentation.
*/
package nxm.ice.core;
import nxm.ice.lib.*;
import nxm.ice.core.Modefs;
public class Modems extends CoreLibrary implements Modefs {
  public static int getModID (String s) {
    int id = findListItem (modList, s, -2);
    if (id < 0) System.out.printf ("Unknown MOD type=%s\n", s);
    return id;
  }
  public static int getFecID (String s) {
    int id = findListItem (fecList, s, -2);
    if (id < 0) System.out.printf ("Unknown FEC type=%s\n", s);
    return id;
  }
  public static int getMapID (String s) {
    int id = findListItem (mapList, s, -2);
    if (id < 0) System.out.printf ("Unknown MAP type=%s\n", s);
    return id;
  }
  public static int getGridSF (int mod) {
    int gsf;
    switch (mod) {
      case MT_1024QAM : gsf = 16;
      break;
      case MT_512QAM : gsf = 12;
      break;
      case MT_256QAM : gsf = 8;
      break;
      case MT_128QAM : gsf = 6;
      break;
      case MT_64APSK : case MT_64QAM : gsf = 4;
      break;
      case MT_32APSK : case MT_32QAM : gsf = 3;
      break;
      case MT_16APSK : case MT_16QAM : gsf = 2;
      break;
      case MT_8QAM : gsf = 2;
      break;
      default : gsf = 1;
    }
    return gsf;
  }
  public static int getBitsPerSym (int mod) {
    int bps;
    switch (mod) {
      case MT_1024QAM : bps = 10;
      break;
      case MT_512QAM : bps = 9;
      break;
      case MT_256QAM : bps = 8;
      break;
      case MT_128QAM : bps = 7;
      break;
      case MT_64APSK : case MT_64QAM : bps = 6;
      break;
      case MT_32APSK : case MT_32QAM : bps = 5;
      break;
      case MT_16APSK : case MT_16PSK : case MT_16QAM : bps = 4;
      break;
      case MT_8PSK : bps = 3;
      break;
      case MT_8QAM : bps = 3;
      break;
      case MT_FSK : case MT_BPSK : bps = 1;
      break;
      default : bps = 2;
    }
    return bps;
  }
  public static float getMinSNR (int mod) {
    float snr;
    switch (mod) {
      case MT_1024QAM : snr = 40;
      break;
      case MT_512QAM : snr = 36;
      break;
      case MT_256QAM : snr = 30;
      break;
      case MT_128QAM : snr = 20;
      break;
      case MT_64APSK : case MT_64QAM : snr = 15;
      break;
      case MT_32APSK : case MT_32QAM : snr = 12;
      break;
      case MT_16APSK : case MT_16QAM : snr = 9;
      break;
      case MT_8PSK : snr = 9;
      break;
      case MT_8QAM : snr = 9;
      break;
      case MT_BPSK : snr = 6;
      break;
      default : snr = 6;
    }
    return snr;
  }
  public static int bitRev (int ord, int im) {
    int i, om = 0;
    for (i = 0; i < ord; i ++) if (((im >> i) & 1) != 0) om |= (1 << (ord - 1 - i));
    return om;
  }
  public final static byte[] mapTCM = { 0x0, 0x2, 0x3, 0x1, 0x4, 0x6, 0x7, 0x5 };
  public static int getMap (int map, int ord, int i) {
    int n = (1 << ord), nh = n / 2, o = i;
    if (map == MAP_BRGCIB && i >= nh) i = n - 1 - i + nh;
    if (map >= MAP_BRGC) o = i ^ (i >> 1);
    if (map == MAP_BRGCNT) o = mapTCM[i];
    if (map == MAP_BRGCBE) o = bitRev (ord, o);
    return o;
  }
  public static int getMapXY (int map, int ord, int i, int j, int k) {
    int o, hord = ord / 2, n = (1 << hord), im, jm;
    if (map == MAP_BRGCIX || map == MAP_BRGCIXY) i = n - 1 - i;
    if (map == MAP_BRGCIY || map == MAP_BRGCIXY) j = n - 1 - j;
    im = (map >= MAP_BRGC) ? i ^ (i >> 1) : i;
    jm = (map >= MAP_BRGC) ? j ^ (j >> 1) : j;
    o = (im << hord) | jm;
    if ((ord & 1) != 0) o = k;
    if (map == MAP_BRGCBE) o = bitRev (ord, o);
    return o;
  }
  public static int getSymbolMap (int mod, int map, double amp, double midx, int nper, float[] x, float[] y) {
    float scl = (float) amp;
    int i, j, k = 0, im, jm, km, hlut = 0, olut = 0;
    double p;
    if (map < 0) map = MAP_BRGC;
    if (mod == MT_NONE) olut = 0;
    else if (mod == MT_CW) {
      olut = 10;
      float r1 = scl * (1.414F / 2);
      for (i = 0; i < 1024; i ++) {
        p = (i + 0.5) / 1024;
        x[i] = r1 * coscf (p);
        y[i] = r1 * sincf (p);
      }
    }
    else if (mod == MT_FSK) {
      olut = 1;
      float r1 = scl * (1.414F / 2);
      for (i = 0; i < nper * 2; i ++) {
        p = (0.5 * midx * i) / nper;
        j = 0 + (i << 4);
        x[j] = r1 * coscf (p);
        y[j] = r1 * sincf (p);
      }
      for (i = 0; i < nper * 2; i ++) {
        p = (-0.5 * midx * i) / nper;
        j = 1 + (i << 4);
        x[j] = r1 * coscf (p);
        y[j] = r1 * sincf (p);
      }
    }
    else if (mod == MT_4FSK) {
      olut = 2;
      float r1 = scl * (1.414F / 2);
      for (i = 0; i < nper * 2; i ++) {
        p = (0.5 * midx * i) / nper;
        j = 0 + (i << 4);
        x[j] = r1 * coscf (p);
        y[j] = r1 * sincf (p);
      }
      for (i = 0; i < nper * 2; i ++) {
        p = (-0.5 * midx * i) / nper;
        j = 1 + (i << 4);
        x[j] = r1 * coscf (p);
        y[j] = r1 * sincf (p);
      }
      for (i = 0; i < nper * 2; i ++) {
        p = (1.5 * midx * i) / nper;
        j = 2 + (i << 4);
        x[j] = r1 * coscf (p);
        y[j] = r1 * sincf (p);
      }
      for (i = 0; i < nper * 2; i ++) {
        p = (-1.5 * midx * i) / nper;
        j = 3 + (i << 4);
        x[j] = r1 * coscf (p);
        y[j] = r1 * sincf (p);
      }
    }
    else if (mod == MT_BPSK) {
      olut = 1;
      float r1 = scl * (1.414F / 2);
      for (i = 0; i < 2; i ++) {
        p = (i + 0.25) / 2;
        im = getMap (map, olut, i);
        x[im] = r1 * coscf (p);
        y[im] = r1 * sincf (p);
      }
    }
    else if (mod >= MT_QPSK && mod <= MT_1P4DQPSK) {
      olut = 2;
      float r1 = scl * (1.414F / 2);
      for (i = 0; i < 4; i ++) {
        p = (i + 0.5) / 4;
        im = getMap (map, olut, i);
        x[im] = r1 * coscf (p);
        y[im] = r1 * sincf (p);
      }
    }
    else if (mod == MT_8PSK) {
      olut = 3;
      float r1 = scl * (1.414F / 2);
      for (i = 0; i < 8; i ++) {
        p = (i + 0.5) / 8;
        im = getMap (map, olut, i);
        x[im] = r1 * coscf (p);
        y[im] = r1 * sincf (p);
      }
    }
    else if (mod == MT_16PSK) {
      olut = 4;
      float r1 = scl * (1.414F / 2);
      for (i = 0; i < 16; i ++) {
        p = (i + 0.5) / 16;
        im = getMap (map, olut, i);
        x[im] = r1 * coscf (p);
        y[im] = r1 * sincf (p);
      }
    }
    else if (mod == MT_16APSK) {
      olut = 4;
      float r2 = scl * (1.5F / 2), r1 = r2 * (1.0F / 2.57F);
      for (i = 0; i < 4; i ++) {
        p = (i + 0.5) / 4;
        im = getMap (map, olut, i);
        x[im] = r1 * coscf (p);
        y[im] = r1 * sincf (p);
      }
      for (i = 4; i < 16; i ++) {
        p = (i - 3.5) / 12;
        im = getMap (map, olut, i);
        x[im] = r2 * coscf (p);
        y[im] = r2 * sincf (p);
      }
    }
    else if (mod == MT_32APSK) {
      olut = 5;
      float r3 = scl * (2.5F / 3), r2 = r3 * (2.53F / 4.30F), r1 = r3 * (1.0F / 4.30F);
      for (i = 0; i < 4; i ++) {
        p = (i + 0.5) / 4;
        im = getMap (map, olut, i);
        x[im] = r1 * coscf (p);
        y[im] = r1 * sincf (p);
      }
      for (i = 4; i < 16; i ++) {
        p = (i - 3.5) / 12;
        im = getMap (map, olut, i);
        x[im] = r2 * coscf (p);
        y[im] = r2 * sincf (p);
      }
      for (i = 16; i < 32; i ++) {
        p = (i - 15.) / 16;
        im = getMap (map, olut, i);
        x[im] = r3 * coscf (p);
        y[im] = r3 * sincf (p);
      }
    }
    else if (mod == MT_64APSK) {
      olut = 6;
      float r4 = scl * (3.5F / 4), r3 = r4 * (4.0F / 5.3F), r2 = r4 * (2.53F / 5.30F), r1 = r4 * (1.0F / 5.30F);
      for (i = 0; i < 4; i ++) {
        p = (i + 0.5) / 4;
        im = getMap (map, olut, i);
        x[im] = r1 * coscf (p);
        y[im] = r1 * sincf (p);
      }
      for (i = 4; i < 16; i ++) {
        p = (i - 3.5) / 12;
        im = getMap (map, olut, i);
        x[im] = r2 * coscf (p);
        y[im] = r2 * sincf (p);
      }
      for (i = 16; i < 36; i ++) {
        p = (i - 15.5) / 20;
        im = getMap (map, olut, i);
        x[im] = r3 * coscf (p);
        y[im] = r3 * sincf (p);
      }
      for (i = 36; i < 64; i ++) {
        p = (i - 35.5) / 28;
        im = getMap (map, olut, i);
        x[im] = r4 * coscf (p);
        y[im] = r4 * sincf (p);
      }
    }
    else if (mod == MT_8QAM) {
      olut = 3;
      float r2 = scl * (1.848F / 2.5F), r1 = (0.768F / 2.5F);
      for (i = 0; i < 4; i ++) {
        p = (i + 0.5) / 4;
        im = getMap (map, olut, i);
        x[im] = r1 * coscf (p);
        y[im] = r1 * sincf (p);
      }
      for (i = 4; i < 8; i ++) {
        p = (i - 3.5) / 4;
        im = getMap (map, olut, i);
        x[im] = r2 * coscf (p);
        y[im] = r2 * sincf (p);
      }
    }
    else {
      switch (mod) {
        case MT_16QAM : olut = 4;
        hlut = 4;
        break;
        case MT_32QAM : olut = 5;
        hlut = 6;
        break;
        case MT_64QAM : olut = 6;
        hlut = 8;
        break;
        case MT_128QAM : olut = 7;
        hlut = 12;
        break;
        case MT_256QAM : olut = 8;
        hlut = 16;
        break;
        case MT_512QAM : olut = 9;
        hlut = 24;
        break;
        case MT_1024QAM : olut = 10;
        hlut = 32;
        break;
      }
      float ampd = 2 * scl / hlut, amp0 = - scl + ampd / 2;
      for (i = 0; i < hlut; i ++) {
        for (j = 0; j < hlut; j ++) {
          if (mod == MT_32QAM && (i < 1 || i > 4) && (j < 1 || j > 4)) continue;
          if (mod == MT_128QAM && (i < 2 || i > 9) && (j < 2 || j > 9)) continue;
          if (mod == MT_512QAM && (i < 4 || i > 19) && (j < 4 || j > 19)) continue;
          im = getMapXY (map, olut, i, j, k);
          x[im] = amp0 + i * ampd;
          y[im] = amp0 + j * ampd;
          k ++;
        }
      }
    }
    return olut;
  }
  public static int diff (int order, int e) {
    int i, i0, i1 = 0, ix, d = 0;
    for (i = 0; i < order; i ++) {
      i0 = i1;
      i1 = (e >> i) & 1;
      ix = i0 ^ i1;
      d |= (ix << i);
    }
    return d;
  }
  public static int genLUT (int order, int poly0, int poly1, boolean denc, int iper, int oper, int plen, int ppat, int[] lut, int[] pflg) {
    int MO = 9;
    int i, j, k, k0, k1, pp, p0, p1, p2, p3, p4, par, len, mask, mpunc;
    boolean tcm = (ppat == 7);
    len = (order == 0) ? 1 << iper : 1 << order;
    mask = (order == 1) ? 0 : len - 1;
    mpunc = plen - 1;
    if (mpunc < 0) mpunc = 0;
    if (lut != null) for (i = 0; i < len; i ++) {
      k = denc ? diff (order, i) : i;
      k0 = ones (k & poly0, order) & 0x1;
      k1 = ones (k & poly1, order) & 0x1;
      p0 = (i % 2 == 1) ? (1 << oper) - 1 : 0;
      p1 = 0x100 | k0;
      p2 = 0x100 | k1;
      p3 = (k1 << 1) | k0;
      p4 = (k0 << 1) | k1;
      if (tcm) for (j = 0; j < 8; j ++) {
        k = (k0 != 0) ? (j & 0x5) : (j & 0x3);
        par = ones (k, 3) & 0x1;
        lut[(j<<MO)|i] = (par << 2) | (k0 << 1) | k1;
      }
      else for (j = 0; j < plen; j ++) {
        pp = (ppat >> (4 * j)) & 0xF;
        lut[(j<<MO)|i] = (short) ((order == 0) ? i & mask : (pp == 0) ? p0 : (pp == 1) ? p1 : (pp == 2) ? p2 : (pp == 3) ? p3 : (pp == 4) ? p4 : p0);
      }
    }
    if (pflg != null) for (j = 0; j < plen; j ++) {
      pp = (ppat >> (4 * j)) & 0xF;
      if (pp == 2) pflg[j] = 0x9;
      else if (pp == 1) pflg[j] = 0xA;
      else pflg[j] = 0x0;
    }
    return (mpunc << 28) | (mask << 16) | (oper << 8) | iper;
  }
  public static int getFECLUT (int alg, int upp, int[] lut, int[] pflg) {
    int io = 0, order, npunc;
    boolean up = (upp != 0);
    switch (alg) {
      case FEC_NONE : io = genLUT (0, 0x000, 0x000, false, 1, 1, 1, up ? upp : 0x00000000, lut, pflg);
      break;
      case FEC_REP1 : io = genLUT (1, 0x001, 0x000, false, 1, 1, 1, up ? upp : 0x00000000, lut, pflg);
      break;
      case FEC_REP2 : io = genLUT (1, 0x001, 0x000, false, 1, 2, 1, up ? upp : 0x00000000, lut, pflg);
      break;
      case FEC_REP3 : io = genLUT (1, 0x001, 0x000, false, 1, 3, 1, up ? upp : 0x00000000, lut, pflg);
      break;
      case FEC_V27 : case FEC_V27P12 : io = genLUT (7, V27PA, V27PB, false, 1, 2, 1, up ? upp : 0x00000003, lut, pflg);
      break;
      case FEC_V27P23 : io = genLUT (7, V27PA, V27PB, false, 1, 2, 2, up ? upp : 0x00000013, lut, pflg);
      break;
      case FEC_V27P34 : io = genLUT (7, V27PA, V27PB, false, 1, 2, 3, up ? upp : 0x00000213, lut, pflg);
      break;
      case FEC_V27P45 : io = genLUT (7, V27PA, V27PB, false, 1, 2, 4, up ? upp : 0x00001113, lut, pflg);
      break;
      case FEC_V27P56 : io = genLUT (7, V27PA, V27PB, false, 1, 2, 5, up ? upp : 0x00021213, lut, pflg);
      break;
      case FEC_V27P67 : io = genLUT (7, V27PA, V27PB, false, 1, 2, 6, up ? upp : 0x00212113, lut, pflg);
      break;
      case FEC_V27P78 : io = genLUT (7, V27PA, V27PB, false, 1, 2, 7, up ? upp : 0x02121113, lut, pflg);
      break;
      case FEC_V29 : case FEC_V29P12 : io = genLUT (9, V29PA, V29PB, false, 1, 2, 1, up ? upp : 0x00000003, lut, pflg);
      break;
      case FEC_V29P23 : io = genLUT (9, V29PA, V29PB, false, 1, 2, 2, up ? upp : 0x00000013, lut, pflg);
      break;
      case FEC_V29P34 : io = genLUT (9, V29PA, V29PB, false, 1, 2, 3, up ? upp : 0x00000113, lut, pflg);
      break;
      case FEC_V29P45 : io = genLUT (9, V29PA, V29PB, false, 1, 2, 4, up ? upp : 0x00001213, lut, pflg);
      break;
      case FEC_V29P56 : io = genLUT (9, V29PA, V29PB, false, 1, 2, 5, up ? upp : 0x00021123, lut, pflg);
      break;
      case FEC_V29P67 : io = genLUT (9, V29PA, V29PB, false, 1, 2, 6, up ? upp : 0x00211213, lut, pflg);
      break;
      case FEC_V29P78 : io = genLUT (9, V29PA, V29PB, false, 1, 2, 7, up ? upp : 0x01121213, lut, pflg);
      break;
      case FEC_TCM : case FEC_TCM23 : io = genLUT (7, V27PA, V27PB, false, 2, 3, 1, up ? upp : 0x00000007, lut, pflg);
      break;
      case FEC_DTCM23 : io = genLUT (7, V27PA, V27PB, true, 2, 3, 1, up ? upp : 0x00000007, lut, pflg);
      break;
      default : io = genLUT (0, 0x000, 0x000, false, 1, 1, 1, up ? upp : 0x00000000, lut, pflg);
      System.out.printf ("Unhandled FEC algorithm index=%d \n", alg);
    }
    return io;
  }
  public static int getFrameSize (int modt, int fect, int word, int len) {
    int fs, fsb, isb;
    int bps = getBitsPerSym (modt);
    int iom = getFECLUT (fect, 0, null, null);
    int iper = (iom >> 0) & 0xFF;
    int oper = (iom >> 8) & 0xFF;
    int mask = (iom >> 16) & 0xFFF;
    int punc = (iom >> 28) & 0xF;
    punc += 1;
    int iperp = iper * punc;
    int operp = oper + (punc - 1) * (oper - 1);
    for (fs = len; fs > 30; fs --) {
      fsb = fs * bps;
      if ((fsb % operp) != 0) continue;
      isb = (fsb / operp) * iperp;
      if ((isb % word) != 0) continue;
      break;
    }
    if (fs != len) System.out.printf ("RFP Frame: ask=%d use=%d\n", len, fs);
    if (fs < 32) System.out.printf ("Problem finding frame size for bps=%d word=%d feci=%d feco=%d punc=%d\n", bps, word, iper, oper, punc);
    return (oper << 28) | (iper << 24) | (punc << 20) | (bps << 16) | fs;
  }
  public static int getFrameFor (String mod, String fec, int word, int len) {
    return getFrameSize (getModID (mod), getFecID (fec), word, len);
  }
  public static int getFrameAWG (int fsm) {
    int fs = (fsm >> 0) & 0xFFFF;
    return fs;
  }
  public static double getFECratio (int fect) {
    int iom = getFECLUT (fect, 0, null, null);
    int iper = (iom >> 0) & 0xFF;
    int oper = (iom >> 8) & 0xFF;
    int mask = (iom >> 16) & 0xFFF;
    int punc = (iom >> 28) & 0xF;
    punc += 1;
    int iperp = iper * punc;
    int operp = oper + (punc - 1) * (oper - 1);
    return i2d (operp * iper) / iperp;
  }
  public static int getFrameFEC (int fsm) {
    int fs = (fsm >> 0) & 0xFFFF;
    int bps = (fsm >> 16) & 0xF;
    int punc = (fsm >> 20) & 0xF;
    int iper = (fsm >> 24) & 0xF;
    int oper = (fsm >> 28) & 0xF;
    int iperp = iper * punc;
    int operp = oper + (punc - 1) * (oper - 1);
    return fs * bps / operp * iperp / iper;
  }
  public static class IFEC extends CoreComponent {
    int MO, MP, OLUT, NLUT;
    public int alg;
    public int upp;
    public double ratio;
    int ilen, olen;
    int ibit, slen;
    int obit, serr;
    int ipunc, jpunc, mpunc;
    int mask, shft;
    int rluts, vluts;
    int[] rlut;
    int[] pflgs;
    int vflg;
    int sdb;
    long ivec;
    int ovec;
    boolean iby3;
    boolean oby2;
    boolean frm1, frm2;
    int uv;
    Viterbi vit;
    public IFEC (int OFEC) {
      MO = OFEC;
      MP = MO + 3;
      OLUT = MP + 2;
      NLUT = (1 << OLUT);
      pflgs = new int[8];
      rlut = new int[NLUT];
      vit = new Viterbi ();
    }
    public void formLUT () {
      int i, iom, bi, bo, ni, iuv, ferrs, score0, score1, score2, score3, shift;
      int p, q, r, u, v;
      int[] elut = new int[NLUT];
      iom = getFECLUT (alg, upp, elut, pflgs);
      olen = (iom >> 0) & 0xFF;
      ilen = (iom >> 8) & 0xFF;
      mask = (iom >> 16) & 0xFFF;
      mpunc = (iom >> 28) & 0xF;
      if (! getBit(vflg, 7) || getBit(vflg, 6)) {
        rlut = new int[8];
        return;
      }
      ni = (ilen >= 3) ? 8 : (ilen == 2) ? 4 : 2;
      for (shift = 0; shift < (1 << MO); shift ++) {
        for (bi = 0; bi < ni; bi ++) {
          score0 = (bi ^ elut[((shift<<1)&mask)|0]) & 3;
          score1 = (bi ^ elut[((shift<<1)&mask)|1]) & 3;
          ferrs = 0;
          if (alg >= FEC_TCM) {
            r = (score1 < score0) ? 1 : 0;
            if (score0 != 0 && score1 != 0) ferrs ++;
            q = ((bi & 2) != 0) ? 1 : 0;
            p = ((bi & 4) != 0) ? 1 : 0;
            for (iuv = 0; iuv < 4; iuv ++) {
              u = ((iuv & 1) != 0) ? 1 : 0;
              v = ((iuv & 2) != 0) ? 1 : 0;
              bo = (r << 1) | ((q != 0) ? p ^ v : p ^ u);
              rlut[(iuv<<MP)|(bi<<MO)|shift] = (ferrs << 3) | (q << 2) | bo;
            }
          }
          else {
            bo = (score1 < score0) ? 1 : 0;
            if (score0 != 0 && score1 != 0) ferrs ++;
            if (score0 == 0) rlut[(1<<MP)|(((bi>>1)&1)<<MO)|shift] = bo;
            if (score1 == 0) rlut[(1<<MP)|(((bi>>1)&1)<<MO)|shift] = bo;
            if (score0 == 0) rlut[(2<<MP)|(((bi>>0)&1)<<MO)|shift] = bo;
            if (score1 == 0) rlut[(2<<MP)|(((bi>>0)&1)<<MO)|shift] = bo;
            rlut[(0<<MP)|(bi<<MO)|shift] = (ferrs << 3) | bo;
          }
        }
      }
    }
    public void open (int palg, int pupp, int flags) {
      alg = palg;
      upp = pupp;
      vflg = flags;
      formLUT ();
      iby3 = (ilen == 3);
      oby2 = (olen == 2);
      ibit = 0;
      obit = 0;
      serr = 0;
      sdb = getBit(vflg, 1) ? 4 : getBit(vflg, 0) ? 3 : 1;
      slen = ilen * sdb;
    }
    public double getRatio () {
      return getFECratio (alg);
    }
    public void processReframe () {
      if (getBit(vflg, 5)) {
        frm1 = (ibit == sdb);
        frm2 = ! frm1;
      }
      if (frm2) {
        shft = 0;
      }
    }
    public void processRepunc () {
      ipunc = (ipunc >= mpunc) ? 0 : ipunc + 1;
      jpunc = (jpunc >= mpunc) ? 0 : jpunc + 1;
      if (jpunc == 0 && ! getBit(vflg, 2)) {
        ibit ++;
      }
    }
    public int process (int hsym, int hbits) {
      int ilut;
      int pflg;
      int bihd;
      int bisd;
      int iinc, hlen, sluts, xluts;
      int fhd, ferr, flen, ump;
      int shift;
      boolean init, valid, restr, s3, s4, tcm, uv35, ufad, ufrm, uvit, ufec;
      s3 = getBit(vflg, 0);
      s4 = getBit(vflg, 1);
      tcm = getBit(vflg, 2);
      uv35 = getBit(vflg, 3);
      ufad = getBit(vflg, 4);
      ufrm = getBit(vflg, 5);
      uvit = getBit(vflg, 6);
      ufec = getBit(vflg, 7);
      ivec = (hsym << ibit) | getBits(ivec, 7, 0);
      ibit += hbits;
      obit = 0;
      init = true;
      while (ibit >= slen) {
        pflg = pflgs[ipunc];
        ump = tcm ? uv : getBits(pflg, 1, 0);
        iinc = iby3 ? (s4 ? 12 : s3 ? 9 : 3) : getBit(pflg, 3) ? (s4 ? 4 : s3 ? 3 : 1) : (s4 ? 8 : s3 ? 6 : 2);
        ipunc = (ipunc >= mpunc) ? 0 : ipunc + 1;
        bihd = iby3 ? getBits(ivec, 2, 0) : ! getBit(pflg, 3) ? getBits(ivec, 1, 0) : getBits(ivec, 0, 0);
        if (uvit) {
          vluts = vit.process (getBits(ivec, 11, 0), pflg, vflg);
        }
        else {
          restr = ufad && getBit(rluts, 3);
          shift = restr ? 0 : (frm2 ? 0 : tcm ? getBits(rluts, 1, 1) : getBits(rluts, 0, 0)) | (shft << 1);
          ilut = (ump << MP) | (bihd << MO) | (shift & mask);
          rluts = rlut[ilut];
          shft = frm1 ? 0 : shift;
          uv = getBit(rluts, 2) ? (uv & 1) | (getBits(rluts, 0, 0) << 1) : (uv & 2) | (getBits(rluts, 0, 0));
        }
        xluts = uvit ? vluts : rluts;
        valid = uvit ? getBit(vluts, 2) : true;
        fhd = valid ? getBits(xluts, 1, 0) : 0;
        ferr = valid ? getBits(xluts, 3, 3) : 0;
        flen = valid ? olen : 0;
        serr = init ? ferr : serr + ferr;
        ovec = init ? fhd : ovec | (fhd << obit);
        obit = init ? flen : obit + flen;
        ivec = ivec >> iinc;
        ibit -= iinc;
        init = false;
        frm2 = frm1;
        frm1 = false;
      }
      return (serr << 24) | (obit << 16) | ovec;
    }
    public final static String handleAuto = "sets,process=iix1,processReframe=x1,processRepunc=x0";
    public final static String handleMethod_process = "$process_ena=T,$hsym=%1,$hbits=%2,x=1,%0=$process_ret";
    public final static String handleMethod_processReframe = "$processReframe_ena=T,x=1";
    public final static String handleMethod_processRepunc = "$processRepunc_ena=T,x=0";
    public final static String handleArgs = "sets,i:process_ena,i:uint32:hsym,i:uint5:hbits,o:uint32:process_ret,i:processReframe_ena,i:processRepunc_ena";
  }
}
