/**
  Do NOT edit.
  This file is generated by ICEJVCC.
  See Filters.jv for documentation.
*/
#ifndef _Filters_
#include "cores/CoreDefs.h"

enum { Filters_FIRKAIS_LOW = 1 };
enum { Filters_FIRKAIS_HIGH = 2 };
enum { Filters_FIRKAIS_BAND = 3 };


/** Define CORE Plan Handles */
typedef struct {
  int_4 mlen;
  int_4 mask;
  int_2 offa;
  int_2 offb;
  real_4 scale;
  real_8 fx;
  real_4* ax;
  int_1 full;
  real_4 ival;
} Filters_Smooth;

int_4 Filters_Smooth_upload (Filters_Smooth* plan) {
  void *planp=NULL;
  HW_loadHdr (planp,10);
  HW_loadInt  (planp,plan->mlen);
  HW_loadInt  (planp,plan->mask);
  HW_loadInt  (planp,plan->offa);
  HW_loadInt  (planp,plan->offb);
  HW_loadFlt  (planp,plan->scale);
  HW_loadDbl  (planp,plan->fx);
  HW_loadBuf  (planp,plan->ax,'f',0);
  HW_loadInt  (planp,plan->full);
  HW_loadFlt  (planp,plan->ival);
  return 10;
}
typedef struct {
  int_4 mlen;
  int_4 mask;
  int_u2 offa;
  int_u2 offb;
  int_u1 olen;
  int_4 lx;
  int_4* ax;
  int_1 full;
} Filters_SmoothP2;

int_4 Filters_SmoothP2_upload (Filters_SmoothP2* plan) {
  void *planp=NULL;
  HW_loadHdr (planp,8);
  HW_loadInt  (planp,plan->mlen);
  HW_loadInt  (planp,plan->mask);
  HW_loadInt  (planp,plan->offa);
  HW_loadInt  (planp,plan->offb);
  HW_loadInt  (planp,plan->olen);
  HW_loadInt  (planp,plan->lx);
  HW_loadBuf  (planp,plan->ax,'i',0);
  HW_loadInt  (planp,plan->full);
  return 8;
}
typedef struct {
  int_4 shift;
  int_4 mshft;
  real_4 val;
  real_4 scale;
} Filters_SmoothP2X;

int_4 Filters_SmoothP2X_upload (Filters_SmoothP2X* plan) {
  void *planp=NULL;
  HW_loadHdr (planp,4);
  HW_loadInt  (planp,plan->shift);
  HW_loadInt  (planp,plan->mshft);
  HW_loadFlt  (planp,plan->val);
  HW_loadFlt  (planp,plan->scale);
  return 4;
}
typedef struct {
  int_4 O_CIC;
  int_4 O_DEC;
  int_u2 count;
  int_u2 decm;
  int_u1 coarse;
  int_u1 fine;
  int_8* pix;
  int_8* piy;
  int_4* pox;
  int_4* poy;
  int_4* pdx;
  int_4* pdy;
} Filters_CxCIC;

int_4 Filters_CxCIC_upload (Filters_CxCIC* plan) {
  void *planp=NULL;
  HW_loadHdr (planp,12);
  HW_loadInt  (planp,plan->O_CIC);
  HW_loadInt  (planp,plan->O_DEC);
  HW_loadInt  (planp,plan->count);
  HW_loadInt  (planp,plan->decm);
  HW_loadInt  (planp,plan->coarse);
  HW_loadInt  (planp,plan->fine);
  HW_loadBuf  (planp,plan->pix,'l',0);
  HW_loadBuf  (planp,plan->piy,'l',0);
  HW_loadBuf  (planp,plan->pox,'i',0);
  HW_loadBuf  (planp,plan->poy,'i',0);
  HW_loadBuf  (planp,plan->pdx,'i',0);
  HW_loadBuf  (planp,plan->pdy,'i',0);
  return 12;
}
typedef struct {
  int_2 off;
  int_2 lenm1;
  real_4 fx;
  real_4 fy;
  real_4 scale;
  real_4* ax;
  real_4* ay;
  int_1 full;
} Filters_CxComb;

int_4 Filters_CxComb_upload (Filters_CxComb* plan) {
  void *planp=NULL;
  HW_loadHdr (planp,8);
  HW_loadInt  (planp,plan->off);
  HW_loadInt  (planp,plan->lenm1);
  HW_loadFlt  (planp,plan->fx);
  HW_loadFlt  (planp,plan->fy);
  HW_loadFlt  (planp,plan->scale);
  HW_loadBuf  (planp,plan->ax,'f',0);
  HW_loadBuf  (planp,plan->ay,'f',0);
  HW_loadInt  (planp,plan->full);
  return 8;
}
typedef struct {
  real_4 b0;
  real_4 b1;
  real_4 b2;
  real_4 a1;
  real_4 a2;
} Filters_CxIIRStageO1;

int_4 Filters_CxIIRStageO1_upload (Filters_CxIIRStageO1* plan) {
  void *planp=NULL;
  HW_loadHdr (planp,5);
  HW_loadFlt  (planp,plan->b0);
  HW_loadFlt  (planp,plan->b1);
  HW_loadFlt  (planp,plan->b2);
  HW_loadFlt  (planp,plan->a1);
  HW_loadFlt  (planp,plan->a2);
  return 5;
}
Filters_CxIIRStageO1* Filters_CxIIRStageO1_new() { 
  return (Filters_CxIIRStageO1*)zalloc(sizeof(Filters_CxIIRStageO1)); 
}
typedef struct {
  real_4 b0;
  real_4 b1;
  real_4 b2;
  real_4 a1;
  real_4 a2;
} Filters_CxIIRStageO2;

int_4 Filters_CxIIRStageO2_upload (Filters_CxIIRStageO2* plan) {
  void *planp=NULL;
  HW_loadHdr (planp,5);
  HW_loadFlt  (planp,plan->b0);
  HW_loadFlt  (planp,plan->b1);
  HW_loadFlt  (planp,plan->b2);
  HW_loadFlt  (planp,plan->a1);
  HW_loadFlt  (planp,plan->a2);
  return 5;
}
Filters_CxIIRStageO2* Filters_CxIIRStageO2_new() { 
  return (Filters_CxIIRStageO2*)zalloc(sizeof(Filters_CxIIRStageO2)); 
}
typedef struct {
  int_4 ORD;
  int_4 STR;
  int_4 LEN;
  int_4 LENM1;
  Filters_CxIIRStageO1* s1;
  Filters_CxIIRStageO1* s2;
  Filters_CxIIRStageO1* s3;
  CxReal_4* c1;
  CxReal_4* c2;
  int_u1 iN;
  int_u1 iM;
  int_u1 i2M;
  real_4* ax1;
  real_4* ax2;
  real_4* ax3;
  real_4* ax4;
  real_4* ay1;
  real_4* ay2;
  real_4* ay3;
  real_4* ay4;
} Filters_CxIIR;

int_4 Filters_CxIIR_upload (Filters_CxIIR* plan) {
  void *planp=NULL;
  HW_loadHdr (planp,20);
  HW_loadInt  (planp,plan->ORD);
  HW_loadInt  (planp,plan->STR);
  HW_loadInt  (planp,plan->LEN);
  HW_loadInt  (planp,plan->LENM1);
  HW_loadObj  (planp,Filters_CxIIRStageO1_upload(plan->s1));
  HW_loadObj  (planp,Filters_CxIIRStageO1_upload(plan->s2));
  HW_loadObj  (planp,Filters_CxIIRStageO1_upload(plan->s3));
  HW_loadInt  (planp,0);
  HW_loadInt  (planp,0);
  HW_loadInt  (planp,plan->iN);
  HW_loadInt  (planp,plan->iM);
  HW_loadInt  (planp,plan->i2M);
  HW_loadBuf  (planp,plan->ax1,'f',0);
  HW_loadBuf  (planp,plan->ax2,'f',0);
  HW_loadBuf  (planp,plan->ax3,'f',0);
  HW_loadBuf  (planp,plan->ax4,'f',0);
  HW_loadBuf  (planp,plan->ay1,'f',0);
  HW_loadBuf  (planp,plan->ay2,'f',0);
  HW_loadBuf  (planp,plan->ay3,'f',0);
  HW_loadBuf  (planp,plan->ay4,'f',0);
  return 20;
}
typedef struct {
  int_4 BNSHF;
  real_4 B0;
  real_4 B1;
  real_4 adl;
  real_8 nco;
  real_8 uF;
} Filters_CxPhasePLL;

int_4 Filters_CxPhasePLL_upload (Filters_CxPhasePLL* plan) {
  void *planp=NULL;
  HW_loadHdr (planp,8);
  HW_loadInt  (planp,plan->BNSHF);
  HW_loadFlt  (planp,plan->B0);
  HW_loadFlt  (planp,plan->B1);
  HW_loadFlt  (planp,plan->adl);
  HW_loadDbl  (planp,plan->nco);
  HW_loadDbl  (planp,plan->uF);
  return 8;
}

real_8 Filters_sinx (real_8 arg) {
  real_8 num = sin (arg);
  if (fabs (arg) < 1e-20 && fabs (num) < 1e-20) return 1.0;
  return num / arg;
}

real_8 Filters_besselIO (real_8 x) {
  real_8 ds = 1, d = 0, s = 1;
  for (;;) {
    d += 2;
    ds = (ds * x * x) / (d * d);
    s += ds;
    if (ds - (s * 0.2e-8) < 0) break;
  }
  return s;
}

int_4 Filters_genFirKais (int_4 type, real_8 f1, real_8 f2, real_8 f3, real_8 attn, real_4* filt, int_4 ntap) {
  real_8 fcntr, fpass, ftnbw, fsamp, mtap, beta, alpha, fcut, wcut, den, strt, lo, pcos, psin, resp, factor, wind;
  int_4 i;
  fcntr = f1;
  fpass = (type == Filters_FIRKAIS_BAND) ? f2 * 0.5 : f1;
  ftnbw = f3;
  fsamp = 2.0;
  mtap = (attn - 8) / (2.285 * 2 * PI * ftnbw / fsamp);
  if (ntap <= 0) ntap = (int_4) (mtap + 1.5);
  if (ntap <= 0) return 0;
  if (attn > 50.0) beta = 0.1102 * (attn - 8.7);
  else if (attn >= 21.0) beta = 0.58420 * pow (attn - 21.0, 0.4) + 0.07886 * (attn - 21.0);
  else beta = 0.0;
  alpha = 0.5 * (ntap - 1);
  fcut = (type == Filters_FIRKAIS_HIGH) ? fpass - 0.5 * ftnbw : fpass + 0.5 * ftnbw;
  fcut /= fsamp;
  wcut = 2 * PI * fcut;
  den = Filters_besselIO (beta);
  if (type != Filters_FIRKAIS_BAND) fcntr = 0;
  strt = -0.5 * (ntap - 1);
  lo = 2.0 * PI * fcntr / fsamp;
  for (i = 0; i < ntap; i ++) {
    pcos = cos ((strt + i) * lo);
    psin = sin ((strt + i) * lo);
    resp = 2.0 * fcut * Filters_sinx (wcut * (i - alpha));
    if (type == Filters_FIRKAIS_HIGH) resp = Filters_sinx (PI * (i - alpha)) - resp;
    factor = sqrt (1.0 - pow ((1.0 * i - alpha) / alpha, 2.0));
    wind = Filters_besselIO (beta * factor) / den;
    filt[i+i+0] = (real_4) (wind * resp * pcos);
    filt[i+i+1] = (real_4) (wind * resp * psin);
  }
  return ntap;
}

real_8 Filters_sincfunc (real_8 x) {
  real_8 num = sin (x);
  real_8 sinc = 1.0;
  if (fabs (num) > 1e-20 && fabs (x) > 1e-20) sinc = num / x;
  return sinc;
}

real_4* Filters_genWindowFilter (int_4 len, int_4 wtype, int_4 ftype, real_8 freq1, real_8 freq2, real_8 fs) {
  real_8 win, alpha, halfbw, outfc, ideal;
  int_4 i;
  real_4* filt = zallocBuf(sizeof(real_4)*(len));
  freq1 /= fs;
  freq2 /= fs;
  alpha = 0.5 * (len - 1);
  for (i = 0; i < len; i ++) {
    win = 1.0;
    if (wtype == 1) win = 0.50 - 0.50 * cos (i * PI / alpha);
    if (wtype == 2) win = 0.54 - 0.46 * cos (i * PI / alpha);
    ideal = 2.0 * freq1 * Filters_sincfunc (TWOPI * freq1 * (i - alpha));
    if (ftype == 2) ideal = Filters_sincfunc (PI * (i - alpha)) - ideal;
    filt[i] = (real_4) (win * ideal);
  }
  return filt;
}

int_4 Filters_applyCompensation (real_4 alpha, real_4* filt, int_4 n) {
  real_4 c0 = - alpha / 2, c1 = 1.0F + alpha, c2 = - alpha / 2;
  real_4 f0, f1 = filt[n-1], f2 = filt[0], fx = f2;
  int_4 i;
  for (i = 0; i < n; i ++) {
    f0 = f1;
    f1 = f2;
    f2 = (i == n - 1) ? fx : filt[i+1];
    filt[i] = f0 * c0 + f1 * c1 + f2 * c2;
  }
  return n;
}

int_4 Filters_genLinearSlope (real_8 attn, real_4* filt, int_4 ntap) {
  int_4 n = ntap;
  return n;
}

void Filters_Smooth_setLength (Filters_Smooth* plan, int_2 length) {
  int_4 len = length;
  if (len > plan->mask) {
    printf ("Smoother length reduced from desired len=%d to max len=%d\n", len, plan->mask);
    len = plan->mask;
  }
  plan->scale = 1.0F / len;
  plan->offa = 0;
  plan->offb = (plan->offa - len) & plan->mask;
  plan->full = 0;
  plan->fx = 0;
  plan->ival = 0;
}

void Filters_Smooth_setInitial (Filters_Smooth* plan, real_4 val) {
  plan->ival = val;
  plan->fx = plan->ival / plan->scale;
}

Filters_Smooth* Filters_Smooth_new (int_4 ORDER) {
  Filters_Smooth* plan=zalloc(sizeof(Filters_Smooth));
  plan->mlen = 1 << ORDER;
  plan->mask = (plan->mlen - 1);
  plan->ax = zallocBuf(sizeof(real_4)*(plan->mlen));
  Filters_Smooth_setLength (plan, plan->mlen - 1);
  Filters_Smooth_setInitial (plan, 0.0F);
  return plan;
}

real_4 Filters_Smooth_process (Filters_Smooth* plan, real_4 fin, int_1 valid) {
  real_4 fa, fb;
  fa = fin;
  plan->ax[plan->offa] = fin;
  fb = plan->full ? plan->ax[plan->offb] : plan->ival;
  plan->full = plan->full || (plan->offb == plan->mask);
  if (valid) {
    plan->offa = (plan->offa + 1) & plan->mask;
    plan->offb = (plan->offb + 1) & plan->mask;
    plan->fx += f2d (fa - fb);
  }
  return d2f (plan->fx * plan->scale);
}

void Filters_SmoothP2_reset (Filters_SmoothP2* plan) {
  int_4 len = (1 << plan->olen);
  plan->offa = 0;
  plan->offb = (plan->offa - len + 1) & plan->mask;
  plan->full = 0;
  plan->lx = 0;
}

void Filters_SmoothP2_setLength (Filters_SmoothP2* plan, int_2 length) {
  int_4 len = 1;
  for (plan->olen = 0; len < length; plan->olen ++, len *= 2);
  if (len != length) {
    printf ("Smoother length modified from desired len=%d to power2 len=%d\n", length, len);
  }
  Filters_SmoothP2_reset (plan);
}

Filters_SmoothP2* Filters_SmoothP2_new (int_4 ORDER) {
  Filters_SmoothP2* plan=zalloc(sizeof(Filters_SmoothP2));
  plan->mlen = 1 << ORDER;
  plan->mask = (plan->mlen - 1);
  plan->ax = zallocBuf(sizeof(int_4)*(plan->mlen));
  plan->olen = ORDER;
  Filters_SmoothP2_reset (plan);
  return plan;
}

real_4 Filters_SmoothP2_process (Filters_SmoothP2* plan, real_4 fin, int_1 valid) {
  int_4 lin, fa, fb;
  lin = F2K (fin);
  fa = lin;
  plan->ax[plan->offa] = lin;
  fb = plan->full ? plan->ax[plan->offb] : 0;
  plan->full = plan->full || (plan->offb == plan->mask);
  if (valid) {
    plan->offa = (plan->offa + 1) & plan->mask;
    plan->offb = (plan->offb + 1) & plan->mask;
    plan->lx += (fa - fb);
  }
  return K2F (plan->lx >> plan->olen);
}

Filters_SmoothP2X* Filters_SmoothP2X_new (int_4 ORDER) {
  Filters_SmoothP2X* plan=zalloc(sizeof(Filters_SmoothP2X));
  plan->val = 0;
  plan->shift = ORDER;
  plan->scale = 1.0F - 1.0F / (1 << plan->shift);
  return plan;
}

void Filters_SmoothP2X_reset (Filters_SmoothP2X* plan) {
  plan->val = 0;
}

real_4 Filters_SmoothP2X_process (Filters_SmoothP2X* plan, real_4 fin, int_1 valid) {
  if (valid) {
    plan->val = plan->val * plan->scale + divfp2 (mulfp2 (fin, 8), plan->shift);
  }
  return divfp2 (plan->val, 8);
}

void Filters_CxCIC_setGain (Filters_CxCIC* plan, int_4 gain) {
  int_4 dec = plan->decm + 1;
  int_4 shift = (int_4) (5.0 * log2 ((real_8) dec / 4) + 9) - d2i (gain / 6.0);
  if (shift < 0) shift = 0;
  if (shift >= 32) {
    plan->coarse = 31;
    plan->fine = shift - 31;
  }
  else {
    plan->coarse = shift;
    plan->fine = 0;
  }
}

void Filters_CxCIC_setDecimation (Filters_CxCIC* plan, int_4 dec) {
  plan->decm = dec - 1;
  plan->count = plan->decm;
  Filters_CxCIC_setGain (plan, 0);
}

Filters_CxCIC* Filters_CxCIC_new (int_4 ocic, int_4 odec) {
  Filters_CxCIC* plan=zalloc(sizeof(Filters_CxCIC));
  plan->O_CIC = ocic;
  plan->O_DEC = odec;
  plan->pix = zallocBuf(sizeof(int_8)*(plan->O_CIC + 1));
  plan->piy = zallocBuf(sizeof(int_8)*(plan->O_CIC + 1));
  plan->pox = zallocBuf(sizeof(int_4)*(plan->O_CIC + 1));
  plan->poy = zallocBuf(sizeof(int_4)*(plan->O_CIC + 1));
  plan->pdx = zallocBuf(sizeof(int_4)*(plan->O_CIC + 1));
  plan->pdy = zallocBuf(sizeof(int_4)*(plan->O_CIC + 1));
  Filters_CxCIC_setDecimation (plan, 1 << odec);
  return plan;
}

int_1 Filters_CxCIC_process (Filters_CxCIC* plan, CxReal_4* fi, CxReal_4* fo) {
  int_4 ia, ib;
  int_1 out;
  int_8 pox0, poy0;
  for (ia = plan->O_CIC; ia >= 0; ia --) {
    plan->pix[ia] = (ia == 0) ? s2l (F2I (fi->x)) : plan->pix[ia] + plan->pix[ia-1];
    plan->piy[ia] = (ia == 0) ? s2l (F2I (fi->y)) : plan->piy[ia] + plan->piy[ia-1];
  }
  out = (plan->count == 0);
  plan->count = (plan->count == 0) ? plan->decm : plan->count - 1;
  if (out) {
    pox0 = plan->pix[plan->O_CIC] >> plan->coarse;
    poy0 = plan->piy[plan->O_CIC] >> plan->coarse;
    for (ib = plan->O_CIC; ib >= 0; ib --) {
      plan->pdx[ib] = plan->pox[ib];
      plan->pox[ib] = (ib == 0) ? l2i (pox0) : plan->pox[ib-1] - plan->pdx[ib-1];
      plan->pdy[ib] = plan->poy[ib];
      plan->poy[ib] = (ib == 0) ? l2i (poy0) : plan->poy[ib-1] - plan->pdy[ib-1];
    }
    fo->x = K2F (plan->pox[plan->O_CIC] >> plan->fine);
    fo->y = K2F (plan->poy[plan->O_CIC] >> plan->fine);
  }
  return out;
}

void Filters_CxComb_setLength (Filters_CxComb* plan, int_2 length) {
  plan->lenm1 = length - 1;
  plan->scale = 1.0F / length;
}

Filters_CxComb* Filters_CxComb_new (int_4 ORDER) {
  Filters_CxComb* plan=zalloc(sizeof(Filters_CxComb));
  int_4 len = 1 << ORDER;
  plan->ax = zallocBuf(sizeof(real_4)*(1 << ORDER));
  plan->ay = zallocBuf(sizeof(real_4)*(1 << ORDER));
  plan->full = 0;
  plan->lenm1 = len - 1;
  plan->scale = 1.0F / len;
  plan->off = 0;
  return plan;
}

int_1 Filters_CxComb_process (Filters_CxComb* plan, CxReal_4* fi, CxReal_4* fo) {
  real_4 axi, ayi;
  real_4 bxi, byi;
  axi = ! plan->full ? 0 : plan->ax[plan->off];
  ayi = ! plan->full ? 0 : plan->ay[plan->off];
  bxi = fi->x;
  byi = fi->y;
  plan->ax[plan->off] = fi->x;
  plan->ay[plan->off] = fi->y;
  plan->fx = plan->fx + bxi - axi;
  plan->fy = plan->fy + byi - ayi;
  fo->x = plan->fx * plan->scale;
  fo->y = plan->fy * plan->scale;
  plan->full = plan->full || (plan->off == plan->lenm1);
  plan->off = (plan->off < plan->lenm1) ? plan->off + 1 : 0;
  return plan->full;
}

void Filters_CxIIRStageO1_open (Filters_CxIIRStageO1* plan, int_4 order, real_4 gfact, real_4 p1, real_4 z1, real_4 p2, real_4 z2) {
  int_4 ord = order;
  plan->b0 = gfact;
  plan->b1 = - ord * z1;
  plan->b2 = - ord * z2;
  plan->a1 = - ord * p1;
  plan->a2 = - ord * p2;
}

int_4 Filters_CxIIRStageO1_process (Filters_CxIIRStageO1* plan, CxReal_4* fi, CxReal_4* fo, real_4 axM, real_4 ayM, real_4 naxM, real_4 nayM) {
  real_4 tax, tay, tbx, tby;
  tax = naxM * plan->a1 - nayM * plan->a2;
  tay = nayM * plan->a1 + naxM * plan->a2;
  tbx = axM * plan->b1 - ayM * plan->b2 + fi->x;
  tby = ayM * plan->b1 + axM * plan->b2 + fi->y;
  fo->x = tbx * plan->b0 - tax;
  fo->y = tby * plan->b0 - tay;
  return 1;
}

void Filters_CxIIRStageO2_open (Filters_CxIIRStageO2* plan, int_4 order, real_4 gfact, real_4 p1, real_4 z1, real_4 p2, real_4 z2) {
  int_4 ord = order;
  plan->b0 = gfact;
  plan->b1 = - ord * z1;
  plan->b2 = (z1 * z1 + z2 * z2);
  plan->a1 = - ord * p1;
  plan->a2 = (p1 * p1 + p2 * p2);
}

int_4 Filters_CxIIRStageO2_process (Filters_CxIIRStageO2* plan, CxReal_4* fi, CxReal_4* fo, real_4 axM, real_4 ayM, real_4 naxM, real_4 nayM, real_4 ax2M, real_4 ay2M, real_4 nax2M, real_4 nay2M) {
  real_4 tax, tay, tbx, tby;
  tax = naxM * plan->a1 + nax2M * plan->a2;
  tay = nayM * plan->a1 + nay2M * plan->a2;
  tbx = axM * plan->b1 + ax2M * plan->b2 + fi->x;
  tby = ayM * plan->b1 + ay2M * plan->b2 + fi->y;
  fo->x = tbx * plan->b0 - tax;
  fo->y = tby * plan->b0 - tay;
  return 1;
}

Filters_CxIIR* Filters_CxIIR_new (int_4 ORDER, int_4 STRIDE) {
  Filters_CxIIR* plan=zalloc(sizeof(Filters_CxIIR));
  int_4 i;
  plan->ORD = ORDER;
  plan->STR = STRIDE;
  plan->LEN = plan->STR * 2;
  plan->LENM1 = plan->LEN - 1;
  plan->s1 = Filters_CxIIRStageO1_new ();
  plan->s2 = Filters_CxIIRStageO1_new ();
  plan->s3 = Filters_CxIIRStageO1_new ();
  plan->c1 = CxReal_4_new ();
  plan->c2 = CxReal_4_new ();
  plan->ax1 = zallocBuf(sizeof(real_4)*(plan->LEN));
  plan->ay1 = zallocBuf(sizeof(real_4)*(plan->LEN));
  plan->ax2 = zallocBuf(sizeof(real_4)*(plan->LEN));
  plan->ay2 = zallocBuf(sizeof(real_4)*(plan->LEN));
  plan->ax3 = zallocBuf(sizeof(real_4)*(plan->LEN));
  plan->ay3 = zallocBuf(sizeof(real_4)*(plan->LEN));
  plan->ax4 = zallocBuf(sizeof(real_4)*(plan->LEN));
  plan->ay4 = zallocBuf(sizeof(real_4)*(plan->LEN));
  return plan;
}

void Filters_CxIIR_open (Filters_CxIIR* plan, int_4 order, real_4 gain, real_4* poles, real_4* zeros) {
  int_4 stages = 3;
  real_4 gfact = powf (gain * 8, 1.0F / stages);
  if (order == 3) {
    Filters_CxIIRStageO1_open (plan->s3, 1, gfact, poles[4], zeros[4], 0.0F, 0.0F);
    Filters_CxIIRStageO1_open (plan->s2, 1, gfact, poles[2], zeros[2], poles[3], zeros[3]);
    Filters_CxIIRStageO1_open (plan->s1, 1, gfact, poles[0], zeros[0], poles[1], zeros[1]);
  }
  else if (order == 5) {
    Filters_CxIIRStageO1_open (plan->s3, 1, gfact, poles[8], zeros[8], 0.0F, 0.0F);
    Filters_CxIIRStageO1_open (plan->s2, 2, gfact, poles[4], zeros[4], poles[5], zeros[5]);
    Filters_CxIIRStageO1_open (plan->s1, 2, gfact, poles[0], zeros[0], poles[1], zeros[1]);
  }
  else {
    printf ("Unsupported IIR filter order=%d\n", order);
  }
  plan->iN = 0;
  plan->iM = (plan->LEN - plan->STR);
  plan->i2M = 0;
}

int_4 Filters_CxIIR_process (Filters_CxIIR* plan, CxReal_4* ci, CxReal_4* co) {
  plan->ax1[plan->iN] = ci->x;
  plan->ay1[plan->iN] = ci->y;
  Filters_CxIIRStageO1_process (plan->s1, ci, plan->c1, plan->ax1[plan->iM], plan->ay1[plan->iM], plan->ax2[plan->iM], plan->ay2[plan->iM]);
  plan->ax2[plan->iN] = plan->c1->x;
  plan->ay2[plan->iN] = plan->c1->y;
  Filters_CxIIRStageO1_process (plan->s2, plan->c1, plan->c2, plan->ax2[plan->iM], plan->ay2[plan->iM], plan->ax3[plan->iM], plan->ay3[plan->iM]);
  plan->ax3[plan->iN] = plan->c2->x;
  plan->ay3[plan->iN] = plan->c2->y;
  Filters_CxIIRStageO1_process (plan->s3, plan->c2, co, plan->ax3[plan->iM], plan->ay3[plan->iM], plan->ax4[plan->iM], plan->ay4[plan->iM]);
  plan->ax4[plan->iN] = co->x;
  plan->ay4[plan->iN] = co->y;
  plan->iN = (plan->iN == plan->LENM1) ? 0 : plan->iN + 1;
  plan->iM = (plan->iM == plan->LENM1) ? 0 : plan->iM + 1;
  plan->i2M = (plan->i2M == plan->LENM1) ? 0 : plan->i2M + 1;
  return 1;
}

Filters_CxPhasePLL* Filters_CxPhasePLL_new () {
  Filters_CxPhasePLL* plan=zalloc(sizeof(Filters_CxPhasePLL));
  plan->BNSHF = 20;
  return plan;
}

void Filters_CxPhasePLL_setup (Filters_CxPhasePLL* plan, real_8 K, real_8 bw, real_8 Zeta, real_8 Fs) {
  real_8 wn = bw * PI / Zeta;
  real_8 Tau1 = K / (wn * wn);
  real_8 Tau2 = 2 * Zeta / wn;
  plan->B0 = mulfp2 ((real_4) ((1.0 / (2.0 * Tau1 * Fs * Fs)) * (1 + 1.0 / tan (1.0 / (2.0 * Tau2 * Fs)))), plan->BNSHF);
  plan->B1 = mulfp2 ((real_4) ((1.0 / (2.0 * Tau1 * Fs * Fs)) * (1 - 1.0 / tan (1.0 / (2.0 * Tau2 * Fs)))), plan->BNSHF);
  plan->adl = 0;
  plan->uF = 0;
}

real_4 Filters_CxPhasePLL_process (Filters_CxPhasePLL* plan, CxReal_4* fi) {
  real_4 ap, ad;
  ap = atan2cf (fi->y, fi->x);
  ad = wrapf (ap - d2f (plan->nco));
  plan->nco = frac (plan->nco + divp2 (plan->uF, plan->BNSHF));
  plan->uF += f2d (plan->B0 * ad + plan->B1 * plan->adl);
  plan->adl = ad;
  return d2f (plan->nco);
}
#define _Filters_
#endif
