/**
  Do NOT edit.
  This file is generated by ICEJVCC.
  See FMC.jv for documentation.
*/
package nxm.ice.core;
import nxm.ice.core.Modefs;
import nxm.ice.core.Modems;
import nxm.ice.core.Filters;
import nxm.ice.lib.*;
public class FMC extends CoreFactory {

public static class JVM extends CORE       {                             public JVM() { setFlow(STREAM); } }
public static class CPU extends CoreNative { public native long alloc(); public CPU() { setFlow(STREAM); } }
public static class ICE extends CoreNative { public native long alloc(); public ICE() { setFlow(STREAM); } }

public final static int FLOW = STREAM, SELFPACE = 1, IFMT = FBIT, BW = 32, OSEQ = 11, NSEQ = 1 << OSEQ, OLUT = 10, NLUT = 1 << OLUT;
public static class CORE extends Core implements Modefs {
  public int rfp;
  public int mod;
  public int map;
  public int fec;
  public int scr;
  public double midx;
  public double fS;
  public double fSym;
  public double tOff;
  public int frame;
  double ps;
  int bpw;
  int iper, nper, mper;
  int flgs;
  int pr, princ;
  int mlut;
  float[] xlut, ylut;
  int din;
  int dinc;
  int scrvec;
  int[] seq;
  int iseq, mseq;
  int di;
  int db;
  public void setFrame (int len) {
    frame = len;
  }
  public int init () {
    mod = 0;
    midx = 1.0;
    fS = -1.0;
    tOff = 0;
    bpw = -1;
    nper = 1;
    mper = 0;
    iseq = 0;
    scr = -1;
    map = MAP_BRGC;
    frame = 1920;
    return 0;
  }
  public int set (String key, Value value) {
    if (isMatch (key, "S:SHAPE")) mod = value.toItem (modList);
    else if (isMatch (key, "D:MIDX")) midx = value.toD ();
    else if (isMatch (key, "S:RFP")) rfp = value.toItem (rfpList);
    else if (isMatch (key, "S:MOD")) mod = value.toItem (modList);
    else if (isMatch (key, "S:MAP")) map = value.toItem (mapList);
    else if (isMatch (key, "S:FEC")) fec = value.toItem (fecList);
    else if (isMatch (key, "S:SCR")) scr = value.toItem (scrList);
    else if (isMatch (key, "L:FRAME")) frame = value.toL ();
    else if (isMatch (key, "L:BPW")) bpw = value.toL ();
    else if (isMatch (key, "D:FS")) fS = value.toD ();
    else if (isMatch (key, "D:FSYM")) fSym = value.toD ();
    else return super.set (key, value);
    return 0;
  }
  public int get (String key, Value value) {
    if (isMatch (key, "D:FS")) value.fromD (fS);
    else if (isMatch (key, "D:FSYM")) value.fromD (fSym);
    else return super.get (key, value);
    return 0;
  }
  public void genSeq (int olut) {
    int i = 0, j, bits, seed = 123456, lrs = ~ seed, mask = (1 << olut) - 1;
    mseq = NSEQ - 3;
    if (rfp == RFP_ICE) {
      for (j = 0; j <= (32 - olut); j += olut) {
        bits = (frameSync >> j) & mask;
        seq[i++] = 0x8000 | bits;
      }
      seq[i-1] |= 0x4000;
      mseq = frame + i;
      if (mseq > NSEQ) System.out.printf ("Total RFP frame data=%d + sync=%d > max seq=%d\n", frame, i, NSEQ);
    }
    if (mod == MT_CW) {
      scr = 0;
      if (midx > 0) {
        mseq = d2i (nper * fSym / midx / 0x10000);
        if (mseq <= 0) {
          System.out.printf ("Unable to perform CW sweep parameters\n", mseq);
          mseq = 1;
        }
        if (mseq > 2048) {
          System.out.printf ("Unable to perform CW sweep parameters\n", mseq);
          mseq = 2048;
        }
        seq[i++] = 0x4000;
      }
      else {
        mseq = 16;
        seq[i++] = 0x0000;
      }
    }
    for (; i < mseq; i ++) {
      if (scr != SCR_LRS) lrs = 0;
      else for (j = 0; j < 8; j ++) {
        lrs = (lrs << 1) | (0x1 ^ getBits(lrs, 0, 0) ^ getBits(lrs, 1, 1) ^ getBits(lrs, 5, 5) ^ getBits(lrs, 25, 25));
      }
      seq[i] = lrs & 0x3FF;
    }
    mseq --;
  }
  public void genRotates (int nn) {
    int i, n, ii = 16;
    float p, ax, ay, bx, by;
    for (i = 0; i < ii; i ++) {
      p = i2f (i) / ii;
      bx = coscf (p);
      by = sincf (p);
      for (n = 0; n < nn; n ++) {
        ax = xlut[n];
        ay = ylut[n];
        xlut[(i<<4)+n] = ax * bx - ay * by;
        ylut[(i<<4)+n] = ax * by + ay * bx;
      }
    }
  }
  public double getFilterWidth () {
    double fw = 1;
    if (mod == MT_FSK) fw = 2 * midx / nper;
    if (mod == MT_4FSK) fw = 4 * midx / nper;
    if (mod == MT_OQPSK) fw /= 2;
    return fw;
  }
  public double getFeedRate () {
    return fSym * nper;
  }
  public int getDefaultTaps () {
    boolean oqpsk = (mod == MT_OQPSK);
    boolean fsk = (mod == MT_FSK) || (mod == MT_4FSK);
    return oqpsk ? 7 : fsk ? 21 : (mod >= MT_512QAM) ? 11 : 7;
  }
  public boolean isGenerator () {
    return (bpw == 0);
  }
  public int open () {
    int i, olut, nlut;
    double ratio;
    boolean oqpsk = (mod == MT_OQPSK);
    boolean fsk = (mod == MT_FSK) || (mod == MT_4FSK);
    if (mod == MT_FSK) {
      nper = (int) (midx * 2);
      mper = 2 * nper - 1;
    }
    if (mod == MT_4FSK) {
      nper = (int) (midx * 6);
      mper = 2 * nper - 1;
    }
    if (oqpsk) {
      nper = 2;
      mper = 1;
    }
    xlut = new float[NLUT];
    ylut = new float[NLUT];
    olut = Modems.getSymbolMap (mod, map, 1.0, midx, nper, xlut, ylut);
    nlut = (1 << olut);
    mlut = nlut - 1;
    if (bpw < 0) bpw = olut;
    if (scr < 0) scr = (fec == FEC_NONE) ? SCR_LRS : SCR_NONE;
    seq = new int[NSEQ];
    genSeq (olut);
    scrvec = 0;
    pr = 0;
    ps = 0;
    di = 0;
    iper = 0;
    flgs = 0;
    flgs=setBit(flgs, 0, (bpw == 0));
    flgs=setBit(flgs, 1, (bpw == 32));
    flgs=setBit(flgs, 2, fsk);
    flgs=setBit(flgs, 3, oqpsk);
    dinc = getBit(flgs, 0) ? 0x5555 : 0;
    princ = (mod == MT_1P4QPSK) ? 2 : (mod == MT_3P4QPSK) ? 6 : 0;
    if (princ != 0) genRotates (nlut);
    if((this.halo.vbpr&1)!=0)System.out.printf ("FCM mod=%d scr=%d fec=%d flgs=%x \n", mod, scr, fec, flgs);
    this.halo.state=1;
    return 0;
  }
  public int process (Stream si, Stream so) {
    boolean gen, byp, fsk, oqp, sos;
    CxFloat cm=CxFloat.stk(), cb=CxFloat.stk();
    int dix;
    int lper;
    int diy;
    int ia, ja;
    gen = getBit(flgs, 0);
    byp = getBit(flgs, 1);
    fsk = getBit(flgs, 2);
    oqp = getBit(flgs, 3);
    while ((gen || si.rok) && so.wok) {
      sos = iper == 0 || iper == nper;
      lper = iper;
      iper = (iper == mper) ? 0 : iper + 1;
      if (sos) {
        scrvec = seq[iseq];
        iseq = (iseq == mseq) ? 0 : iseq + 1;
        if (getBit(scrvec, 15)) {
          di = 0;
        }
        else if (gen) {
          di = din;
        }
        else {
          di = si.rdBits (bpw);
        }
        din = din + (dinc >> 6);
        if (getBit(scrvec, 14)) {
          dinc = dinc + 1;
        }
      }
      dix = (di ^ scrvec) & mlut;
      diy = sos ? (db & 2) | (dix & 1) : (dix & 2) | (db & 1);
      db = oqp ? diy : dix | (lper << 4) | (pr << 4);
      pr = (pr + princ) & 0xF;
      cm.x = xlut[db];
      cm.y = ylut[db];
      cb.x = CI2Fx (di);
      cb.y = CI2Fy (di);
      so.wrCFI (byp ? cb : cm);
    }
    return 0;
  }
  public int close () {
    this.halo.state=0;
    return 0;
  }
}
}
