/**
  Do NOT edit.
  This file is generated by ICEJVCC.
  See FMC.jv for documentation.
*/
#include "Modefs.c"
#include "Modems.c"
#include "Filters.c"

/** Define Signatures */
#define CORE_NAME FMC
#define CORE_AREA nxm_ice_core
#define CORE_FLOW 1
#include "cores/CoreDefs.h"
#define NP 1
#define AW 16
#define BW 32
#define CW 6

enum { FMC_OSEQ = 11 };
enum { FMC_NSEQ = 1 << FMC_OSEQ };
enum { FMC_OLUT = 10 };
enum { FMC_NLUT = 1 << FMC_OLUT };


/** Define CORE Plan Handles */
typedef struct {
  HALO halo;
  int_4 rfp;
  int_4 mod;
  int_4 map;
  int_4 fec;
  int_4 scr;
  real_8 midx;
  real_8 fS;
  real_8 fSym;
  real_8 tOff;
  int_4 frame;
  real_8 ps;
  int_1 bpw;
  int_u1 iper;
  int_u1 nper;
  int_u1 mper;
  int_u1 flgs;
  int_u1 pr;
  int_u1 princ;
  int_u2 mlut;
  real_4* xlut;
  real_4* ylut;
  int_u2 din;
  int_u2 dinc;
  int_u2 scrvec;
  int_u2* seq;
  int_u2 iseq;
  int_u2 mseq;
  int_u4 di;
  int_u2 db;
} FMC;

#include "cores/CoreProtos.h"

/** CORE Code */

void* FMC_alloc (char *config) {
  FMC* plan = FMC_plan();
  if (plan==NULL) return NULL;
  HW_alloc(plan,config);
  return (void*)plan;
}


int_4 FMC_upload (FMC* plan) {
  void *planp=(void*)plan;
  if (HW_isLocal(planp)) return 0;
  HW_push (planp,HW_PREP);
  HW_loadHdr (planp,20);
  HW_loadDbl  (planp,plan->ps);
  HW_loadInt  (planp,plan->bpw);
  HW_loadInt  (planp,plan->iper);
  HW_loadInt  (planp,plan->nper);
  HW_loadInt  (planp,plan->mper);
  HW_loadInt  (planp,plan->flgs);
  HW_loadInt  (planp,plan->pr);
  HW_loadInt  (planp,plan->princ);
  HW_loadInt  (planp,plan->mlut);
  HW_loadBuf  (planp,plan->xlut,'f',1);
  HW_loadBuf  (planp,plan->ylut,'f',1);
  HW_loadInt  (planp,plan->din);
  HW_loadInt  (planp,plan->dinc);
  HW_loadInt  (planp,plan->scrvec);
  HW_loadBuf  (planp,plan->seq,'s',1);
  HW_loadInt  (planp,plan->iseq);
  HW_loadInt  (planp,plan->mseq);
  HW_loadInt  (planp,plan->di);
  HW_loadInt  (planp,plan->db);
  HW_push (planp,HW_OPEN);
  return 20;
}

void FMC_setFrame (FMC* plan, int_4 len) {
  plan->frame = len;
}

int_4 FMC_init (FMC* plan) {
  plan->mod = 0;
  plan->midx = 1.0;
  plan->fS = -1.0;
  plan->tOff = 0;
  plan->bpw = -1;
  plan->nper = 1;
  plan->mper = 0;
  plan->iseq = 0;
  plan->scr = -1;
  plan->map = Modefs_MAP_BRGC;
  plan->frame = 1920;
  return 0;
}

int_4 FMC_set (FMC* plan, String* key, Value* value) {
  if (isMatch (key, "S:SHAPE")) plan->mod = Value_toItem (value, Modefs_modList);
  else if (isMatch (key, "D:MIDX")) plan->midx = Value_toD (value);
  else if (isMatch (key, "S:RFP")) plan->rfp = Value_toItem (value, Modefs_rfpList);
  else if (isMatch (key, "S:MOD")) plan->mod = Value_toItem (value, Modefs_modList);
  else if (isMatch (key, "S:MAP")) plan->map = Value_toItem (value, Modefs_mapList);
  else if (isMatch (key, "S:FEC")) plan->fec = Value_toItem (value, Modefs_fecList);
  else if (isMatch (key, "S:SCR")) plan->scr = Value_toItem (value, Modefs_scrList);
  else if (isMatch (key, "L:FRAME")) plan->frame = Value_toL (value);
  else if (isMatch (key, "L:BPW")) plan->bpw = Value_toL (value);
  else if (isMatch (key, "D:FS")) plan->fS = Value_toD (value);
  else if (isMatch (key, "D:FSYM")) plan->fSym = Value_toD (value);
  else return Core_set (plan, key, value);
  return 0;
}

int_4 FMC_get (FMC* plan, String* key, Value* value) {
  if (isMatch (key, "D:FS")) Value_fromD (value, plan->fS);
  else if (isMatch (key, "D:FSYM")) Value_fromD (value, plan->fSym);
  else return Core_get (plan, key, value);
  return 0;
}

void FMC_genSeq (FMC* plan, int_4 olut) {
  int_4 i = 0, j, bits, seed = 123456, lrs = ~ seed, mask = (1 << olut) - 1;
  plan->mseq = FMC_NSEQ - 3;
  if (plan->rfp == Modefs_RFP_ICE) {
    for (j = 0; j <= (32 - olut); j += olut) {
      bits = (Modefs_frameSync >> j) & mask;
      plan->seq[i++] = 0x8000 | bits;
    }
    plan->seq[i-1] |= 0x4000;
    plan->mseq = plan->frame + i;
    if (plan->mseq > FMC_NSEQ) printf ("Total RFP frame data=%d + sync=%d > max seq=%d\n", plan->frame, i, FMC_NSEQ);
  }
  if (plan->mod == Modefs_MT_CW) {
    plan->scr = 0;
    if (plan->midx > 0) {
      plan->mseq = d2i (plan->nper * plan->fSym / plan->midx / 0x10000);
      if (plan->mseq <= 0) {
        printf ("Unable to perform CW sweep parameters\n", plan->mseq);
        plan->mseq = 1;
      }
      if (plan->mseq > 2048) {
        printf ("Unable to perform CW sweep parameters\n", plan->mseq);
        plan->mseq = 2048;
      }
      plan->seq[i++] = 0x4000;
    }
    else {
      plan->mseq = 16;
      plan->seq[i++] = 0x0000;
    }
  }
  for (; i < plan->mseq; i ++) {
    if (plan->scr != Modefs_SCR_LRS) lrs = 0;
    else for (j = 0; j < 8; j ++) {
      lrs = (lrs << 1) | (0x1 ^ getBits(lrs, 0, 0) ^ getBits(lrs, 1, 1) ^ getBits(lrs, 5, 5) ^ getBits(lrs, 25, 25));
    }
    plan->seq[i] = lrs & 0x3FF;
  }
  plan->mseq --;
}

void FMC_genRotates (FMC* plan, int_4 nn) {
  int_4 i, n, ii = 16;
  real_4 p, ax, ay, bx, by;
  for (i = 0; i < ii; i ++) {
    p = i2f (i) / ii;
    bx = coscf (p);
    by = sincf (p);
    for (n = 0; n < nn; n ++) {
      ax = plan->xlut[n];
      ay = plan->ylut[n];
      plan->xlut[(i<<4)+n] = ax * bx - ay * by;
      plan->ylut[(i<<4)+n] = ax * by + ay * bx;
    }
  }
}

real_8 FMC_getFilterWidth (FMC* plan) {
  real_8 fw = 1;
  if (plan->mod == Modefs_MT_FSK) fw = 2 * plan->midx / plan->nper;
  if (plan->mod == Modefs_MT_4FSK) fw = 4 * plan->midx / plan->nper;
  if (plan->mod == Modefs_MT_OQPSK) fw /= 2;
  return fw;
}

real_8 FMC_getFeedRate (FMC* plan) {
  return plan->fSym * plan->nper;
}

int_4 FMC_getDefaultTaps (FMC* plan) {
  int_1 oqpsk = (plan->mod == Modefs_MT_OQPSK);
  int_1 fsk = (plan->mod == Modefs_MT_FSK) || (plan->mod == Modefs_MT_4FSK);
  return oqpsk ? 7 : fsk ? 21 : (plan->mod >= Modefs_MT_512QAM) ? 11 : 7;
}

int_1 FMC_isGenerator (FMC* plan) {
  return (plan->bpw == 0);
}

int_4 FMC_open (FMC* plan) {
  int_4 i, olut, nlut;
  real_8 ratio;
  int_1 oqpsk = (plan->mod == Modefs_MT_OQPSK);
  int_1 fsk = (plan->mod == Modefs_MT_FSK) || (plan->mod == Modefs_MT_4FSK);
  if (plan->mod == Modefs_MT_FSK) {
    plan->nper = (int_4) (plan->midx * 2);
    plan->mper = 2 * plan->nper - 1;
  }
  if (plan->mod == Modefs_MT_4FSK) {
    plan->nper = (int_4) (plan->midx * 6);
    plan->mper = 2 * plan->nper - 1;
  }
  if (oqpsk) {
    plan->nper = 2;
    plan->mper = 1;
  }
  plan->xlut = zallocBuf(sizeof(real_4)*(FMC_NLUT));
  plan->ylut = zallocBuf(sizeof(real_4)*(FMC_NLUT));
  olut = Modems_getSymbolMap (plan->mod, plan->map, 1.0, plan->midx, plan->nper, plan->xlut, plan->ylut);
  nlut = (1 << olut);
  plan->mlut = nlut - 1;
  if (plan->bpw < 0) plan->bpw = olut;
  if (plan->scr < 0) plan->scr = (plan->fec == Modefs_FEC_NONE) ? Modefs_SCR_LRS : Modefs_SCR_NONE;
  plan->seq = zallocBuf(sizeof(int_u2)*(FMC_NSEQ));
  FMC_genSeq (plan, olut);
  plan->scrvec = 0;
  plan->pr = 0;
  plan->ps = 0;
  plan->di = 0;
  plan->iper = 0;
  plan->flgs = 0;
  plan->flgs=setBit(plan->flgs, 0, (plan->bpw == 0));
  plan->flgs=setBit(plan->flgs, 1, (plan->bpw == 32));
  plan->flgs=setBit(plan->flgs, 2, fsk);
  plan->flgs=setBit(plan->flgs, 3, oqpsk);
  plan->dinc = getBit(plan->flgs, 0) ? 0x5555 : 0;
  plan->princ = (plan->mod == Modefs_MT_1P4QPSK) ? 2 : (plan->mod == Modefs_MT_3P4QPSK) ? 6 : 0;
  if (plan->princ != 0) FMC_genRotates (plan, nlut);
  if(plan->halo.vbpr&1)printf ("FCM mod=%d scr=%d fec=%d flgs=%x \n", plan->mod, plan->scr, plan->fec, plan->flgs);
  FMC_upload (plan);
  return 0;
}

int_4 FMC_process (FMC* plan, Stream* si, Stream* so) {
  int_1 gen, byp, fsk, oqp, sos;
  CxReal_4 cm_,*cm=&cm_, cb_,*cb=&cb_;
  int_u2 dix;
  int_u1 lper;
  int_u1 diy;
  int_u1 ia, ja;
  gen = getBit(plan->flgs, 0);
  byp = getBit(plan->flgs, 1);
  fsk = getBit(plan->flgs, 2);
  oqp = getBit(plan->flgs, 3);
  while ((gen || si->rok) && so->wok) {
    sos = plan->iper == 0 || plan->iper == plan->nper;
    lper = plan->iper;
    plan->iper = (plan->iper == plan->mper) ? 0 : plan->iper + 1;
    if (sos) {
      plan->scrvec = plan->seq[plan->iseq];
      plan->iseq = (plan->iseq == plan->mseq) ? 0 : plan->iseq + 1;
      if (getBit(plan->scrvec, 15)) {
        plan->di = 0;
      }
      else if (gen) {
        plan->di = plan->din;
      }
      else {
        plan->di = Stream_rdBits (si, plan->bpw);
      }
      plan->din = plan->din + (plan->dinc >> 6);
      if (getBit(plan->scrvec, 14)) {
        plan->dinc = plan->dinc + 1;
      }
    }
    dix = (plan->di ^ plan->scrvec) & plan->mlut;
    diy = sos ? (plan->db & 2) | (dix & 1) : (dix & 2) | (plan->db & 1);
    plan->db = oqp ? diy : dix | (lper << 4) | (plan->pr << 4);
    plan->pr = (plan->pr + plan->princ) & 0xF;
    cm->x = plan->xlut[plan->db];
    cm->y = plan->ylut[plan->db];
    cb->x = CI2Fx (plan->di);
    cb->y = CI2Fy (plan->di);
    Stream_wrCFI (so, byp ? cb : cm);
  }
  return 0;
}

int_4 FMC_close (FMC* plan) {
  HW_push(plan,HW_CLOSE);
  return 0;
}

int_4 FMC_poll (FMC* plan) { return 0; }

int_4 FMC_free (FMC* plan) {
  HW_free(plan);
  free(plan);
}

#include "cores/CoreHandles.h"

FMC* FMC_subCore (HALO* halo, int_4 scid) {
  FMC* plan = FMC_plan();
  if (plan==NULL) return NULL;
  Core_copyHaloToSub(halo,&plan->halo,scid);
  FMC_init(plan);
  return plan;
}
#undef CORE_NAME
#undef CORE_AREA
#undef CORE_FLOW
#undef AW
#undef BW
#undef CW
#undef NP
