/**
  Do NOT edit.
  This file is generated by ICEJVCC.
  See DUC.jv for documentation.
*/

import CORE_types::*;
package DUC_types;
import CORE_types::*;
endpackage
import DUC_types::*;

module DUC_core #(PORT=1, IBW=64,OBW=IBW, IFLG=0,OFLG=0, IOCLKS=1, IKR=8,OKR=4, PBW=32,PKR=1) (
  input[2:0] s_clks, input s_rst, input s_cs, input[31:0] s_addr,
                     input s_wr, input[31:0] s_wrbus, input s_rd, output[31:0] s_rdbus, output s_ack,
  input[3:0] io_clk, output[1:0] i_rdy, input i_ena, input[7:0] i_sel, input[IBW-1:0] i_bus,
                     output[1:0] o_rdy, input o_ena, output[7:0] o_sel, output[OBW-1:0] o_bus,
  output [7:0] s_test);
  wire T=1,F=0; wire[7:0] T8=~0,F8=0;
  localparam SBW=32, ARRAY=0, STREAM=1, BUFFER=2, BUFSTR=3, PACKET=4;
  localparam BCIO=0, BCI=1, BCO=2, BCIIO=3, BCIOO=4, BCIIIOO=5;
  localparam FRAW=0, FCXI=1, FBIT=2, FAXI=3, FALL=4, FSWP=5;
  localparam TIGHT=8, BPAR=1024, BDMA=2048, BENA=16384, DBLBUF=32768, NEMPTY=131072, RAHEAD=262144;
  localparam FLOW=STREAM, BUFCFG=BCIO, SELFPACE=0, PIPE=-1, MC=0, CW=6, AW=16, MBW=256, NP=1, BW=32, SIBW=BW, SOBW=BW, BIBW=BW, BOBW=BW, PIBW=PBW, POBW=PBW, IFMT=FRAW, OFMT=FRAW, DBGBW=32, DBGBD=10, P2=FLOW, P3=NP, P4=BW, P5=0, P6=0, P7=0;
  localparam XIBW=SIBW, XOBW=SOBW;
  localparam BWP=BW/8, IBWP=IBW/8, OBWP=OBW/8, XIBWP=XIBW/8, XOBWP=XOBW/8;
  localparam XIBWO=(XIBW>64)? 4 : (XIBW>32)? 3 : (XIBW>16)? 2 : (XIBW>8)? 1 : 0;
  localparam XOBWO=(XOBW>64)? 4 : (XOBW>32)? 3 : (XOBW>16)? 2 : (XOBW>8)? 1 : 0;
  localparam SUB=(PORT>10)? PORT-10:0;

  wire s_clk=s_clks[0],clk=s_clks[0],clk2=s_clks[1]; wire[1:0] clks=s_clks;
  logic rst,s_wrsys,s_wrscid; logic[31:0] s_sys; logic s_csm,s_csd,s_ena; logic[3:0] s_scid; 
  logic c_rd,c_wr,c_wok; logic[15:0] c_adr; logic[31:0] c_wbus,c_rbus; wire c_ok;
  always @(posedge s_clk) begin
    s_csd <= s_cs && s_addr[11:0]==12'hFFC;
    s_csm <= s_cs && !s_csd;
    s_wrsys <= s_cs && s_wr && s_addr[11:0]==0;
    if (s_rst) s_sys <= 0; else if (s_wrsys) s_sys <= s_wrbus;
    rst <= s_rst || s_sys[23];
    if (s_rst) c_wok <= 1; else if (!c_wr) c_wok <= !s_sys[22];
    s_ena <= (SUB==0)? s_sys[0] : s_clks[2];
  end
  wire frst=!s_ena; wire s_opt=s_sys[4]; wire[3:0] s_ifmt=s_sys[11:8], s_ofmt=s_sys[15:12]; wire [1:0] s_vbpr=s_sys[21:20];
  wire i_frst = frst; wire o_frst = frst; wire p_frst = frst;

  wire [31:0] s_sub, s_rdbusm, s_rdbust; wire [63:0] s_val; wire [15:0] s_ind; wire[22:0] s_set;
  wire s_csr=s_csm && !s_sub[24] && !s_addr[0];
  setter #(23,1) s_bank (clk,rst,s_csm&s_wr,s_addr,s_wrbus,s_sub,s_ind,s_set,s_val);
  portstatusblk #(PORT,"DUC",P2,P3,P4,P5,P6,P7) s_sblk (s_clk,s_csr,s_addr,s_wr,s_wrbus,s_rd,s_rdbusm, clk,1'b1,c_adr,c_wok&c_wr,c_wbus,c_rd,c_rbus);
  assign s_rdbus = s_rdbusm;

  wire i_clk=io_clk[0], o_clk=(IOCLKS>1)?io_clk[1]:io_clk[0];
  logic si_ren,so_wen,si_rok_,so_wok_; logic[5:0] si_bits,so_bits; logic[XOBW-1:0] so_wbus; logic[XOBWP-1:0] so_wsel; logic[XIBW-1:0] si_rbus; logic[XIBWP-1:0] si_rsel; logic[7:0] so_swaps;
  wire c_rdy = (SELFPACE!=0) || (si_rok_ && so_wok_); wire si_rok = si_rok_ && c_ok; wire so_wok = so_wok_ && c_ok;
  generate if (SUB&1) begin
    assign si_rbus=i_bus, si_rsel=i_sel, i_rdy=si_ren, si_rok_=i_ena;
  end else begin
    logic i_val; always @(posedge i_clk) i_val <= i_ena;
    fifoNxM #(IBW+IBWP,XIBW+XIBWP,IKR/2,3,IFLG^BPAR,BPAR) f_i (i_clk,i_frst, i_rdy,i_val,{i_sel,i_bus}, s_clk,i_frst, si_rok_,si_ren,{si_rsel,si_rbus});
    if (SUB==2) assign s_ack = si_rok_;
  end endgenerate
  generate if (SUB&2) begin
    assign o_bus=so_wbus, o_sel=so_wsel, o_rdy=so_wen, so_wok_=o_ena;
  end else begin
    fifoNxM #(XOBW+XOBWP,OBW+OBWP,OKR/2,4,BPAR,OFLG^BPAR) f_o (s_clk,o_frst, so_wok_,so_wen,{so_wsel,so_wbus}, o_clk,o_frst, o_rdy,o_ena,{o_sel,o_bus});
    if (SUB==1) assign s_ack = so_wok_;
  end endgenerate

  logic c_start,c_done,c_active; logic[15:0] c_cnt,c_stat;
  always @(posedge clk) begin
    if (frst) c_start <= 0; else c_start <= s_ena && c_rdy && !c_start && !c_active;
    if (frst) c_active <= 0; else c_active <= c_start || (c_active && !c_done);
    if (c_start) c_cnt <= 0; else c_cnt <= c_cnt+1;
  end
  flowcontrol f_c (clk, frst, s_opt, c_cnt, c_ok);

  import CORE_funcs::*;

  localparam NL=86, OTAP=5, RTAP=32, PTAP=16, OFILT=7, NFILT=1<<OFILT, FPS=(NFILT/8)-1, MAXMON=1048575, MAXCR=250000000,
     PF_BYPASS=0, PF_CTXF=1, PF_DEBUG=2;
  localparam CV_halo_sys=0, CV_halo_flag=28, CV_halo_func=64, CV_halo_fmts=68, CV_halo_flow=72, CV_halo_impl=76;
  localparam CV_ps=256,CV_dps=264,CV_p=272,CV_dp=280,CV_fscl=288,CV_lfps=292,CV_ntap=296,CV_nrpt=300,CV_mrpt=304,
    CV_vd=308,CV_rft=312,CV_imon=316,CV_mmon=320,CV_ovsr=324,CV_cper=328,CV_cups=332,CV_ifS=336,CV_flags=340,CV_upds=344;

  dptx ps;
  dptx dps;
  dptx p;
  dptx dp;
  fptx fscl;
  fptx lfps;
  fptx lfps_2; delayp #(2,32) dp_lfps_2(clk,lfps,lfps_2);
  intx ntap;
  intx nrpt;
  intx mrpt;
  uint20 imon;
  uint20 mmon;
  uint3 ovsr;
  uint3 cper;
  uint4 cups;
  int32 ifS;
  uint8 flags;
  uint32 upds;
  logic[4-1:0] vd_stride; logic vd_split; logic vd_load; CxFptx vd_wbus; logic vd_ren[PTAP]; logic[OTAP-1:0] vd_radr[PTAP]; CxFptx vd_rbus[PTAP]; 
  CxTapBuf #( OTAP , 1 , PTAP , 0 ) vd (clks,rst,vd_stride,vd_split,vd_load,vd_wbus,vd_ren,vd_radr,vd_rbus);
  logic rft_renr; fptx rft_rNr; logic[OFILT-1:0] rft_rN; logic[OTAP-1:0] rft_rM[PTAP]; fptx rft_rbus[PTAP]; 
  RomF2Di #( OFILT , OTAP , PTAP ) rft (clks,rst,s_set[14],s_sub,s_val,rft_renr,rft_rNr,rft_rN,rft_rM,rft_rbus);

  /* verilator lint_off UNOPTFLAT */
  Line c_ln[86];  wire c_en[86];  wire c_xn[86];
  /* verilator lint_on UNOPTFLAT */

  setLine #(1,0,0) f_1 (c_ln[1],"startMethod",c_start,F);    // public int process ( StreamI si , StreamO so ) {
  CxFptx_stk sc, fo, cm, cn, cmr, cmrs;                      // CxFptx_stk sc , fo , cm , cn , cmr , cmrs ;
  fptx fps, dfps, fp, ifps;                                  // fptx fps , dfps , fp , ifps ;
  dptx dtmp;                                                 // dptx dtmp ;
  uint32 idat;                                               // uint32 idat ;
  uint6 ia, chn;                                             // uint6 ia , chn ;
  uint6 ia_1; delayp #(1,6) dp_ia_1(clk,ia,ia_1);
  boolean load, mon, cmon, xmon, byp, chx, ctxf;             // boolean load , mon , cmon , xmon , byp , chx , ctxf ;
  setLine #(1,0,1) f_8 (c_ln[8],"StreamI_getC",T,F);         // chn = si.getC ( ) ;
  setLine #(1,0,1) f_9 (c_ln[9],"setVar",T,F);               // byp = flags [ 0 ] && ! flags [ 1 ] ;
  setLine #(1,0,1) f_10 (c_ln[10],"setVar",T,F);             // ctxf = flags [ 1 ] ;
  setLine #(1,1,1) f_11 (c_ln[11],"setVar",T,F);             // chx = ctxf && ( chn > 0 ) ;
  setLine #(1,0,1) f_12 (c_ln[12],"setVar",T,F);             // cmon = ( mmon == MAXMON ) ;
  setLine #(1,0,1) f_13 (c_ln[13],"setVar",T,F);             // mon = ( mmon > 0 ) ;
  setLine #(1,0,1) f_14 (c_ln[14],"StreamO_setC",T,F);       // so.setC ( cups ) ;
  setLine #(1,2,0) f_15 (c_ln[15],"While",si_rok && so_wok && byp,c_xn[18]); // while ( si.rok && so.wok && byp ) {
  setLine #(15,0,3) f_16 (c_ln[16],"StreamI_rdL",T,F);       // idat = si.rdL ( ) ;
  setLine #(15,3,1) f_17 (c_ln[17],"StreamO_wrL",T,F);       // so.wrL ( idat ) ;
  setLine #(15,4,0) f_18 (c_ln[18],"endWhile",c_xn[15],F);   // }
  setLinx #(18,0,0) f_19 (c_ln[19],"While",si_rok && so_wok && ! chx && ! byp,c_xn[52],cper); // while ( si.rok && so.wok && ! chx && ! byp ) {
  setLine #(19,0,1) f_20 (c_ln[20],"setVar",T,F);            // fps = fracf ( d2f ( ps ) ) ;
  setLine #(19,0,1) f_21 (c_ln[21],"setVar",T,F);            // ps = ( mon && imon == 0 ) ? 0 : frac ( ps + dps ) ;
  setLine #(19,0,1) f_22 (c_ln[22],"setVar",T,F);            // imon = ( imon >= mmon ) ? 0 : imon + 1 ;
  setLine #(19,1,1) f_23 (c_ln[23],"setVar",T,F);            // mmon = ( mmon != MAXMON ) ? mmon : ( imon >= MAXMON ) ? 0 : ( imon > 2 && d2dptx ( ps ) < 8 ) ? imon - 2 : mmon ;
  setLine #(19,1,1) f_24 (c_ln[24],"setVar",T,F);            // load = ( fps <= lfps ) ;
  setLine #(19,1,1) f_25 (c_ln[25],"setVar",T,F);            // lfps = fps ;
  setLine #(19,2,0) f_26 (c_ln[26],"If",load,F);             // if ( load ) {
  setLine #(26,0,1) f_27 (c_ln[27],"StreamI_getC",T,F);      // chn = si.getC ( ) ;
  setLine #(26,1,1) f_28 (c_ln[28],"setVar",T,F);            // chx = ctxf && ( chn > 0 ) ;
  setLine #(26,0,3) f_29 (c_ln[29],"StreamI_rdCIF",T,F);     // si.rdCIF ( cm ) ;
  setLine #(26,3,0) f_30 (c_ln[30],"CxTapBuf_load",T,F);     // vd.load ( cm ) ;
  setLine #(26,0,0) f_31 (c_ln[31],"endIf",c_xn[26],F);      // }
  setLine #(19,4,1) f_32 (c_ln[32],"setVar",T,F);            // ifps = lfps ;
  setLine #(19,8,9) f_33 (c_ln[33],"Accum",T,F);             // fo.x = 0 ;
  setLine #(19,8,9) f_34 (c_ln[34],"Accum",T,F);             // fo.y = 0 ;
  setLine #(19,5,0) f_35 (c_ln[35],"GenForP",ia+PTAP < ntap,F); // for ( ia = 0 ; ia < ntap ; ia ++ ) {
  setLine #(35,0,2) f_38 (c_ln[38],"RomF2Di_getrN",T,F);     // ftx = rft.getrN ( ifps , ia ) ;
  setLine #(35,2,1) f_39 (c_ln[39],"setVar",T,F);            // ft = ftx ;
  setLine #(35,1,1) f_40 (c_ln[40],"CxTapBuf_get",T,F);      // vd.get ( ia , fdix ) ;
  setLine #(35,2,1) f_41 (c_ln[41],"setVar",T,F);            // fdi = fdix ;
  setLine #(35,3,1) f_42 (c_ln[42],"setAcc",c_en[33],F);     // fo.x += ft * fdi.x ;
  setLine #(35,3,1) f_43 (c_ln[43],"setAcc",c_en[34],F);     // fo.y += ft * fdi.y ;
  setLine #(35,0,0) f_44 (c_ln[44],"endGenForP",c_xn[35],F); // }
  setLine #(19,17,1) f_45 (c_ln[45],"setVar",T,F);           // cn = fo ;
  setLine #(19,14,1) f_46 (c_ln[46],"setVar",T,F);           // fp = d2f ( p ) ;
  setLine #(19,14,1) f_47 (c_ln[47],"setVar",T,F);           // p = frac ( p + dp ) ;
  setLine #(19,15,3) f_48 (c_ln[48],"doTask",T,F);           // sc = sincoscfx ( fp ) ;
  setLine #(19,18,2) f_49 (c_ln[49],"doTask",T,F);           // cmr = mulccx ( cn , sc ) ;
  setLine #(19,20,1) f_50 (c_ln[50],"setVar",T,F);           // cmrs = mulcf ( cmr , fscl ) ;
  setLine #(19,21,1) f_51 (c_ln[51],"StreamO_wrCFI",T,F);    // so.wrCFI ( cmrs ) ;
  setLine #(19,22,0) f_52 (c_ln[52],"endWhile",c_xn[19],F);  // }
  setLine #(52,0,0) f_53 (c_ln[53],"While",si_rok && chx,c_xn[83]); // while ( si.rok && chx ) {
  setLine #(53,0,1) f_54 (c_ln[54],"StreamI_getC",T,F);      // chn = si.getC ( ) ;
  setLine #(53,0,3) f_55 (c_ln[55],"StreamI_rdL",T,F);       // idat = si.rdL ( ) ;
  setLine #(53,1,1) f_56 (c_ln[56],"setVar",T,F);            // chx = ( chn > 0 ) ;
  setLine #(53,3,0) f_57 (c_ln[57],"print",s_vbpr[1],F);     // dprint ( "Got chn=%d dat=%d at %d\n" , chn , idat , c_cnt ) ;
  setLine #(53,3,0) f_58 (c_ln[58],"If",chn == 3 || chn == 4 || chn == 10,F); // if ( chn == 3 || chn == 4 || chn == 10 ) {
  setLine #(58,0,33) f_59 (c_ln[59],"doTask",T,F);           // dtmp = divii ( idat , ifS ) ;
  setLine #(58,33,0) f_60 (c_ln[60],"If",chn == 3,F);        // if ( chn == 3 ) {
  setLine #(60,0,1) f_61 (c_ln[61],"setVar",T,F);            // dp = dtmp ;
  setLine #(60,0,0) f_62 (c_ln[62],"print",s_vbpr[0],F);     // vprint ( "DUC  Ctx chn=%d IF=%d dp=%x\n" , chn , idat , d2x ( dtmp ) ) ;
  setLine #(60,1,0) f_63 (c_ln[63],"endIf",c_xn[60],F);      // }
  setLine #(63,0,0) f_64 (c_ln[64],"If",chn == 4,F);         // if ( chn == 4 ) {
  setLine #(64,0,1) f_65 (c_ln[65],"setVar",T,F);            // dp = dtmp ;
  setLine #(64,0,0) f_66 (c_ln[66],"print",s_vbpr[0],F);     // vprint ( "DUC  Ctx chn=%d RF=%d dp=%x\n" , chn , idat , d2x ( dtmp ) ) ;
  setLine #(64,1,0) f_67 (c_ln[67],"endIf",c_xn[64],F);      // }
  setLine #(67,0,0) f_68 (c_ln[68],"If",chn == 10,F);        // if ( chn == 10 ) {
  setLine #(68,0,1) f_69 (c_ln[69],"setVar",T,F);            // dps = dptx2d ( d2dptx ( dtmp ) + 1 ) ;
  setLine #(68,0,1) f_70 (c_ln[70],"setVar",T,F);            // mmon = MAXMON ;
  setLine #(68,0,1) f_71 (c_ln[71],"setVar",T,F);            // imon = 0 ;
  setLine #(68,0,0) f_72 (c_ln[72],"print",s_vbpr[0],F);     // vprint ( "DUC  Ctx chn=%d SR=%d dp=%x\n" , chn , idat , d2x ( dtmp ) ) ;
  setLine #(68,1,0) f_73 (c_ln[73],"endIf",c_xn[68],F);      // }
  setLine #(73,0,0) f_74 (c_ln[74],"endIf",c_xn[58],F);      // }
  setLine #(74,0,0) f_75 (c_ln[75],"If",chn == 8,F);         // if ( chn == 8 ) {
  setLine #(75,0,0) f_76 (c_ln[76],"print",s_vbpr[0],F);     // vprint ( "DUC  Ctx chn=%d GAIN=%d fscl=%x\n" , chn , idat , f2x ( fscl ) ) ;
  setLine #(75,0,0) f_77 (c_ln[77],"endIf",c_xn[75],F);      // }
  setLine #(77,0,1) f_78 (c_ln[78],"setVar",T,F);            // upds [ 15 : 0 ] = upds [ 15 : 0 ] + 1 ;
  setLine #(77,1,0) f_79 (c_ln[79],"If",chn > 2,F);          // if ( chn > 2 ) {
  setLine #(79,0,1) f_80 (c_ln[80],"setVar",T,F);            // upds [ 31 : 16 ] = chn ;
  setLine #(79,1,0) f_81 (c_ln[81],"endIf",c_xn[79],F);      // }
  setLine #(81,0,0) f_82 (c_ln[82],"Ram_wr",CV_upds,F);      // this.upds = upds ;
  setLine #(81,0,0) f_83 (c_ln[83],"endWhile",c_xn[53],F);   // }
  setLine #(83,0,0) f_84 (c_ln[84],"return",c_stat,F);       // return 0 ;
  setLine #(84,0,0) f_85 (c_ln[85],"endMethod",T,F);         // }
  sincoscfx_task fn48 (clks,rst,c_en[48],c_xn[48], fp,sc);
  mulccx_task fn49 (clks,rst,c_en[49],c_xn[49], cn,sc,cmr);
  divii_task fn59 (clks,rst,c_en[59],c_xn[59], idat,ifS,dtmp);

  assign vd_load = c_en[30], vd_wbus = cm;
  always @(posedge clk) begin
    c_wr <= F; c_rd <= F; c_done <= F;
    if (MC==0) begin so_wen <= F; si_ren <= F; end
    if (s_set[1]) ps <= lswap(s_val);
    if (s_set[3]) dps <= lswap(s_val);
    if (s_set[5]) p <= lswap(s_val);
    if (s_set[7]) dp <= lswap(s_val);
    if (s_set[8]) fscl <= s_val;
    if (s_set[9]) lfps <= s_val;
    if (s_set[10]) ntap <= s_val;
    if (s_set[11]) nrpt <= s_val;
    if (s_set[12]) mrpt <= s_val;
    if (s_set[15]) imon <= s_val;
    if (s_set[16]) mmon <= s_val;
    if (s_set[17]) ovsr <= s_val;
    if (s_set[18]) cper <= s_val;
    if (s_set[19]) cups <= s_val;
    if (s_set[20]) ifS <= s_val;
    if (s_set[21]) flags <= s_val;
    if (s_set[22]) upds <= s_val;
    if (c_xn[8]) begin chn <= si_rsel; end
    if (c_xn[9]) begin byp <= flags[0] && ! flags[1]; end
    if (c_xn[10]) begin ctxf <= flags[1]; end
    if (c_xn[11]) begin chx <= ctxf && (chn > 0); end
    if (c_xn[12]) begin cmon <= (mmon == MAXMON); end
    if (c_xn[13]) begin mon <= (mmon > 0); end
    if (c_xn[14]) begin so_wsel <= cups; end
    if (c_en[16]) begin si_ren <= T; end 
    if (c_xn[16]) begin idat <= si_rbus; end
    if (c_xn[17]) begin so_wen <= T; so_wbus <= idat; end
    if (c_xn[20]) begin fps <= fracf (d2f (ps)); end
    if (c_xn[21]) begin ps <= (mon && imon == 0) ? 0 : frac (ps + dps); end
    if (c_xn[22]) begin imon <= (imon >= mmon) ? 0 : imon + 1; end
    if (c_xn[23]) begin mmon <= (mmon != MAXMON) ? mmon : (imon >= MAXMON) ? 0 : (imon > 2 && d2dptx (ps) < 8) ? imon - 2 : mmon; end
    if (c_xn[24]) begin load <= (fps <= lfps); end
    if (c_xn[25]) begin lfps <= fps; end
    if (c_xn[27]) begin chn <= si_rsel; end
    if (c_xn[28]) begin chx <= ctxf && (chn > 0); end
    if (c_en[29]) begin si_ren <= T; end 
    if (c_xn[29]) begin cm <= CI2CF (si_rbus); end
    if (c_xn[32]) begin ifps <= lfps_2; end
    if (c_xn[35] || rst) begin ia <= 0; end else if (c_en[35]) begin ia <= ia + PTAP; end
    if (c_xn[45]) begin cn <= fo; end
    if (c_xn[46]) begin fp <= d2f (p); end
    if (c_xn[47]) begin p <= frac (p + dp); end
    if (c_xn[48]) begin /* sc <= sincoscfx (fp); */ end
    if (c_xn[49]) begin /* cmr <= mulccx (cn, sc); */ end
    if (c_xn[50]) begin cmrs <= mulcf (cmr, fscl); end
    if (c_xn[51]) begin so_wen <= T; so_wbus <= CF2CI (cmrs); end
    if (c_xn[54]) begin chn <= si_rsel; end
    if (c_en[55]) begin si_ren <= T; end 
    if (c_xn[55]) begin idat <= si_rbus; end
    if (c_xn[56]) begin chx <= (chn > 0); end
    if (c_xn[57]) begin $write ("Got chn=%d dat=%d at %d\n", chn, idat, c_cnt); end
    if (c_xn[59]) begin /* dtmp <= divii (idat, ifS); */ end
    if (c_xn[61]) begin dp <= dtmp; end
    if (c_xn[62]) begin $write ("DUC  Ctx chn=%d IF=%d dp=%x\n", chn, idat, d2x (dtmp)); end
    if (c_xn[65]) begin dp <= dtmp; end
    if (c_xn[66]) begin $write ("DUC  Ctx chn=%d RF=%d dp=%x\n", chn, idat, d2x (dtmp)); end
    if (c_xn[69]) begin dps <= dptx2d (d2dptx (dtmp) + 1); end
    if (c_xn[70]) begin mmon <= MAXMON; end
    if (c_xn[71]) begin imon <= 0; end
    if (c_xn[72]) begin $write ("DUC  Ctx chn=%d SR=%d dp=%x\n", chn, idat, d2x (dtmp)); end
    if (c_xn[76]) begin $write ("DUC  Ctx chn=%d GAIN=%d fscl=%x\n", chn, idat, f2x (fscl)); end
    if (c_xn[78]) begin upds[15:0] <= upds[15:0] + 1; end
    if (c_xn[80]) begin upds[31:16] <= chn; end
    if (c_xn[82]) begin c_wr <= T; c_adr <= CV_upds; c_wbus <= upds; end
    if (c_xn[84]) begin c_stat <= 0; c_done <= T; end
  end

  /* verilator lint_off SELRANGE */
  generate
  genvar I1,I2,I3,I4;
  fptx fo_x_a[PTAP]; sumf # (PTAP, 4) fn33 (clk, rst, c_en[42], c_xn[42], fo_x_a, fo.x);
  fptx fo_y_a[PTAP]; sumf # (PTAP, 4) fn34 (clk, rst, c_en[43], c_xn[43], fo_y_a, fo.y);
  for (I1 = 0; I1 < PTAP; I1 = I1 + 1) begin : b35
    fptx ft, ftx;
    CxFptx_stk fdi, fdix;
    assign rft_renr = c_en[38], rft_rNr = ifps, rft_rM[I1] = I1 + ia, ftx = rft_rbus[I1];
    always @(posedge clk) if (c_xn[39]) begin ft <= ftx; end
    assign vd_stride = 1, vd_ren[I1] = c_en[40], vd_radr[I1] = I1 + ia_1;
    always @(posedge clk) if (c_xn[40]) begin fdix <= vd_rbus[I1]; end
    always @(posedge clk) if (c_xn[41]) begin fdi <= fdix; end
    always @(posedge clk) if (c_xn[42]) begin fo_x_a[I1] <= mulff (ft, fdi.x); end
    always @(posedge clk) if (c_xn[43]) begin fo_y_a[I1] <= mulff (ft, fdi.y); end
  end
  endgenerate
  /* verilator lint_on SELRANGE */

  /* verilator lint_off WIDTHCONCAT */
  localparam int SEQ_PARAMS[86*4] = '{ 0,0,0,0, 11,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0, 10,1,0,0, 21,1,0,0, 21,1,0,0, 21,1,1,0, 21,1,0,0, 21,1,0,0, 10,1,0,0, 41,1,2,1, 10,15,0,2, 10,15,3,0, 42,15,4,0, 41,18,0,2, 21,19,0,0, 21,19,0,0, 21,19,0,0, 21,19,1,0, 21,19,1,0, 21,19,1,0, 31,19,2,0, 10,26,0,0, 21,26,1,0, 10,26,0,2, 10,26,3,0, 32,26,0,0, 21,19,4,0, 10,19,8,8, 10,19,8,8, 62,19,5,0, 0,0,0,0, 0,0,0,0, 10,35,0,1, 21,35,2,0, 10,35,1,0, 21,35,2,0, 23,35,3,0, 23,35,3,0, 10,35,0,0, 21,19,17,0, 21,19,14,0, 21,19,14,0, 10,19,15,2, 10,19,18,1, 21,19,20,0, 10,19,21,0, 42,19,22,0, 41,52,0,0, 10,53,0,0, 10,53,0,2, 21,53,1,0, 24,53,3,0, 31,53,3,0, 10,58,0,32, 31,58,33,0, 21,60,0,0, 24,60,0,0, 32,60,1,0, 31,63,0,0, 21,64,0,0, 24,64,0,0, 32,64,1,0, 31,67,0,0, 21,68,0,0, 21,68,0,0, 21,68,0,0, 24,68,0,0, 32,68,1,0, 32,73,0,0, 31,74,0,0, 24,75,0,0, 32,75,0,0, 21,77,0,0, 31,77,1,0, 21,79,0,0, 32,79,1,0, 10,81,0,0, 42,81,0,0, 14,83,0,0, 15,84,0,0};
  sequencer #(86,SEQ_PARAMS) c_seq (clks,rst, c_ln, c_en,c_xn);
  /* verilator lint_on WIDTHCONCAT */
  assign s_test = {c_cnt[0],c_done,c_active,c_start,o_ena,i_ena,o_frst,i_frst};
endmodule

