/**
  Do NOT edit.
  This file is generated by ICEJVCC.
  See DUC.jv for documentation.
*/
#include "Filters.c"

/** Define Signatures */
#define CORE_NAME DUC
#define CORE_AREA nxm_ice_core
#define CORE_FLOW 1
#include "cores/CoreDefs.h"
#define NP 1
#define AW 16
#define BW 32
#define CW 6

enum { DUC_OTAP = 5 };
enum { DUC_RTAP = 32 };
enum { DUC_PTAP = 16 };
enum { DUC_OFILT = 7 };
enum { DUC_NFILT = 1 << DUC_OFILT };
enum { DUC_FPS = ( DUC_NFILT / 8 ) - 1 };
enum { DUC_MAXMON = 0xFFFFF };
enum { DUC_MAXCR = 250000000 };
static char* DUC_flgList = "Bypass,CTXF,Debug";
enum { DUC_PF_BYPASS = 0 };
enum { DUC_PF_CTXF = 1 };
enum { DUC_PF_DEBUG = 2 };


/** Define CORE Plan Handles */
typedef struct {
  HALO halo;
  real_8 fS;
  real_8 fSi;
  real_8 tOff;
  real_8 fbwf;
  real_8 fbwn;
  real_8 fC;
  int_4 ups;
  int_4 bups;
  int_1 mute;
  int_1 isFPGA;
  real_8 ps;
  real_8 dps;
  real_8 p;
  real_8 dp;
  real_4 fscl;
  real_4 lfps;
  int_2 ntap;
  int_2 nrpt;
  int_2 mrpt;
  CxTapBuf* vd;
  RomF2Di* rft;
  int_u4 imon;
  int_u4 mmon;
  int_u1 ovsr;
  int_u1 cper;
  int_u1 cups;
  int_4 ifS;
  int_u1 flags;
  int_u4 upds;
} DUC;

#include "cores/CoreProtos.h"

/** CORE Code */

void* DUC_alloc (char *config) {
  DUC* plan = DUC_plan();
  if (plan==NULL) return NULL;
  HW_alloc(plan,config);
  return (void*)plan;
}


int_4 DUC_upload (DUC* plan) {
  void *planp=(void*)plan;
  if (HW_isLocal(planp)) return 0;
  HW_push (planp,HW_PREP);
  HW_loadHdr (planp,23);
  HW_loadDbl  (planp,plan->ps);
  HW_loadDbl  (planp,plan->dps);
  HW_loadDbl  (planp,plan->p);
  HW_loadDbl  (planp,plan->dp);
  HW_loadFlt  (planp,plan->fscl);
  HW_loadFlt  (planp,plan->lfps);
  HW_loadInt  (planp,plan->ntap);
  HW_loadInt  (planp,plan->nrpt);
  HW_loadInt  (planp,plan->mrpt);
  HW_loadInt  (planp,0);
  HW_loadObj  (planp,RomF2Di_upload(plan->rft));
  HW_loadInt  (planp,plan->imon);
  HW_loadInt  (planp,plan->mmon);
  HW_loadInt  (planp,plan->ovsr);
  HW_loadInt  (planp,plan->cper);
  HW_loadInt  (planp,plan->cups);
  HW_loadInt  (planp,plan->ifS);
  HW_loadInt  (planp,plan->flags);
  HW_loadInt  (planp,plan->upds);
  HW_push (planp,HW_OPEN);
  return 23;
}

int_4 DUC_findMoN (DUC* plan, real_8 dphase) {
  int_4 i;
  real_8 phase, err;
  if (dphase < 0.0001) return 0;
  for (i = 2; i < 0x80000; i ++) {
    phase = dphase * i;
    err = fabs (phase - round (phase));
    if (err < 1.0e-12) return i;
  }
  return 0;
}

void DUC_setDPS (DUC* plan) {
  real_8 err, odps = plan->dps, freq = plan->dps * plan->fS / plan->ovsr;
  if(plan->halo.vbpr&2)printf ("DUC fs=%f mon=%d\n", plan->fS, DUC_findMoN (plan, odps));
  plan->mmon = 0;
  plan->dps = dptx2d (d2dptx (plan->dps));
  plan->fSi = plan->dps * plan->fS / plan->ovsr;
  if (plan->fSi != freq) {
    plan->mmon = DUC_findMoN (plan, odps);
    if (plan->mmon > 1) {
      err = frac (plan->dps * plan->mmon);
      if (err > 0.5) {
        plan->dps = dptx2d (d2dptx (plan->dps) + 0x4);
        err = frac (plan->dps * plan->mmon);
        plan->fSi = plan->dps * plan->fS / plan->ovsr;
      }
      if (err > 1.0e-3 && plan->fSi != freq) printf ("DUC fS=%18.9f fSi=%18.9f fActual=%18.9f MoN=%d perr=%8.6f\n", plan->fS, freq, plan->fSi, plan->mmon, err);
      plan->fSi = odps * plan->fS / plan->ovsr;
    }
    else {
      printf ("DUC fS=%18.9f fSi=%18.9f fActual=%18.9f\n", plan->fS, freq, plan->fSi);
    }
  }
  plan->mmon = (plan->mmon == 0) ? 0 : plan->mmon - 1;
  if (HW_needsPut(plan)) { HW_push(plan,HW_PREP);  HW_loadAddr(plan,2);HW_loadDbl(plan,plan->dps); HW_loadAddr(plan,16);HW_loadInt4(plan,plan->mmon);  HW_push(plan,HW_UPD); }
}

void DUC_setRate (DUC* plan, real_8 sr) {
  if (sr > 2 * DUC_MAXCR) {
    printf ("Desired sample rate = %f limited to max supported rate of %d\n", sr, DUC_MAXCR * 2);
    sr = DUC_MAXCR * 2;
  }
  plan->ups = (sr > DUC_MAXCR) ? 2 : 1;
  plan->fS = sr / plan->ups;
}

void DUC_setRateIn (DUC* plan, real_8 sr) {
  plan->fSi = sr;
}

void DUC_setCUPS (DUC* plan, int_4 c) {
  plan->cups = (c >= 0) ? c : plan->mute ? 0 : plan->bups + 2;
  if (HW_needsPut(plan)) { HW_push(plan,HW_PREP);  HW_loadAddr(plan,19);HW_loadInt1(plan,plan->cups);  HW_push(plan,HW_UPD); }
}

void DUC_setMute (DUC* plan, int_4 m) {
  plan->mute = (m != 0);
  DUC_setCUPS (plan, -1);
}

void DUC_setFcny (DUC* plan, real_8 f) {
  plan->bups = 0;
  plan->dp = f;
  if (plan->ups == 2) {
    if (f <- 0.125) {
      plan->bups = -1;
      plan->dp = (f + 0.25) * plan->ups;
    }
    else if (f < 0.125) {
      plan->bups = 0;
      plan->dp = (f - 0.00) * plan->ups;
    }
    else {
      plan->bups = 1;
      plan->dp = (f - 0.25) * plan->ups;
    }
  }
  if (f <- 0.5 || f > 0.5) plan->bups = 0;
  if (plan->isFPGA) plan->dp = dptx2d (d2dptx (plan->dp));
  plan->cups = plan->mute ? 0 : plan->bups + 2;
  plan->fC = (plan->dp / plan->ups + (plan->bups * 0.25)) * plan->fS * plan->ups;
  if (HW_needsPut(plan)) { HW_push(plan,HW_PREP);  HW_loadAddr(plan,6);HW_loadDbl(plan,plan->dp); HW_loadAddr(plan,19);HW_loadInt1(plan,plan->cups);  HW_push(plan,HW_UPD); }
}

void DUC_setFreq (DUC* plan, real_8 f) {
  DUC_setFcny (plan, f / (plan->fS * plan->ups));
}

void DUC_setGain (DUC* plan, real_8 gain) {
  plan->fscl = d2f (pow (2.0, gain / 6.0) * plan->fbwf / DUC_FPS);
  if (HW_needsPut(plan)) { HW_push(plan,HW_PREP);  HW_loadAddr(plan,8);HW_loadFlt(plan,plan->fscl);  HW_push(plan,HW_UPD); }
}

void DUC_setCTXF (DUC* plan, int_1 x) {
  plan->flags=setBit(plan->flags, DUC_PF_CTXF, x);
}

void DUC_setFilterWidth (DUC* plan, real_8 f) {
  plan->fbwn = f;
}

void DUC_setFeedRate (DUC* plan, real_8 f) {
  plan->fSi = f;
}

void DUC_genFilt (DUC* plan) {
  int_4 i, j, k, nt = plan->nrpt * plan->ntap;
  real_8 fw = plan->fbwn * plan->fbwf;
  real_4 scl = d2f (plan->nrpt * DUC_FPS / fw);
  real_4* ctap = zallocBuf(sizeof(real_4)*(nt * 2));
  Filters_genFirKais (1, fw / plan->nrpt, 0.0, 0.05 / plan->nrpt, 90.0, ctap, nt);
  for (i = j = 0; j < plan->ntap; j ++) for (k = 0; k < plan->nrpt; k ++, i += 2) RomF2Di_set (plan->rft, k, j, ctap[i] * scl);
}

int_4 DUC_init (DUC* plan) {
  plan->ups = 1;
  plan->fbwf = 1.0;
  plan->fbwn = 1.0;
  plan->fS = -1.0;
  plan->dp = 0;
  plan->dps = 0.25;
  plan->tOff = 0;
  plan->fscl = -1;
  plan->ntap = -1;
  plan->ovsr = NP;
  plan->fSi = -1;
  plan->isFPGA = (plan->halo.impl >= CORE_TYPE_FPGA);
  return 0;
}

int_4 DUC_set (DUC* plan, String* key, Value* value) {
  if (isMatch (key, "D:FS")) DUC_setRate (plan, Value_toD (value));
  else if (isMatch (key, "D:FSO")) DUC_setRate (plan, Value_toD (value));
  else if (isMatch (key, "D:FREQ")) DUC_setFreq (plan, Value_toD (value));
  else if (isMatch (key, "D:COFF")) DUC_setFreq (plan, Value_toD (value));
  else if (isMatch (key, "D:FCNY")) DUC_setFcny (plan, Value_toD (value));
  else if (isMatch (key, "D:FSI")) DUC_setRateIn (plan, Value_toD (value));
  else if (isMatch (key, "D:FSYM")) DUC_setRateIn (plan, Value_toD (value));
  else if (isMatch (key, "D:BAUD")) DUC_setRateIn (plan, Value_toD (value));
  else if (isMatch (key, "D:FBWF")) plan->fbwf = Value_toD (value);
  else if (isMatch (key, "D:TOFF")) plan->tOff = Value_toD (value);
  else if (isMatch (key, "L:NTAP")) plan->ntap = Value_toL (value);
  else if (isMatch (key, "D:GAIN")) DUC_setGain (plan, Value_toD (value));
  else if (isMatch (key, "L:GAIN")) DUC_setGain (plan, Value_toD (value));
  else if (isMatch (key, "L:CUPS")) DUC_setCUPS (plan, Value_toL (value));
  else if (isMatch (key, "L:MUTE")) DUC_setMute (plan, Value_toL (value));
  else return Core_set (plan, key, value);
  return 0;
}

int_4 DUC_get (DUC* plan, String* key, Value* value) {
  if (isMatch (key, "D:FS")) Value_fromD (value, plan->fS);
  else if (isMatch (key, "D:FSO")) Value_fromD (value, plan->fS);
  else if (isMatch (key, "D:FSI")) Value_fromD (value, plan->fSi);
  else if (isMatch (key, "D:FSYM")) Value_fromD (value, plan->fSi);
  else if (isMatch (key, "D:FREQ")) Value_fromD (value, plan->dp * plan->fS);
  else if (isMatch (key, "D:XDO")) Value_fromD (value, 1 / plan->fS);
  else return Core_get (plan, key, value);
  return 0;
}

int_4 DUC_open (DUC* plan) {
  int_4 i, mtap;
  if (plan->fSi < 0) plan->fSi = 1e6;
  if (plan->fS < 0) plan->fS = plan->fSi;
  plan->dps = plan->fSi * plan->ovsr / plan->fS;
  DUC_setDPS (plan);
  plan->cper = imax (1, imin (2, d2i (DUC_MAXCR / plan->fS)));
  if (plan->ntap <= 0) plan->ntap = imin (DUC_RTAP, DUC_PTAP * plan->cper);
  if (plan->ntap > DUC_RTAP) {
    printf ("Warn ntap=%d limited to ntap=%d for this compile\n", plan->ntap, DUC_RTAP);
    plan->ntap = DUC_RTAP;
  }
  plan->cper = (plan->ntap + DUC_PTAP - 1) / DUC_PTAP;
  if (plan->fS > DUC_MAXCR * NP / plan->cper) printf ("Number taps=%d at fS=%f too large for FPGA load NP=%d PTAP=%d RTAP=%d\n", plan->ntap, plan->fS, NP, DUC_PTAP, DUC_RTAP);
  mtap = DUC_PTAP * plan->cper;
  if (NP > 1 && plan->ntap == mtap) {
    plan->ntap --;
    printf ("Trim taps from %d to %d for parallel algorithm\n", mtap, plan->ntap);
  }
  if (plan->fscl < 0) DUC_setGain (plan, -3.0);
  plan->nrpt = DUC_NFILT;
  plan->mrpt = plan->nrpt - 1;
  plan->vd = CxTapBuf_new (DUC_OTAP, 1, DUC_PTAP, 0);
  CxTapBuf_setLength (plan->vd, plan->ntap);
  plan->rft = RomF2Di_new (DUC_OFILT, DUC_OTAP, DUC_PTAP);
  DUC_genFilt (plan);
  plan->lfps = 1;
  plan->ps = 0;
  plan->p = 0;
  plan->imon = 1;
  plan->ifS = d2i (plan->fS);
  plan->flags=setBit(plan->flags, DUC_PF_BYPASS, (plan->dps == 1.0));
  if(plan->halo.vbpr&1)printf ("DUC fSi=%f fS=%f fbwn=%f fbwf=%f fscl=%f mmon=%d ntap=%d cper=%d ups=%d flags=%x NP=%d\n", plan->fSi, plan->fS, plan->fbwn, plan->fbwf, plan->fscl, plan->mmon, plan->ntap, plan->cper, plan->ups, plan->flags, NP);
  DUC_upload (plan);
  return 0;
}

int_4 DUC_process (DUC* plan, Stream* si, Stream* so) {
  CxReal_4 sc_,*sc=&sc_, fo_,*fo=&fo_, cm_,*cm=&cm_, cn_,*cn=&cn_, cmr_,*cmr=&cmr_, cmrs_,*cmrs=&cmrs_;
  real_4 fps, dfps, fp, ifps;
  real_8 dtmp;
  int_u4 idat;
  int_u1 ia, chn;
  int_1 load, mon, cmon, xmon, byp, chx, ctxf;
  chn = Stream_getC (si);
  byp = getBit(plan->flags, 0) && ! getBit(plan->flags, 1);
  ctxf = getBit(plan->flags, 1);
  chx = ctxf && (chn > 0);
  cmon = (plan->mmon == DUC_MAXMON);
  mon = (plan->mmon > 0);
  Stream_setC (so, plan->cups);
  while (si->rok && so->wok && byp) {
    idat = Stream_rdL (si);
    Stream_wrL (so, idat);
  }
  while (si->rok && so->wok && ! chx && ! byp) {
    fps = fracf (d2f (plan->ps));
    plan->ps = (mon && plan->imon == 0) ? 0 : frac (plan->ps + plan->dps);
    plan->imon = (plan->imon >= plan->mmon) ? 0 : plan->imon + 1;
    plan->mmon = (plan->mmon != DUC_MAXMON) ? plan->mmon : (plan->imon >= DUC_MAXMON) ? 0 : (plan->imon > 2 && d2dptx (plan->ps) < 8) ? plan->imon - 2 : plan->mmon;
    load = (fps <= plan->lfps);
    plan->lfps = fps;
    if (load) {
      chn = Stream_getC (si);
      chx = ctxf && (chn > 0);
      Stream_rdCIF (si, cm);
      CxTapBuf_load (plan->vd, cm);
    }
    ifps = plan->lfps;
    fo->x = 0;
    fo->y = 0;
    for (ia = 0; ia < plan->ntap; ia ++) {
      real_4 ft, ftx;
      CxReal_4 fdi_,*fdi=&fdi_, fdix_,*fdix=&fdix_;
      ftx = RomF2Di_getrN (plan->rft, ifps, ia);
      ft = ftx;
      CxTapBuf_get (plan->vd, ia, fdix);
      fdi = fdix;
      fo->x += ft * fdi->x;
      fo->y += ft * fdi->y;
    }
    cn = fo;
    fp = d2f (plan->p);
    plan->p = frac (plan->p + plan->dp);
    sincoscf (fp, sc);
    mulcc (cn, sc, cmr);
    mulcf (cmr, plan->fscl, cmrs);
    Stream_wrCFI (so, cmrs);
  }
  while (si->rok && chx) {
    chn = Stream_getC (si);
    idat = Stream_rdL (si);
    chx = (chn > 0);
    if(plan->halo.vbpr&2)printf ("Got chn=%d dat=%d at %d\n", chn, idat, 0);
    if (chn == 3 || chn == 4 || chn == 10) {
      dtmp = divii (idat, plan->ifS);
      if (chn == 3) {
        plan->dp = dtmp;
        if(plan->halo.vbpr&1)printf ("DUC  Ctx chn=%d IF=%d dp=%x\n", chn, idat, d2x (dtmp));
      }
      if (chn == 4) {
        plan->dp = dtmp;
        if(plan->halo.vbpr&1)printf ("DUC  Ctx chn=%d RF=%d dp=%x\n", chn, idat, d2x (dtmp));
      }
      if (chn == 10) {
        plan->dps = dptx2d (d2dptx (dtmp) + 1);
        plan->mmon = DUC_MAXMON;
        plan->imon = 0;
        if(plan->halo.vbpr&1)printf ("DUC  Ctx chn=%d SR=%d dp=%x\n", chn, idat, d2x (dtmp));
      }
    }
    if (chn == 8) {
      if(plan->halo.vbpr&1)printf ("DUC  Ctx chn=%d GAIN=%d fscl=%x\n", chn, idat, f2x (plan->fscl));
    }
    plan->upds=setBits(plan->upds, 15, 0, getBits(plan->upds, 15, 0) + 1);
    if (chn > 2) {
      plan->upds=setBits(plan->upds, 31, 16, chn);
    }
    plan->upds = plan->upds;
  }
  return 0;
}

int_4 DUC_close (DUC* plan) {
  HW_push(plan,HW_CLOSE);
  return 0;
}

int_4 DUC_poll (DUC* plan) {
  if (HW_needsPut(plan)) { HW_push(plan,HW_PREP);  HW_unloadInt4(plan,22,&plan->upds);  HW_push(plan,HW_UPD); }
  if(plan->halo.vbpr&1)printf ("DUC upds=%08x\n", plan->upds);
  return 1;
}

int_4 DUC_free (DUC* plan) {
  HW_free(plan);
  free(plan);
}

#include "cores/CoreHandles.h"

DUC* DUC_subCore (HALO* halo, int_4 scid) {
  DUC* plan = DUC_plan();
  if (plan==NULL) return NULL;
  Core_copyHaloToSub(halo,&plan->halo,scid);
  DUC_init(plan);
  return plan;
}
#undef CORE_NAME
#undef CORE_AREA
#undef CORE_FLOW
#undef AW
#undef BW
#undef CW
#undef NP
