/**
  Do NOT edit.
  This file is generated by ICEJVCC.
  See DDC.jv for documentation.
*/
#include "Filters.c"

/** Define Signatures */
#define CORE_NAME DDC
#define CORE_AREA nxm_ice_core
#define CORE_FLOW 1
#include "cores/CoreDefs.h"
#define NP 1
#define AW 16
#define BW NP*32
#define CW 6

enum { DDC_OCIC = 5 };
enum { DDC_ODEC = 10 };
enum { DDC_OTAP = 8 };
enum { DDC_RTAP = 256 };
enum { DDC_PTAP = 8 };
enum { DDC_OAGC = 12 };
enum { DDC_FPS = ( DDC_RTAP / 8 ) - 1 };
enum { DDC_MAXCR = 250000000 };


/** Define CORE Plan Handles */
typedef struct {
  HALO halo;
  real_8 fs;
  real_8 fbwf;
  real_8 dbwf;
  real_4 alpha;
  int_4 gain;
  real_8 p;
  real_8 dp;
  real_4 fscl;
  int_2 ntap;
  int_2 cdec;
  int_2 ndec;
  int_2 ups;
  int_2 mdec;
  int_2 idec;
  int_1 oagc;
  int_2 pass;
  int_2 maxpass;
  int_2 count;
  int_2 maxcount;
  real_4 blkSum;
  real_4 AMDes;
  int_1 cntovr;
  Filters_CxCIC* cic;
  CxTapBuf* vd;
  RomF* rft;
} DDC;

#include "cores/CoreProtos.h"

/** CORE Code */

void* DDC_alloc (char *config) {
  DDC* plan = DDC_plan();
  if (plan==NULL) return NULL;
  HW_alloc(plan,config);
  return (void*)plan;
}


int_4 DDC_upload (DDC* plan) {
  void *planp=(void*)plan;
  if (HW_isLocal(planp)) return 0;
  HW_push (planp,HW_PREP);
  HW_loadHdr (planp,22);
  HW_loadDbl  (planp,plan->p);
  HW_loadDbl  (planp,plan->dp);
  HW_loadFlt  (planp,plan->fscl);
  HW_loadInt  (planp,plan->ntap);
  HW_loadInt  (planp,plan->cdec);
  HW_loadInt  (planp,plan->ndec);
  HW_loadInt  (planp,plan->ups);
  HW_loadInt  (planp,plan->mdec);
  HW_loadInt  (planp,plan->idec);
  HW_loadInt  (planp,plan->oagc);
  HW_loadInt  (planp,plan->pass);
  HW_loadInt  (planp,plan->maxpass);
  HW_loadInt  (planp,plan->count);
  HW_loadInt  (planp,plan->maxcount);
  HW_loadFlt  (planp,plan->blkSum);
  HW_loadFlt  (planp,plan->AMDes);
  HW_loadInt  (planp,plan->cntovr);
  HW_loadObj  (planp,Filters_CxCIC_upload(plan->cic));
  HW_loadInt  (planp,0);
  HW_loadObj  (planp,RomF_upload(plan->rft));
  HW_push (planp,HW_OPEN);
  return 22;
}

void DDC_setFreq (DDC* plan, real_8 freq) {
  plan->dp = - freq / plan->fs;
  if (HW_needsPut(plan)) { HW_push(plan,HW_PREP);  HW_loadAddr(plan,2);HW_loadDbl(plan,plan->dp);  HW_push(plan,HW_UPD); }
}

void DDC_setFcny (DDC* plan, real_8 fcny) {
  plan->dp = - fcny;
  if (HW_needsPut(plan)) { HW_push(plan,HW_PREP);  HW_loadAddr(plan,2);HW_loadDbl(plan,plan->dp);  HW_push(plan,HW_UPD); }
}

void DDC_setBW (DDC* plan, real_8 bw) {
  plan->ups = 1;
  plan->cdec = 1;
  plan->ndec = d2i (plan->fs / (bw * plan->dbwf));
  if (plan->ndec < 1) {
    plan->ups = 2;
    plan->ndec = 1;
  }
  if (plan->ndec > 3) {
    plan->cdec = (plan->ndec >> 1);
    plan->ndec = 2;
  }
  plan->fbwf = bw / (plan->ups * plan->fs / plan->cdec);
  if(plan->halo.vbpr&1)printf ("DDC.setBW fs=%f bw=%f bwf=%f ups=%d cdec=%d ndec=%d\n", plan->fs, bw, plan->dbwf, plan->ups, plan->cdec, plan->ndec);
}

real_8 DDC_getRatio (DDC* plan) {
  return (1.0 * plan->ups) / (plan->cdec * plan->ndec);
}

real_8 DDC_getDelay (DDC* plan) {
  real_8 delay = plan->oagc * plan->maxcount * plan->cdec * plan->ndec;
  if (plan->cdec == 1) delay -= (2.5 * plan->cdec * plan->ndec);
  else delay -= (3.5 + 2.5 * plan->cdec * plan->ndec);
  delay -= (plan->ntap / 2 * plan->cdec);
  return delay / plan->fs;
}

void DDC_setDec (DDC* plan, int_4 dec) {
  plan->ups = 1;
  plan->cdec = 1;
  plan->ndec = dec;
  if (plan->ndec > 3) {
    plan->cdec = (plan->ndec >> 1);
    plan->ndec = 2;
  }
  plan->fbwf = 0.8;
}

void DDC_setGain (DDC* plan, real_8 gain) {
  int_4 cicgain = d2i (plan->gain / 6) * 6;
  Filters_CxCIC_setGain (plan->cic, cicgain);
  plan->gain -= cicgain;
  plan->fscl = d2f (pow (2.0, plan->gain / 6)) / i2f (DDC_FPS);
  if (HW_needsPut(plan)) { HW_push(plan,HW_PREP);  HW_loadAddr(plan,4);HW_loadFlt(plan,plan->fscl);  HW_push(plan,HW_UPD); }
}

void DDC_genFilt (DDC* plan) {
  int_4 i, nt = plan->ntap;
  real_8 fw = plan->fbwf;
  real_4 scl = i2f (DDC_FPS);
  real_4 falpha = (plan->alpha > 0) ? plan->alpha : (plan->cdec == 2) ? 0.2F : (plan->cdec == 3) ? 0.3F : 0.4F;
  real_4* ctap = zallocBuf(sizeof(real_4)*(nt * 2));
  Filters_genFirKais (1, fw, 0.0, 0.01, 70.0, ctap, nt);
  for (i = 0; i < nt; i ++) ctap[i] = ctap[i+i];
  if (plan->cdec > 1) Filters_applyCompensation (falpha, ctap, nt);
  for (i = 0; i < nt; i ++) RomF_set (plan->rft, i, ctap[i] * scl);
}

int_4 DDC_init (DDC* plan) {
  plan->fs = -1.0;
  plan->dbwf = 1.5;
  plan->dp = 0;
  plan->ntap = 128;
  plan->gain = 0;
  plan->alpha = -1;
  plan->AMDes = 0.7071F;
  DDC_setDec (plan, 1);
  plan->maxcount = (1 << DDC_OAGC);
  return 0;
}

int_4 DDC_set (DDC* plan, String* key, Value* value) {
  if (isMatch (key, "D:FS")) plan->fs = Value_toD (value);
  else if (isMatch (key, "D:FREQ")) DDC_setFreq (plan, Value_toD (value));
  else if (isMatch (key, "D:FCNY")) DDC_setFcny (plan, Value_toD (value));
  else if (isMatch (key, "D:BW")) DDC_setBW (plan, Value_toD (value));
  else if (isMatch (key, "L:DEC")) DDC_setDec (plan, Value_toL (value));
  else if (isMatch (key, "D:FBWF")) plan->fbwf = Value_toD (value);
  else if (isMatch (key, "D:DBWF")) plan->dbwf = Value_toD (value);
  else if (isMatch (key, "L:NTAP")) plan->ntap = Value_toL (value);
  else if (isMatch (key, "L:GAIN")) plan->gain = Value_toL (value);
  else if (isMatch (key, "L:AGC")) plan->oagc = Value_toL (value);
  else if (isMatch (key, "F:AMDES")) plan->AMDes = Value_toF (value);
  else if (isMatch (key, "F:ALPHA")) plan->alpha = Value_toF (value);
  else if (isMatch (key, "L:MAXPASS")) plan->maxpass = Value_toL (value);
  else return Core_set (plan, key, value);
  return 0;
}

int_4 DDC_get (DDC* plan, String* key, Value* value) {
  if (isMatch (key, "D:FS")) Value_fromD (value, plan->fs);
  else if (isMatch (key, "D:FREQ")) Value_fromD (value, plan->dp * plan->fs);
  else if (isMatch (key, "D:RATIO")) Value_fromD (value, DDC_getRatio (plan));
  else if (isMatch (key, "D:XDIO")) Value_fromD (value, 1.0 / DDC_getRatio (plan));
  else if (isMatch (key, "D:XSIO")) Value_fromD (value, DDC_getDelay (plan));
  else if (isMatch (key, "L:NTAP")) Value_fromL (value, plan->ntap);
  else if (isMatch (key, "L:GAIN")) Value_fromL (value, plan->gain);
  else return Core_get (plan, key, value);
  return 0;
}

int_4 DDC_open (DDC* plan) {
  plan->cic = Filters_CxCIC_new (DDC_OCIC, DDC_ODEC);
  Filters_CxCIC_setDecimation (plan->cic, plan->cdec);
  plan->vd = CxTapBuf_new (DDC_OTAP, 1, DDC_PTAP, 0);
  CxTapBuf_setLength (plan->vd, plan->ntap);
  plan->rft = RomF_new (DDC_OTAP, DDC_PTAP);
  DDC_genFilt (plan);
  DDC_setGain (plan, plan->gain);
  if (plan->oagc > 0) plan->AMDes *= d2f (pow (2.0, plan->gain / 6));
  plan->p = 0;
  plan->mdec = plan->ndec - 1;
  plan->idec = plan->mdec;
  printf ("DDC Fs=%f Fc=%f cdec=%d ndec=%d fbwf=%f ntap=%d mc=%d NP=%d\n", plan->fs, - plan->fs * plan->dp, plan->cdec, plan->ndec, plan->fbwf, plan->ntap, plan->maxcount, NP);
  DDC_upload (plan);
  return 0;
}

int_4 DDC_process (DDC* plan, Stream* si, Stream* so) {
  CxReal_4 sc_,*sc=&sc_, cn_,*cn=&cn_, cm_,*cm=&cm_, cc_,*cc=&cc_, fo_,*fo=&fo_, fos_,*fos=&fos_, fc_,*fc=&fc_;
  real_4 fp, msq, mag, blkAvg, blkAvgInv;
  int_1 cgo, fout, okOut;
  int_u1 ia;
  if (plan->cntovr) {
    plan->pass = (plan->pass >= 0x1000) ? 0x1000 : plan->pass + 1;
    if (plan->pass <= plan->oagc) {
      blkAvg = divfp2 (plan->blkSum, DDC_OAGC);
      blkAvgInv = invf (blkAvg);
      plan->fscl = plan->fscl * plan->AMDes * blkAvgInv;
      plan->blkSum = 0;
    }
    plan->count = 0;
    plan->cntovr = 0;
  }
  okOut = (plan->pass >= plan->oagc);
  while (si->rok && so->wok && ! plan->cntovr) {
    if (plan->ups == 2 && getBit(plan->count, 0)) {
      cn->x = 0;
      cn->y = 0;
    }
    else {
      Stream_rdCIF (si, cn);
    }
    fp = d2f (plan->p);
    plan->p = frac (plan->p + plan->dp);
    sincoscf (fp, sc);
    mulcc (cn, sc, cm);
    cgo = Filters_CxCIC_process (plan->cic, cm, cc);
    if (cgo) {
      CxTapBuf_load (plan->vd, cc);
      fout = (plan->idec == 0);
      plan->idec = (plan->idec == 0) ? plan->mdec : plan->idec - 1;
      if (fout) {
        fo->x = 0;
        fo->y = 0;
        for (ia = 0; ia < plan->ntap; ia ++) {
          real_4 ft;
          CxReal_4 fdi_,*fdi=&fdi_;
          ft = RomF_get (plan->rft, ia);
          CxTapBuf_get (plan->vd, ia, fdi);
          fo->x += ft * fdi->x;
          fo->y += ft * fdi->y;
        }
        mulcf (fo, plan->fscl, fos);
        if (okOut) {
          Stream_wrCFI (so, fos);
        }
        if (plan->pass < plan->oagc) {
          fc->x = fos->x * fos->x;
          fc->y = fos->y * fos->y;
          msq = fc->x + fc->y;
          mag = sqrtf (msq);
          plan->blkSum = plan->blkSum + mag;
        }
        plan->count = plan->count + 1;
        plan->cntovr = (plan->count >= plan->maxcount);
      }
    }
  }
  return 0;
}

int_4 DDC_close (DDC* plan) {
  HW_push(plan,HW_CLOSE);
  return 0;
}

int_4 DDC_poll (DDC* plan) { return 0; }

int_4 DDC_free (DDC* plan) {
  HW_free(plan);
  free(plan);
}

#include "cores/CoreHandles.h"

DDC* DDC_subCore (HALO* halo, int_4 scid) {
  DDC* plan = DDC_plan();
  if (plan==NULL) return NULL;
  Core_copyHaloToSub(halo,&plan->halo,scid);
  DDC_init(plan);
  return plan;
}
#undef CORE_NAME
#undef CORE_AREA
#undef CORE_FLOW
#undef AW
#undef BW
#undef CW
#undef NP
