/**
  Do NOT edit.
  This file is generated by ICEJVCC.
  See CFIR.jv for documentation.
*/
package nxm.ice.core;
import nxm.ice.lib.*;
import nxm.dsp.prim.firkais;
public class CFIR extends CoreFactory {

public static class JVM extends CORE       {                             public JVM() { setFlow(STREAM); } }
public static class CPU extends CoreNative { public native long alloc(); public CPU() { setFlow(STREAM); } }
public static class ICE extends CoreNative { public native long alloc(); public ICE() { setFlow(STREAM); } }

public final static int FLOW = STREAM, ONP = 1, NP = 2, BW = 32 * NP, RTAP = 32, NCTAP = 22, NCTAPX = NCTAP + NP, CSCL = 16;
public final static double[] EQFILT_6DB = { 0.0013318773, -0.0, -0.002600332, 6.3422725E-5, 0.0048201275, -1.2684545E-4, -0.008562068, 3.1711368E-4, 0.014714073, -6.3422736E-4, -0.024481175, 0.0012050319, 0.039639205, -0.0022197957, -0.06393011, 0.0042493227, 0.10585253, -0.008752337, -0.19686416, 0.02295903, 0.6135515, -0.16718231, 0.648878, 0.12361091, -0.20047925, -0.005898314, 0.106994145, -5.073818E-4, -0.06437407, 0.0013953, 0.039829474, -0.0012684547, -0.024544597, 9.5134095E-4, 0.0147774955, -6.9765E-4, -0.0086254915, 4.4395908E-4, 0.0048201275, -2.536909E-4, -0.002600332, 1.2684545E-4, 0.0013318773, -6.3422725E-5 };
public final static double[] EQFILT_12DB = { 0.0013437333, -3.7325924E-5, -0.0025754888, 1.1197778E-4, 0.0048150443, -2.2395556E-4, -0.008584962, 4.8523702E-4, 0.014706414, -9.331481E-4, -0.02444848, 0.0017543184, 0.039602805, -0.0032846814, -0.06382733, 0.006308081, 0.10570701, -0.013176052, -0.19644634, 0.035496954, 0.6100549, -0.27303913, 0.6520839, 0.22746417, -0.20077613, -0.015378281, 0.10705075, 0.0021275778, -0.06434989, 3.7325924E-4, 0.039864086, -8.584963E-4, -0.024523133, 8.2117034E-4, 0.014781066, -5.972148E-4, -0.008584962, 4.1058517E-4, 0.0048150443, -2.6128147E-4, -0.0025754888, 1.493037E-4, 0.0013437333, -7.465185E-5 };
public final static double[] EQFILT_15DB = { 0.0013215624, -5.7459238E-5, -0.0025856656, 1.436481E-4, 0.004826576, -2.872962E-4, -0.008590156, 5.745924E-4, 0.014709565, -0.0010917255, -0.024420176, 0.0020685326, 0.039618142, -0.0038784987, -0.063808486, 0.0074409717, 0.10563881, -0.015600183, -0.1962233, 0.042376187, 0.60820603, -0.33125252, 0.6539436, 0.2845956, -0.20093496, -0.020570407, 0.10710402, 0.0035912024, -0.064383075, -1.436481E-4, 0.03984798, -6.607812E-4, -0.024535095, 7.1824045E-4, 0.014767024, -5.745924E-4, -0.008590156, 4.0221465E-4, 0.004826576, -2.5856658E-4, -0.0025856656, 1.436481E-4, 0.0013215624, -8.618886E-5 };
public static class CORE extends Core {
  public int eq;
  public int ntap, nrpt;
  public int gain;
  public double fwf;
  boolean bypass;
  CxFloat[] vi, vo;
  float[] cftx, cfty;
  CxFloat[] cdt;
  float cscl;
  public void setEq (int deq) {
    int i, aeq, nt = 0;
    aeq = (deq < 0) ? - deq : deq;
    if (cftx == null) {
      eq = deq;
      return;
    }
    double[] filt = null;
    for (i = 0; i < NCTAP; i ++) {
      cftx[i] = 0;
      cfty[i] = 0;
    }
    if (aeq == 0) {
      nt = 1;
      cftx[0] = CSCL;
    }
    else if (aeq == 6) {
      nt = 22;
      filt = EQFILT_6DB;
    }
    else if (aeq == 12) {
      nt = 22;
      filt = EQFILT_12DB;
    }
    else if (aeq == 15) {
      nt = 22;
      filt = EQFILT_15DB;
    }
    else {
      System.out.printf ("Unsupported EQ rollOff=%d dB\n", eq);
      return;
    }
    if (nt > 1 && filt != null) {
      for (i = 0; i < nt; i ++) {
        cftx[i] = d2f (CSCL * filt[i+i+0]);
        cfty[i] = d2f (CSCL * filt[i+i+1]);
      };
      if (deq < 0) for (i = 0; i < nt; i ++) cfty[i] = - cfty[i];
    }
    eq = deq;
  }
  public int init () {
    ntap = RTAP;
    bypass = false;
    fwf = 1;
    cscl = 1.0F / CSCL;
    return 0;
  }
  public int set (String key, Value value) {
    if (isMatch (key, "L:GAIN")) gain = value.toL ();
    else if (isMatch (key, "L:EQ")) setEq (value.toL ());
    else if (isMatch (key, "L:NTAP")) ntap = value.toL ();
    else return super.set (key, value);
    return 0;
  }
  public int get (String key, Value value) {
    if (isMatch (key, "L:GAIN")) value.fromL (gain);
    else if (isMatch (key, "L:NTAP")) value.fromL (ntap);
    else return super.get (key, value);
    return 0;
  }
  public void genFilt () {
    int i, j, k, nt = nrpt * ntap;
    int joff = RTAP - ntap;
    double fw = fwf;
    float[] ctap = new float[nt*2];
    firkais.generate (1, fw / nrpt, 0.0, 0.05 / nrpt, 80.0, ctap, nt, false);
  }
  public int open () {
    int i;
    cftx = new float[NCTAP];
    cfty = new float[NCTAP];
    cdt = new CxFloat[NCTAPX];
    for (i = 0; i < NCTAPX; i ++) cdt[i] = new CxFloat ();
    vi = new CxFloat[NP];
    for (i = 0; i < NP; i ++) vi[i] = new CxFloat ();
    vo = new CxFloat[NP];
    for (i = 0; i < NP; i ++) vo[i] = new CxFloat ();
    setEq (eq);
    System.out.printf ("CFIR ntap=%d NP=%d eq=%d byp=%d\n", ntap, NP, eq, bypass ? 1 : 0);
    this.halo.state=1;
    return 0;
  }
  public int process (Stream si, Stream so) {
    boolean doin, doout;
    int i, j, k;
    while (si.rok && so.wok) {
      si.rdCIFA (vi, NP);
      for (k = NCTAP - 1; k >= 0; k --) {
        dupcc ((k < NP) ? vi[NP-1-k] : cdt[k-NP], cdt[k]);
      }
      for (j = 0; j < NP; j ++) {
        CxFloat csum=CxFloat.stk();
        csum.x = 0;
        csum.y = 0;
        for (i = 0; i < NCTAP; i ++) {
          CxFloat ctap=CxFloat.stk(), cdat=CxFloat.stk(), cmx=CxFloat.stk(), cmy=CxFloat.stk();
          ctap.x = cftx[i];
          ctap.y = cfty[i];
          cdat = cdt[NP-1-j+i];
          cmx.x = ctap.x * cdat.x;
          cmx.y = ctap.y * cdat.y;
          cmy.x = ctap.x * cdat.y;
          cmy.y = ctap.y * cdat.x;
          csum.x += cmx.x - cmx.y;
          csum.y += cmy.x + cmy.y;
        }
        mulcf (csum, cscl, vo[j]);
      }
      so.wrCFIA (vo, NP);
    }
    return 0;
  }
  public int close () {
    this.halo.state=0;
    return 0;
  }
}
}
