/**
  Do NOT edit.
  This file is generated by ICEJVCC.
  See AWG.jv for documentation.
*/
package nxm.ice.core;
import nxm.ice.core.Modefs;
import nxm.ice.core.Modems;
import nxm.ice.core.Filters;
import nxm.ice.lib.*;
public class AWG extends CoreFactory {

public static class JVM extends CORE       {                             public JVM() { setFlow(STREAM); } }
public static class CPU extends CoreNative { public native long alloc(); public CPU() { setFlow(STREAM); } }
public static class ICE extends CoreNative { public native long alloc(); public ICE() { setFlow(STREAM); } }

public final static int FLOW = STREAM, SELFPACE = 1, IFMT = FBIT, BW = 32, OSEQ = 11, NSEQ = (1 << OSEQ), OLUT = 10, NLUT = (1 << OLUT), OFILT = 7, NFILT = (1 << OFILT), OTAP = 5, RTAP = 32, PTAP = 16, HTAP = 8, FPS = (NFILT / 8 - 1);
public final static int MAXCR = 250000000;
public final static int OMSEQ = 24;
public static class CORE extends Core implements Modefs {
  public int mod;
  public int map;
  public int scr;
  public int ups;
  public double gain;
  public boolean isFPGA;
  double ps, dps;
  double p, dp;
  float fscl;
  float lfps;
  int bpw;
  int iper, nper, mper;
  int flgs;
  int pr, princ;
  int mlut;
  float[] xlut, ylut;
  int din;
  int dinc;
  int ntap, nrpt, ntot;
  CxTapBuf vd;
  RomF2Di rft;
  int scrvec;
  int[] seq;
  int iseq, mseq;
  int di;
  int db;
  int imon, mmon;
  int cups;
  int cper;
  int ifbd, mfbd;
  public double midx;
  public double fS;
  public double fSym;
  public double tOff;
  public double fC;
  public double fbwf;
  public int obpw;
  public int lmod;
  public int bups;
  public int fbd;
  public boolean mute;
  public void dump (String cc) {
    System.out.printf ("set=%s fsym=%f dps=%f nper=%d imon=%d mmon=%d cper=%d cups=%d mseq=%d bpw=%d flgs=%d\n", cc, fSym, dps, nper, imon, mmon, cper, cups, mseq, bpw, flgs);
  }
  public int findMoN (double dphase) {
    int i;
    double phase, err;
    if (dphase < 0.0001) return 0;
    for (i = 2; i < 0x100000; i ++) {
      phase = dphase * i;
      err = fabs (phase - round (phase));
      if (err < 1.0e-12) return i;
    }
    return 0;
  }
  public void genFilt () {
    int i, j, k, nt = nrpt * ntap, nhlf = nrpt / 2;
    float scl = d2f (nrpt * FPS / fbwf);
    double fw = fbwf;
    if (mod == MT_FSK) fw = 2 * midx / nper;
    if (mod == MT_4FSK) fw = 4 * midx / nper;
    float[] ctap = new float[nt*2];
    Filters.genFirKais (1, fw / nrpt, 0.0, 0.05 / nrpt, 90.0, ctap, nt);
    rft.clear ();
    for (i = j = 0; j < ntap; j ++) for (k = 0; k < nrpt; k ++, i += 2) rft.set (k, j, ctap[i] * scl);
    if (mod == MT_OQPSK) for (i = j = 0; j < ntap; j ++) for (k = 0; k < nrpt; k ++, i += 2) rft.set (k + nhlf, j + HTAP, ctap[i] * scl);
  }
  public void genRotates () {
    int i, n, ii = 16;
    float p, ax, ay, bx, by;
    boolean alt = false;
    boolean rot = (mod == MT_1P4DQPSK);
    int nn = mlut + 1;
    princ = (mod == MT_1P4DQPSK) ? 2 : (mod == MT_1P4QPSK) ? 2 : (mod == MT_3P4QPSK) ? 6 : 0;
    if (princ == 0) return;
    for (i = 0; i < ii; i ++) {
      p = rot ? i / 8.0F : alt ? princ / 16.0F : 0;
      bx = coscf (p);
      by = sincf (p);
      for (n = 0; n < nn; n ++) {
        ax = xlut[n];
        ay = ylut[n];
        xlut[(i<<4)+n] = ax * bx - ay * by;
        ylut[(i<<4)+n] = ax * by + ay * bx;
      }
      alt = ! alt;
    }
    princ = 1;
  }
  public void setDPS () {
    double err, odps = dps, freq = dps * fS;
    dps = dptx2d (d2dptx (dps));
    fSym = dps * fS * nper;
    mmon = 0;
    if (fSym != freq) {
      mmon = findMoN (odps);
      if (mmon > 1) {
        err = frac (dps * mmon);
        if (err > 0.5) {
          dps = dptx2d (d2dptx (dps) + 0x4);
          err = frac (dps * mmon);
          fSym = dps * fS;
        }
        if (err > 1.0e-3 && fSym != freq) System.out.printf ("AWG fS=%18.9f fSym=%18.9f fActual=%18.9f MoN=%d perr=%8.6f\n", fS, freq, fSym, mmon, err);
        fSym = odps * fS;
      }
      else {
        System.out.printf ("AWG fS=%18.9f fSym=%18.9f fActual=%18.9f\n", fS, freq, fSym);
      }
    }
    mmon = (mmon == 0) ? 0 : mmon - 1;
    flgs=setBit(flgs, 4, (mmon > 0));
    putVars ("dps,mmon,flgs");
  }
  public void setRate (double sr) {
    if (sr > 2 * MAXCR) {
      System.out.printf ("Desired sample rate = %f limited to max supported rate of %d\n", sr, MAXCR * 2);
      sr = MAXCR * 2;
    }
    ups = (sr > MAXCR) ? 2 : 1;
    fS = sr / ups;
  }
  public void setCUPS (int c) {
    cups = (c >= 0) ? c : mute ? 0 : bups + 2;
    putVars ("cups");
  }
  public void setMute (int m) {
    mute = (m != 0);
    setCUPS (-1);
  }
  public void setFcny (double f) {
    bups = 0;
    dp = f;
    if (ups == 2) {
      if (f <- 0.125) {
        bups = -1;
        dp = (f + 0.25) * ups;
      }
      else if (f < 0.125) {
        bups = 0;
        dp = (f - 0.00) * ups;
      }
      else {
        bups = 1;
        dp = (f - 0.25) * ups;
      }
    }
    if (f <- 0.5 || f > 0.5) bups = 0;
    if (isFPGA) dp = dptx2d (d2dptx (dp));
    cups = mute ? 0 : bups + 2;
    fC = (dp / ups + (bups * 0.25)) * fS * ups;
    putVars ("dp,cups");
  }
  public void setFreq (double f) {
    setFcny (f / (fS * ups));
  }
  public void setGain (double g) {
    gain = g;
    if (mod >= MT_FSK) g -= 3;
    if (mod > MT_OQPSK) g -= 3;
    fscl = d2f (pow (2.0, g / 6) * fbwf / (double) FPS);
    putVars ("fscl");
  }
  public void setSpec (double v) {
    boolean sweep = false;
    int mxseq = (1 << OMSEQ);
    midx = v;
    if (mod == MT_CW && fS > 0) {
      mseq = 0;
      if (midx > 0) {
        sweep = true;
        mseq = d2i (fS * dps / midx / 0x10000);
        if (mseq < 1) {
          System.out.printf ("Unable to perform CW sweep parameters min=%d\n", mseq);
          mseq = 1;
        }
        if (mseq > mxseq) {
          System.out.printf ("Unable to perform CW sweep parameters max=%d\n", mseq);
          mseq = mxseq;
        }
      }
      flgs=setBit(flgs, 5, sweep);
      if (mseq > 0) mseq --;
      putVars ("flgs,mseq");
      if (! sweep) dinc = 0;
      putVars ("dinc");
    }
  }
  public void genSeq (int olut) {
    int i = 0, j, bits, seed = 123456, lrs = ~ seed, mask = (1 << olut) - 1, mxseq = (1 << OMSEQ);
    mseq = NSEQ - 3;
    if (mod == MT_CW) {
      scr = 0;
      mseq = 1;
      seq[0] = 0x0000;
      setSpec (midx);
    }
    else {
      for (; i < mseq; i ++) {
        if (scr != SCR_LRS) lrs = 0;
        else for (j = 0; j < 8; j ++) {
          lrs = (lrs << 1) | (0x1 ^ getBits(lrs, 0, 0) ^ getBits(lrs, 1, 1) ^ getBits(lrs, 5, 5) ^ getBits(lrs, 25, 25));
        }
        seq[i] = lrs & 0x3FF;
      }
    }
    mseq --;
  }
  public void genMod () {
    int olut, nlut;
    switch (mod) {
      case MT_FSK : nper = (int) (midx * 2);
      mper = 2 * nper - 1;
      break;
      case MT_4FSK : nper = (int) (midx * 4);
      mper = 2 * nper - 1;
      break;
      default : nper = 1;
      mper = 0;
      break;
    }
    olut = Modems.getSymbolMap (mod, map, 1.0, midx, nper, xlut, ylut);
    nlut = (1 << olut);
    mlut = nlut - 1;
    bpw = (mod == MT_NONE) ? 32 : (obpw >= 0) ? obpw : olut;
    dinc = 0;
    genSeq (olut);
    putVars ("seq,mseq,nper,mper,dinc");
    putVars ("xlut,ylut,mlut,bpw");
    lmod = mod;
  }
  public void setFBWF (double f) {
    fbwf = f;
    if (this.halo.state == 1) {
      setGain (gain);
      genFilt ();
      putVars ("rft");
    }
  }
  public void setFsym (double f) {
    fSym = f;
    dps = nper * fSym / fS;
    setDPS ();
    if (this.halo.state == 1) {
      genFilt ();
      putVars ("rft");
    }
    mfbd = d2i (fS / (1.5 * fSym)) - 1;
  }
  public int init () {
    mod = MT_NONE;
    midx = 1.0;
    fbwf = 1.0;
    fS = -1.0;
    dp = 0;
    dps = 0.25;
    tOff = 0;
    gain = -3;
    ntap = -1;
    obpw = -1;
    iseq = 0;
    scr = -1;
    map = -1;
    nper = 1;
    mper = 0;
    ups = 1;
    bups = 0;
    fbd = -1;
    mfbd = 0;
    flgs = 0;
    isFPGA = (this.halo.impl >= CORE_TYPE_FPGA);
    return 0;
  }
  public int set (String key, Value value) {
    int lmod = mod;
    double lmidx = midx, lfSym = fSym;
    if (isMatch (key, "S:SHAPE")) mod = value.toItem (modList);
    else if (isMatch (key, "D:MIDX")) setSpec (value.toD ());
    else if (isMatch (key, "D:SPEC")) setSpec (value.toD ());
    else if (isMatch (key, "S:MOD")) mod = value.toItem (modList);
    else if (isMatch (key, "L:MOD")) mod = value.toL ();
    else if (isMatch (key, "S:MAP")) map = value.toItem (mapList);
    else if (isMatch (key, "S:SCR")) scr = value.toItem (scrList);
    else if (isMatch (key, "D:FS")) setRate (value.toD ());
    else if (isMatch (key, "D:FREQ")) setFreq (value.toD ());
    else if (isMatch (key, "D:COFF")) setFreq (value.toD ());
    else if (isMatch (key, "D:FCNY")) setFcny (value.toD ());
    else if (isMatch (key, "D:FSYM")) setFsym (value.toD ());
    else if (isMatch (key, "D:BAUD")) setFsym (value.toD ());
    else if (isMatch (key, "D:FBWF")) setFBWF (value.toD ());
    else if (isMatch (key, "D:TOFF")) tOff = value.toD ();
    else if (isMatch (key, "L:NTAP")) ntap = value.toL ();
    else if (isMatch (key, "L:BPW")) obpw = value.toL ();
    else if (isMatch (key, "L:FBD")) fbd = value.toL ();
    else if (isMatch (key, "D:GAIN")) setGain (value.toD ());
    else if (isMatch (key, "L:GAIN")) setGain (value.toD ());
    else if (isMatch (key, "L:CUPS")) setCUPS (value.toL ());
    else if (isMatch (key, "L:MUTE")) setMute (value.toL ());
    else return super.set (key, value);
    if (this.halo.state == 0) return 0;
    if ((mod >= MT_FSK && mod <= MT_4FSK) && (midx != lmidx || fSym != lfSym)) lmod = 0;
    if (mod != lmod) genMod ();
    return 0;
  }
  public int get (String key, Value value) {
    if (isMatch (key, "D:FS")) value.fromD (fS * ups);
    else if (isMatch (key, "D:XDO")) value.fromD (1.0 / (fS * ups));
    else if (isMatch (key, "D:FSYM")) value.fromD (fSym);
    else if (isMatch (key, "D:FREQ")) value.fromD (fC);
    else if (isMatch (key, "L:CUPS")) value.fromL (cups);
    else if (isMatch (key, "L:MOD")) value.fromL (mod);
    else if (isMatch (key, "L:FBD")) value.fromL ((mfbd + 1) * ups);
    else if (isMatch (key, "S:MODLIST")) value.fromS (modList);
    else if (isMatch (key, "S:MAPLIST")) value.fromS (mapList);
    else if (isMatch (key, "S:SCRLIST")) value.fromS (scrList);
    else return super.get (key, value);
    return 0;
  }
  public int open () {
    int mtap;
    if (scr < 0) scr = SCR_NONE;
    if (map < 0) map = MAP_BRGC;
    seq = new int[NSEQ];
    xlut = new float[NLUT];
    ylut = new float[NLUT];
    genMod ();
    setFsym (fSym);
    setGain (gain);
    mtap = isFPGA ? PTAP : RTAP;
    if (ntap <= 0) ntap = (mod <= 0) ? mtap : (mod == MT_FSK || mod == MT_4FSK) ? 21 : 7;
    if (ntap >= HTAP && mod == MT_OQPSK) {
      System.out.printf ("Warn ntap=%d limited to ntap=%d for OQPSK\n", ntap, HTAP - 1);
      ntap = HTAP - 1;
    }
    if (ntap > RTAP) {
      System.out.printf ("Warn ntap=%d limited to ntap=%d for this compile\n", ntap, RTAP);
      ntap = RTAP;
    }
    cper = (ntap + PTAP - 1) / PTAP;
    mtap = isFPGA ? PTAP * imax (1, d2i (MAXCR / fS)) : RTAP;
    if (ntap > mtap) {
      System.out.printf ("Number taps=%d at fS=%f too large max=%d for FPGA load PTAP=%d RTAP=%d\n", ntap, fS, mtap, PTAP, RTAP);
      ntap = mtap;
      cper = ntap / PTAP;
    }
    nrpt = NFILT;
    ntot = ntap;
    vd = new CxTapBuf (OTAP, 1, PTAP, 0);
    vd.setLength (ntap);
    rft = new RomF2Di (OFILT, OTAP, PTAP);
    genFilt ();
    pr = 0;
    ps = 0;
    p = 0;
    di = 0;
    lfps = 1;
    iper = 0;
    ifbd = 0;
    imon = 1;
    scrvec = 0;
    flgs = 0;
    flgs=setBit(flgs, 0, (bpw == 0));
    flgs=setBit(flgs, 1, (bpw == 32));
    flgs=setBit(flgs, 2, (mod == MT_CW));
    flgs=setBit(flgs, 3, (mod == MT_OQPSK));
    flgs=setBit(flgs, 4, (mmon > 0));
    flgs=setBit(flgs, 5, (mod == MT_CW && midx > 0));
    if (fbd > 0) mfbd = (fbd / ups) - 1;
    genRotates ();
    setCUPS (-1);
    if((this.halo.vbpr&1)!=0)System.out.printf ("AWG fSym=%f fS=%f fbwf=%f mmon=%d ntap=%d bpw=%d cper=%d\n", fSym, fS, fbwf, mmon, ntap, bpw, cper);
    this.halo.state=1;
    return 0;
  }
  public int process (Stream si, Stream so) {
    boolean gen, byp, cw, oqp, mon, load, sos, zseq, zbinc, zfbd;
    CxFloat cm=CxFloat.stk(), cb=CxFloat.stk(), sc=CxFloat.stk(), fo=CxFloat.stk(), cn=CxFloat.stk(), cmr=CxFloat.stk(), cmrs=CxFloat.stk();
    float fps, fp;
    int dix;
    int lper;
    int diy;
    int ia;
    gen = getBit(flgs, 0);
    byp = getBit(flgs, 1);
    cw = getBit(flgs, 2);
    oqp = getBit(flgs, 3);
    mon = getBit(flgs, 4);
    zbinc = getBit(flgs, 5);
    so.setC (cups);
    while ((gen || si.rok) && so.wok) {
      fps = fracf (d2f (ps));
      ps = (mon && (imon == 0)) ? 0 : frac (ps + dps);
      imon = (imon >= mmon) ? 0 : imon + 1;
      load = (fps < lfps);
      lfps = fps;
      if (load) {
        sos = (iper == 0) || (iper == nper);
        lper = iper;
        iper = (iper == mper) ? 0 : iper + 1;
        if (sos) {
          scrvec = seq[iseq&0x7FF];
          iseq = (iseq >= mseq) ? 0 : iseq + 1;
          zseq = (iseq == 0);
          if (gen | cw) {
            di = din & 0x3FF;
          }
          else {
            di = si.rdBits (bpw);
          }
          din = din + (dinc >> 6);
          if (zbinc && zseq) {
            dinc = dinc + 1;
          }
        }
        dix = (di ^ scrvec) & mlut;
        db = dix | (lper << 4) | (pr << 4);
        pr = (pr + princ) & 0xF;
        cm.x = xlut[db];
        cm.y = ylut[db];
        cb.x = CI2Fx (di);
        cb.y = CI2Fy (di);
        vd.load (byp ? cb : cm);
      }
      fo.x = 0;
      fo.y = 0;
      for (ia = 0; ia < ntot; ia ++) {
        CxFloat ft=CxFloat.stk(), fdi=CxFloat.stk(), fdj=CxFloat.stk();
        rft.getrNc (lfps, ia, oqp, ft);
        vd.get (ia, fdi);
        fdj = fdi;
        fo.x += ft.x * fdj.x;
        fo.y += ft.y * fdj.y;
      }
      cn = fo;
      fp = d2f (p + dp);
      p = frac (p + dp);
      sincoscf (fp, sc);
      mulcc (cn, sc, cmr);
      zfbd = (ifbd == mfbd);
      ifbd = (ifbd == mfbd) ? 0 : ifbd + 1;
      mulcf (cmr, fscl, cmrs);
      so.wrCFI (cmrs);
    }
    return 0;
  }
  public int close () {
    this.halo.state=0;
    return 0;
  }
}
}
