# STEP#1: define the output directory area.
load_package flow
#
set part [lindex $argv 0]
set desn [lindex $argv 1]
set card [lindex $argv 2]
set io   [lindex $argv 3]
set pe   [lindex $argv 4]
set hsv  [lindex $argv 5]
puts "vFlow part=$part design=$desn card=$card io=$io p2=$pe hsv=$hsv"
#
#
set project_name top
project_new top
set_global_assignment -name family ARRIA10
set_global_assignment -name device $part
set_global_assignment -name SEED 1
set_global_assignment -name NUM_PARALLEL_PROCESSORS 4
set_global_assignment -name VERILOG_MACRO "QUARTUS=true"
set_global_assignment -name VERILOG_MACRO "ALTERA=true"

# STEP#2: setup design sources and constraints (read the top.prj file)
# 
set f [open top.prj]
while {[gets $f line] > -1} {
  if { [string first # $line] > -1} continue
  set fn [string range $line 14 end-1]
  puts "qFlow loading file=$fn"
        if { [string last .v $fn] > -1} { set_global_assignment -name VERILOG_FILE $fn
  } elseif { [string last .sv $fn] > -1} { set_global_assignment -name SYSTEMVERILOG_FILE $fn
  } elseif { [string last .vhdl $fn] > -1} { set_global_assignment -name VHDL_FILE $fn
  } elseif { [string last .qsf $fn] > -1} { set_global_assignment -name SOURCE_FILE $fn
  } elseif { [string last .sdc $fn] > -1} { set_global_assignment -name SDC_FILE $fn
  } elseif { [string last .tcl $fn] > -1}  { source $fn
  }
}
close $f
#
# STEP#3: run synthesis, write design checkpoint, report timing, and utilization estimates
#
execute_flow -compile
report_slack

project_close

exit
