/**********************************************
 ICE Proprietary Software - do NOT disseminate
 **********************************************/
/*
  ICEPIC-8+ Processor Module Controller

  Jeff Schoen
  Innovative Computer Engineering, Inc.
  12/15/2004

  Packet Contents

	Code	Signal	icnt
  p A5  Key	
  n 00  Cmd	
  p 04  Cnt	isync
  n 01  Chn
  p  0  Data	ichan	00	icycle up
  n  1
     2			03	wvali up
     3
     4			02
   ...
     6		idone	01	
     7
      			00	icycle dn

*/
`include "vdefs.h"
`include "../lib/ramdefs.h"
`include "../lib/hypdefs.h"

`ifdef PIC6
  `define DTAPS 0
`else
  `define DTAPS 24
`endif

module pmodule (
  sclk,rst, scs,saddr, swr,swrbus, srd,srdbus, sack,
`ifdef PM_RIO
  rclk,rrst,ribus,robus, 
`else
  vclks, vipc,vip,vopc,vop, vinc,vin,vonc,von,
`endif
  ioclk, istat,iena,ibus,isel, ostat,oena,obus,osel,
  istat1,istat2,ostat1,ostat2,mcena, test);			

  parameter PORT=1;
  parameter IBW=64;
  parameter MODE=5;

`ifdef PM_RIO
  localparam DBW=128;
  localparam HFLGS=`HYP_ONOF|`HYP_CMDF;
`else
  localparam DBW=32;
  localparam HFLGS=`HYP_ONOF;
`endif
  localparam DBV=DBW/8;
  localparam IBV=IBW/8;
  localparam DBWP=4+1+1+DBW;
  localparam NRO=(MODE>7)? 8:2;
  localparam NRI=(MODE>7)? 16:4;

  // system bus
  input sclk,rst,scs,swr,srd;
  input [31:0] saddr,swrbus;
  output [31:0] srdbus;
  output sack;

`ifdef PM_RIO
  // RIO Interface
  input rrst;
  input [1:0] rclk;
  input [DBWP-1:0] ribus;
  output [DBWP-1:0] robus;
`else
  // HyperTransport Interface
  input [3:0] vclks;
  inout vipc, vinc;
  inout [7:0] vip, vin;
  inout vopc, vonc;
  inout [7:0] vop, von;
`endif

  // DMA bus
  input ioclk,iena,oena;
  input [IBW-1:0] ibus;
  input [7:0] isel;
  output [IBW-1:0] obus;
  output [15:0] osel;		// upper bytes for NVME address
  output istat,ostat;

  // direct
  output istat1,istat2;
  output ostat1,ostat2;
  input [7:0] mcena;

  // test port
`ifdef TRACE_DBG_PMOD
  output [32:0] test;
`else
  output [7:0] test;
`endif

  // global signals
  wire L=0, H=1;
  reg [31:0] pm;
  assign sack=H;

  wire good = H;
  wire ena  = pm[0];
  wire orst = pm[16];   // test reset
  wire irst = pm[17];   // test reset
  wire mode = pm[31];   // raw data collect for calib

  reg enb,enc,dclkrst,dclkadj,dclkud;
  wire swriom = (scs && swr && saddr[5:2]==0);
  wire swriop = (scs && swr && saddr[5:0]==6);
  always @(posedge sclk) begin
    if (swriom) pm <= swrbus;
    dclkrst <= swriop && swrbus[0];
    dclkadj <= swriop && swrbus[1];
    dclkud  <= swriop && swrbus[8];
    enb     <= ena && !rst;
    enc     <= enb && !mode;
  end
  wire frst = !enb;
  wire [2:0] frsts = {frst,frst,frst};
  wire [3:0] vadj = {dclkud,dclkadj,dclkrst,sclk};

  reg scscmd,scssta,cmdrst,swrcmd,srdcmd;
  always @(posedge sclk) begin
    scscmd <= (scs && saddr[5]);
    scssta <= (scs && saddr[5] && !saddr[4] && saddr[3]);
    if (scssta && swr) cmdrst <= swrbus[0];
    swrcmd <= (scs && swr && saddr[5] && saddr[4]);
    srdcmd <= (scs && srd && saddr[5] && saddr[4]);
  end

  // channel wires
  wire wvalix,wvalox;
  wire [2:0] wrdyo;
  wire [2:0] wrdyi;
  wire [DBV-1:0] wchni,wchno;
  wire [DBW-1:0] wbusi,wbuso;
  reg  [2:0] icnt,ocnt;
  reg ienad;
  always @(posedge ioclk) begin
    if (!oena) ocnt <= 0; else ocnt <= ocnt+1;
    if (iena&!ienad) icnt <= 1; else icnt <= icnt+1;
    ienad <= iena;
  end
  wire ichi  = isel[0];
  wire isen  = isel[1];
  wire iten  = isel[2];
  wire iaux  = isel[3];
  wire isena = isel[4];
  wire isenb = isel[5];
  wire [7:0] votest,vitest,calib;
  wire [3:0] ohold_;

`ifdef PM_RIO
   wire mcs   = isel[7];
   wire vclk   = rclk[0];
   wire fclk   = rclk[1];
   wire vrdy   = ribus[DBW+1];
   wire [IBV-1:0] ichn = {4{mcs,L,L,L,L,iten,isen,ichi}};
`else
   wire mcs   = L;
   wire vclk   = vclks[0];
   wire vopclk = vclks[1];
   wire vrdy   = H;
   wire [IBV-1:0] ichn = {2{iten,iten,isen,ichi,isen,ichi,isen,ichi}};
`endif

  // command FIFOs
  wire [31:0] srdbusp,srdbusc;
`ifdef PM_RIO
  wire [35:0] cobus; wire[31:0] costats; wire coena,cordy,sordy; 
  cmdfifo cof (cmdrst,costats, sclk,sordy,swrcmd,{saddr[3:0],swrbus}, vclk,cordy,coena,cobus);
  wire [35:0] cibus; wire[31:0] cistats; wire ciena,cirdy,sirdy; 
  cmdfifo cif (cmdrst,cistats, fclk,cirdy,ciena,cibus, sclk,sirdy,srdcmd,srdbusc);
  assign srdbus = scssta? cistats : scscmd? srdbusc : srdbusp;
`else
   assign srdbus = srdbusp;
`endif

  // multichan aggregators
  reg mcd; always @(posedge sclk) mcd <= mcena[3];
  wire csm,cab; // channel single/multi and A/B 
  wire [2:0] wvali = !wvalix? 3'b0 : (mcd&&~csm)? {cab,~cab,L} : {L,L,H}; 
  wire [2:0] oenas = mcena[2:0];

  // output dual aggregators
  reg [2:0] ivals; always @(posedge ioclk) ivals <= mcena[6:4]; 
  reg [3:0] ihold; always @(posedge vclk) ihold <= !enc? 0 : mcd? {L,~wrdyi[2:0]} : {L,{3{~wrdyi[0]}}};
  reg [3:0] ohold; always @(posedge vclk) ohold <= ohold_;
  reg [2:0] och;   always @(posedge vclk) och <= (wrdyo[2] && !ohold[2])? 4 : (wrdyo[1] && !ohold[1])? 2 : (wrdyo[0] && !ohold[0])? 1 : 0;
  reg [2:0] ocho;  always @(posedge vclk) if (!wvalox && och!=0) ocho <= och;
  reg vrdyd;       always @(posedge vclk) vrdyd <= vrdy;
  wire [2:0] wvalo = !wvalox? 0 : ocho;
  wire wrdyx = (och!=0) && vrdyd;

  // the qdr output packet handler
`ifdef PM_RIO
  wire ordy = ribus[DBW+1];
  mcfifoNxM #(IBW+IBV,DBW+DBV,NRO,3,`BPAR,`PACKET) fo (ioclk,frsts,{istat2,istat1,istat},ivals,{ichn,ibus}, vclk,frsts,wrdyo,wvalo,{wchno,wbuso});
  hypoutr #(DBW,DBW,`DMA_PKT_LEN,HFLGS) qhypo (vclk,enb&ordy, robus[DBW],robus[DBW-1:0], wrdyx,wvalox,wchno,wbuso, cordy,coena,cobus, ihold,votest);
//  assign test[32]=ioclk; assign test[31:0] = {ichn[7:0],ordy,wrdyo[2:0],wvalo[2:0],ichn[7:0],ohold[3:0],ihold[3:0],istat2,istat1,istat,ivals[2:0]};
`else
  wire [31:0] vdato;
  wire ordy,vorst,voss;
  assign istat = L; assign wrdyo[0]=L;	// no ram channel out on older models
  dcfifoNxM #(IBW+IBV,DBW+DBV,2,3,`BPAR,`PACKET) fo (ioclk,frsts,{istat2,istat1},ivals[2:1],{ichn,ibus}, vclk,frsts,wrdyo[2:1],wvalo[2:1],{wchno,wbuso});
  hypoutq #(DBW,DBW,1,HFLGS) qhypo (vclk,enb,vdato, wrdyx,wvalox,wchno,wbuso, ihold,votest);
  doqdrc		     qclko (vopc,vonc, vclk,orst,vopclk,vorst,voss,L);
  doqdrN #(8,0)		     qdato (vop,von, vclk,vopclk,vorst,voss,L, vdato[7:0], vdato[15:8], vdato[23:16], vdato[31:24]);
`endif

  // the qdr input packet handler
`ifdef PM_RIO
  // RIO packetizer
  wire [31:0] vdati = 0;	// for ctest
  hypinr #(DBW,DBW,`DMA_PKT_LEN,HFLGS) qhypi (fclk,enb, ribus[DBW],ribus[DBW-1:0], 
				wvalix,wchni,wbusi, ciena,cibus, mode,ohold_,csm,cab,calib,vitest);
  assign test = {ordy,robus[DBW],oena,iena, wvalox,wvalix,ohold[0],ihold[0]};
`else
  wire [31:0] vdati;
  wire fclk,virst,vipclk,viss;
  diqdrc                    qclki (vipc,vinc, fclk,irst,vipclk,virst,viss, vadj,vitest);
  diqdrN #(8,0,0,`DTAPS)    qdati (vip,vin, fclk,vipclk,virst,viss, vdati[7:0],vdati[15:8],vdati[23:16],vdati[31:24]);
  hypinq #(DBW,DBW,0,HFLGS) qhypi (fclk,enb,vdati, wvalix,wchni,wbusi, mode,ohold_,csm,cab,calib,vhtest);
  assign test = {oena,iena, wrdyo[0],wrdyi[0], wvalox,wvalix,ohold[0],ihold[0]};
`endif

`ifdef PM_RIOX
  // extra pipeline for wvali
  reg [2:0] wvalj; reg [DBV-1:0] wchnj; reg [DBW-1:0] wbusj;
  always @(posedge fclk) begin wvalj<=wvali; wchnj<=wchni; wbusj<=wbusi; end
  mcfifoNxM #(DBW+DBV,IBW+IBV,NRI,4,`BPAR|`DBLBUF,`PACKET) fi (fclk,frsts, wrdyi,wvalj,{wchnj,wbusj}, ioclk,frsts, {ostat2,ostat1,ostat},oenas,{osel,obus});
`else
  mcfifoNxM #(DBW+DBV,IBW+IBV,NRI,4,`BPAR|`DBLBUF,`PACKET) fi (fclk,frsts, wrdyi,wvali,{wchni,wbusi}, ioclk,frsts, {ostat2,ostat1,ostat},oenas,{osel,obus});
`endif

  // status counter readback ram
  reg tload,tincl,tincu,tput,tag,ichx;
  reg [1:0] isenl;
  reg [31:0] tcnt;
  wire [1:0] isenx = {isenb,isena};
  wire [31:0] twrbus,trdbus;
  always @(posedge ioclk) begin
    ichx  <= icnt[2];
    tload <= (icnt==1) || (icnt==5);
    tincl <= tload && iena && (ichi==ichx);
    tincu <= tload && (trdbus[15:0]==16'hFFFF);
    tput  <= tincl;
    tag   <= tload && isenx[ichx] && !isenl[ichx];
    if (tload) tcnt[15:00] <= trdbus[15:00]; else if (tincl) tcnt[15:00] <= tcnt[15:00]+1;
    if (tload) tcnt[31:16] <= trdbus[31:16]; else if (tincu) tcnt[31:16] <= tcnt[31:16]+1;
    if (tload&!ichx) isenl[0] <= isenx[0];
    if (tload& ichx) isenl[1] <= isenx[1];
  end
  wire twr = tag || tput;
  wire [1:0] taddr = {tag,ichx};
  dpram #(2,32,32) rs (sclk,scs, saddr[10:2],swr, swrbus,srdbusp,
                       ioclk,H, {7'b1,taddr},twr, twrbus,trdbus);
  assign twrbus = tcnt;

//  reg ctest; always @(posedge vclk) ctest <= ((vdati[7:0]^vdati[15:8])!=8'hFF) || ((vdati[23:16]^vdati[31:24])!=8'hFF);
//  assign test = vitest;
//  assign test = {iena,oena,wvali,wvalox,wvalix,ribus[32]};
//  assign test = votest;

endmodule

