/**********************************************
 ICE Proprietary Software - do NOT disseminate
 **********************************************/
/*
  JTAG port controller 
  Jeff Schoen
  Innovative Computer Engineering, Inc.
  1/15/2003

  all circuits run at 100MHz

  go - transition tclk
  cycle - an 8/16/24/32 bit cycle
  count - half bit count

  the pins are registered in the IO cells for both in and out
  this produces a 2 cycle delay of the TDI input signal

cyc count tck data

L    0x0   L
H    0x0   L
H    0x1   H  
H    0x2   L  next
H    0x3   H
H    0x4   L  next
H    0x5   H
H    0x6   L  next

*/
module jtag ();
endmodule

module jtagports (
  sclk,srst, scs,saddr, swr,swrbus, srd,srdbus,
  tckx,tmsx,tdix,tdox,
  tck1,tms1,tdi1,tdo1,
  tck2,tms2,tdi2,tdo2,
`ifndef JTAG_NOPM
  tck3,tms3,tdi3,tdo3,
  tck4,tms4,tdi4,tdo4,
`endif
`ifdef JTAG_QPM
  tck5,tms5,tdi5,tdo5,
  tck6,tms6,tdi6,tdo6,
`endif
`ifdef PIC6
  tscs,tsalert, prot, 
`endif
`ifdef JTAG_MPIO
  mpio,
`endif
`ifdef JTAG_QDRX
  irdy1,irdy2,
`endif
  test
  );

`ifdef JTAG_QPM
  localparam PORTS=6;
`else
  localparam PORTS=4;
`endif

  // system bus
  input sclk,srst,scs,swr,srd;
  input [31:0] saddr,swrbus;
  output [31:0] srdbus;

`ifdef BSCAN_INTERNAL
  output tckx, tmsx, tdix;
`else
  inout  tckx, tmsx, tdix;
`endif
  input  tdox;

  output tck1, tms1, tdi1;
  input  tdo1;
  output tck2, tms2, tdi2;
  input  tdo2;
`ifdef JTAG_NOPM
  wire tck3,tms3,tdi3,tdo3;
  wire tck4,tms4,tdi4,tdo4;
  assign tdo3=0;
  assign tdo4=0;
`else
  output tck3, tms3, tdi3;
  input  tdo3;
  output tck4, tms4, tdi4;
  input  tdo4;
`endif
`ifdef JTAG_QPM
  output tck5, tms5, tdi5;
  input  tdo5;
  output tck6, tms6, tdi6;
  input  tdo6;
`else
  wire tck5,tms5,tdi5,tdo5;
  wire tck6,tms6,tdi6,tdo6;
`endif
`ifdef PIC6
  inout  tscs, tsalert;
  input  prot;
`endif
`ifdef JTAG_MPIO
  inout [7:0] mpio;
`else
  wire [7:0] mpio;
`endif
`ifdef JTAG_QDRX
  input irdy1,irdy2;
`endif
  output [7:0] test;

  wire L=0, H=1;

  // Boundary Scan control interface
  reg [3:0] cnt;
  reg [5:0] count;
  reg [31:0] mask,data,datao,enable;

  wire ebyte,datax;
  wire [2:0] sel   = enable[18:16];
  wire [3:0] speed = enable[23:20];
  mux4xN mxe (ebyte, enable[0],enable[1],enable[2],enable[3], count[5:4]);

  wire [1:0]  addr  = saddr[3:2];
  wire [31:0] wrbus = swrbus;
  wire        rst   = srst;
  wire        wr    = scs && swr;

  wire wrmask = (wr  && addr==0);
  wire wrdata = (wr  && addr==1);
  wire wrenab = (wr  && addr==2);
  wire wrmpio = (wr  && addr==3);
  wire status = (scs && addr==3);

  reg init,cycle,tck,ondata,onena;
  reg en0,en1,en2,en3,en4,en5,en6,en8;

  wire go = (cnt==speed);
  wire shiftw = go && cycle && count[0];
  reg shiftd,shiftr;
  reg [1:0] rwoff;

`ifdef DIODE
  reg dprot,mprot,eprot;
  always @(posedge sclk) begin
    dprot <= (data==32'h0ea00000) || (data==32'h0ec00000);
    mprot <= (mask==32'h180000C0);
    if (wrenab) eprot <= prot && dprot && mprot;
  end
`else
  wire eprot = L;
`endif
  wire minit = wrmask|init;
  
  always @(posedge sclk) begin
    if (minit) ondata <= 0;  else if (wrenab) ondata <= 1;
    if (minit) onena <= 0;   else if (wrdata) onena <= 1;
    if (go|!cycle) cnt <= 0; else cnt <= cnt+1;
    if (rst) init <= 0;      else init <= (onena && wrenab) || (ondata && wrdata);
    if (rst) cycle <= 0;     else cycle <= (init && !eprot) || (cycle && !(go && count==63));
    if (rst) enable <= 0;    else if (wrenab) enable <= wrbus;
    if (!cycle) count <= 0;  else if (go) count <= count+1;
    if (!cycle) tck <= 0;    else if (go) tck <= ebyte && !count[0];
    if (!cycle) rwoff <= 0;  else if (shiftw&!shiftr) rwoff <= rwoff+1; else if (shiftr&!shiftw) rwoff <= rwoff-1;
    if (wrmask) mask<=wrbus; else if (shiftw) mask <= {mask[0],mask[31:1]};
    if (wrdata) data<=wrbus; else if (shiftr) data <= {datax,data[31:1]};
    en0 <= (sel==0) || enable[28];
    en1 <= (sel==1) || enable[24];
    en2 <= (sel==2) || enable[25];
    en3 <= (sel==3) || enable[26];
    en4 <= (sel==4) || enable[27];
    en5 <= (sel==5) || enable[26];
    en6 <= (sel==6) || enable[27];
    en8 <= enable[19];			// PIC6 temp sensor
    shiftd <= shiftw;
    shiftr <= shiftd;
  end
  assign srdbus = status? {data[31:16], mpio, 7'd0,cycle} : data;

  wire datai,btdox,btdo7,btdo6,btdo5,btdo4,btdo3,btdo2,btdo1;
  mux4xN mxi (datai, data[0],data[1],data[2],data[3], rwoff);

  wire feed = enable[31];
//  wire btck = tck;
  wire btck = !cycle || !ebyte || tck;
  wire btms = mask[0] || en8;
  wire btdi = datai;
  wire toe  = enable[28];

`ifdef JTAG_QDRX
  wire btdi1 = en1? btdi : !irdy1;
  wire btdi2 = en2? btdi : !irdy2;
`else
  wire btdi1 = btdi;
  wire btdi2 = btdi;
`endif

  // main FPGA port
`ifdef BSCAN_INTERNAL
  ff(tckx,tck&en0,sclk);
  ff(tmsx,btms,sclk);
  ff(tdix,btdi,sclk);
  ff(btdox,tdox,sclk);
`else
  obfftN #(3) _tx ({tdix,tmsx,tckx},sclk,toe,{btdi,btms,btck}); ibff _tox (tdox,sclk,btdox); 
`endif

  // auxiliary IO ports
  obffN #(3) _t1 ({tdi1,tms1,tck1},sclk,{btdi1,en1?btms:H,tck&en1}); ibff _to1 (tdo1,sclk,btdo1); 
  obffN #(3) _t2 ({tdi2,tms2,tck2},sclk,{btdi2,en2?btms:H,tck&en2}); ibff _to2 (tdo2,sclk,btdo2); 

`ifdef JTAG_TSPM
  // auxiliary PM ports (for TRAYs Arduino access)
  obfftN #(3) _t3 ({tdi3,tms3,tck3},sclk,en3,{btdi,btms,btck}); ibff _to3 (tdo3,sclk,btdo3); 
  obfftN #(3) _t4 ({tdi4,tms4,tck4},sclk,en4,{btdi,btms,btck}); ibff _to4 (tdo4,sclk,btdo4); 
`elsif JTAG_NOPU 
  // auxiliary PM ports (Always Drive Low between commands - original way like IOM)
  obffN #(3) _t3 ({tdi3,tms3,tck3},sclk,{btdi,btms,tck&en3}); ibff _to3 (tdo3,sclk,btdo3); 
  obffN #(3) _t4 ({tdi4,tms4,tck4},sclk,{btdi,btms,tck&en4}); ibff _to4 (tdo4,sclk,btdo4); 
`else
  // auxiliary PM ports (ADPM=AlwaysDrivePMs)
  obffN #(3) _t3 ({tdi3,tms3,tck3},sclk,{btdi,btms,!en3|btck}); ibff _to3 (tdo3,sclk,btdo3); 
  obffN #(3) _t4 ({tdi4,tms4,tck4},sclk,{btdi,btms,!en4|btck}); ibff _to4 (tdo4,sclk,btdo4); 
`endif

`ifdef JTAG_QPM
  // auxiliary PM ports (for POD8 PM3 & PM4)
  obfftN #(3) _t5 ({tdi5,tms5,tck5},sclk,en5,{btdi,btms,btck}); ibff _to5 (tdo5,sclk,btdo5); 
  obfftN #(3) _t6 ({tdi6,tms6,tck6},sclk,en6,{btdi,btms,btck}); ibff _to6 (tdo6,sclk,btdo6); 
`endif
  
  // tdo input mux
  mux8xN mxd (datax, btdox,btdo1,btdo2,btdo3,btdo4,btdo5,btdo6,btdo7, sel);

`ifdef PIC6
  // temperature sensor chip select
  assign tscs = en8? mask[0] : 1'b1;
  assign tsalert = 1'bZ;
`endif

`ifdef JTAG_MPIO_DEF
  wire [15:0] mpdef = `JTAG_MPIO_DEF;
`else
  wire [15:0] mpdef = 0;
`endif
`ifdef JTAG_MPIO
  genvar i;
  generate
  for (i=0; i<4; i=i+1) begin:mpr
    reg [3:0] mpreg;
    always @(posedge sclk or posedge srst) begin
      if (srst) mpreg <= mpdef[i*4+3:i*4];  else if (wrmpio && wrbus[6:5]==i) mpreg <= wrbus[3:0];
    end
    assign mpio[i*2+1:i*2] = {mpreg[3]?mpreg[1]:1'bZ,mpreg[2]?mpreg[0]:1'bZ};
  end
  endgenerate
`else
  assign mpio = 0;
`endif

  assign test = {btdi2,btdi1,datax,btdi,btms,btck,cycle,en3};
//  assign test = {btdi2,btdi1,datax,tdox,tdix,tmsx,tckx,toe};
//  assign test = 0;

endmodule

