`ifndef _FLAGDEFS
`define _FLAGDEFS

`define RAM_OREG	1	// register data outputs
`define RAM_CENA	2	// use clock enable on registered outputs
`define RAM_CINV	4	// use inverted clock
`define RAM_TIGHT	8	// tight FIFO control
`define RAM_LOOSE	16	// loose FIFO control
`define RAM_PACKET	32	// packet size FIFO control
`define RAM_EINV	64	// use inverted enable
`define RAM_IREG	128	// register wr/addr/data inputs
`define RAM_WONLY	256	// write only port
`define RAM_RONLY	512	// read only port
`define RAM_BPAR	1024	// use block parity
`define RAM_BDMA	2048	// enable dma modes in Buffers
`define RAM_BSTREAM	4096	// enable stream modes in Buffers
`define RAM_RFIRST	8192	// READ_FIRST address conflict resolution
`define RAM_BENA	16384	// byte enable write strobes
`define RAM_DBLBUF	32768	// double buffer accounting on this fifo port
`define RAM_WFIRST	65536	// WRITE_FIRST address conflict resolution
`define RAM_NEMPTY	131072	// queue size FIFO control

`endif
