`include "../lib/ramdefs.h"

module ice_tg_phy (
	clk,rst, irdy,iena,isel,ibus, ordy,oena,osel,obus,
	sclk,srst, scs,saddr, swr,swrbus, srd,srdbus,
	cclk,crd,cwr,cpage,caddr,cdata,cdatao, cs,
	drpclk,drprst,drpen,drpaddr,drpwe,drpdi,drprdy,drpdo,dmondo,
	refclks, txp,txn, rxp,rxn, streams,testout, dbgsys,dbgout);

  parameter NC = 4;	// number channels
  parameter DW = 32;	// IO bus width
  parameter NB = 1;	// number IO busses
  parameter NE = NC;	// number of packet engines
  parameter INDEX = 0;	// index

  localparam NQ = (NC+3)/4;	// number of RIO Quads
  localparam CW = DW;		// external IO bus width
  localparam PW = 32;		// internal QSFP bus width
  localparam CWC = CW/8;
  localparam PWC = PW/8;
  localparam CWX = CW+CWC;
  localparam PWX = PW+PWC;
  localparam ONC = (NC>4)? 3 : (NC>2)? 2 : (NC>1)? 1 : 0;
  localparam NKR = 8;		// num KBy RAM in PKT2DAT buffers

  input clk;
  input [NB-1:0] rst;

  output reg [NB-1:0] irdy;
  input [NB-1:0] iena;
  input [NB*8-1:0] isel;
  input [NB*CW-1:0] ibus;

  output [NB-1:0] ordy;
  input  [NB-1:0] oena;
  output [NB*8-1:0] osel;
  output [NB*CW-1:0] obus;

  input sclk,srst,scs,swr,srd;
  input [31:0] saddr,swrbus;
  output [31:0] srdbus;

  input cclk,crd,cwr,cs;
  input [7:0] cpage,caddr,cdata;
  output [7:0] cdatao;

  input drpclk;
  input drprst;
  input drpen;
  input [8:0] drpaddr;
  input drpwe;
  input [15:0] drpdi;
  output [NC-1:0] drprdy;
  output [(NC*16)-1:0] drpdo;
  output [(NC*17)-1:0] dmondo;

  inout [3:0] refclks;
  output [NC-1:0] txp,txn;
  input  [NC-1:0] rxp,rxn;

  output [NC*38:0] streams;
  output [7:0] testout;
  input  [7:0] dbgsys;
  output [32:0] dbgout;

  // Functions
  function [3:0] selector (input [7:0] rdys);
    selector = rdys[0]? 0 : rdys[1]? 1 : rdys[2]? 2 : rdys[3]? 3 : rdys[4]? 4 : rdys[5]? 5 : rdys[6]? 6 : rdys[7]? 7 : 8;
  endfunction

  wire T=1, F=0;

  wire raw   = dbgsys[0];
  wire ardy  = dbgsys[1];
  wire arst  = dbgsys[2] || srst;
  wire tmode = dbgsys[3];

`ifdef NIO_MIM
  wire [3:0] mims = dbgsys[7:4];
`else
  wire [3:0] mims = 0;
`endif

  wire [2:0] pma_pmd_type = 3'b111;
  wire signal_detect=T;
  wire tx_fault=F;
  wire tx_disable;

  wire coreclk,txoutclk,txusrclk,txusrclk2;
  wire areset_coreclk,areset_txusrclk2,gttxreset,gtrxreset,txuserrdy,reset_counter_done;
  wire [NC-1:0] qpll0reset,qpll0lock,txoutclks;
  wire tclk = txusrclk;
  wire rclk = txusrclk;

  wire [NB-1:0] irdy_;
  wire [NC-1:0] irdys,ordys;
  wire [NC-1:0] ordys0,ordys1;
  wire [CW-1:0] obuss[NC-1:0];
  wire [7:0]    osels[NC-1:0];

  // Main JVM Controller
  wire srwx,srdx,swrx,sackx,swrs,srds,swrf,srdf;
  wire [31:0] saddrx,srdbusx,swrbusx;
  wire [7:0] testp;
  wire bwr,brd;
  wire [31:0] bwrbus;
  wire [31:0] brdbus;
  wire [15:0] baddr;
  processorLite #(PW,2,2) prc ( 
	cclk,crd,cwr,cpage,caddr,cdata,cdatao, cs,
	sclk,baddr, brd,brdbus, bwr,bwrbus,
	sclk,srst, srwx,saddrx, srdx,srdbusx, swrx,swrbusx, sackx,
	tclk,srds,swrs, tclk,srdf,swrf, testp);

  // System bus
  reg twr_,twr,twrd,swrt;
  reg [15:0] taddr;
  reg [31:0] twrbus,srdbus;
  wire [31:0] srdbusi[NC-1:0], srdbusj[NC-1:0];
  wire [ONC-1:0] tchn = taddr[14:12];
  wire [ONC-1:0] schn = saddr[14:12];
  wire aios = saddr[17];
  wire sios = saddr[15];
  wire tios = taddr[15];
  always @(posedge tclk) begin
    twr_ <= scs && swr && !aios;	// tclk should be ~ 3x sclk
    twr  <= twr_; twrd <= twr; 
    taddr <= saddr;
    if (twr) twrbus <= swrbus;
    swrt <= twr && !twrd;		// swrti and j are 1 cycle later
  end
  reg [3:0] iauxf,oauxf;
  always @(posedge sclk) begin
    if (arst) iauxf <= 0; else if (scs && swr && aios && saddr[2]) iauxf <= swrbus;
    if (arst) oauxf <= 0; else if (scs && swr && aios && saddr[3]) oauxf <= swrbus;
    srdbus <= sios? srdbusj[schn] : srdbusi[schn];
  end

  // Input bus counters
  reg [9:0] icnt;
  wire [1:0] iauxm = iauxf[1:0];	// mode
  wire [1:0] iauxs = iauxf[3:2];	// size
  wire [1:0] ichn = (iauxs==0)? icnt[6:5] : (iauxs==1)? icnt[7:6] : (iauxs==2)? icnt[8:7] : icnt[9:8];
  always @(posedge clk) begin
    if (rst[0]) icnt <= 0; else if (iena[0]) icnt <= icnt+1;
  end

  // Output bus aggregation
  reg noaux;
  reg [ONC-1:0] ochn0,ochn1,ochn0p,ochn1p,pchn0,pchn1;
  reg [NB-1:0] oval,pval,pena;
  reg [CWX-1:0] pbus [NB-1:0];
  reg [9:0] ocnt; 
  wire [NB-1:0] prdy;
  wire [1:0] oauxm = oauxf[1:0];	// mode
  wire [1:0] oauxs = oauxf[3:2];	// size
  wire [NC-1:0] oenas;
  always @(posedge rclk) begin
    noaux <= (oauxm==0);
    pval <= oval; pena <= pval; 
    pchn0 <= ochn0; pchn1 <= ochn1;
  end
  // 7	ocyc
  // 0	oval	ochnx	oenas
  // 1	pval	pchnx	
  // 2	pena	pbus
  generate
  if (NB==1) begin
    wire ocyc = noaux? (ocnt[3:0]==0) : (oauxs==0)? (ocnt[4:0]==0) : (oauxs==1)? (ocnt[5:0]==0) : (oauxs==2)? (ocnt[6:0]==0) : (ocnt[7:0]==0);
    always @(posedge rclk) begin
      if (rst[0]) ocnt <= 0; else if (oval) ocnt <= ocnt+1;	// special MUXGBE capability
      if (oval) ochn0p <= ((oauxm==1) && (ochn0>=1))? 0 : ochn0+1;
      oval <= oval? (ocnt[3:0]!=15) : prdy[0] && ( ocyc? (ordys!=0) : ordys[ochn0] ); 
      if (ocyc&!oval) ochn0 <= (!noaux && ordys[ochn0p])? ochn0p : selector(ordys);
      pbus[0] <= {osels[pchn0][3:0],4'b0,obuss[pchn0]};		// use lower 4 bits of osel now that OBW=32
    end
    fifoNxM #(CWX,CWX,4,4) ofifo (rclk,rst[0], prdy[0],pena[0],pbus[0], clk,rst[0], ordy[0],oena[0],{osel[7:0],obus[CW-1:0]});
    assign irdy_ = irdys[3]&irdys[2]&irdys[1]&irdys[0];
    assign oenas = (oval<<ochn0);
  end 
  else if (NB==2) begin
    wire ocyc = (ocnt[3:0]==0);
    always @(posedge rclk) begin
      ocnt <= ocnt+1;	// no special MUXGBE capability
      if (ocyc) oval <= {(ordys1!=0) && prdy[1], (ordys0!=0) && prdy[0]}; 
      if (ocyc) ochn0 <= selector(ordys0); ochn1 <= selector(ordys1);
      pbus[0] <= {osels[pchn0][3:0],4'b0,obuss[pchn0]}; pbus[1] <= {osels[pchn1][3:0],4'b0,obuss[pchn1]};
    end
    fifoNxM #(CWX,CWX,4,4) ofifo0 (rclk,rst[0], prdy[0],pena[0],pbus[0], clk,rst[0], ordy[0],oena[0],{osel[7:0],obus[CW-1:0]});
    fifoNxM #(CWX,CWX,4,4) ofifo1 (rclk,rst[1], prdy[1],pena[1],pbus[1], clk,rst[1], ordy[1],oena[1],{osel[15:8],obus[2*CW-1:CW]});
    assign irdy_ = {irdys[7]&irdys[5]&irdys[3]&irdys[1], irdys[6]&irdys[4]&irdys[2]&irdys[0]};
    assign oenas = {(oval[1]<<ochn1),(oval[0]<<ochn0)};
  end
  endgenerate

  always @(posedge clk) irdy <= ardy? {NB{T}} : irdy_;

  // Packet responder bus logic
  reg  [31:0] ibusx;
  wire [31:0] obusx;
  wire [31:0] rtbuss [NC-1:0];
  reg  [NC-1:0] rtrdys,rtnrdys;
  wire [NC-1:0] rtrdys_,rtenas,rtsels;
  reg  [ONC-1:0] rseli,rselo,rselx;
  reg  [7:0] rtcnt,ioaddr;
  wire [2:0] rsely = rselx;
  wire rtrdyi = rtrdys[rselx];
  wire rtnrdyi = rtnrdys[rselx];
  wire rtseli = rtsels[rselo];
  reg  rtena,rtenax,rtval,rtvalx,rtrd,rdyany,rtoff,rtrw,oreq;
  assign srdbusx = saddrx[2]? {rtena,oreq, rtrdys, 1'h0,rtrdyi,1'h0,rdyany,1'h0,rsely} : ibusx;
  wire rtstr = swrs && !saddrx[2];
  wire rtrw_ = swrbusx[31];	// read=0 or write=1 cycle
  wire oenax = rtena && rtrw;
  wire ienax = rtena && !rtrw;
  wire ienaxd; delayp #(2) dpxd (tclk,ienax,ienaxd);
  always @(posedge tclk) begin
    rtrdys <= rtrdys_;
    rtnrdys <= ~rtrdys_;
    ibusx <= rtbuss[rseli];
    rtrd <= srds && saddrx[3];	// read from one of the FIFOs
    rdyany <= (rtrdys!=0);
    rseli <= saddrx[18:16];
    if (rtnrdyi) rselx <= rselx+1;
    if (rtstr) ioaddr <= swrbusx[25:18]; else if (oenax|ienaxd) ioaddr <= ioaddr+1;
    if (rtstr) rtcnt <= swrbusx[9:2]; else if (rtena) rtcnt <= rtcnt-1;
    if (rtstr) rtoff <= swrbusx[1];
    if (rtstr) rtrw <= rtrw_;
    if (rtstr) oreq <= rtrw_; else if (rtena) oreq <= F;
    if (rtstr) rselo <= saddrx[18:16];
    rtena <= (rtstr && !rtrw_) || (oreq && rtseli) || (rtena && rtcnt>1);
    rtenax <= rtena && (rtcnt==1) && rtoff;
    rtval <= rtena && rtrw;
    rtvalx <= rtenax && rtrw;
  end
  wire rtrdd; delayp #(6) dp (tclk,rtrd,rtrdd);

  dpram #(4,32,32) dram (sclk,T, baddr[15:2],bwr, bwrbus,brdbus,
                         tclk,T, ioaddr,ienaxd, ibusx,obusx);

  // Main Transceiver Clocking Block
  wire refclk = refclks[0];
  wire refclkcopy = refclks[1];
  assign txoutclk = txoutclks[0];
  assign streams[NC*38] = txusrclk;
  wire qpllreset;

  tge_0_shared_clock_and_reset_mod ten_gig_eth_pcs_pma_shared_clock_reset_block (
     .areset(arst),
//     .refclk_p(refclks[2]),
//     .refclk_n(refclks[3]),
     .qpll0reset(qpll0reset[0]),
//     .refclk(refclk_),
     .refclkcopy(refclkcopy),
     .coreclk(coreclk),
     .txoutclk(txoutclk),
     .qplllock(qpll0lock[0]),
     .areset_coreclk(areset_coreclk),
     .areset_txusrclk2(areset_txusrclk2),
     .gttxreset(gttxreset),
     .gtrxreset(gtrxreset),
     .txuserrdy(txuserrdy),
     .txusrclk(txusrclk),
     .txusrclk2(txusrclk2),
     .qpllreset(qpllreset),
     .reset_counter_done(reset_counter_done)
  );

  genvar i,j;
  generate
  for (j=0; j<NQ; j=j+1) begin		// for each Quad

  wire qpll0outclk,qpll0outrefclk;
  tge_0_gt_common ten_gig_eth_pcs_pma_gt_common_block (
     .refclk(refclk),
     .qpllreset(qpllreset),
     .qpll0lock(qpll0lock[j]),
     .qpll0outclk(qpll0outclk),
     .qpll0outrefclk(qpll0outrefclk)
  );

  wire [PW-1:0] xgmii_mimd [3:0];
  wire [PWC-1:0] xgmii_mimc [3:0];

  for (i=j*4; i<(j+1)*4; i=i+1) begin	// for each TGe

  localparam im = i ^ 1;
  localparam iq = i & 15;

  wire [7:0] core_status;
  wire [PW-1:0] xgmii_txd,xgmii_rxd,tbus,tfbus;
  wire [PWC-1:0] xgmii_txc,xgmii_rxc;
  wire rstat,tstat,rxclk,rxstat,txstat,tval,trdy,tbyp;
  wire [1:0] tfstat;
  wire [2:0] tfena;
  wire [31:0] tdbus,rtbus;
  wire [3:0] tcbus,tfsel;
  reg rtsel,tvalx,tvaly,tvalz,rtrdy;
  reg [31:0] tbusx; 
  wire [7:0] dtest,ptest;

  reg swrti; always @(posedge tclk) swrti <= swrt && (tchn==i) && (tios==0);
  reg swrtj; always @(posedge tclk) swrtj <= swrt && (tchn==i) && (tios==1);
  reg srstx; always @(posedge tclk) srstx <= ptest[0];
  reg reset; always @(posedge sclk) reset <= rst[i%NB];

  wire xena,xstat; wire [31:0] xbus; wire [7:0] xsel=0;
  wire yena,ystat; wire [31:0] ybus; wire tack;
  eth2pkt e2p (rxclk,srstx, xgmii_rxc,xgmii_rxd, xena,xbus, yena,ybus);

  PKT2DAT_core #(.PORT(i),.IBW(PW),.OBW(CW),.IOCLKS(2),.IKR(NKR)) p2d (
	rclk,srst, T,taddr, swrtj,twrbus,F,srdbusj[i],tack,
	{rclk,rxclk}, xstat,xena,xsel,xbus, ordys[i],oenas[i],osels[i],obuss[i],
	 ystat,yena,ybus, rtrdys_[i],rtenas[i],rtbuss[i], ptest);

  assign ordys0[i] = ordys[i] && (NB==1 || !osels[i][0]);
  assign ordys1[i] = ordys[i] && (NB==2 &&  osels[i][0]);
  assign rtenas[i] = (ienax||rtrdd) && (rseli==i);
  assign rtsels[i] = rtsel;

  // stream output all QSFP channels RAW or packetized for MultiChannel processing
  reg [36:0] strx; always @(posedge rxclk) strx <= {raw || (xgmii_rxc!=15), xgmii_rxc, xgmii_rxd};
  assign streams[i*38+37:i*38] = {rxclk,strx};

  // this iena is not 1 cycle early like all others
  wire       iena_ = iena[i%NB];
  wire [7:0] isel_ = (i%NB)? isel[15:8] : isel[7:0];
  wire       csel_ = (NB==2)? isel_[(i>>1)+4] : isel_[i+4];
  wire       ienac = iena_ && ((iauxm==1)? (ichn[0]==i) : (iauxm==2)? (ichn[1:0]==i) : csel_);
  wire [1:0] ienas = { ienac && isel_[3], ienac && !isel_[3] };
  wire [CW-1:0] ibus_ = (i%NB)? ibus[2*CW-1:CW] : ibus[CW-1:0]; 
  wire [1:0] irdys_;
  // need to support 2 input channels for A|B sides of card DMAs
`ifdef NIO_NR2K
  dcfifoNxM #(CWX,PWX,2,5,`BPAR,`DBLBUF) tfifo (clk,reset, irdys_,ienas,{isel_,ibus_}, tclk,reset, tfstat,tfena,{tfsel,tfbus});
  assign irdys[i] = irdys_[1]&irdys_[0];
`elsif NIO_DC8K
  dcfifoNxM #(CWX,PWX,8,5,`BPAR,`DBLBUF) tfifo (clk,reset, irdys_,ienas,{isel_,ibus_}, tclk,reset, tfstat,tfena,{tfsel,tfbus});
  assign irdys[i] = irdys_[1]&irdys_[0];
`elsif NIO_CVT12
  wire ziv,zov, zos; reg zis; wire [3:0] zsel; wire [PW-1:0] zib,zob;
  always @(posedge tclk) zis <= zis && zos;
  fifoNxM #(CWX,PWX,8,5,`BPAR,`DBLBUF) tfifo1 (clk,reset, irdys[i],ienac,{isel_,ibus_}, tclk,reset, zis,ziv,{zsel,zib});
  cvt16to12 zcvt (tclk,reset, ziv,zib, zov,zob);
  fifoNxM #(PWX,PWX,4,5,`BPAR,`DBLBUF) tfifo2 (tclk,reset, zos,zov,{zsel,zob}, tclk,reset, tfstat[0],tfena,{tfsel,tfbus});
`else
  fifoNxM #(CWX,PWX,8,5,`BPAR,`DBLBUF) tfifo (clk,reset, irdys[i],ienac,{isel_,ibus_}, tclk,reset, tfstat[0],tfena,{tfsel,tfbus});
`endif
  wire tok = !(rtrdy || (rtval && rtsel));
  wire twait; delayp #(6) (tclk,tfena && tok,twait);
  dat2pkt #(PW,2) d2p (tclk,srstx, swrti,taddr,twrbus,srdbusi[i], tfstat,tfena,tfsel,tfbus, tok,tval,tbus, tbyp,dtest);
/*
    trdy&tsel -> cstart -> cseq -> chdr|cdata -> oena -> tval -> !tval  
                                       oreq   -> rtrdy                  -> rtsel -> rtena-> rtval -> rtval -> !rtval -> !rtsel -> tsel
*/
  reg [16:0] tcnt;
  wire tdone = (tvalx&!rtsel) && !tval;
  always @(posedge tclk) begin
    if (!tmode) tcnt <= 0; else if (tdone) tcnt <= tcnt+1;
    rtrdy <= oreq && (rselo==i);
    rtsel <= (rtrdy && !tvalx && !twait) || (rtsel && (oreq|rtval));	// needs 4 clks between tval and rtval
    tvalx <= (rtval && rtsel) || tval;
    tvaly <= (rtvalx && rtsel);
    tbusx <= rtsel? obusx : tbus;
    tvalz <= (rtval && rtsel) || (tval && !tcnt[16]);
  end
  pkt2eth tpkte  (tclk,srstx, trdy,tvalz,tvaly,tbusx, tcbus,tdbus);

  if (i==0) begin
    assign testout = {oena[0],pena[0],rst[0]};
//    assign testout = {tvalx,trdy,rtval,tok,tval,rtrdy};
  end

`ifdef NIO_MIM
  wire mim = mims[iq];
  rsfifo (rxclk,xgmii_rxc,xgmii_rxd, tclk,xgmii_mimc[i],xgmii_mimd[i]);
`else
  wire mim = F;
`endif
  
  assign xgmii_txd = mim? xgmii_mimd[im] : tdbus;
  assign xgmii_txc = mim? xgmii_mimc[im] : tcbus;

  wire drp_req;
  wire drpc=drp_req;
  wire drp_gnt=drpc;
  wire core_to_gt_drpen;
  wire core_to_gt_drpwe;
  wire [15:0] core_to_gt_drpaddr;
  wire [15:0] core_to_gt_drpdi;
  wire drprdyx; assign drprdy[i]=drprdyx;
  wire core_to_gt_drprdy=drprdyx;
  wire [15:0] drpdox; assign drpdo[15+i*16:i*16]=drpdox;
  wire [16:0] dmondox; assign dmondo[16+i*17:i*17]=dmondox;
  wire [15:0] core_to_gt_drpdo=drpdox;
  wire tx_resetdone_int,rx_resetdone_int; 

  tge_0_block_32 ten_gig_eth_pcs_pma_block_i (
      .coreclk(coreclk),
      .dclk(drpclk),
      .txusrclk(txusrclk),
      .txusrclk2(txusrclk2),
      .txoutclk(txoutclks[i]),
      .areset_coreclk(areset_coreclk),
      .txuserrdy(txuserrdy),
      .rxrecclk_out(rxclk),
      .areset(arst),
      .gttxreset(gttxreset),
      .gtrxreset(gtrxreset),
      .qpll0lock(qpll0lock),
      .qpll0outclk(qpll0outclk),
      .qpll0outrefclk(qpll0outrefclk),
      .qpll0reset(qpll0reset[i]),
      .reset_counter_done(reset_counter_done),
      .xgmii_txd(xgmii_txd),
      .xgmii_txc(xgmii_txc),
      .xgmii_rxd(xgmii_rxd),
      .xgmii_rxc(xgmii_rxc),
      .txp(txp[i]),
      .txn(txn[i]),
      .rxp(rxp[i]),
      .rxn(rxn[i]),
      .core_status(core_status),
      .tx_resetdone(tx_resetdone_int),
      .rx_resetdone(rx_resetdone_int),
      .signal_detect(signal_detect),
      .tx_fault(tx_fault),
      .drp_req(drp_req),
      .drp_gnt(drp_gnt),
      .core_to_gt_drpen(core_to_gt_drpen),
      .core_to_gt_drpwe(core_to_gt_drpwe),
      .core_to_gt_drpaddr(core_to_gt_drpaddr),
      .core_to_gt_drpdi(core_to_gt_drpdi),
      .core_to_gt_drprdy(core_to_gt_drprdy),
      .core_to_gt_drpdo(core_to_gt_drpdo),
      .gt_drprdy(drprdyx),
      .gt_drpdo(drpdox),
      .gt_drpen(drpc?core_to_gt_drpen:drpen),
      .gt_drpwe(drpc?core_to_gt_drpwe:drpwe),
      .gt_drpaddr(drpc?core_to_gt_drpaddr:drpaddr),
      .gt_drpdi(drpc?core_to_gt_drpdi:drpdi),
      .gt_dmonitorout(dmondox),
      .pma_pmd_type(pma_pmd_type),
      .tx_disable(tx_disable)
  );

  end
  end
  endgenerate

  reg sss; always @(posedge sclk) sss <= !sss;
  reg rrr; always @(posedge rclk) rrr <= !rrr;
  reg ttt; always @(posedge tclk) ttt <= !ttt;
  reg ddd; always @(posedge coreclk) ddd <= !ddd;
//  assign testout = {rtval,rtena,rtrdyi,rtrdd};
//  assign testout = {isel[6],isel[4],irdy[0],iena[0],irdys};
//  assign testout = {ddd,ttt,rrr,sss};

  assign dbgout = 0;
//  assign dbgsys = {16'hF0F0,drp_req,drp_gnt,tx_fault,tx_disable,reset,tx_resetdone_int,reset_counter_done,signal_detect,core_status};
//  assign testout = {gttxreset,gtrxreset,tval,rval,ttt,rrr,xgmii_rxc[0],reset};

endmodule

/*
 resynchronize Rx and Tx streams by stuffing comma frames (note: must be at least 3x4by between packets)

 ictl	0	C	F	F	F	F	3
 idat			F7	F7	F7	F7	
 iena	1	1	1	1	1	0	1
 icnt	5	6	7	8	9	10	10

 octl	0	7	15	15	15	15
 odat			F7	F7	F7	F7
 oena	1	1	0	0	1	1
 ocnt	5	6	7	7	7	8

*/

module  rsfifo (iclk,ictl,idat, oclk,octl,odat);

input iclk;  input [3:0] ictl;  input [31:0] idat;
input oclk; output [3:0] octl; output [31:0] odat;

wire H=1;
reg [7:0] icnt,ocnt;
wire [7:0] diff = icnt-ocnt;
reg [2:0] icoms,ocoms,idifs,odifs;
wire icom = (ictl==15);
wire ocom = (octl==15);
wire iena = !( (icoms==7) && icom && (idifs==7) );
wire oena = !( ocom && (odifs==7) );
always @(posedge iclk) begin
  icoms <= {icom,icoms[2:1]};
  idifs <= {diff[7:6]>2,idifs[2:1]};
  if (iena) icnt <= icnt+1;
end
always @(posedge oclk) begin
  odifs <= {diff[7:6]<1,odifs[2:1]};
  if (oena) ocnt <= ocnt+1;
end
sdpram #(1,36,36) dp (iclk,H, icnt,iena, {ictl,idat},   oclk,oena, ocnt,{octl,odat});
endmodule


`define CRC_2BYTE_INIT 1

`include "crc32.v"
