module
resengine
(
sclk
,
srst
,
scs
,
saddr
,
swr
,
swrbus
,
srd
,
srdbus
,
sack
,
ioclk
,
istat
,
iena
,
isel
,
ibus
,
ostat
,
oena
,
osel
,
obus
,
test
);
parameter
PORT
=
1
;
parameter
IBW
=
64
;
parameter
TAPS
=
10
;
parameter
DBW
=
16
;
parameter
GBW
=
4
;
parameter
RBW
=
4
;
localparam
SBW
=
GBW
+
DBW
+
RBW
;
input
sclk
;
input
srst
;
input
scs
;
input
swr
;
input
srd
;
input
[
31
:
0
]
saddr
;
input
[
31
:
0
]
swrbus
;
output
[
31
:
0
]
srdbus
;
output
sack
;
input
ioclk
;
output
istat
;
input
iena
;
input
[
7
:
0
]
isel
;
input
[
IBW
-
1
:
0
]
ibus
;
output
ostat
;
input
oena
;
output
[
7
:
0
]
osel
;
output
[
IBW
-
1
:
0
]
obus
;
output
[
7
:
0
]
test
;
wire
z1
=
0
,
z2
=
1
;
assign
sack
=
z2
;
wire
[
DBW
-
1
:
0
]
z3
;
wire
[
DBW
-
1
:
0
]
z4
;
wire
z5
,
z6
,
z7
;
reg
z8
,
z9
,
z10
,
z11
;
reg
[
31
:
0
]
z12
;
always
@(
posedge
ioclk
)
z10
<=
iena
;
reg
z13
,
z14
,
z15
,
z16
,
z17
;
always
@(
posedge
sclk
)
begin
z13
<=
scs
&&
swr
&&
saddr
[
3
:
0
]==
0
;
z17
<=
scs
&&
swr
&&
saddr
[
3
:
0
]==
3
;
z16
<=
scs
&&
swr
&&
saddr
[
3
:
0
]==
4
;
z14
<=
scs
&&
swr
&&
saddr
[
3
:
0
]==
14
;
z15
<=
scs
&&
swr
&&
saddr
[
3
:
0
]==
15
;
z8
<=
z6
&&
z5
;
z9
<=
z8
;
z11
<=
!
z12
[
0
]
||
srst
;
if
(
z13
)
z12
<=
swrbus
;
end
wire
z18
=
z12
[
2
];
wire
z19
=
z12
[
3
];
wire
[
SBW
-
1
:
0
]
z20
,
z21
;
wire
z22
,
z23
;
fifoNxM
#
(
IBW
,
DBW
)
fin
(
ioclk
,
z11
,
istat
,
z10
,
ibus
,
sclk
,
z11
,
z6
,
z8
,
z3
);
resfilter
#
(
TAPS
,
DBW
,
DBW
,
DBW
,
GBW
,
RBW
)
res
(
sclk
,
z11
,
z1
,
z16
,
z17
,
z14
,
z15
,
swrbus
,
z5
,
z9
,
z3
,
z7
,
z22
,
z20
);
roundN2Mc
#
(
SBW
,
DBW
,
GBW
)
rnd
(
z20
,
z21
,
z18
,
z19
,
sclk
,
z23
);
reg
z24
;
always
@(
posedge
sclk
)
z24
<=
z22
;
assign
z4
=
z21
[
RBW
+
DBW
-
1
:
RBW
];
fifoNxM
#
(
DBW
,
IBW
)
fout
(
sclk
,
z11
,
z7
,
z24
,
z4
,
ioclk
,
z11
,
ostat
,
oena
,
obus
);
endmodule
module
resfilter
(
clk
,
srst
,
byp
,
srat
,
srep
,
rload
,
cload
,
sbus
,
z5
,
vin
,
din
,
wrdy
,
vout
,
dout
);
parameter
TAPS
=
10
;
parameter
IBW
=
16
;
parameter
CBW
=
16
;
parameter
OBW
=
16
;
parameter
GBW
=
4
;
parameter
RBW
=
4
;
parameter
CHN
=
2
;
parameter
FD
=
5
;
localparam
PBW
=
IBW
+
CBW
-
1
;
localparam
QBW
=
OBW
+
RBW
;
localparam
SBW
=
OBW
+
GBW
+
RBW
;
localparam
HTAPS
=
TAPS
/
2
;
localparam
IBWN
=
IBW
*
CHN
;
localparam
OBWN
=
OBW
*
CHN
;
localparam
FMX
=(
1
<
FD
)-
1
;
input
clk
,
srst
,
byp
;
input
srat
,
srep
,
rload
,
cload
;
input
[
31
:
0
]
sbus
;
output
z5
;
input
vin
;
input
[
IBWN
-
1
:
0
]
din
;
input
wrdy
;
output
reg
vout
;
output
reg
[
OBWN
-
1
:
0
]
dout
;
wire
z1
=
0
,
z2
=
1
;
wire
[
IBWN
-
1
:
0
]
z25
;
reg
z26
,
z27
,
z28
,
z29
,
z30
,
z31
,
z32
,
z33
;
reg
z34
,
z5
,
z35
,
z36
,
z37
,
z38
,
z39
;
reg
[
29
:
0
]
z40
,
z41
;
reg
[
FD
-
1
:
0
]
z42
;
reg
[
1
:
0
]
z43
;
wire
[
1
:
0
]
z44
=
z40
[
29
:
28
];
wire
[
10
:
0
]
z45
=
z40
[
27
:
17
];
reg
[
10
:
0
]
z46
;
reg
[
FD
-
1
:
0
]
z47
;
always
@(
posedge
clk
)
begin
z33
<=
srst
;
if
(
z33
)
z47
<=
0
;
else
if
(
z29
&!
vin
)
z47
<=
z47
-
1
;
else
if
(!
z29
&
vin
)
z47
<=
z47
+
1
;
z5
<=
(
z47
<
z42
)
||
(
z47
==
FMX
)
||
byp
;
z34
<=
(
z47
>
4
)
&&
(
z47
!=
FMX
);
z32
<=
vin
;
z27
<=
(
TAPS
==
0
)
||
byp
;
end
srlMxN
#
(
FD
,
IBWN
)
fifo
(
clk
,
vin
,
z47
,
din
,
z25
);
reg
[
15
:
0
]
z48
,
z49
,
z50
;
always
@(
posedge
clk
)
begin
if
(
srat
)
z41
<=
sbus
[
29
:
0
];
if
(
srep
)
z48
<=
sbus
[
31
:
16
];
if
(
srep
)
z49
<=
sbus
[
15
:
0
];
z31
<=
srep
||
z33
||
(
z48
==
0
);
if
(
rload
)
z42
<=
(
sbus
[
FD
-
1
:
0
]==
0
)?
(
FMX
>>
1
)
:
sbus
[
FD
-
1
:
0
];
end
wire
[
CBW
-
1
:
0
]
z51
=
sbus
[
32
-
1
:
32
-
CBW
];
reg
[
1
:
0
]
z52
;
wire
[
1
:
0
]
z53
=
(
z44
-
z43
);
wire
[
1
:
0
]
z54
=
z33
?
2'b0
:
(
z52
+
z49
[
1
:
0
]);
wire
z55
=
z26
&&
(
z53
!=
0
);
wire
z56
=
z26
&&
(
z53
<
2
);
wire
z57
=
(
z50
==
1
);
wire
z58
=
z33
||
(
z57
&&
z56
);
wire
z59
=
z31
||
(
z57
&&
z56
);
always
@(
posedge
clk
)
begin
if
(
z33
)
z52
<=
0
;
else
if
(
z58
)
z52
<=
z54
;
if
(
z58
)
z40
<=
{
z54
,
28'b0
};
else
if
(
z56
)
z40
<=
z40
+
z41
;
if
(
z59
)
z50
<=
z48
;
else
if
(
z56
)
z50
<=
z50
-
1
;
if
(
z33
)
z43
<=
3
;
else
if
(
z55
)
z43
<=
z43
+
1
;
end
wire
z60
;
always
@(
posedge
clk
)
begin
z26
<=
z34
&&
wrdy
&&
!
z60
;
if
(
z33
)
z35
<=
0
;
else
z35
<=
z56
;
if
(
z33
)
z28
<=
0
;
else
z28
<=
z55
;
if
(
z33
)
z29
<=
0
;
else
z29
<=
z28
;
if
(
z56
)
z46
<=
z45
;
z30
<=
cload
;
z36
<=
z35
;
z37
<=
z36
;
z38
<=
z37
;
z39
<=
z38
;
end
wire
z61
;
wire
signed
[
SBW
-
1
:
0
]
z62
,
z63
;
genvar
i
;
generate
if
(
TAPS
==
8
)
begin
:
tapn
reg
[
2
:
0
]
z64
,
z65
;
reg
[
10
:
0
]
z66
,
z67
;
reg
[
2
:
0
]
z68
,
z69
;
reg
z70
,
z71
,
z72
,
z73
;
always
@(
posedge
clk
)
begin
z73
<=
z56
||
(
z73
&&
z64
!=
5
);
z70
<=
z56
||
(
z70
&&
z64
!=
7
);
if
(!
z70
)
z64
<=
0
;
else
z64
<=
z64
+
1
;
if
(
rload
)
z66
<=
0
;
else
if
(
z70
)
z66
<=
z64
[
2
]?
{~
z64
[
1
:
0
],~
z46
[
10
:
3
]}
:
{
z64
[
1
:
0
],
z46
[
10
:
3
]};
else
if
(
z30
)
z66
<=
z66
+
1
;
z68
<=
z64
[
2
]?
~
z46
[
2
:
0
]
:
z46
[
2
:
0
];
z69
<=
z68
;
z65
<=
z64
;
z71
<=
z70
;
z72
<=
z71
;
z67
<=
z66
;
end
assign
z60
=
z73
||
z26
;
`ifdef TFDD_RINTERP
wire
signed
[
CBW
-
1
:
0
]
z74
,
z75
,
z76
,
z77
;
wire
[
CBW
-
1
:
0
]
z78
=
z51
;
wire
[
CBW
-
1
:
0
]
z79
=
z51
-
cind
;
reg
[
CBW
-
1
:
0
]
z80
;
always
@(
posedge
clk
)
if
(
z30
)
z80
<=
z51
;
spram
#
(
2
,
CBW
)
inst
(
clk
,
z2
,
z66
,
z30
,
z78
,
z75
);
spram
#
(
2
,
CBW
)
intr
(
clk
,
z2
,
z66
,
z30
,
z79
,
z76
);
assign
z77
=
z76
*
z69
;
assign
z74
=
z75
+
(
z77
>>>
3
);
`else
wire
signed
[
CBW
-
1
:
0
]
z74
;
spram
#
(
2
,
CBW
)
inst
(
clk
,
z2
,
z66
,
z30
,
z51
,
z74
);
`endif
wire
[
IBWN
-
1
:
0
]
z81
;
srl16xNp
#
(
IBWN
)
tapd
(
clk
,
z28
,
z65
,
z25
,
z81
);
wire
signed
[
QBW
-
1
:
0
]
z82
,
z83
;
srmul
#
(
IBW
,
CBW
,
QBW
,
2
)
prodr
(
z81
[
1
*
IBW
-
1
:
1
*
IBW
-
IBW
],
z74
,
z82
,
clk
,
z2
);
srmul
#
(
IBW
,
CBW
,
QBW
,
2
)
prodi
(
z81
[
2
*
IBW
-
1
:
2
*
IBW
-
IBW
],
z74
,
z83
,
clk
,
z2
);
sum1
#
(
QBW
,
SBW
)
smr
(
clk
,
z39
,
z82
,
z62
);
sum1
#
(
QBW
,
SBW
)
smi
(
clk
,
z39
,
z83
,
z63
);
srl16xNp
vod
(
clk
,
z2
,
4'h7
,
z39
,
z61
);
end
if
(
TAPS
==
10
)
begin
:
tapw
reg
[
13
:
0
]
z84
,
z85
;
always
@(
posedge
clk
)
begin
if
(
rload
)
z84
<=
0
;
else
if
(
z35
)
z84
<=
{
z1
,
z1
,
z1
,~
z46
};
else
if
(
z30
)
z84
<=
z84
+
1
;
if
(
z35
)
z85
<=
{
z1
,
z1
,
z1
,
z46
};
end
assign
z60
=
z1
;
reg
[
IBWN
-
1
:
0
]
z81
[
TAPS
:
0
];
wire
signed
[
CBW
-
1
:
0
]
z74
[
TAPS
:
0
];
for
(
i
=
0
;
i
<
HTAPS
;
i
=
i
+
1
)
begin
:
cram
reg
z86
;
always
@(
posedge
clk
)
z86
<=
cload
&&
(
z84
[
13
:
11
]==
i
);
dpram
#
(
4
,
CBW
,
CBW
)
inst
(
clk
,
z2
,
z84
[
10
:
0
],
z86
,
z51
,
z74
[
i
],
clk
,
z2
,
z85
[
10
:
0
],
z1
,
18'b0
,
z74
[
TAPS
-
1
-
i
]);
end
wire
signed
[
QBW
-
1
:
0
]
z82
[
TAPS
-
1
:
0
],
z83
[
TAPS
-
1
:
0
];
for
(
i
=
0
;
i
<
TAPS
;
i
=
i
+
1
)
begin
:
tap
always
@(
posedge
clk
)
if
(
z29
)
z81
[
i
]
<=
(
i
+
1
<
TAPS
)?
z81
[
i
+
1
]
:
z25
;
srmul
#
(
IBW
,
CBW
,
QBW
,
2
)
prodr
(
z81
[
i
][
1
*
IBW
-
1
:
1
*
IBW
-
IBW
],
z74
[
i
],
z82
[
i
],
clk
,
z2
);
srmul
#
(
IBW
,
CBW
,
QBW
,
2
)
prodi
(
z81
[
i
][
2
*
IBW
-
1
:
2
*
IBW
-
IBW
],
z74
[
i
],
z83
[
i
],
clk
,
z2
);
end
sum10
#
(
QBW
,
SBW
)
smr
(
clk
,
z82
[
0
],
z82
[
1
],
z82
[
2
],
z82
[
3
],
z82
[
4
],
z82
[
5
],
z82
[
6
],
z82
[
7
],
z82
[
8
],
z82
[
9
],
z62
);
sum10
#
(
QBW
,
SBW
)
smi
(
clk
,
z83
[
0
],
z83
[
1
],
z83
[
2
],
z83
[
3
],
z83
[
4
],
z83
[
5
],
z83
[
6
],
z83
[
7
],
z83
[
8
],
z83
[
9
],
z63
);
srl16xNp
vod
(
clk
,
z2
,
4'h5
,
z36
,
z61
);
end
endgenerate
wire
z87
,
z88
;
wire
[
SBW
-
1
:
0
]
z89
,
z90
;
roundN2Mc
#
(
SBW
,
OBW
,
GBW
)
cvtr
(
z62
,
z89
,
z2
,
z2
,
clk
,
z87
);
roundN2Mc
#
(
SBW
,
OBW
,
GBW
)
cvti
(
z63
,
z90
,
z2
,
z2
,
clk
,
z88
);
always
@(
posedge
clk
)
begin
vout
<=
z27
?
vin
:
z61
;
dout
<=
z27
?
{
din
[
IBWN
-
1
:
IBWN
-
OBW
],
din
[
IBW
-
1
:
IBW
-
OBW
]}
:
{
z90
[
QBW
-
1
:
QBW
-
OBW
],
z89
[
QBW
-
1
:
QBW
-
OBW
]};
end
endmodule
module
sum10
(
clk
,
in0
,
in1
,
in2
,
in3
,
in4
,
in5
,
in6
,
in7
,
in8
,
in9
,
out
);
parameter
IBW
=
16
;
parameter
OBW
=
16
;
input
clk
;
input
signed
[
IBW
-
1
:
0
]
in0
,
in1
,
in2
,
in3
,
in4
,
in5
,
in6
,
in7
,
in8
,
in9
;
output
signed
[
OBW
-
1
:
0
]
out
;
reg
signed
[
OBW
-
1
:
0
]
z91
[
7
:
0
],
z92
;
always
@(
posedge
clk
)
begin
z91
[
0
]
<=
in0
+
in9
;
z91
[
1
]
<=
in1
+
in8
;
z91
[
2
]
<=
in2
+
in7
;
z91
[
3
]
<=
in3
+
in6
;
z91
[
4
]
<=
in4
+
in5
;
z91
[
5
]
<=
z91
[
0
]+
z91
[
1
]+
z91
[
2
];
z91
[
6
]
<=
z91
[
3
]+
z91
[
4
];
z92
<=
z91
[
5
]+
z91
[
6
];
end
endmodule
module
sum1
(
clk
,
init
,
in0
,
z92
);
parameter
IBW
=
16
;
parameter
OBW
=
16
;
input
clk
,
init
;
input
signed
[
IBW
-
1
:
0
]
in0
;
output
signed
[
OBW
-
1
:
0
]
z92
;
reg
signed
[
OBW
-
1
:
0
]
z93
;
always
@(
posedge
clk
)
begin
if
(
init
)
z93
<=
in0
;
else
z93
<=
z93
+
in0
;
end
assign
z92
=
z93
;
endmodule
