module
r2cengine
(
sclk
,
srst
,
scs
,
saddr
,
swr
,
swrbus
,
srd
,
srdbus
,
sack
,
ioclk
,
istat
,
iena
,
isel
,
ibus
,
ostat
,
oena
,
osel
,
obus
,
test
);
parameter
PORT
=
1
;
parameter
IBW
=
64
;
parameter
DBW
=
32
;
parameter
CBW
=
18
;
`ifdef R2C_TAPS
parameter
TAPS
=`R2C_TAPS
;
`else
parameter
TAPS
=
64
;
`endif
`ifdef R2C_I2X
localparam
NPC
=
2
;
`else
localparam
NPC
=
1
;
`endif
input
sclk
;
input
srst
;
input
scs
;
input
swr
;
input
srd
;
input
[
31
:
0
]
saddr
;
input
[
31
:
0
]
swrbus
;
output
[
31
:
0
]
srdbus
;
output
sack
;
input
ioclk
;
output
istat
;
input
iena
;
input
[
7
:
0
]
isel
;
input
[
IBW
-
1
:
0
]
ibus
;
output
ostat
;
input
oena
;
output
[
7
:
0
]
osel
;
output
[
IBW
-
1
:
0
]
obus
;
output
[
7
:
0
]
test
;
wire
z1
=
0
,
z2
=
1
;
assign
sack
=
z2
;
wire
[
NPC
*
DBW
-
1
:
0
]
z3
;
wire
[
NPC
*
DBW
-
1
:
0
]
z4
,
z5
,
z6
;
reg
[
NPC
*
DBW
-
1
:
0
]
z7
;
reg
z8
,
z9
,
z10
,
z11
;
reg
[
31
:
0
]
z12
,
z13
,
z14
,
z15
;
wire
z16
,
z17
,
z18
,
z19
,
z20
,
z21
,
z22
;
statusblk
#
(
"R2C"
,
TAPS
)
ss
(
sclk
,
scs
,
saddr
,
swr
,
swrbus
,
srd
,
srdbus
);
wire
[
7
:
0
]
z23
;
swrbank
#
(
0
,
8
)
swb
(
sclk
,
scs
,
swr
,
saddr
,
z23
);
wire
z24
=
z23
[
0
];
wire
z25
=
z23
[
1
];
wire
z26
=
z23
[
5
];
wire
z27
=
z23
[
6
];
wire
z28
=
z23
[
7
];
always
@(
posedge
sclk
)
begin
if
(
srst
)
z12
<=
0
;
else
if
(
z24
)
z12
<=
swrbus
;
if
(
srst
)
z13
<=
0
;
else
if
(
z25
)
z13
<=
swrbus
;
if
(
srst
)
z15
<=
0
;
else
if
(
z26
)
z15
<=
swrbus
;
if
(
srst
)
z14
<=
0
;
else
if
(
z28
)
z14
<=
swrbus
;
end
wire
z29
=
z14
[
0
];
wire
z30
=
z14
[
1
];
wire
z31
=
!
z12
[
0
];
wire
z32
=
z12
[
2
];
wire
z33
=
z12
[
3
];
wire
[
3
:
0
]
z34
=
z12
[
11
:
8
];
wire
[
3
:
0
]
z35
=
z12
[
15
:
12
];
wire
z36
=
z32
?
z34
[
3
]
:
z2
;
assign
z18
=
z32
?
z19
:
z9
;
always
@(
posedge
sclk
)
begin
z9
<=
z16
&&
z17
;
z10
<=
z18
;
z11
<=
z30
?
z22
:
z32
?
z21
:
z20
;
z7
<=
z30
?
z6
:
z32
?
z5
:
z4
;
end
always
@(
posedge
ioclk
)
z8
<=
iena
;
`ifdef R2C_I2X
fifoNxM
#
(
IBW
,
NPC
*
DBW
)
fi
(
ioclk
,
z31
,
istat
,
z8
,
ibus
,
sclk
,
z31
,
z16
,
z18
,
z3
);
r2cfilter
#
(
DBW
/
2
,
CBW
,
DBW
/
2
,
TAPS
,
NPC
)
fir
(
sclk
,
z31
,
freq
,
z29
,
z10
,
z3
,
z20
,
z4
);
fifoNxM
#
(
NPC
*
DBW
,
IBW
)
fo
(
sclk
,
z31
,
z17
,
z11
,
z7
,
ioclk
,
z31
,
ostat
,
oena
,
obus
);
`else
fifoNxMfmt
#
(
IBW
,
DBW
,
0
,
NPC
)
fi
(
ioclk
,
z31
,
{
z36
,
z34
[
2
:
0
]},
istat
,
z8
,
ibus
,
sclk
,
z31
,
{
z33
,
4'h8
},
z16
,
z18
,
z3
);
r2cfilter
#
(
DBW
/
2
,
CBW
,
DBW
/
2
,
TAPS
,
NPC
)
fir
(
sclk
,
z31
,
!
z30
,
z29
,
z10
,
z3
,
z20
,
z4
);
cxtuner
#
(
DBW
/
2
,
16
,
DBW
/
2
)
cxt
(
sclk
,
z31
,
z27
,
z1
,
swrbus
,
z20
,
z4
,
z22
,
z6
);
z32
#
(
DBW
)
nop
(
sclk
,
z31
,
z2
,
z13
,
z15
,
z1
,
z1
,
z1
,
z16
,
z19
,
z3
,
z17
,
z21
,
z5
);
fifoNxMfmti
#
(
IBW
,
DBW
)
fo
(
ioclk
,
z31
,
z35
,
ostat
,
oena
,
obus
,
sclk
,
z31
,
4'h8
,
z17
,
z11
,
z7
);
`endif
assign
test
=
0
;
endmodule
module
r2cfilter
(
clk
,
rst
,
rot
,
inv
,
vin
,
din
,
vout
,
dout
);
parameter
IBW
=
16
;
parameter
CBW
=
18
;
parameter
OBW
=
16
;
parameter
TAPS
=
64
;
parameter
NPC
=
1
;
localparam
HTAP
=
TAPS
/
2
;
localparam
ORDER
=
3
;
localparam
GBW
=
4
;
localparam
RBW
=
8
;
localparam
QBW
=
OBW
+
RBW
;
localparam
PBW
=
IBW
+
CBW
+
1
;
localparam
SBW
=
OBW
+
GBW
+
RBW
-
1
;
localparam
XBW
=
18
;
localparam
YBW
=
XBW
+
16
;
localparam
IBW2
=
IBW
*
2
;
localparam
OBW2
=
OBW
*
2
;
input
clk
,
rst
;
input
rot
;
input
inv
;
input
vin
;
input
[
NPC
*
IBW2
-
1
:
0
]
din
;
output
reg
vout
;
output
reg
[
NPC
*
OBW2
-
1
:
0
]
dout
;
wire
z1
=
0
,
z2
=
1
;
wire
[
4
:
0
]
z37
=
(
NPC
<=
1
)?
HTAP
-
1
:
HTAP
/
NPC
;
wire
z38
,
z39
,
z40
;
srlMxN
#
(
5
,
1
)
vtapd
(
clk
,
rst
|
vin
,
z37
,
!
rst
,
z38
);
delaypipe
#
(
7
)
vacud
(
clk
,
vin
&
z38
,
z39
);
delaypipe
#
(
9
)
vacuf
(
clk
,
vin
&
z38
,
z40
);
reg
z41
;
always
@(
posedge
clk
)
begin
if
(
rst
)
z41
<=
0
;
else
if
(
z40
)
z41
<=
!
z41
;
vout
<=
z40
;
end
wire
[
CBW
-
1
:
0
]
z42
[
HTAP
-
1
:
0
];
generate
if
(
TAPS
==
64
)
begin
:
t64
assign
z42
[
00
]
=
3
;
assign
z42
[
01
]
=
7
;
assign
z42
[
02
]
=
15
;
assign
z42
[
03
]
=
27
;
assign
z42
[
04
]
=
45
;
assign
z42
[
05
]
=
71
;
assign
z42
[
06
]
=
107
;
assign
z42
[
07
]
=
156
;
assign
z42
[
08
]
=
220
;
assign
z42
[
09
]
=
303
;
assign
z42
[
10
]
=
410
;
assign
z42
[
11
]
=
543
;
assign
z42
[
12
]
=
709
;
assign
z42
[
13
]
=
912
;
assign
z42
[
14
]
=
1159
;
assign
z42
[
15
]
=
1457
;
assign
z42
[
16
]
=
1814
;
assign
z42
[
17
]
=
2239
;
assign
z42
[
18
]
=
2744
;
assign
z42
[
19
]
=
3344
;
assign
z42
[
20
]
=
4057
;
assign
z42
[
21
]
=
4908
;
assign
z42
[
22
]
=
5932
;
assign
z42
[
23
]
=
7180
;
assign
z42
[
24
]
=
8729
;
assign
z42
[
25
]
=
10706
;
assign
z42
[
26
]
=
13327
;
assign
z42
[
27
]
=
17005
;
assign
z42
[
28
]
=
22627
;
assign
z42
[
29
]
=
32500
;
assign
z42
[
30
]
=
55098
;
assign
z42
[
31
]
=
166709
;
end
if
(
TAPS
==
48
)
begin
:
t48
assign
z42
[
00
]
=
0
;
assign
z42
[
01
]
=
2
;
assign
z42
[
02
]
=
9
;
assign
z42
[
03
]
=
20
;
assign
z42
[
04
]
=
37
;
assign
z42
[
05
]
=
61
;
assign
z42
[
06
]
=
91
;
assign
z42
[
07
]
=
129
;
assign
z42
[
08
]
=
175
;
assign
z42
[
09
]
=
230
;
assign
z42
[
10
]
=
297
;
assign
z42
[
11
]
=
375
;
assign
z42
[
12
]
=
469
;
assign
z42
[
13
]
=
579
;
assign
z42
[
14
]
=
712
;
assign
z42
[
15
]
=
872
;
assign
z42
[
16
]
=
1070
;
assign
z42
[
17
]
=
1320
;
assign
z42
[
18
]
=
1651
;
assign
z42
[
19
]
=
2114
;
assign
z42
[
20
]
=
2820
;
assign
z42
[
21
]
=
4057
;
assign
z42
[
22
]
=
6884
;
assign
z42
[
23
]
=
20837
;
end
endgenerate
reg
signed
[
IBW
-
1
:
0
]
z43
[
TAPS
-
1
+
NPC
:
0
];
genvar
n
,
i
,
j
;
generate
for
(
n
=
0
;
n
<
NPC
;
n
=
n
+
1
)
begin
:
chx
localparam
m
=
(
NPC
<=
1
)?
0
:
(
n
==
0
)?
1
:
0
;
localparam
l
=
(
NPC
<=
1
)?
0
:
(
n
==
0
)?
2
:
1
;
reg
signed
[
IBW
:
0
]
z44
[
HTAP
-
1
:
0
];
wire
signed
[
PBW
-
1
:
0
]
z45
[
HTAP
-
1
:
0
];
wire
signed
[
QBW
-
1
:
0
]
z46
[
HTAP
-
1
:
0
];
wire
signed
[
SBW
-
1
:
0
]
z47
[
HTAP
-
1
:
0
];
reg
signed
[
SBW
-
1
:
0
]
z48
[
HTAP
-
1
:
0
][
ORDER
+
1
:
0
];
reg
signed
[
SBW
-
1
:
0
]
z49
;
wire
signed
[
IBW
-
1
:
0
]
z50
,
z51
;
wire
signed
[
OBW
-
1
:
0
]
z52
;
srlMxN
#
(
5
,
IBW
)
dtapd
(
clk
,
vin
,
z37
,
din
[
IBW
-
1
+
n
*
IBW2
:
0
+
n
*
IBW2
],
z50
);
delaypipe
#
(
9
,
1
,
IBW
)
dacud
(
clk
,
z50
,
z51
);
for
(
i
=
0
;
i
<=
TAPS
;
i
=
i
+
NPC
)
begin
:
dat
always
@(
posedge
clk
)
if
(
vin
)
z43
[
i
+
n
]
<=
(
i
==
0
)?
din
[
IBW2
-
1
+
m
*
IBW2
:
IBW
+
m
*
IBW2
]
:
z43
[
i
+
n
-
NPC
];
end
for
(
i
=
0
;
i
<
HTAP
;
i
=
i
+
1
)
begin
:
tap
always
@(
posedge
clk
)
z44
[
i
]
<=
z43
[
TAPS
-
1
-
i
+
l
]
-
z43
[
i
+
l
];
wire
signed
[
CBW
:
0
]
z53
=
{
z1
,
z42
[
i
]};
assign
z45
[
i
]
=
z44
[
i
]
*
z53
;
assign
z46
[
i
]
=
z45
[
i
][
PBW
-
1
:
PBW
-
OBW
-
RBW
];
assign
z47
[
i
]
=
z46
[
i
];
always
@(
posedge
clk
)
z48
[
i
][
0
]
<=
z47
[
i
];
end
for
(
i
=
0
;
i
<
HTAP
/
2
;
i
=
i
+
1
)
begin
:
treeA
always
@(
posedge
clk
)
z48
[
i
][
1
]
<=
z48
[
i
+
i
][
0
]
+
z48
[
i
+
i
+
1
][
0
];
end
for
(
i
=
0
;
i
<
HTAP
/
4
;
i
=
i
+
1
)
begin
:
treeB
always
@(
posedge
clk
)
z48
[
i
][
2
]
<=
z48
[
i
+
i
][
1
]
+
z48
[
i
+
i
+
1
][
1
];
end
for
(
i
=
0
;
i
<
HTAP
/
8
;
i
=
i
+
1
)
begin
:
treeC
always
@(
posedge
clk
)
z48
[
i
][
3
]
<=
z48
[
i
+
i
][
2
]
+
z48
[
i
+
i
+
1
][
2
];
end
for
(
i
=
0
;
i
<
HTAP
/
16
;
i
=
i
+
1
)
begin
:
treeD
always
@(
posedge
clk
)
z48
[
i
][
4
]
<=
z48
[
i
+
i
][
3
]
+
z48
[
i
+
i
+
1
][
3
];
end
always
@(
posedge
clk
)
z49
<=
(
TAPS
==
48
)?
z48
[
0
][
3
]
+
z48
[
1
][
3
]
+
z48
[
2
][
3
]
:
z48
[
0
][
4
]
+
z48
[
1
][
4
];
wire
z54
;
wire
[
SBW
-
1
:
0
]
z55
;
roundN2Mc
#
(
SBW
,
OBW
,
GBW
,
2
)
cvt
(
z49
,
z55
,
z2
,
z2
,
clk
,
z54
);
assign
z52
=
z55
[
SBW
-
GBW
-
1
:
SBW
-
GBW
-
OBW
];
wire
z56
=
(
NPC
<=
1
)?
z41
:
(
n
%
2
==
1
);
wire
[
OBW2
-
1
:
0
]
z57
=
(
z56
&&
rot
)?
{-
z52
,-
z51
}:{
z52
,
z51
};
always
@(
posedge
clk
)
begin
dout
[
OBW2
-
1
+
n
*
OBW2
:
n
*
OBW2
]
<=
inv
?
{
z57
[
OBW
-
1
:
0
],
z57
[
OBW2
-
1
:
OBW
]}
:
z57
;
end
end
endgenerate
endmodule
