`include "../lib/firdefs.h"
`include "../lib/ramdefs.h"
module
qtfdengine
(
sclk
,
rst
,
scs
,
saddr
,
swr
,
swrbus
,
srd
,
srdbus
,
sack
,
ioclk
,
istat
,
iena
,
isel
,
ibus
,
ostat
,
oena
,
osel
,
obus
,
test
);
parameter
PORT
=
1
;
parameter
IBW
=
64
;
parameter
DBW
=
16
;
parameter
EBW
=
8
;
parameter
GBW
=
6
;
parameter
RBW
=
12
;
`ifdef QFIR_ORDER
parameter
ORDER
=`QFIR_ORDER
;
`else
parameter
ORDER
=
5
;
`endif
parameter
WIDTH
=
8
;
parameter
WDBW
=
WIDTH
*
DBW
;
parameter
WEBW
=
WIDTH
*
EBW
;
input
sclk
;
input
rst
;
input
scs
;
input
swr
;
input
srd
;
input
[
31
:
0
]
saddr
;
input
[
31
:
0
]
swrbus
;
output
[
31
:
0
]
srdbus
;
output
sack
;
input
ioclk
;
output
istat
;
input
iena
;
input
[
7
:
0
]
isel
;
input
[
IBW
-
1
:
0
]
ibus
;
output
ostat
;
input
oena
;
output
[
7
:
0
]
osel
;
output
[
IBW
-
1
:
0
]
obus
;
output
[
7
:
0
]
test
;
wire
z1
=
0
,
z2
=
1
;
assign
sack
=
z2
;
wire
z3
=
sclk
;
statusblk
#
(
"QTFD"
,
ORDER
,
WIDTH
)
ss
(
sclk
,
scs
,
saddr
,
swr
,
swrbus
,
srd
,
srdbus
);
wire
[
15
:
0
]
z4
;
swrbank
#
(
0
,
16
)
swb
(
sclk
,
scs
,
swr
,
saddr
,
z4
);
wire
z5
=
z4
[
0
];
wire
z6
=
z4
[
1
];
wire
z7
=
z4
[
6
];
wire
z8
=
z4
[
12
];
wire
z9
=
z4
[
13
];
reg
z10
;
reg
[
31
:
0
]
z11
,
z12
;
reg
[
3
:
0
]
z13
;
reg
[
1
:
0
]
z14
,
z15
;
reg
[
7
:
0
]
z16
;
wire
[
7
:
0
]
z17
=
z12
[
31
:
24
];
always
@(
posedge
sclk
)
begin
if
(
z5
)
z11
<=
swrbus
;
z10
<=
!
z11
[
0
]
||
rst
;
if
(
z6
)
z13
<=
swrbus
[
3
:
0
];
z14
<=
(
z13
>=
7
)?
3
:
(
z13
>=
3
)?
2
:
(
z13
>=
1
)?
1
:
0
;
if
(
z7
)
z12
<=
swrbus
[
31
:
0
];
z16
<=
(
z17
<<
z14
);
end
wire
[
3
:
0
]
z18
=
z11
[
11
:
8
];
wire
[
3
:
0
]
z19
=
z11
[
15
:
12
];
wire
z20
=
!
z18
[
0
];
wire
z21
,
z22
,
z23
,
z24
;
reg
z25
,
z26
,
z27
,
z28
,
z29
,
z30
,
z31
,
z32
;
reg
[
2
:
0
]
z33
;
reg
[
7
:
0
]
z34
;
reg
[
7
:
0
]
z35
[
WIDTH
-
1
:
0
];
reg
[
WDBW
-
1
:
0
]
z36
;
wire
[
WDBW
-
1
:
0
]
z37
,
z38
,
z39
,
z40
,
z41
;
wire
[
31
:
0
]
z42
;
always
@(
posedge
sclk
)
z15
<=
z14
+
z20
;
wire
z43
;
mux4xN
mena
(
z43
,
(
z33
[
2
:
0
]==
0
),
(
z33
[
1
:
0
]==
0
),
(
z33
[
0
]==
0
),
z2
,
z15
);
always
@(
posedge
ioclk
)
z32
<=
iena
;
fifoNxM
#
(
IBW
,
WEBW
)
fi
(
ioclk
,
z10
,
istat
,
z32
,
ibus
,
z3
,
z10
,
z23
,
z30
,
z41
);
genvar
i
;
generate
for
(
i
=
0
;
i
<
WIDTH
;
i
=
i
+
1
)
begin
:
lane
assign
z39
[
i
*
DBW
+
DBW
-
1
:
i
*
DBW
]
=
{
z41
[
WEBW
-
i
*
8
-
1
:
WEBW
-
i
*
8
-
8
],
8'h0
};
assign
z40
[
i
*
DBW
+
DBW
-
1
:
i
*
DBW
]
=
z41
[
WDBW
-
i
*
DBW
-
1
:
WDBW
-
i
*
DBW
-
DBW
];
always
@(
posedge
sclk
)
z35
[
i
]
<=
(
i
==
0
)?
0
:
z35
[
i
-
1
]-
z17
;
qrot
lut
(
z3
,
z10
,
z8
,
swrbus
,
z28
,
z34
+
z35
[
i
],
z36
[
i
*
DBW
+
DBW
-
1
:
i
*
DBW
],
z37
[
i
*
DBW
+
DBW
-
1
:
i
*
DBW
],
z38
[
i
*
DBW
+
DBW
-
1
:
i
*
DBW
]);
end
endgenerate
always
@(
posedge
z3
)
begin
z25
<=
z23
&&
z24
&&
!
z10
;
z26
<=
z25
;
z27
<=
z26
;
z28
<=
z27
;
z29
<=
z28
;
z30
<=
z25
&&
z43
&&
!
z10
;
z31
<=
z30
;
if
(
z10
)
z33
<=
0
;
else
if
(
z25
)
z33
<=
z33
+
1
;
if
(
z10
)
z34
<=
0
;
else
if
(
z25
)
z34
<=
z34
+
z16
;
if
(
z27
)
z36
<=
z31
?
(
z20
?
z40
:
z39
)
:
(
z14
==
0
)?
{
z36
[
WDBW
-
1
*
DBW
-
1
:
0
],{
1
*
DBW
{
z1
}}}
:
(
z14
==
1
)?
{
z36
[
WDBW
-
2
*
DBW
-
1
:
0
],{
2
*
DBW
{
z1
}}}
:
{
z36
[
WDBW
-
4
*
DBW
-
1
:
0
],{
4
*
DBW
{
z1
}}};
end
qfilt
#
(
ORDER
,
WIDTH
,
DBW
,
DBW
,
DBW
,
GBW
,
RBW
,
0
)
rfir
(
z3
,
z10
,
z14
,
z9
,
swrbus
,
z29
,
z37
,
z21
,
z42
[
15
:
00
]);
qfilt
#
(
ORDER
,
WIDTH
,
DBW
,
DBW
,
DBW
,
GBW
,
RBW
,
1
)
ifir
(
z3
,
z10
,
z14
,
z9
,
swrbus
,
z29
,
z38
,
z22
,
z42
[
31
:
16
]);
fifoNxMfmti
#
(
IBW
,
32
)
fo
(
ioclk
,
z10
,
z19
,
ostat
,
oena
,
obus
,
z3
,
z10
,
4'h8
,
z24
,
z21
,
z42
);
endmodule
module
qfilt
(
clk
,
rst
,
z14
,
cload
,
sbus
,
vin
,
din
,
vout
,
dout
);
parameter
ORDER
=
4
;
parameter
IBN
=
1
;
parameter
IBW
=
16
;
parameter
CBW
=
16
;
parameter
OBW
=
16
;
parameter
GBW
=
8
;
parameter
RBW
=
4
;
parameter
FLAGS
=
0
;
parameter
PBW
=
IBW
+
CBW
-
1
;
parameter
SBW
=
OBW
+
GBW
+
RBW
-
1
;
parameter
CELLS
=(
2
**
ORDER
);
parameter
TAPS
=(
2
*
CELLS
);
parameter
ROWS
=
CELLS
/
IBN
;
input
clk
,
rst
;
input
[
1
:
0
]
z14
;
input
cload
;
input
[
31
:
0
]
sbus
;
input
vin
;
input
[
IBN
*
IBW
-
1
:
0
]
din
;
output
vout
;
output
[
OBW
-
1
:
0
]
dout
;
wire
z1
=
0
,
z2
=
1
;
wire
signed
[
IBW
-
1
:
0
]
z44
[
TAPS
-
1
:
0
];
wire
signed
[
OBW
+
RBW
-
1
:
0
]
z45
[
CELLS
-
1
:
0
];
reg
signed
[
SBW
-
1
:
0
]
z46
[
CELLS
-
1
:
0
][
ORDER
:
0
];
wire
signed
[
SBW
-
1
:
0
]
z47
,
z48
,
z49
;
wire
signed
[
CBW
-
1
:
0
]
z50
=
sbus
[
32
-
1
:
32
-
CBW
];
wire
[
ORDER
:
0
]
z51
=
sbus
[
ORDER
:
0
];
wire
z52
;
wire
[
3
:
0
]
z53
=
ORDER
+
2
;
srl16xNp
vouts
(
clk
,
z2
,
z53
,
vin
,
z52
);
wire
signed
[
IBW
-
1
:
0
]
z54
[
7
:
0
];
assign
z54
[
0
]
=
din
[
1
*
IBW
-
1
:
0
*
IBW
];
assign
z54
[
1
]
=
din
[
2
*
IBW
-
1
:
1
*
IBW
];
assign
z54
[
2
]
=
din
[
3
*
IBW
-
1
:
2
*
IBW
];
assign
z54
[
3
]
=
din
[
4
*
IBW
-
1
:
3
*
IBW
];
assign
z54
[
4
]
=
din
[
5
*
IBW
-
1
:
4
*
IBW
];
assign
z54
[
5
]
=
din
[
6
*
IBW
-
1
:
5
*
IBW
];
assign
z54
[
6
]
=
din
[
7
*
IBW
-
1
:
6
*
IBW
];
assign
z54
[
7
]
=
din
[
8
*
IBW
-
1
:
7
*
IBW
];
genvar
i
,
j
;
generate
for
(
i
=
0
;
i
<
CELLS
;
i
=
i
+
1
)
begin
:
tap
mux4xNpe
#
(
IBW
)
z15
(
z44
[
i
],
(
i
<
1
)?
z54
[
i
-
1
+
8
]
:
z44
[
i
-
1
],(
i
<
2
)?
z54
[
i
-
2
+
8
]
:
z44
[
i
-
2
],(
i
<
4
)?
z54
[
i
-
4
+
8
]
:
z44
[
i
-
4
],(
i
<
8
)?
z54
[
i
-
8
+
8
]
:
z44
[
i
-
8
],
z14
,
clk
,
vin
);
mux4xNpe
#
(
IBW
)
dmk
(
z44
[
i
+
CELLS
],
z44
[
i
+
CELLS
-
1
],
z44
[
i
+
CELLS
-
2
],
z44
[
i
+
CELLS
-
4
],
z44
[
i
+
CELLS
-
8
],
z14
,
clk
,
vin
);
reg
z55
;
reg
signed
[
IBW
:
0
]
z56
;
reg
signed
[
CBW
-
1
:
0
]
z57
;
reg
signed
[
PBW
-
1
:
0
]
z58
;
always
@(
posedge
clk
)
begin
:
mac
if
(!
cload
)
z55
<=
0
;
else
z55
<=
(
z51
==
i
);
if
(
z55
)
z57
<=
z50
;
z56
<=
z44
[
i
]
+
z44
[
TAPS
-
1
-
i
];
z58
<=
z56
*
z57
;
end
assign
z45
[
i
]
=
z58
[
PBW
-
1
:
PBW
-
OBW
-
RBW
];
end
endgenerate
generate
for
(
j
=
0
;
j
<
ORDER
;
j
=
j
+
1
)
begin
:
order
for
(
i
=
0
;
i
<(
2
**
j
);
i
=
i
+
1
)
begin
:
tree
always
@(
posedge
clk
)
z46
[
i
][
j
]
<=
(
j
+
1
==
ORDER
)?
z45
[
i
+
i
]
+
z45
[
i
+
i
+
1
]
:
z46
[
i
+
i
][
j
+
1
]
+
z46
[
i
+
i
+
1
][
j
+
1
];
end
end
endgenerate
wire
z59
;
assign
z48
=
z46
[
0
][
0
];
roundN2Mc
#
(
SBW
,
OBW
,
GBW
)
cvt
(
z48
,
z49
,
z2
,
z2
,
clk
,
z59
);
assign
vout
=
z52
;
assign
dout
=
z49
[
SBW
-
GBW
-
1
:
SBW
-
GBW
-
OBW
];
endmodule
module
qrot
(
clk
,
z10
,
swr
,
sbus
,
vin
,
dadr
,
din
,
doutr
,
douti
);
parameter
IBW
=
16
;
parameter
OBW
=
16
;
parameter
CBW
=
16
;
parameter
GBW
=
2
;
parameter
RBW
=
6
;
parameter
PBW
=
IBW
+
CBW
-
1
;
parameter
QBW
=
OBW
+
GBW
+
RBW
;
input
clk
,
z10
,
swr
;
input
[
31
:
0
]
sbus
;
input
vin
;
input
[
7
:
0
]
dadr
;
input
signed
[
IBW
-
1
:
0
]
din
;
output
[
OBW
-
1
:
0
]
doutr
,
douti
;
wire
z1
=
0
,
z2
=
1
;
wire
signed
[
CBW
-
1
:
0
]
z60
,
z61
;
reg
signed
[
CBW
-
1
:
0
]
z62
,
z63
;
reg
signed
[
PBW
-
1
:
0
]
z64
,
z65
;
reg
signed
[
PBW
-
1
:
0
]
z66
,
z67
;
wire
signed
[
PBW
-
1
:
0
]
z68
,
z69
;
reg
[
7
:
0
]
z70
;
sdpram
#
(
2
,
32
,
32
)
ram
(
clk
,
z2
,
{
1'b0
,
z70
},
swr
,
sbus
,
clk
,
z2
,
{
1'b0
,
dadr
},{
z60
,
z61
});
always
@(
posedge
clk
)
begin
if
(
z10
)
z70
<=
0
;
else
if
(
swr
)
z70
<=
z70
+
1
;
z62
<=
z60
;
z63
<=
z61
;
z64
<=
z62
*
din
;
z65
<=
z63
*
din
;
z66
<=
z64
;
z67
<=
z65
;
end
wire
z71
,
z72
;
roundN2Mc
#
(
QBW
,
OBW
,
GBW
)
cvtr
(
z65
[
PBW
-
1
:
PBW
-
QBW
],
z69
[
PBW
-
1
:
PBW
-
QBW
],
z2
,
z2
,
clk
,
z71
);
roundN2Mc
#
(
QBW
,
OBW
,
GBW
)
cvti
(
z64
[
PBW
-
1
:
PBW
-
QBW
],
z68
[
PBW
-
1
:
PBW
-
QBW
],
z2
,
z2
,
clk
,
z72
);
assign
doutr
=
z69
[
PBW
-
GBW
-
1
:
PBW
-
GBW
-
OBW
];
assign
douti
=
z68
[
PBW
-
GBW
-
1
:
PBW
-
GBW
-
OBW
];
endmodule
